/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Sets;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.ReferenceTreeNode;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.ReferenceIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MethodReferenceTreeNode
extends DefaultMutableTreeNode
implements ReferenceTreeNode<MethodEntry, MethodDefEntry> {
    private final Translator translator;
    private MethodEntry entry;
    private EntryReference<MethodEntry, MethodDefEntry> reference;

    public MethodReferenceTreeNode(Translator translator, MethodEntry entry) {
        this.translator = translator;
        this.entry = entry;
        this.reference = null;
    }

    public MethodReferenceTreeNode(Translator translator, EntryReference<MethodEntry, MethodDefEntry> reference) {
        this.translator = translator;
        this.entry = (MethodEntry)reference.entry;
        this.reference = reference;
    }

    @Override
    public MethodEntry getEntry() {
        return this.entry;
    }

    @Override
    public EntryReference<MethodEntry, MethodDefEntry> getReference() {
        return this.reference;
    }

    @Override
    public String toString() {
        if (this.reference != null) {
            return String.format("%s", this.translator.translate((MethodDefEntry)this.reference.context));
        }
        return this.translator.translate(this.entry).getName();
    }

    public void load(JarIndex index, boolean recurse, boolean recurseMethod) {
        Collection<EntryReference<MethodEntry, MethodDefEntry>> references = this.getReferences(index, recurseMethod);
        for (EntryReference<MethodEntry, MethodDefEntry> reference : references) {
            this.add(new MethodReferenceTreeNode(this.translator, reference));
        }
        if (recurse && this.children != null) {
            for (EntryReference<MethodEntry, MethodDefEntry> child : this.children) {
                if (!(child instanceof MethodReferenceTreeNode)) continue;
                MethodReferenceTreeNode node = (MethodReferenceTreeNode)((Object)child);
                HashSet<MethodEntry> ancestors = Sets.newHashSet();
                TreeNode n = node;
                while (n.getParent() != null) {
                    if (!((n = n.getParent()) instanceof MethodReferenceTreeNode)) continue;
                    ancestors.add(((MethodReferenceTreeNode)n).getEntry());
                }
                if (ancestors.contains(node.getEntry())) continue;
                node.load(index, true, false);
            }
        }
    }

    private Collection<EntryReference<MethodEntry, MethodDefEntry>> getReferences(JarIndex index, boolean recurseMethod) {
        ReferenceIndex referenceIndex = index.getReferenceIndex();
        if (recurseMethod) {
            ArrayList<EntryReference<MethodEntry, MethodDefEntry>> references = new ArrayList<EntryReference<MethodEntry, MethodDefEntry>>();
            EntryResolver entryResolver = index.getEntryResolver();
            for (MethodEntry methodEntry : entryResolver.resolveEquivalentMethods(this.entry)) {
                references.addAll(referenceIndex.getReferencesToMethod(methodEntry));
            }
            return references;
        }
        return referenceIndex.getReferencesToMethod(this.entry);
    }
}

