/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classprovider;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cuchaz.enigma.classprovider.ClassProvider;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class CachingClassProvider
implements ClassProvider {
    private final ClassProvider classProvider;
    private final Cache<String, Optional<ClassNode>> cache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(1L, TimeUnit.MINUTES).concurrencyLevel(1).build();

    public CachingClassProvider(ClassProvider classProvider) {
        this.classProvider = classProvider;
    }

    @Override
    @Nullable
    public ClassNode get(String name) {
        try {
            return this.cache.get(name, () -> Optional.ofNullable(this.classProvider.get(name))).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

