/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.cfr;

import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.Source;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.source.cfr.CfrSource;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.utils.AsmUtil;
import java.util.Collection;
import java.util.Map;
import org.benf.cfr.reader.apiunreleased.ClassFileSource2;
import org.benf.cfr.reader.apiunreleased.JarContent;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.util.AnalysisType;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class CfrDecompiler
implements Decompiler {
    private final SourceSettings settings;
    private final Options options = OptionsImpl.getFactory().create(Map.of("trackbytecodeloc", "true"));
    private final ClassFileSource2 classFileSource;

    public CfrDecompiler(ClassProvider classProvider, SourceSettings sourceSettings) {
        this.settings = sourceSettings;
        this.classFileSource = new ClassFileSource(classProvider);
    }

    @Override
    public Source getSource(String className, @Nullable EntryRemapper mapper) {
        return new CfrSource(className, this.settings, this.options, this.classFileSource, mapper);
    }

    private record ClassFileSource(ClassProvider classProvider) implements ClassFileSource2
    {
        @Override
        public JarContent addJarContent(String s2, AnalysisType analysisType) {
            return null;
        }

        @Override
        public void informAnalysisRelativePathDetail(String usePath, String classFilePath) {
        }

        @Override
        public Collection<String> addJar(String jarPath) {
            return null;
        }

        @Override
        public String getPossiblyRenamedPath(String path) {
            return path;
        }

        @Override
        public Pair<byte[], String> getClassFileContent(String path) {
            ClassNode node = this.classProvider.get(path.substring(0, path.lastIndexOf(46)));
            if (node == null) {
                return null;
            }
            return new Pair<byte[], String>(AsmUtil.nodeToBytes(node), path);
        }
    }
}

