/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import cuchaz.enigma.analysis.IndexTreeBuilder;
import cuchaz.enigma.analysis.MethodImplementationsTreeNode;
import cuchaz.enigma.analysis.MethodInheritanceTreeNode;
import cuchaz.enigma.analysis.index.BridgeMethodIndex;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.VoidTranslator;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class IndexEntryResolver
implements EntryResolver {
    private final EntryIndex entryIndex;
    private final InheritanceIndex inheritanceIndex;
    private final BridgeMethodIndex bridgeMethodIndex;
    private final IndexTreeBuilder treeBuilder;

    public IndexEntryResolver(JarIndex index) {
        this.entryIndex = index.getEntryIndex();
        this.inheritanceIndex = index.getInheritanceIndex();
        this.bridgeMethodIndex = index.getBridgeMethodIndex();
        this.treeBuilder = new IndexTreeBuilder(index);
    }

    @Override
    public <E extends Entry<?>> Collection<E> resolveEntry(E entry, ResolutionStrategy strategy) {
        if (entry == null) {
            return Collections.emptySet();
        }
        Entry<ClassEntry> classChild = this.getClassChild(entry);
        if (classChild != null && !(classChild instanceof ClassEntry)) {
            Set<Entry<ClassEntry>> resolvedChildren;
            AccessFlags access = this.entryIndex.getEntryAccess(classChild);
            if (strategy == ResolutionStrategy.RESOLVE_CLOSEST && access != null) {
                return Collections.singleton(entry);
            }
            if (!(access != null && access.isPrivate() || (resolvedChildren = this.resolveChildEntry(classChild, strategy)).isEmpty())) {
                return resolvedChildren.stream().map(resolvedChild -> entry.replaceAncestor(classChild, resolvedChild)).toList();
            }
        }
        return Collections.singleton(entry);
    }

    @Nullable
    private Entry<ClassEntry> getClassChild(Entry<?> entry) {
        if (entry instanceof ClassEntry) {
            return null;
        }
        List<Entry<?>> ancestry = entry.getAncestry();
        for (int i = ancestry.size() - 1; i > 0; --i) {
            Entry<?> child = ancestry.get(i);
            Entry<ClassEntry> cast = child.castParent(ClassEntry.class);
            if (cast == null || cast instanceof ClassEntry) continue;
            return cast;
        }
        return null;
    }

    private Set<Entry<ClassEntry>> resolveChildEntry(Entry<ClassEntry> entry, ResolutionStrategy strategy) {
        MethodEntry bridgeMethod;
        ClassEntry ownerClass = entry.getParent();
        if (entry instanceof MethodEntry && (bridgeMethod = this.bridgeMethodIndex.getBridgeFromSpecialized((MethodEntry)entry)) != null && ownerClass.equals((ClassEntry)bridgeMethod.getParent())) {
            Set<Entry<ClassEntry>> resolvedBridge = this.resolveChildEntry(bridgeMethod, strategy);
            if (!resolvedBridge.isEmpty()) {
                return resolvedBridge;
            }
            return Collections.singleton(bridgeMethod);
        }
        HashSet<Entry<ClassEntry>> resolvedEntries = new HashSet<Entry<ClassEntry>>();
        for (ClassEntry parentClass : this.inheritanceIndex.getParents(ownerClass)) {
            Entry<ClassEntry> parentEntry = entry.withParent(parentClass);
            if (strategy == ResolutionStrategy.RESOLVE_ROOT) {
                resolvedEntries.addAll(this.resolveRoot(parentEntry, strategy));
                continue;
            }
            resolvedEntries.addAll(this.resolveClosest(parentEntry, strategy));
        }
        return resolvedEntries;
    }

    private Collection<Entry<ClassEntry>> resolveRoot(Entry<ClassEntry> entry, ResolutionStrategy strategy) {
        AccessFlags parentAccess;
        Set<Entry<ClassEntry>> parentResolution = this.resolveChildEntry(entry, strategy);
        if (parentResolution.isEmpty() && (parentAccess = this.entryIndex.getEntryAccess(entry)) != null && !parentAccess.isPrivate()) {
            return Collections.singleton(entry);
        }
        return parentResolution;
    }

    private Collection<Entry<ClassEntry>> resolveClosest(Entry<ClassEntry> entry, ResolutionStrategy strategy) {
        AccessFlags parentAccess = this.entryIndex.getEntryAccess(entry);
        if (parentAccess != null && !parentAccess.isPrivate()) {
            return Collections.singleton(entry);
        }
        return this.resolveChildEntry(entry, strategy);
    }

    @Override
    public Set<Entry<?>> resolveEquivalentEntries(Entry<?> entry) {
        MethodEntry relevantMethod = entry.findAncestor(MethodEntry.class);
        if (relevantMethod == null || !this.entryIndex.hasMethod(relevantMethod)) {
            return Collections.singleton(entry);
        }
        Set<MethodEntry> equivalentMethods = this.resolveEquivalentMethods(relevantMethod);
        HashSet equivalentEntries = new HashSet(equivalentMethods.size());
        for (MethodEntry equivalentMethod : equivalentMethods) {
            Entry<?> equivalentEntry = entry.replaceAncestor(relevantMethod, equivalentMethod);
            equivalentEntries.add(equivalentEntry);
        }
        return equivalentEntries;
    }

    @Override
    public Set<MethodEntry> resolveEquivalentMethods(MethodEntry methodEntry) {
        HashSet<MethodEntry> set = new HashSet<MethodEntry>();
        this.resolveEquivalentMethods(set, methodEntry);
        return set;
    }

    private void resolveEquivalentMethods(Set<MethodEntry> methodEntries, MethodEntry methodEntry) {
        AccessFlags access = this.entryIndex.getMethodAccess(methodEntry);
        if (access == null) {
            throw new IllegalArgumentException("Could not find method " + String.valueOf(methodEntry));
        }
        if (!this.canInherit(methodEntry, access)) {
            methodEntries.add(methodEntry);
            return;
        }
        this.resolveEquivalentMethods(methodEntries, this.treeBuilder.buildMethodInheritance(VoidTranslator.INSTANCE, methodEntry));
    }

    private void resolveEquivalentMethods(Set<MethodEntry> methodEntries, MethodInheritanceTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        if (methodEntries.contains(methodEntry)) {
            return;
        }
        AccessFlags flags = this.entryIndex.getMethodAccess(methodEntry);
        if (flags != null && this.canInherit(methodEntry, flags)) {
            methodEntries.add(methodEntry);
        }
        MethodEntry bridgedMethod = this.bridgeMethodIndex.getBridgeFromSpecialized(methodEntry);
        while (bridgedMethod != null) {
            this.resolveEquivalentMethods(methodEntries, bridgedMethod);
            bridgedMethod = this.bridgeMethodIndex.getBridgeFromSpecialized(bridgedMethod);
        }
        for (MethodImplementationsTreeNode implementationsNode : this.treeBuilder.buildMethodImplementations(VoidTranslator.INSTANCE, methodEntry)) {
            this.resolveEquivalentMethods(methodEntries, implementationsNode);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.resolveEquivalentMethods(methodEntries, (MethodInheritanceTreeNode)node.getChildAt(i));
        }
    }

    private void resolveEquivalentMethods(Set<MethodEntry> methodEntries, MethodImplementationsTreeNode node) {
        MethodEntry methodEntry = node.getMethodEntry();
        AccessFlags flags = this.entryIndex.getMethodAccess(methodEntry);
        if (flags != null && !flags.isPrivate() && !flags.isStatic()) {
            methodEntries.add(methodEntry);
        }
        MethodEntry bridgedMethod = this.bridgeMethodIndex.getBridgeFromSpecialized(methodEntry);
        while (bridgedMethod != null) {
            this.resolveEquivalentMethods(methodEntries, bridgedMethod);
            bridgedMethod = this.bridgeMethodIndex.getBridgeFromSpecialized(bridgedMethod);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.resolveEquivalentMethods(methodEntries, (MethodImplementationsTreeNode)node.getChildAt(i));
        }
    }

    private boolean canInherit(MethodEntry entry, AccessFlags access) {
        return !entry.isConstructor() && !access.isPrivate() && !access.isStatic() && !access.isFinal();
    }
}

