/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde.proguard;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingOperations;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.serde.MappingsReader;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProguardMappingsReader
implements MappingsReader {
    public static final ProguardMappingsReader INSTANCE = new ProguardMappingsReader();
    private static final String NAME = "[a-zA-Z0-9_\\-.$<>]+";
    private static final String TYPE = "[a-zA-Z0-9_\\-.$<>]+(?:\\[])*";
    private static final String TYPE_LIST = "|(?:(?:[a-zA-Z0-9_\\-.$<>]+(?:\\[])*,)*[a-zA-Z0-9_\\-.$<>]+(?:\\[])*)";
    private static final Pattern CLASS = Pattern.compile("([a-zA-Z0-9_\\-.$<>]+) -> ([a-zA-Z0-9_\\-.$<>]+):");
    private static final Pattern FIELD = Pattern.compile(" {4}([a-zA-Z0-9_\\-.$<>]+(?:\\[])*) ([a-zA-Z0-9_\\-.$<>]+) -> ([a-zA-Z0-9_\\-.$<>]+)");
    private static final Pattern METHOD = Pattern.compile(" {4}(?:[0-9]+:[0-9]+:)?([a-zA-Z0-9_\\-.$<>]+(?:\\[])*) ([a-zA-Z0-9_\\-.$<>]+)\\((|(?:(?:[a-zA-Z0-9_\\-.$<>]+(?:\\[])*,)*[a-zA-Z0-9_\\-.$<>]+(?:\\[])*))\\) -> ([a-zA-Z0-9_\\-.$<>]+)");

    @Override
    public EntryTree<EntryMapping> read(Path path, ProgressListener progress, MappingSaveParameters saveParameters) throws MappingParseException, IOException {
        HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
        int lineNumber = 0;
        ClassEntry currentClass = null;
        for (String line : Files.readAllLines(path, StandardCharsets.UTF_8)) {
            String name;
            ++lineNumber;
            if (line.startsWith("#") || line.isEmpty()) continue;
            Matcher classMatcher = CLASS.matcher(line);
            Matcher fieldMatcher = FIELD.matcher(line);
            Matcher methodMatcher = METHOD.matcher(line);
            if (classMatcher.matches()) {
                String name2 = classMatcher.group(1);
                String targetName = classMatcher.group(2);
                currentClass = new ClassEntry(name2.replace('.', '/'));
                mappings.insert(currentClass, new EntryMapping(ClassEntry.getInnerName(targetName.replace('.', '/'))));
                continue;
            }
            if (fieldMatcher.matches()) {
                String type = fieldMatcher.group(1);
                name = fieldMatcher.group(2);
                String targetName = fieldMatcher.group(3);
                if (currentClass == null) {
                    throw new MappingParseException(path, lineNumber, "field mapping not inside class: " + line);
                }
                mappings.insert(new FieldEntry(currentClass, name, new TypeDescriptor(this.getDescriptor(type))), new EntryMapping(targetName));
                continue;
            }
            if (methodMatcher.matches()) {
                String returnType = methodMatcher.group(1);
                name = methodMatcher.group(2);
                String[] parameterTypes = methodMatcher.group(3).isEmpty() ? new String[]{} : methodMatcher.group(3).split(",");
                String targetName = methodMatcher.group(4);
                if (currentClass == null) {
                    throw new MappingParseException(path, lineNumber, "method mapping not inside class: " + line);
                }
                mappings.insert(new MethodEntry(currentClass, name, new MethodDescriptor(this.getDescriptor(returnType, parameterTypes))), new EntryMapping(targetName));
                continue;
            }
            throw new MappingParseException(path, lineNumber, "invalid mapping line: " + line);
        }
        return MappingOperations.invert(mappings);
    }

    private String getDescriptor(String type) {
        StringBuilder descriptor = new StringBuilder();
        while (type.endsWith("[]")) {
            descriptor.append("[");
            type = type.substring(0, type.length() - 2);
        }
        switch (type) {
            case "byte": {
                return String.valueOf(descriptor) + "B";
            }
            case "char": {
                return String.valueOf(descriptor) + "C";
            }
            case "short": {
                return String.valueOf(descriptor) + "S";
            }
            case "int": {
                return String.valueOf(descriptor) + "I";
            }
            case "long": {
                return String.valueOf(descriptor) + "J";
            }
            case "float": {
                return String.valueOf(descriptor) + "F";
            }
            case "double": {
                return String.valueOf(descriptor) + "D";
            }
            case "boolean": {
                return String.valueOf(descriptor) + "Z";
            }
            case "void": {
                return String.valueOf(descriptor) + "V";
            }
        }
        descriptor.append("L");
        descriptor.append(type.replace('.', '/'));
        descriptor.append(";");
        return descriptor.toString();
    }

    private String getDescriptor(String returnType, String[] parameterTypes) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append('(');
        for (String parameterType : parameterTypes) {
            descriptor.append(this.getDescriptor(parameterType));
        }
        descriptor.append(')');
        descriptor.append(this.getDescriptor(returnType));
        return descriptor.toString();
    }
}

