/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde.tinyv2;

import com.google.common.base.Strings;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.serde.LfPrintWriter;
import cuchaz.enigma.translation.mapping.serde.MappingHelper;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.serde.MappingsWriter;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.StreamSupport;

public final class TinyV2Writer
implements MappingsWriter {
    private static final String MINOR_VERSION = "0";
    private final String obfHeader;
    private final String deobfHeader;

    public TinyV2Writer(String obfHeader, String deobfHeader) {
        this.obfHeader = obfHeader;
        this.deobfHeader = deobfHeader;
    }

    @Override
    public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progress, MappingSaveParameters parameters) {
        List<EntryTreeNode> classes = StreamSupport.stream(mappings.spliterator(), false).filter(node -> node.getEntry() instanceof ClassEntry).toList();
        try (LfPrintWriter writer = new LfPrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            writer.println("tiny\t2\t0\t" + this.obfHeader + "\t" + this.deobfHeader);
            for (EntryTreeNode node2 : classes) {
                this.writeClass(writer, node2, mappings);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void writeClass(PrintWriter writer, EntryTreeNode<EntryMapping> node, EntryMap<EntryMapping> tree) {
        writer.print("c\t");
        ClassEntry classEntry = (ClassEntry)node.getEntry();
        String fullName = classEntry.getFullName();
        writer.print(fullName);
        LinkedList<String> parts = new LinkedList<String>();
        do {
            EntryMapping mapping;
            if ((mapping = tree.get(classEntry)) != null && mapping.targetName() != null) {
                parts.addFirst(mapping.targetName());
                continue;
            }
            parts.addFirst(classEntry.getName());
        } while ((classEntry = classEntry.getOuterClass()) != null);
        String mappedName = String.join((CharSequence)"$", parts);
        writer.print("\t");
        writer.print(mappedName);
        writer.println();
        this.writeComment(writer, node.getValue(), 1);
        for (EntryTreeNode<EntryMapping> child : node.getChildNodes()) {
            Entry<?> entry = child.getEntry();
            if (entry instanceof FieldEntry) {
                this.writeField(writer, child);
                continue;
            }
            if (!(entry instanceof MethodEntry)) continue;
            this.writeMethod(writer, child);
        }
    }

    private void writeMethod(PrintWriter writer, EntryTreeNode<EntryMapping> node) {
        writer.print(this.indent(1));
        writer.print("m\t");
        writer.print(((MethodEntry)node.getEntry()).getDesc().toString());
        writer.print("\t");
        writer.print(node.getEntry().getName());
        writer.print("\t");
        EntryMapping mapping = node.getValue();
        if (mapping == null) {
            mapping = EntryMapping.DEFAULT;
        }
        if (mapping.targetName() != null) {
            writer.println(mapping.targetName());
        } else {
            writer.println(node.getEntry().getName());
        }
        this.writeComment(writer, mapping, 2);
        for (EntryTreeNode<EntryMapping> child : node.getChildNodes()) {
            Entry<?> entry = child.getEntry();
            if (!(entry instanceof LocalVariableEntry)) continue;
            this.writeParameter(writer, child);
        }
    }

    private void writeField(PrintWriter writer, EntryTreeNode<EntryMapping> node) {
        if (node.getValue() == null || node.getValue().equals(EntryMapping.DEFAULT)) {
            return;
        }
        writer.print(this.indent(1));
        writer.print("f\t");
        writer.print(((FieldEntry)node.getEntry()).getDesc().toString());
        writer.print("\t");
        writer.print(node.getEntry().getName());
        writer.print("\t");
        EntryMapping mapping = node.getValue();
        if (mapping == null) {
            mapping = EntryMapping.DEFAULT;
        }
        if (mapping.targetName() != null) {
            writer.println(mapping.targetName());
        } else {
            writer.println(node.getEntry().getName());
        }
        this.writeComment(writer, mapping, 2);
    }

    private void writeParameter(PrintWriter writer, EntryTreeNode<EntryMapping> node) {
        if (node.getValue() == null || node.getValue().equals(EntryMapping.DEFAULT)) {
            return;
        }
        writer.print(this.indent(2));
        writer.print("p\t");
        writer.print(((LocalVariableEntry)node.getEntry()).getIndex());
        writer.print("\t");
        writer.print(node.getEntry().getName());
        writer.print("\t");
        EntryMapping mapping = node.getValue();
        if (mapping == null || mapping.targetName() == null) {
            writer.println();
        } else {
            writer.println(mapping.targetName());
            this.writeComment(writer, mapping, 3);
        }
    }

    private void writeComment(PrintWriter writer, EntryMapping mapping, int indent) {
        if (mapping != null && mapping.javadoc() != null) {
            writer.print(this.indent(indent));
            writer.print("c\t");
            writer.print(MappingHelper.escape(mapping.javadoc()));
            writer.println();
        }
    }

    private String indent(int level) {
        return Strings.repeat("\t", level);
    }
}

