/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.mapping.IdentifierValidation;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public interface Entry<P extends Entry<?>>
extends Translatable {
    public String getName();

    public String getSimpleName();

    public String getFullName();

    public String getContextualName();

    public String getJavadocs();

    default public String getSourceRemapName() {
        return this.getName();
    }

    @Nullable
    public P getParent();

    public Class<P> getParentType();

    public Entry<P> withName(String var1);

    public Entry<P> withParent(P var1);

    public boolean canConflictWith(Entry<?> var1);

    public boolean canShadow(Entry<?> var1);

    default public ClassEntry getContainingClass() {
        ClassEntry last = null;
        for (Entry<P> current = this; current != null; current = current.getParent()) {
            if (!(current instanceof ClassEntry)) continue;
            last = (ClassEntry)current;
            break;
        }
        return Objects.requireNonNull(last, () -> String.format("%s has no containing class?", this));
    }

    default public ClassEntry getTopLevelClass() {
        ClassEntry last = null;
        for (Entry<P> current = this; current != null; current = current.getParent()) {
            if (!(current instanceof ClassEntry)) continue;
            last = (ClassEntry)current;
        }
        return Objects.requireNonNull(last, () -> String.format("%s has no top level class?", this));
    }

    default public List<Entry<?>> getAncestry() {
        P parent = this.getParent();
        ArrayList entries = new ArrayList();
        if (parent != null) {
            entries.addAll(parent.getAncestry());
        }
        entries.add(this);
        return entries;
    }

    @Nullable
    default public <E extends Entry<?>> E findAncestor(Class<E> type) {
        List<Entry<?>> ancestry = this.getAncestry();
        for (int i = ancestry.size() - 1; i >= 0; --i) {
            Entry<?> ancestor = ancestry.get(i);
            if (!type.isAssignableFrom(ancestor.getClass())) continue;
            return (E)ancestor;
        }
        return null;
    }

    default public <E extends Entry<?>> Entry<P> replaceAncestor(E target, E replacement) {
        if (replacement.equals(target)) {
            return this;
        }
        if (this.equals(target)) {
            return replacement;
        }
        P parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return this.withParent(parent.replaceAncestor(target, replacement));
    }

    default public void validateName(ValidationContext vc, String name) {
        IdentifierValidation.validateIdentifier(vc, name);
    }

    @Nullable
    default public <C extends Entry<?>> Entry<C> castParent(Class<C> parentType) {
        if (parentType.equals(this.getParentType())) {
            return this;
        }
        return null;
    }
}

