/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.reflect.ClassPath;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class I18n {
    public static final String DEFAULT_LANGUAGE = "en_us";
    private static final Gson GSON = new Gson();
    private static Map<String, String> defaultTranslations = I18n.load("en_us");
    private static Map<String, String> translations = defaultTranslations;
    private static Map<String, String> languageNames = Maps.newHashMap();

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> load(String language) {
        block13: {
            try (InputStream inputStream = I18n.class.getResourceAsStream("/lang/" + language + ".json");){
                Map map;
                if (inputStream == null) break block13;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    map = GSON.fromJson((Reader)reader, Map.class);
                }
                return map;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }

    public static String translateOrNull(String key) {
        String value = translations.get(key);
        if (value != null) {
            return value;
        }
        return defaultTranslations.get(key);
    }

    public static String translate(String key) {
        String tr = I18n.translateOrNull(key);
        return tr != null ? tr : key;
    }

    public static String translateOrEmpty(String key, Object ... args) {
        String text = I18n.translateOrNull(key);
        if (text != null) {
            return String.format(text, args);
        }
        return "";
    }

    public static String translateFormatted(String key, Object ... args) {
        String text = I18n.translateOrNull(key);
        if (text != null) {
            return String.format(text, args);
        }
        if (args.length == 0) {
            return key;
        }
        return key + Arrays.stream(args).map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String getLanguageName(String language) {
        return languageNames.get(language);
    }

    public static void setLanguage(String language) {
        translations = I18n.load(language);
    }

    public static ArrayList<String> getAvailableLanguages() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ImmutableList<ClassPath.ResourceInfo> resources = ClassPath.from(Thread.currentThread().getContextClassLoader()).getResources().asList();
            Stream dirStream = resources.stream();
            dirStream.forEach(context -> {
                String file = context.getResourceName();
                if (file.startsWith("lang/") && file.endsWith(".json")) {
                    String fileName = file.substring(5, file.length() - 5);
                    list.add(fileName);
                    I18n.loadLanguageName(fileName);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void loadLanguageName(String fileName) {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("lang/" + fileName + ".json");
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            Map map = GSON.fromJson((Reader)reader, Map.class);
            languageNames.put(fileName, map.get("language").toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

