/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Utils {
    public static String readStreamToString(InputStream in) throws IOException {
        return CharStreams.toString(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public static String readResourceToString(String path) throws IOException {
        InputStream in = Utils.class.getResourceAsStream(path);
        if (in == null) {
            throw new IllegalArgumentException("Resource not found! " + path);
        }
        return Utils.readStreamToString(in);
    }

    public static void delete(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            for (Path p : Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).toList()) {
                Files.delete(p);
            }
        }
    }

    public static byte[] zipSha1(Path path) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try (ZipFile zip = new ZipFile(path.toFile());){
            ArrayList<? extends ZipEntry> entries = Collections.list(zip.entries());
            entries.removeIf(entry -> !entry.getName().toLowerCase(Locale.ROOT).endsWith(".class"));
            entries.sort(Comparator.comparing(ZipEntry::getName));
            byte[] buffer = new byte[8192];
            for (ZipEntry zipEntry : entries) {
                digest.update(zipEntry.getName().getBytes(StandardCharsets.UTF_8));
                InputStream in = zip.getInputStream(zipEntry);
                try {
                    int n;
                    while ((n = in.read(buffer)) != -1) {
                        digest.update(buffer, 0, n);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return digest.digest();
    }

    public static void withLock(Lock l, Runnable op) {
        try {
            l.lock();
            op.run();
        }
        finally {
            l.unlock();
        }
    }

    public static <R> R withLock(Lock l, Supplier<R> op) {
        try {
            l.lock();
            R r = op.get();
            return r;
        }
        finally {
            l.unlock();
        }
    }
}

