/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir;

import com.strobel.assembler.ir.FrameType;
import com.strobel.assembler.ir.FrameValue;
import com.strobel.assembler.ir.FrameValueType;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.HashUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerHelpers;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.util.ContractUtils;
import com.strobel.util.EmptyArrayCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Frame {
    public static final FrameValue[] EMPTY_VALUES = EmptyArrayCache.fromElementType(FrameValue.class);
    public static final Frame NEW_EMPTY = new Frame(FrameType.New, EmptyArrayCache.fromElementType(FrameValue.class), EmptyArrayCache.fromElementType(FrameValue.class));
    public static final Frame SAME = new Frame(FrameType.Same, EmptyArrayCache.fromElementType(FrameValue.class), EmptyArrayCache.fromElementType(FrameValue.class));
    private final FrameType _frameType;
    private final List<FrameValue> _localValues;
    private final List<FrameValue> _stackValues;

    public Frame(FrameType frameType, FrameValue[] localValues, FrameValue[] stackValues) {
        this._frameType = VerifyArgument.notNull(frameType, "frameType");
        this._localValues = ArrayUtilities.asUnmodifiableList((Object[])VerifyArgument.notNull(localValues, "localValues").clone());
        this._stackValues = ArrayUtilities.asUnmodifiableList((Object[])VerifyArgument.notNull(stackValues, "stackValues").clone());
    }

    private Frame(FrameType frameType, List<FrameValue> localValues, List<FrameValue> stackValues) {
        this._frameType = frameType;
        this._localValues = localValues;
        this._stackValues = stackValues;
    }

    public final FrameType getFrameType() {
        return this._frameType;
    }

    public final List<FrameValue> getLocalValues() {
        return this._localValues;
    }

    public final List<FrameValue> getStackValues() {
        return this._stackValues;
    }

    public final Frame withEmptyStack() {
        if (this._frameType != FrameType.New) {
            throw new IllegalStateException("Can only call withEmptyStack() on New frames.");
        }
        return new Frame(this._frameType, this._localValues, Collections.emptyList());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Frame)) {
            return false;
        }
        Frame frame = (Frame)o;
        return frame._frameType == this._frameType && CollectionUtilities.sequenceDeepEquals(frame._localValues, this._localValues) && CollectionUtilities.sequenceDeepEquals(frame._stackValues, this._stackValues);
    }

    public final int hashCode() {
        int i;
        int result = this._frameType.hashCode();
        for (i = 0; i < this._localValues.size(); ++i) {
            result = HashUtilities.combineHashCodes((Object)result, (Object)this._localValues.get(i));
        }
        for (i = 0; i < this._stackValues.size(); ++i) {
            result = HashUtilities.combineHashCodes((Object)result, (Object)this._stackValues.get(i));
        }
        return result;
    }

    public final String toString() {
        PlainTextOutput writer = new PlainTextOutput();
        DecompilerHelpers.writeFrame(writer, this);
        return writer.toString();
    }

    public static Frame computeDelta(Frame previous, Frame current) {
        VerifyArgument.notNull(previous, "previous");
        VerifyArgument.notNull(current, "current");
        List<FrameValue> previousLocals = previous._localValues;
        List<FrameValue> currentLocals = current._localValues;
        List<FrameValue> currentStack = current._stackValues;
        int previousLocalCount = previousLocals.size();
        int currentLocalCount = currentLocals.size();
        int currentStackSize = currentStack.size();
        int localCount = previousLocalCount;
        FrameType type = FrameType.Full;
        if (currentStackSize == 0) {
            switch (currentLocalCount - previousLocalCount) {
                case -3: 
                case -2: 
                case -1: {
                    type = FrameType.Chop;
                    localCount = currentLocalCount;
                    break;
                }
                case 0: {
                    type = FrameType.Same;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    type = FrameType.Append;
                }
            }
        } else if (currentLocalCount == localCount && currentStackSize == 1) {
            type = FrameType.Same1;
        }
        if (type != FrameType.Full) {
            for (int i = 0; i < localCount; ++i) {
                if (currentLocals.get(i).equals(previousLocals.get(i))) continue;
                type = FrameType.Full;
                break;
            }
        }
        switch (type) {
            case Append: {
                return new Frame(type, currentLocals.subList(previousLocalCount, currentLocalCount).toArray(new FrameValue[currentLocalCount - previousLocalCount]), EmptyArrayCache.fromElementType(FrameValue.class));
            }
            case Chop: {
                return new Frame(type, previousLocals.subList(currentLocalCount, previousLocalCount).toArray(new FrameValue[previousLocalCount - currentLocalCount]), EmptyArrayCache.fromElementType(FrameValue.class));
            }
            case Full: {
                return new Frame(type, currentLocals, currentStack);
            }
            case Same: {
                return SAME;
            }
            case Same1: {
                return new Frame(type, EmptyArrayCache.fromElementType(FrameValue.class), new FrameValue[]{currentStack.get(currentStackSize - 1)});
            }
        }
        throw ContractUtils.unreachable();
    }

    public static Frame merge(Frame input, Frame output, Frame next, Map<Instruction, TypeReference> initializations) {
        int i;
        FrameValue t2;
        VerifyArgument.notNull(input, "input");
        VerifyArgument.notNull(output, "output");
        VerifyArgument.notNull(next, "next");
        List<FrameValue> inputLocals = input._localValues;
        List<FrameValue> outputLocals = output._localValues;
        int inputLocalCount = inputLocals.size();
        int outputLocalCount = outputLocals.size();
        int nextLocalCount = next._localValues.size();
        int tempLocalCount = Math.max(nextLocalCount, inputLocalCount);
        FrameValue[] nextLocals = next._localValues.toArray(new FrameValue[tempLocalCount]);
        boolean changed = false;
        for (int i2 = 0; i2 < inputLocalCount; ++i2) {
            t2 = i2 < outputLocalCount ? outputLocals.get(i2) : inputLocals.get(i2);
            if (initializations != null) {
                t2 = Frame.initialize(initializations, t2);
            }
            changed |= Frame.merge(t2, nextLocals, i2);
        }
        List<FrameValue> inputStack = input._stackValues;
        List<FrameValue> outputStack = output._stackValues;
        int inputStackSize = inputStack.size();
        int outputStackSize = outputStack.size();
        int nextStackSize = next._stackValues.size();
        FrameValue[] nextStack = next._stackValues.toArray(new FrameValue[nextStackSize]);
        int max = Math.min(nextStackSize, inputStackSize);
        for (i = 0; i < max; ++i) {
            t2 = inputStack.get(i);
            if (initializations != null) {
                t2 = Frame.initialize(initializations, t2);
            }
            changed |= Frame.merge(t2, nextStack, i);
        }
        max = Math.min(nextStackSize, outputStackSize);
        for (i = inputStackSize; i < max; ++i) {
            t2 = outputStack.get(i);
            if (initializations != null) {
                t2 = Frame.initialize(initializations, t2);
            }
            changed |= Frame.merge(t2, nextStack, i);
        }
        if (!changed) {
            return next;
        }
        int newLocalCount = nextLocalCount;
        return new Frame(FrameType.New, nextLocals.length == newLocalCount ? nextLocals : Arrays.copyOf(nextLocals, newLocalCount), nextStack);
    }

    private static FrameValue initialize(Map<Instruction, TypeReference> initializations, FrameValue t2) {
        TypeReference initializedType;
        if (t2 == null) {
            return t2;
        }
        Object parameter = t2.getParameter();
        if (parameter instanceof Instruction && (initializedType = initializations.get(parameter)) != null) {
            t2 = FrameValue.makeReference(initializedType);
        }
        return t2;
    }

    private static boolean merge(FrameValue t2, FrameValue[] values, int index) {
        FrameValue v;
        FrameValue u = values[index];
        if (Comparer.equals(t2, u)) {
            return false;
        }
        if (t2 == FrameValue.EMPTY) {
            return false;
        }
        if (t2 == FrameValue.NULL && u == FrameValue.NULL) {
            return false;
        }
        if (u == FrameValue.EMPTY) {
            values[index] = t2;
            return true;
        }
        FrameValueType tType = t2.getType();
        FrameValueType uType = u.getType();
        if (uType == FrameValueType.Reference) {
            if (t2 == FrameValue.NULL) {
                return false;
            }
            v = tType == FrameValueType.Reference ? FrameValue.makeReference(MetadataHelper.findCommonSuperType((TypeReference)t2.getParameter(), (TypeReference)u.getParameter())) : FrameValue.TOP;
        } else {
            v = u == FrameValue.NULL && tType == FrameValueType.Reference ? t2 : FrameValue.TOP;
        }
        if (!u.equals(v)) {
            values[index] = v;
            return true;
        }
        return false;
    }
}

