/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.ir.ConstantPool;
import com.strobel.assembler.ir.attributes.CodeAttribute;
import com.strobel.assembler.ir.attributes.ExceptionTableEntry;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.AnonymousLocalTypeCollection;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ClassFileReader;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.GenericParameterCollection;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IMemberDefinition;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodReader;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.ParameterDefinitionCollection;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.HashUtilities;
import com.strobel.core.StringUtilities;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;

public class MethodDefinition
extends MethodReference
implements IMemberDefinition {
    private final GenericParameterCollection _genericParameters = new GenericParameterCollection(this);
    private final ParameterDefinitionCollection _parameters = new ParameterDefinitionCollection(this);
    private final AnonymousLocalTypeCollection _declaredTypes = new AnonymousLocalTypeCollection(this);
    private final Collection<TypeReference> _thrownTypes = new Collection();
    private final Collection<CustomAnnotation> _customAnnotations = new Collection();
    private final Collection<SourceAttribute> _sourceAttributes = new Collection();
    private final List<GenericParameter> _genericParametersView = Collections.unmodifiableList(this._genericParameters);
    private final List<TypeDefinition> _declaredTypesView;
    private final List<ParameterDefinition> _parametersView = Collections.unmodifiableList(this._parameters);
    private final List<TypeReference> _thrownTypesView;
    private final List<CustomAnnotation> _customAnnotationsView;
    private final List<SourceAttribute> _sourceAttributesView;
    private SoftReference<MethodBody> _body;
    private String _name;
    private String _fullName;
    private String _erasedSignature;
    private String _signature;
    private TypeReference _returnType;
    private TypeDefinition _declaringType;
    private long _flags;

    protected MethodDefinition() {
        this._declaredTypesView = Collections.unmodifiableList(this._declaredTypes);
        this._thrownTypesView = Collections.unmodifiableList(this._thrownTypes);
        this._customAnnotationsView = Collections.unmodifiableList(this._customAnnotations);
        this._sourceAttributesView = Collections.unmodifiableList(this._sourceAttributes);
    }

    public final boolean hasBody() {
        SoftReference<MethodBody> bodyCache = this._body;
        return bodyCache != null && bodyCache.get() != null;
    }

    public final MethodBody getBody() {
        MethodBody body;
        SoftReference<MethodBody> cachedBody = this._body;
        if (cachedBody == null || (body = this._body.get()) == null) {
            return this.tryLoadBody();
        }
        return body;
    }

    public final boolean hasThis() {
        return !this.isStatic();
    }

    protected final void setBody(MethodBody body) {
        this._body = new SoftReference<MethodBody>(body);
    }

    @Override
    public final boolean isDefinition() {
        return true;
    }

    public final boolean isAnonymousClassConstructor() {
        return Flags.testAny(this._flags, 0x20000000L);
    }

    public final List<TypeDefinition> getDeclaredTypes() {
        return this._declaredTypesView;
    }

    protected final AnonymousLocalTypeCollection getDeclaredTypesInternal() {
        return this._declaredTypes;
    }

    @Override
    public final List<GenericParameter> getGenericParameters() {
        return this._genericParametersView;
    }

    @Override
    public final List<TypeReference> getThrownTypes() {
        return this._thrownTypesView;
    }

    @Override
    public final TypeDefinition getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public final List<CustomAnnotation> getAnnotations() {
        return this._customAnnotationsView;
    }

    public final List<SourceAttribute> getSourceAttributes() {
        return this._sourceAttributesView;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public String getFullName() {
        if (this._fullName == null) {
            this._fullName = super.getFullName();
        }
        return this._fullName;
    }

    @Override
    public String getSignature() {
        if (this._signature == null) {
            this._signature = super.getSignature();
        }
        return this._signature;
    }

    @Override
    public String getErasedSignature() {
        if (this._erasedSignature == null) {
            this._erasedSignature = super.getErasedSignature();
        }
        return this._erasedSignature;
    }

    @Override
    public final TypeReference getReturnType() {
        return this._returnType;
    }

    @Override
    public final List<ParameterDefinition> getParameters() {
        return this._parametersView;
    }

    protected final void setName(String name) {
        this._name = name;
    }

    protected final void setReturnType(TypeReference returnType) {
        this._returnType = returnType;
        this.invalidateSignature();
    }

    protected final void setDeclaringType(TypeDefinition declaringType) {
        this._declaringType = declaringType;
        this._parameters.setDeclaringType(declaringType);
    }

    protected final void setFlags(long flags) {
        this._flags = flags;
    }

    protected final GenericParameterCollection getGenericParametersInternal() {
        return this._genericParameters;
    }

    protected final ParameterDefinitionCollection getParametersInternal() {
        return this._parameters;
    }

    protected final Collection<TypeReference> getThrownTypesInternal() {
        return this._thrownTypes;
    }

    protected final Collection<CustomAnnotation> getAnnotationsInternal() {
        return this._customAnnotations;
    }

    protected final Collection<SourceAttribute> getSourceAttributesInternal() {
        return this._sourceAttributes;
    }

    public int hashCode() {
        return HashUtilities.hashCode(this.getFullName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodDefinition) {
            MethodDefinition other = (MethodDefinition)obj;
            return StringUtilities.equals(this.getName(), other.getName()) && StringUtilities.equals(this.getErasedSignature(), other.getErasedSignature()) && this.typeNamesMatch(this.getDeclaringType(), other.getDeclaringType());
        }
        return false;
    }

    @Override
    public void invalidateSignature() {
        this._signature = null;
        this._erasedSignature = null;
    }

    private boolean typeNamesMatch(TypeReference t1, TypeReference t2) {
        return t1 != null && t2 != null && StringUtilities.equals(t1.getFullName(), t2.getFullName());
    }

    public final boolean isAbstract() {
        return Flags.testAny(this.getFlags(), 1024L);
    }

    public final boolean isDefault() {
        return Flags.testAny(this.getFlags(), 0x80000000000L);
    }

    public final boolean isBridgeMethod() {
        return Flags.testAny(this.getFlags(), 0x80000040L);
    }

    public final boolean isVarArgs() {
        return Flags.testAny(this.getFlags(), 0x400000080L);
    }

    @Override
    public final long getFlags() {
        return this._flags;
    }

    @Override
    public final int getModifiers() {
        return Flags.toModifiers(this.getFlags());
    }

    @Override
    public final boolean isFinal() {
        return Flags.testAny(this.getFlags(), 16L);
    }

    @Override
    public final boolean isNonPublic() {
        return !Flags.testAny(this.getFlags(), 1L);
    }

    @Override
    public final boolean isPrivate() {
        return Flags.testAny(this.getFlags(), 2L);
    }

    @Override
    public final boolean isProtected() {
        return Flags.testAny(this.getFlags(), 4L);
    }

    @Override
    public final boolean isPublic() {
        return Flags.testAny(this.getFlags(), 1L);
    }

    @Override
    public final boolean isStatic() {
        return Flags.testAny(this.getFlags(), 8L);
    }

    @Override
    public final boolean isSynthetic() {
        return Flags.testAny(this.getFlags(), 4096L);
    }

    @Override
    public final boolean isDeprecated() {
        return Flags.testAny(this.getFlags(), 131072L);
    }

    @Override
    public final boolean isPackagePrivate() {
        return !Flags.testAny(this.getFlags(), 7L);
    }

    @Override
    public String getBriefDescription() {
        return this.appendBriefDescription(new StringBuilder()).toString();
    }

    @Override
    public String getDescription() {
        return this.appendDescription(new StringBuilder()).toString();
    }

    @Override
    public String getErasedDescription() {
        return this.appendErasedDescription(new StringBuilder()).toString();
    }

    @Override
    public String getSimpleDescription() {
        return this.appendSimpleDescription(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
        TypeDefinition declaringType;
        if (fullName && (declaringType = this.getDeclaringType()) != null) {
            return declaringType.appendName(sb, true, false).append('.').append(this.getName());
        }
        return sb.append(this._name);
    }

    public StringBuilder appendDescription(StringBuilder sb) {
        StringBuilder s2 = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers() & 0xFFFFFF7F)) {
            s2.append(modifier.toString());
            s2.append(' ');
        }
        List<TypeReference> typeArguments = this instanceof IGenericInstance ? ((IGenericInstance)((Object)this)).getTypeArguments() : (this.hasGenericParameters() ? this.getGenericParameters() : Collections.emptyList());
        if (!typeArguments.isEmpty()) {
            int count = typeArguments.size();
            s2.append('<');
            for (int i = 0; i < count; ++i) {
                if (i != 0) {
                    s2.append(", ");
                }
                s2 = typeArguments.get(i).appendSimpleDescription(s2);
            }
            s2.append('>');
            s2.append(' ');
        }
        TypeReference returnType = this.getReturnType();
        while (returnType.isWildcardType()) {
            returnType = returnType.getExtendsBound();
        }
        if (returnType.isGenericParameter()) {
            s2.append(returnType.getName());
        } else {
            s2 = returnType.appendSimpleDescription(s2);
        }
        s2.append(' ');
        s2.append(this.getName());
        s2.append('(');
        List<ParameterDefinition> parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterDefinition p = parameters.get(i);
            if (i != 0) {
                s2.append(", ");
            }
            TypeReference parameterType = p.getParameterType();
            while (parameterType.isWildcardType()) {
                parameterType = parameterType.getExtendsBound();
            }
            if (parameterType.isGenericParameter()) {
                s2.append(parameterType.getName());
            } else {
                s2 = parameterType.appendSimpleDescription(s2);
            }
            s2.append(" ").append(p.getName());
        }
        s2.append(')');
        List<TypeReference> thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s2.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                TypeReference t2 = thrownTypes.get(i);
                if (i != 0) {
                    s2.append(", ");
                }
                s2 = t2.appendBriefDescription(s2);
            }
        }
        return s2;
    }

    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        StringBuilder s2 = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers() & 0xFFFFFF7F)) {
            s2.append(modifier.toString());
            s2.append(' ');
        }
        List<TypeReference> typeArguments = this instanceof IGenericInstance ? ((IGenericInstance)((Object)this)).getTypeArguments() : (this.hasGenericParameters() ? this.getGenericParameters() : Collections.emptyList());
        if (!typeArguments.isEmpty()) {
            s2.append('<');
            int n = typeArguments.size();
            for (int i = 0; i < n; ++i) {
                TypeReference typeArgument;
                if (i != 0) {
                    s2.append(", ");
                }
                if ((typeArgument = typeArguments.get(i)) instanceof GenericParameter) {
                    s2.append(typeArgument.getSimpleName());
                    continue;
                }
                s2 = typeArgument.appendSimpleDescription(s2);
            }
            s2.append('>');
            s2.append(' ');
        }
        TypeReference returnType = this.getReturnType();
        while (returnType.isWildcardType()) {
            returnType = returnType.getExtendsBound();
        }
        if (returnType.isGenericParameter()) {
            s2.append(returnType.getName());
        } else {
            s2 = returnType.appendSimpleDescription(s2);
        }
        s2.append(' ');
        s2.append(this.getName());
        s2.append('(');
        List<ParameterDefinition> parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterDefinition p = parameters.get(i);
            if (i != 0) {
                s2.append(", ");
            }
            TypeReference parameterType = p.getParameterType();
            while (parameterType.isWildcardType()) {
                parameterType = parameterType.getExtendsBound();
            }
            if (parameterType.isGenericParameter()) {
                s2.append(parameterType.getName());
                continue;
            }
            s2 = parameterType.appendSimpleDescription(s2);
        }
        s2.append(')');
        List<TypeReference> thrownTypes = this.getThrownTypes();
        if (!thrownTypes.isEmpty()) {
            s2.append(" throws ");
            int n2 = thrownTypes.size();
            for (int i = 0; i < n2; ++i) {
                TypeReference t2 = thrownTypes.get(i);
                if (i != 0) {
                    s2.append(", ");
                }
                s2 = t2.appendSimpleDescription(s2);
            }
        }
        return s2;
    }

    public StringBuilder appendBriefDescription(StringBuilder sb) {
        StringBuilder s2 = sb;
        TypeReference returnType = this.getReturnType();
        while (returnType.isWildcardType()) {
            returnType = returnType.getExtendsBound();
        }
        if (returnType.isGenericParameter()) {
            s2.append(returnType.getName());
        } else {
            s2 = returnType.appendBriefDescription(s2);
        }
        s2.append(' ');
        s2.append(this.getName());
        s2.append('(');
        List<ParameterDefinition> parameters = this.getParameters();
        int n = parameters.size();
        for (int i = 0; i < n; ++i) {
            ParameterDefinition p = parameters.get(i);
            if (i != 0) {
                s2.append(", ");
            }
            TypeReference parameterType = p.getParameterType();
            while (parameterType.isWildcardType()) {
                parameterType = parameterType.getExtendsBound();
            }
            if (parameterType.isGenericParameter()) {
                s2.append(parameterType.getName());
                continue;
            }
            s2 = parameterType.appendBriefDescription(s2);
        }
        s2.append(')');
        return s2;
    }

    public StringBuilder appendErasedDescription(StringBuilder sb) {
        Object definition;
        if (this.hasGenericParameters() && !this.isGenericDefinition() && (definition = this.resolve()) != null) {
            return ((MethodDefinition)definition).appendErasedDescription(sb);
        }
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers() & 0xFFFFFF7F)) {
            sb.append(modifier.toString());
            sb.append(' ');
        }
        List<ParameterDefinition> parameterTypes = this.getParameters();
        StringBuilder s2 = this.getReturnType().appendErasedDescription(sb);
        s2.append(' ');
        s2.append(this.getName());
        s2.append('(');
        int n = parameterTypes.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s2.append(", ");
            }
            s2 = parameterTypes.get(i).getParameterType().appendErasedDescription(s2);
        }
        s2.append(')');
        return s2;
    }

    @Override
    public String toString() {
        return this.getSimpleDescription();
    }

    private MethodBody tryLoadBody() {
        if (Flags.testAny(this._flags, 0x400000000000L)) {
            return null;
        }
        CodeAttribute codeAttribute = (CodeAttribute)SourceAttribute.find("Code", this._sourceAttributes);
        if (codeAttribute == null) {
            return null;
        }
        int codeAttributeIndex = this._sourceAttributes.indexOf(codeAttribute);
        Buffer code = codeAttribute.getCode();
        ConstantPool constantPool = this._declaringType.getConstantPool();
        if (code == null) {
            ITypeLoader typeLoader = this._declaringType.getTypeLoader();
            if (typeLoader == null) {
                this._flags |= 0x400000000000L;
                return null;
            }
            code = new Buffer();
            if (!typeLoader.tryLoadType(this._declaringType.getInternalName(), code)) {
                this._flags |= 0x400000000000L;
                return null;
            }
            List<ExceptionTableEntry> exceptionTableEntries = codeAttribute.getExceptionTableEntries();
            List<SourceAttribute> codeAttributes = codeAttribute.getAttributes();
            CodeAttribute newCode = new CodeAttribute(codeAttribute.getLength(), codeAttribute.getMaxStack(), codeAttribute.getMaxLocals(), codeAttribute.getCodeOffset(), codeAttribute.getCodeSize(), code, exceptionTableEntries.toArray(new ExceptionTableEntry[exceptionTableEntries.size()]), codeAttributes.toArray(new SourceAttribute[codeAttributes.size()]));
            if (constantPool == null) {
                long magic = (long)code.readInt() & 0xFFFFFFFFL;
                if (magic != 3405691582L) {
                    throw new IllegalStateException(String.format("Could not load method body for '%s:%s'; wrong magic number in class header: 0x%8X.", this.getFullName(), this.getSignature(), magic));
                }
                code.readUnsignedShort();
                code.readUnsignedShort();
                constantPool = ConstantPool.read(code);
            }
            this._sourceAttributes.set(codeAttributeIndex, newCode);
        }
        MetadataParser parser = new MetadataParser(this._declaringType);
        ClassFileReader.Scope scope = new ClassFileReader.Scope(parser, this._declaringType, constantPool);
        MethodBody body = new MethodReader(this, scope).readBody();
        this._body = new SoftReference<MethodBody>(body);
        this._sourceAttributes.set(codeAttributeIndex, codeAttribute);
        body.tryFreeze();
        return body;
    }
}

