/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.TargetInvocationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public final class ExceptionUtilities {
    public static RuntimeException asRuntimeException(Throwable t2) {
        VerifyArgument.notNull(t2, "t");
        if (t2 instanceof RuntimeException) {
            return (RuntimeException)t2;
        }
        return new UndeclaredThrowableException(t2, "An unhandled checked exception occurred.");
    }

    public static Throwable unwrap(Throwable t2) {
        Throwable cause = t2.getCause();
        if (cause == null || cause == t2) {
            return t2;
        }
        if (t2 instanceof InvocationTargetException || t2 instanceof TargetInvocationException || t2 instanceof UndeclaredThrowableException) {
            return ExceptionUtilities.unwrap(cause);
        }
        return t2;
    }

    public static String getMessage(Throwable t2) {
        String message = VerifyArgument.notNull(t2, "t").getMessage();
        if (StringUtilities.isNullOrWhitespace(message)) {
            return t2.getClass().getSimpleName() + " was thrown.";
        }
        return message;
    }

    /*
     * Exception decompiling
     */
    public static String getStackTraceString(Throwable t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void rethrowCritical(Throwable t2) {
        if (t2 instanceof ThreadDeath || t2 instanceof VirtualMachineError) {
            throw ExceptionUtilities.rethrow(t2);
        }
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable t2) throws T {
        throw t2;
    }

    public static <T extends Throwable, R> R rethrowAs(Throwable t2) throws T {
        throw t2;
    }

    public static RuntimeException wrapOrThrow(Throwable t2) {
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        throw new UndeclaredThrowableException(t2);
    }
}

