/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.ArrayType;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.CoreMetadataFactory;
import com.strobel.assembler.metadata.DefaultTypeVisitor;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.TypeSubstitutionVisitor;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.WildcardType;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringComparison;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.AstKeys;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Condition;
import com.strobel.decompiler.ast.DefaultMap;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Lambda;
import com.strobel.decompiler.ast.Loop;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Variable;
import com.strobel.functions.Supplier;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class TypeAnalysis {
    private static final int FLAG_BOOLEAN_PROHIBITED = 1;
    private final List<ExpressionToInfer> _allExpressions = new ArrayList<ExpressionToInfer>();
    private final Set<Variable> _singleStoreVariables = new LinkedHashSet<Variable>();
    private final Set<Variable> _singleLoadVariables = new LinkedHashSet<Variable>();
    private final Set<Variable> _allVariables = new LinkedHashSet<Variable>();
    private final Map<Variable, List<ExpressionToInfer>> _assignmentExpressions = new LinkedHashMap<Variable, List<ExpressionToInfer>>(){

        @Override
        public List<ExpressionToInfer> get(Object key) {
            ArrayList value = (ArrayList)super.get(key);
            if (value == null) {
                if (TypeAnalysis.this._doneInitializing) {
                    return Collections.emptyList();
                }
                value = new ArrayList();
                this.put((Variable)key, value);
            }
            return value;
        }
    };
    private final Map<Variable, Set<TypeReference>> _previouslyInferred = new DefaultMap(CollectionUtilities.setFactory());
    private final IdentityHashMap<Variable, TypeReference> _inferredVariableTypes = new IdentityHashMap();
    private final Stack<Expression> _stack = new Stack();
    private DecompilerContext _context;
    private CoreMetadataFactory _factory;
    private boolean _preserveMetadataTypes;
    private boolean _preserveMetadataGenericTypes;
    private boolean _doneInitializing;

    public static void run(DecompilerContext context, Block method) {
        TypeAnalysis ta = new TypeAnalysis();
        Object localVariableTable = SourceAttribute.find("LocalVariableTable", context.getCurrentMethod().getSourceAttributes());
        Object localVariableTypeTable = SourceAttribute.find("LocalVariableTypeTable", context.getCurrentMethod().getSourceAttributes());
        ta._context = context;
        ta._factory = CoreMetadataFactory.make(context.getCurrentType(), (IGenericContext)context.getCurrentMethod());
        ta._preserveMetadataTypes = localVariableTable != null;
        ta._preserveMetadataGenericTypes = localVariableTypeTable != null;
        ta.createDependencyGraph(method);
        ta.identifySingleLoadVariables();
        ta._doneInitializing = true;
        ta.runInference();
    }

    public static void reset(DecompilerContext context, Block method) {
        Object localVariableTable = SourceAttribute.find("LocalVariableTable", context.getCurrentMethod().getSourceAttributes());
        Object localVariableTypeTable = SourceAttribute.find("LocalVariableTypeTable", context.getCurrentMethod().getSourceAttributes());
        boolean preserveTypesFromMetadata = localVariableTable != null;
        boolean preserveGenericTypesFromMetadata = localVariableTypeTable != null;
        for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
            Variable variable;
            e.setInferredType(null);
            e.setExpectedType(null);
            Object operand = e.getOperand();
            if (!(operand instanceof Variable) || !TypeAnalysis.shouldResetVariableType(variable = (Variable)operand, preserveTypesFromMetadata, preserveGenericTypesFromMetadata)) continue;
            variable.setType(null);
        }
    }

    private void createDependencyGraph(Node node) {
        block5: {
            block8: {
                ExpressionToInfer expressionToInfer;
                Expression expression;
                block9: {
                    Variable opVariable;
                    block7: {
                        block6: {
                            block4: {
                                if (!(node instanceof Condition)) break block4;
                                ((Condition)node).getCondition().setExpectedType(BuiltinTypes.Boolean);
                                break block5;
                            }
                            if (!(node instanceof Loop) || ((Loop)node).getCondition() == null) break block6;
                            ((Loop)node).getCondition().setExpectedType(BuiltinTypes.Boolean);
                            break block5;
                        }
                        if (!(node instanceof CatchBlock)) break block7;
                        CatchBlock catchBlock = (CatchBlock)node;
                        if (catchBlock.getExceptionVariable() != null && catchBlock.getExceptionType() != null && catchBlock.getExceptionVariable().getType() == null) {
                            catchBlock.getExceptionVariable().setType(catchBlock.getExceptionType());
                        }
                        break block5;
                    }
                    if (!(node instanceof Expression)) break block8;
                    expression = (Expression)node;
                    expressionToInfer = new ExpressionToInfer();
                    expressionToInfer.expression = expression;
                    this._allExpressions.add(expressionToInfer);
                    this.findNestedAssignments(expression, expressionToInfer);
                    if (!expression.getCode().isStore()) break block5;
                    if (!(expression.getOperand() instanceof Variable) || !this.shouldInferVariableType(opVariable = (Variable)expression.getOperand())) break block9;
                    this._assignmentExpressions.get(opVariable).add(expressionToInfer);
                    this._allVariables.add(opVariable);
                    break block5;
                }
                StrongBox v = new StrongBox();
                if (!PatternMatching.matchLoad((Node)expression.getArguments().get(0), v) || !this.shouldInferVariableType((Variable)v.value)) break block5;
                this._assignmentExpressions.get(v.value).add(expressionToInfer);
                this._allVariables.add((Variable)v.value);
                break block5;
            }
            if (node instanceof Lambda) {
                Lambda lambda = (Lambda)node;
                List<Variable> parameters = lambda.getParameters();
                for (Variable parameter : parameters) {
                    this._assignmentExpressions.get(parameter);
                }
            }
        }
        for (Node child : node.getChildren()) {
            this.createDependencyGraph(child);
        }
    }

    private void findNestedAssignments(Expression expression, ExpressionToInfer parent) {
        for (Expression argument : expression.getArguments()) {
            Variable variable;
            ExpressionToInfer expressionToInfer;
            Object operand = argument.getOperand();
            if (operand instanceof Variable) {
                this._allVariables.add((Variable)operand);
            }
            if (argument.getCode() == AstCode.Store) {
                expressionToInfer = new ExpressionToInfer();
                expressionToInfer.expression = argument;
                this._allExpressions.add(expressionToInfer);
                variable = (Variable)operand;
                if (this.shouldInferVariableType(variable)) {
                    this._assignmentExpressions.get(variable).add(expressionToInfer);
                    this._allVariables.add(variable);
                    parent.dependencies.add(variable);
                }
            } else if (argument.getCode() == AstCode.Inc) {
                expressionToInfer = new ExpressionToInfer();
                expressionToInfer.expression = argument;
                this._allExpressions.add(expressionToInfer);
                variable = (Variable)operand;
                if (this.shouldInferVariableType(variable)) {
                    this._assignmentExpressions.get(variable).add(expressionToInfer);
                    this._allVariables.add(variable);
                    parent.dependencies.add(variable);
                }
            } else if (argument.getCode() == AstCode.PreIncrement || argument.getCode() == AstCode.PostIncrement) {
                expressionToInfer = new ExpressionToInfer();
                expressionToInfer.expression = argument;
                this._allExpressions.add(expressionToInfer);
                Expression load = CollectionUtilities.firstOrDefault(argument.getArguments());
                StrongBox<Variable> variable2 = new StrongBox<Variable>();
                if (load != null && PatternMatching.matchLoadOrRet(load, variable2) && this.shouldInferVariableType((Variable)variable2.value)) {
                    this._assignmentExpressions.get(variable2.value).add(expressionToInfer);
                    this._allVariables.add((Variable)variable2.value);
                    parent.dependencies.add(variable2.value);
                }
            } else {
                StrongBox<Variable> variable3 = new StrongBox<Variable>();
                if (PatternMatching.matchLoadOrRet(argument, variable3) && !this.isThisParameter((Variable)variable3.value)) {
                    parent.dependencies.add(variable3.value);
                    this._allVariables.add((Variable)variable3.value);
                }
            }
            this.findNestedAssignments(argument, parent);
        }
    }

    private boolean isSingleStoreBoolean(Variable variable) {
        if (this._singleStoreVariables.contains(variable)) {
            List<ExpressionToInfer> assignments = this._assignmentExpressions.get(variable);
            ExpressionToInfer e = CollectionUtilities.single(assignments);
            return PatternMatching.matchBooleanConstant(CollectionUtilities.last(e.expression.getArguments())) != null;
        }
        return false;
    }

    private void identifySingleLoadVariables() {
        DefaultMap groupedExpressions = new DefaultMap(new Supplier<List<ExpressionToInfer>>(){

            @Override
            public List<ExpressionToInfer> get() {
                return new ArrayList<ExpressionToInfer>();
            }
        });
        for (ExpressionToInfer expressionToInfer : this._allExpressions) {
            Object v;
            for (Variable variable : expressionToInfer.dependencies) {
                ((List)groupedExpressions.get(variable)).add(expressionToInfer);
            }
            if (expressionToInfer.expression.getCode() != AstCode.Store || !((v = expressionToInfer.expression.getOperand()) instanceof Variable)) continue;
            groupedExpressions.get((Variable)v);
        }
        for (Variable variable : groupedExpressions.keySet()) {
            List expressions = (List)groupedExpressions.get(variable);
            if (expressions.size() != 1) continue;
            int references = 0;
            for (Expression expression : ((ExpressionToInfer)expressions.get((int)0)).expression.getSelfAndChildrenRecursive(Expression.class)) {
                if (expression.getOperand() == variable && ++references > 1) break;
            }
            if (references != true) continue;
            this._singleLoadVariables.add(variable);
            for (ExpressionToInfer assignment : this._assignmentExpressions.get(variable)) {
                assignment.dependsOnSingleLoad = variable;
            }
        }
        for (Variable variable : this._assignmentExpressions.keySet()) {
            int references = this._assignmentExpressions.get(variable).size();
            if (references != 1) continue;
            this._singleStoreVariables.add(variable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runInference() {
        this._previouslyInferred.clear();
        this._inferredVariableTypes.clear();
        int numberOfExpressionsAlreadyInferred = 0;
        boolean ignoreSingleLoadDependencies = false;
        boolean assignVariableTypesBasedOnPartialInformation = false;
        Predicate<Variable> dependentVariableTypesKnown = new Predicate<Variable>(){

            @Override
            public boolean test(Variable v) {
                return TypeAnalysis.this.inferTypeForVariable(v, null) != null || TypeAnalysis.this._singleLoadVariables.contains(v);
            }
        };
        while (true) {
            block7: {
                if (numberOfExpressionsAlreadyInferred >= this._allExpressions.size()) {
                    this.verifyResults();
                    return;
                }
                int oldCount = numberOfExpressionsAlreadyInferred;
                for (ExpressionToInfer e : this._allExpressions) {
                    if (e.done || !TypeAnalysis.trueForAll(e.dependencies, dependentVariableTypesKnown) || e.dependsOnSingleLoad != null && e.dependsOnSingleLoad.getType() == null && !ignoreSingleLoadDependencies) continue;
                    this.runInference(e.expression);
                    e.done = true;
                    ++numberOfExpressionsAlreadyInferred;
                }
                if (numberOfExpressionsAlreadyInferred == oldCount) {
                    if (ignoreSingleLoadDependencies) {
                        if (assignVariableTypesBasedOnPartialInformation) {
                            throw new IllegalStateException("Could not infer any expression.");
                        }
                        assignVariableTypesBasedOnPartialInformation = true;
                        break block7;
                    } else {
                        ignoreSingleLoadDependencies = true;
                        continue;
                    }
                }
                assignVariableTypesBasedOnPartialInformation = false;
                ignoreSingleLoadDependencies = false;
            }
            this.inferTypesForVariables(assignVariableTypesBasedOnPartialInformation);
        }
    }

    private void verifyResults() {
        StrongBox<Expression> a = new StrongBox<Expression>();
        for (Variable variable : this._allVariables) {
            TypeReference type = variable.getType();
            if (type == null || type == BuiltinTypes.Null) {
                TypeReference inferredType = this.inferTypeForVariable(variable, BuiltinTypes.Object);
                if (inferredType == null || inferredType == BuiltinTypes.Null) {
                    variable.setType(BuiltinTypes.Object);
                    continue;
                }
                variable.setType(inferredType);
                continue;
            }
            if (type.isWildcardType()) {
                variable.setType(MetadataHelper.getUpperBound(type));
                continue;
            }
            if (type.getSimpleType() == JvmType.Boolean) {
                for (ExpressionToInfer e : this._assignmentExpressions.get(variable)) {
                    Boolean booleanConstant;
                    if (!PatternMatching.matchStore((Node)e.expression, variable, a) || (booleanConstant = PatternMatching.matchBooleanConstant((Node)a.value)) == null) continue;
                    e.expression.setExpectedType(BuiltinTypes.Boolean);
                    e.expression.setInferredType(BuiltinTypes.Boolean);
                    ((Expression)a.value).setExpectedType(BuiltinTypes.Boolean);
                    ((Expression)a.value).setInferredType(BuiltinTypes.Boolean);
                }
                continue;
            }
            if (type.getSimpleType() != JvmType.Character) continue;
            for (ExpressionToInfer e : this._assignmentExpressions.get(variable)) {
                Character characterConstant;
                if (!PatternMatching.matchStore((Node)e.expression, variable, a) || (characterConstant = PatternMatching.matchCharacterConstant((Node)a.value)) == null) continue;
                e.expression.setExpectedType(BuiltinTypes.Character);
                e.expression.setInferredType(BuiltinTypes.Character);
                ((Expression)a.value).setExpectedType(BuiltinTypes.Character);
                ((Expression)a.value).setInferredType(BuiltinTypes.Character);
            }
        }
    }

    private void inferTypesForVariables(boolean assignVariableTypesBasedOnPartialInformation) {
        for (Variable variable : this._allVariables) {
            List<ExpressionToInfer> expressionsToInfer = this._assignmentExpressions.get(variable);
            boolean inferredFromNull = false;
            TypeReference inferredType = null;
            if (variable.isLambdaParameter()) {
                inferredType = this._inferredVariableTypes.get(variable);
                if (inferredType == null) {
                    continue;
                }
            } else {
                if (expressionsToInfer.isEmpty() || !(assignVariableTypesBasedOnPartialInformation ? this.anyDone(expressionsToInfer) : this.allDone(expressionsToInfer))) continue;
                for (ExpressionToInfer e : expressionsToInfer) {
                    List<Expression> arguments = e.expression.getArguments();
                    assert (e.expression.getCode().isStore() && arguments.size() == 1 || e.expression.getCode() == AstCode.Inc || e.expression.getCode() == AstCode.PreIncrement || e.expression.getCode() == AstCode.PostIncrement);
                    Expression assignedValue = arguments.get(0);
                    if (assignedValue.getInferredType() == null) continue;
                    if (inferredType == null) {
                        inferredType = TypeAnalysis.adjustType(assignedValue.getInferredType(), e.flags);
                        inferredFromNull = PatternMatching.match(assignedValue, AstCode.AConstNull);
                        continue;
                    }
                    TypeReference assigned = this.cleanTypeArguments(assignedValue.getInferredType(), inferredType);
                    TypeReference commonSuper = TypeAnalysis.adjustType(this.typeWithMoreInformation(inferredType, assigned), e.flags);
                    if (inferredFromNull && assigned != BuiltinTypes.Null && !MetadataHelper.isAssignableFrom(commonSuper, assigned)) {
                        TypeReference asSubType = MetadataHelper.asSubType(commonSuper, assigned);
                        inferredType = asSubType != null ? asSubType : assigned;
                        inferredFromNull = false;
                        continue;
                    }
                    inferredType = commonSuper;
                }
            }
            if (inferredType == null) {
                inferredType = variable.getType();
            } else if (!inferredType.isUnbounded()) {
                TypeReference typeReference = inferredType = inferredType.hasSuperBound() ? inferredType.getSuperBound() : inferredType.getExtendsBound();
            }
            if (!this.shouldInferVariableType(variable) || inferredType == null) continue;
            variable.setType(inferredType);
            this._inferredVariableTypes.put(variable, inferredType);
            for (ExpressionToInfer e : this._allExpressions) {
                if (!e.dependencies.contains(variable) && !expressionsToInfer.contains(e) || this._stack.contains(e.expression)) continue;
                boolean invalidate = false;
                for (Expression c : e.expression.getSelfAndChildrenRecursive(Expression.class)) {
                    if (this._stack.contains(c)) continue;
                    c.setExpectedType(null);
                    if ((PatternMatching.matchLoad((Node)c, variable) || PatternMatching.matchStore(c, variable)) && !MetadataHelper.isSameType(c.getInferredType(), inferredType)) {
                        c.setExpectedType(inferredType);
                    }
                    c.setInferredType(null);
                    invalidate = true;
                }
                if (!invalidate) continue;
                this.runInference(e.expression, e.flags);
            }
        }
    }

    private boolean isThisParameter(Variable variable) {
        ParameterDefinition parameter = variable.getOriginalParameter();
        return parameter != null && parameter == this._context.getCurrentMethod().getBody().getThisParameter();
    }

    private boolean shouldInferVariableType(Variable variable) {
        VariableDefinition variableDefinition = variable.getOriginalVariable();
        if (variable.isGenerated() || variable.isLambdaParameter()) {
            return true;
        }
        ParameterDefinition parameter = variable.getOriginalParameter();
        if (parameter != null) {
            if (parameter == this._context.getCurrentMethod().getBody().getThisParameter()) {
                return false;
            }
            TypeReference parameterType = parameter.getParameterType();
            return !this._preserveMetadataGenericTypes && (parameterType.isGenericType() || MetadataHelper.isRawType(parameterType));
        }
        return variableDefinition == null || !variableDefinition.isFromMetadata() || !(variableDefinition.getVariableType().isGenericType() ? this._preserveMetadataGenericTypes : this._preserveMetadataTypes);
    }

    private static boolean shouldResetVariableType(Variable variable, boolean preserveTypesFromMetadata, boolean preserveGenericTypesFromMetadata) {
        if (variable.isGenerated() || variable.isLambdaParameter()) {
            return true;
        }
        VariableDefinition variableDefinition = variable.getOriginalVariable();
        if (variableDefinition != null && variableDefinition.isFromMetadata() && (variableDefinition.getVariableType().isGenericType() ? preserveGenericTypesFromMetadata : preserveTypesFromMetadata)) {
            return false;
        }
        return variableDefinition != null && variableDefinition.getVariableType() == BuiltinTypes.Integer || variableDefinition != null && !variableDefinition.isTypeKnown();
    }

    private void runInference(Expression expression) {
        this.runInference(expression, 0);
    }

    private void runInference(Expression expression, int flags) {
        Variable variable;
        List<Expression> arguments = expression.getArguments();
        Variable changedVariable = null;
        boolean anyArgumentIsMissingExpectedType = false;
        for (Expression argument : arguments) {
            if (argument.getExpectedType() != null) continue;
            anyArgumentIsMissingExpectedType = true;
            break;
        }
        if (expression.getInferredType() == null || anyArgumentIsMissingExpectedType) {
            this.inferTypeForExpression(expression, expression.getExpectedType(), anyArgumentIsMissingExpectedType, flags);
        } else if (expression.getInferredType() == BuiltinTypes.Integer && expression.getExpectedType() == BuiltinTypes.Boolean) {
            if (expression.getCode() == AstCode.Load || expression.getCode() == AstCode.Store) {
                variable = (Variable)expression.getOperand();
                expression.setInferredType(BuiltinTypes.Boolean);
                if (variable.getType() == BuiltinTypes.Integer && this.shouldInferVariableType(variable)) {
                    variable.setType(BuiltinTypes.Boolean);
                    changedVariable = variable;
                }
            }
        } else if (expression.getInferredType() == BuiltinTypes.Integer && expression.getExpectedType() == BuiltinTypes.Character && (expression.getCode() == AstCode.Load || expression.getCode() == AstCode.Store)) {
            variable = (Variable)expression.getOperand();
            expression.setInferredType(BuiltinTypes.Character);
            if (variable.getType() == BuiltinTypes.Integer && this.shouldInferVariableType(variable) && this._singleLoadVariables.contains(variable)) {
                variable.setType(BuiltinTypes.Character);
                changedVariable = variable;
            }
        }
        for (Expression argument : arguments) {
            if (argument.getCode().isStore()) continue;
            this.runInference(argument, flags);
        }
        if (changedVariable != null && this._previouslyInferred.get(changedVariable).add(changedVariable.getType())) {
            this.invalidateDependentExpressions(expression, changedVariable);
        }
    }

    private void invalidateDependentExpressions(Expression expression, Variable variable) {
        List<ExpressionToInfer> assignments = this._assignmentExpressions.get(variable);
        TypeReference inferredType = this._inferredVariableTypes.get(variable);
        for (ExpressionToInfer e : this._allExpressions) {
            if (e.expression == expression || !e.dependencies.contains(variable) && !assignments.contains(e) || this._stack.contains(e.expression)) continue;
            boolean invalidate = false;
            for (Expression c : e.expression.getSelfAndChildrenRecursive(Expression.class)) {
                if (this._stack.contains(c)) continue;
                c.setExpectedType(null);
                if ((PatternMatching.matchLoad((Node)c, variable) || PatternMatching.matchStore(c, variable)) && !MetadataHelper.isSameType(c.getInferredType(), inferredType)) {
                    c.setExpectedType(inferredType);
                }
                c.setInferredType(null);
                invalidate = true;
            }
            if (!invalidate) continue;
            this.runInference(e.expression, e.flags);
        }
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType) {
        return this.inferTypeForExpression(expression, expectedType, 0);
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType, int flags) {
        return this.inferTypeForExpression(expression, expectedType, false, flags);
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType, boolean forceInferChildren) {
        return this.inferTypeForExpression(expression, expectedType, forceInferChildren, 0);
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType, boolean forceInferChildren, int flags) {
        boolean actualForceInferChildren = forceInferChildren;
        if (expectedType != null && !this.isSameType(expression.getExpectedType(), expectedType)) {
            expression.setExpectedType(expectedType);
            if (!expression.getCode().isStore()) {
                actualForceInferChildren = true;
            }
        }
        if (actualForceInferChildren || expression.getInferredType() == null) {
            expression.setInferredType(this.doInferTypeForExpression(expression, expectedType, actualForceInferChildren, flags));
        }
        return expression.getInferredType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeReference doInferTypeForExpression(Expression expression, TypeReference expectedType, boolean forceInferChildren, int flags) {
        if (this._stack.contains(expression) && !PatternMatching.match(expression, AstCode.LdC)) {
            return expectedType;
        }
        this._stack.push(expression);
        try {
            AstCode code = expression.getCode();
            Object operand = expression.getOperand();
            List<Expression> arguments = expression.getArguments();
            switch (code) {
                case LogicalNot: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Boolean);
                    }
                    TypeDefinition typeDefinition = BuiltinTypes.Boolean;
                    return typeDefinition;
                }
                case LogicalAnd: 
                case LogicalOr: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Boolean);
                        this.inferTypeForExpression(arguments.get(1), BuiltinTypes.Boolean);
                    }
                    TypeDefinition typeDefinition = BuiltinTypes.Boolean;
                    return typeDefinition;
                }
                case TernaryOp: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Boolean);
                    }
                    TypeReference typeReference = this.inferBinaryArguments(arguments.get(1), arguments.get(2), expectedType, forceInferChildren, null, null, 0);
                    return typeReference;
                }
                case MonitorEnter: 
                case MonitorExit: {
                    TypeReference typeReference = null;
                    return typeReference;
                }
                case Store: {
                    TypeReference inferredType;
                    Variable v = (Variable)operand;
                    TypeReference lastInferredType = this._inferredVariableTypes.get(v);
                    if (PatternMatching.matchBooleanConstant(expression.getArguments().get(0)) != null && this.shouldInferVariableType(v) && TypeAnalysis.isBoolean(this.inferTypeForVariable(v, expectedType != null ? expectedType : BuiltinTypes.Boolean, true, flags))) {
                        TypeDefinition typeDefinition = BuiltinTypes.Boolean;
                        return typeDefinition;
                    }
                    if (forceInferChildren || lastInferredType == null && v.getType() == null) {
                        inferredType = this.inferTypeForExpression(expression.getArguments().get(0), this.inferTypeForVariable(v, null, flags), flags);
                        if (inferredType != null && inferredType.isWildcardType()) {
                            inferredType = MetadataHelper.getUpperBound(inferredType);
                        }
                        if (inferredType != null) {
                            TypeReference typeReference = TypeAnalysis.adjustType(inferredType, flags);
                            return typeReference;
                        }
                    }
                    inferredType = TypeAnalysis.adjustType(lastInferredType != null ? lastInferredType : v.getType(), flags);
                    return inferredType;
                }
                case Load: {
                    Variable v = (Variable)expression.getOperand();
                    TypeReference inferredType = this.inferTypeForVariable(v, expectedType, flags);
                    TypeDefinition thisType = this._context.getCurrentType();
                    if (v.isParameter() && v.getOriginalParameter() == this._context.getCurrentMethod().getBody().getThisParameter()) {
                        if (this._singleLoadVariables.contains(v) && v.getType() == null) {
                            v.setType(thisType);
                        }
                        TypeDefinition typeDefinition = thisType;
                        return typeDefinition;
                    }
                    TypeReference result = inferredType;
                    if (expectedType != null && expectedType != BuiltinTypes.Null && this.shouldInferVariableType(v)) {
                        TypeReference tempResult = MetadataHelper.isSubType(inferredType, expectedType) ? inferredType : MetadataHelper.asSubType(inferredType, expectedType);
                        if (tempResult != null && tempResult.containsGenericParameters()) {
                            Map<TypeReference, TypeReference> mappings = MetadataHelper.adapt(tempResult, inferredType);
                            ArrayList<TypeReference> mappingsToRemove = null;
                            for (TypeReference key : mappings.keySet()) {
                                GenericParameter gp = this._context.getCurrentMethod().findTypeVariable(key.getSimpleName());
                                if (!MetadataHelper.isSameType(gp, key, true)) continue;
                                if (mappingsToRemove == null) {
                                    mappingsToRemove = new ArrayList<TypeReference>();
                                }
                                mappingsToRemove.add(key);
                            }
                            if (mappingsToRemove != null) {
                                CollectionUtilities.removeAll(mappings, mappingsToRemove);
                            }
                            if (!mappings.isEmpty()) {
                                tempResult = TypeSubstitutionVisitor.instance().visit(tempResult, mappings);
                            }
                        }
                        if (tempResult == null && v.getType() != null && (tempResult = MetadataHelper.asSubType(v.getType(), expectedType)) == null) {
                            tempResult = MetadataHelper.asSubType(MetadataHelper.eraseRecursive(v.getType()), expectedType);
                        }
                        if (tempResult == null) {
                            tempResult = expectedType;
                        }
                        if ((result = tempResult).isGenericType()) {
                            if (expectedType.isGenericDefinition() && !result.isGenericDefinition()) {
                                result = result.getUnderlyingType();
                            }
                            if (MetadataHelper.areGenericsSupported(thisType) && MetadataHelper.getUnboundGenericParameterCount(result) > 0) {
                                result = MetadataHelper.substituteGenericArguments(result, inferredType);
                            }
                        }
                        if (result.isGenericDefinition() && !MetadataHelper.canReferenceTypeVariablesOf(result, this._context.getCurrentType())) {
                            result = new RawType(result.getUnderlyingType());
                        }
                    }
                    List<ExpressionToInfer> assignments = this._assignmentExpressions.get(v);
                    if (result == null && assignments.isEmpty()) {
                        result = BuiltinTypes.Object;
                    }
                    if (result != null && result.isWildcardType()) {
                        result = MetadataHelper.getUpperBound(result);
                    }
                    result = TypeAnalysis.adjustType(result, flags);
                    if (flags != 0) {
                        for (int i = 0; i < assignments.size(); ++i) {
                            assignments.get((int)i).flags |= flags;
                        }
                    }
                    this._inferredVariableTypes.put(v, result);
                    if (result != null && !MetadataHelper.isSameType(result, inferredType) && this._previouslyInferred.get(v).add(result)) {
                        expression.setInferredType(result);
                        this.invalidateDependentExpressions(expression, v);
                    }
                    if (this._singleLoadVariables.contains(v) && v.getType() == null) {
                        v.setType(result);
                    }
                    TypeReference i = result;
                    return i;
                }
                case InvokeDynamic: {
                    TypeReference v = this.inferDynamicCall(expression, expectedType, forceInferChildren);
                    return v;
                }
                case InvokeVirtual: 
                case InvokeSpecial: 
                case InvokeStatic: 
                case InvokeInterface: {
                    TypeReference v = this.inferCall(expression, expectedType, forceInferChildren);
                    return v;
                }
                case GetField: {
                    MemberReference resolvedField;
                    FieldReference field = (FieldReference)operand;
                    if (forceInferChildren) {
                        resolvedField = field.resolve();
                        MemberReference effectiveField = resolvedField != null ? resolvedField : field;
                        TypeReference targetType = this.inferTypeForExpression(arguments.get(0), field.getDeclaringType());
                        if (targetType != null) {
                            FieldReference asMember = MetadataHelper.asMemberOf(effectiveField, targetType);
                            TypeReference i = asMember.getFieldType();
                            return i;
                        }
                    }
                    resolvedField = TypeAnalysis.getFieldType((FieldReference)operand);
                    return resolvedField;
                }
                case GetStatic: {
                    TypeReference field = TypeAnalysis.getFieldType((FieldReference)operand);
                    return field;
                }
                case PutField: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), ((FieldReference)operand).getDeclaringType());
                        this.inferTypeForExpression(arguments.get(1), TypeAnalysis.getFieldType((FieldReference)operand));
                    }
                    TypeReference field = TypeAnalysis.getFieldType((FieldReference)operand);
                    return field;
                }
                case PutStatic: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), TypeAnalysis.getFieldType((FieldReference)operand));
                    }
                    TypeReference field = TypeAnalysis.getFieldType((FieldReference)operand);
                    return field;
                }
                case __New: {
                    TypeReference field = (TypeReference)operand;
                    return field;
                }
                case PreIncrement: 
                case PostIncrement: {
                    TypeReference inferredType = this.inferTypeForExpression(arguments.get(0), null, flags | 1);
                    if (inferredType == null || inferredType == BuiltinTypes.Boolean) {
                        Number n = (Number)operand;
                        if (n instanceof Long) {
                            TypeDefinition effectiveField = BuiltinTypes.Long;
                            return effectiveField;
                        }
                        TypeDefinition effectiveField = BuiltinTypes.Integer;
                        return effectiveField;
                    }
                    TypeReference n = inferredType;
                    return n;
                }
                case Not: 
                case Neg: {
                    TypeReference inferredType = this.inferTypeForExpression(arguments.get(0), expectedType);
                    return inferredType;
                }
                case Add: 
                case Sub: 
                case Mul: 
                case Or: 
                case And: 
                case Xor: 
                case Div: 
                case Rem: {
                    TypeReference inferredType = this.inferBinaryExpression(code, arguments, flags);
                    return inferredType;
                }
                case Shl: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                    }
                    if (expectedType != null && (expectedType.getSimpleType() == JvmType.Integer || expectedType.getSimpleType() == JvmType.Long)) {
                        TypeReference inferredType = this.doBinaryNumericPromotion(this.inferTypeForExpression(arguments.get(0), expectedType, flags | 1));
                        return inferredType;
                    }
                    TypeReference inferredType = this.doBinaryNumericPromotion(this.inferTypeForExpression(arguments.get(0), null, flags | 1));
                    return inferredType;
                }
                case Shr: 
                case UShr: {
                    TypeReference type;
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                    }
                    if ((type = this.doBinaryNumericPromotion(this.inferTypeForExpression(arguments.get(0), null, flags | 1))) == null) {
                        TypeReference n = null;
                        return n;
                    }
                    TypeDefinition expectedInputType = null;
                    switch (type.getSimpleType()) {
                        case Integer: {
                            expectedInputType = BuiltinTypes.Integer;
                            break;
                        }
                        case Long: {
                            expectedInputType = BuiltinTypes.Long;
                        }
                    }
                    if (expectedInputType != null) {
                        this.inferTypeForExpression(arguments.get(0), expectedInputType);
                        TypeDefinition effectiveField = expectedInputType;
                        return effectiveField;
                    }
                    TypeReference effectiveField = type;
                    return effectiveField;
                }
                case CompoundAssignment: {
                    Expression op = arguments.get(0);
                    TypeReference targetType = this.inferTypeForExpression(op.getArguments().get(0), null);
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), targetType);
                    }
                    TypeReference effectiveField = targetType;
                    return effectiveField;
                }
                case AConstNull: {
                    if (expectedType != null && !expectedType.isPrimitive()) {
                        TypeReference op = expectedType;
                        return op;
                    }
                    TypeDefinition op = BuiltinTypes.Null;
                    return op;
                }
                case LdC: {
                    if (operand instanceof Boolean && PatternMatching.matchBooleanConstant(expression) != null && !Flags.testAny(flags, 1)) {
                        TypeDefinition op = BuiltinTypes.Boolean;
                        return op;
                    }
                    if (operand instanceof Character && PatternMatching.matchCharacterConstant(expression) != null) {
                        TypeDefinition op = BuiltinTypes.Character;
                        return op;
                    }
                    if (operand instanceof Number) {
                        Number number = (Number)operand;
                        if (number instanceof Integer) {
                            if (expectedType != null) {
                                switch (expectedType.getSimpleType()) {
                                    case Boolean: {
                                        if (number.intValue() == 0 || number.intValue() == 1) {
                                            TypeReference targetType = TypeAnalysis.adjustType(BuiltinTypes.Boolean, flags);
                                            return targetType;
                                        }
                                        TypeDefinition targetType = BuiltinTypes.Integer;
                                        return targetType;
                                    }
                                    case Byte: {
                                        if (number.intValue() >= -128 && number.intValue() <= 127) {
                                            TypeDefinition targetType = BuiltinTypes.Byte;
                                            return targetType;
                                        }
                                        TypeDefinition targetType = BuiltinTypes.Integer;
                                        return targetType;
                                    }
                                    case Character: {
                                        if (number.intValue() >= 0 && number.intValue() <= 65535) {
                                            TypeDefinition targetType = BuiltinTypes.Character;
                                            return targetType;
                                        }
                                        TypeDefinition targetType = BuiltinTypes.Integer;
                                        return targetType;
                                    }
                                    case Short: {
                                        if (number.intValue() >= Short.MIN_VALUE && number.intValue() <= Short.MAX_VALUE) {
                                            TypeDefinition targetType = BuiltinTypes.Short;
                                            return targetType;
                                        }
                                        TypeDefinition targetType = BuiltinTypes.Integer;
                                        return targetType;
                                    }
                                }
                            } else if (PatternMatching.matchBooleanConstant(expression) != null) {
                                TypeReference targetType = TypeAnalysis.adjustType(BuiltinTypes.Boolean, flags);
                                return targetType;
                            }
                            TypeDefinition targetType = BuiltinTypes.Integer;
                            return targetType;
                        }
                        if (number instanceof Long) {
                            TypeDefinition targetType = BuiltinTypes.Long;
                            return targetType;
                        }
                        if (number instanceof Float) {
                            TypeDefinition targetType = BuiltinTypes.Float;
                            return targetType;
                        }
                        TypeDefinition targetType = BuiltinTypes.Double;
                        return targetType;
                    }
                    if (operand instanceof TypeReference) {
                        TypeReference number = this._factory.makeParameterizedType(this._factory.makeNamedType("java.lang.Class"), null, (TypeReference)operand);
                        return number;
                    }
                    TypeReference number = this._factory.makeNamedType("java.lang.String");
                    return number;
                }
                case NewArray: 
                case __NewArray: 
                case __ANewArray: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), (TypeReference)BuiltinTypes.Integer, flags | 1);
                    }
                    TypeReference number = ((TypeReference)operand).makeArrayType();
                    return number;
                }
                case MultiANewArray: {
                    if (forceInferChildren) {
                        for (int i = 0; i < arguments.size(); ++i) {
                            this.inferTypeForExpression(arguments.get(i), (TypeReference)BuiltinTypes.Integer, flags | 1);
                        }
                    }
                    TypeReference i = (TypeReference)operand;
                    return i;
                }
                case InitObject: {
                    TypeReference i = this.inferInitObject(expression, expectedType, forceInferChildren, (MethodReference)operand, arguments);
                    return i;
                }
                case InitArray: {
                    TypeReference arrayType = (TypeReference)operand;
                    TypeReference elementType = arrayType.getElementType();
                    if (forceInferChildren) {
                        for (Expression argument : arguments) {
                            this.inferTypeForExpression(argument, elementType);
                        }
                    }
                    TypeReference effectiveField = arrayType;
                    return effectiveField;
                }
                case ArrayLength: {
                    TypeDefinition arrayType = BuiltinTypes.Integer;
                    return arrayType;
                }
                case LoadElement: {
                    TypeReference arrayType = this.inferTypeForExpression(arguments.get(0), null);
                    this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                    if (arrayType != null && arrayType.isArray()) {
                        TypeReference elementType = arrayType.getElementType();
                        return elementType;
                    }
                    TypeReference elementType = null;
                    return elementType;
                }
                case StoreElement: {
                    TypeReference arrayType = this.inferTypeForExpression(arguments.get(0), null);
                    this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                    TypeReference expectedElementType = arrayType != null && arrayType.isArray() ? arrayType.getElementType() : null;
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(2), expectedElementType);
                    }
                    TypeReference effectiveField = expectedElementType;
                    return effectiveField;
                }
                case __BIPush: 
                case __SIPush: {
                    Number number = (Number)operand;
                    if (expectedType != null) {
                        if (expectedType.getSimpleType() == JvmType.Boolean && (number.intValue() == 0 || number.intValue() == 1)) {
                            TypeDefinition expectedElementType = BuiltinTypes.Boolean;
                            return expectedElementType;
                        }
                        if (expectedType.getSimpleType() == JvmType.Byte && number.intValue() >= -128 && number.intValue() <= 127) {
                            TypeDefinition expectedElementType = BuiltinTypes.Byte;
                            return expectedElementType;
                        }
                        if (expectedType.getSimpleType() == JvmType.Character && number.intValue() >= 0 && number.intValue() <= 65535) {
                            TypeDefinition expectedElementType = BuiltinTypes.Character;
                            return expectedElementType;
                        }
                        if (expectedType.getSimpleType().isIntegral()) {
                            TypeReference expectedElementType = expectedType;
                            return expectedElementType;
                        }
                    } else if (code == AstCode.__BIPush) {
                        TypeDefinition expectedElementType = BuiltinTypes.Byte;
                        return expectedElementType;
                    }
                    TypeDefinition expectedElementType = BuiltinTypes.Short;
                    return expectedElementType;
                }
                case I2L: 
                case I2F: 
                case I2D: 
                case L2I: 
                case L2F: 
                case L2D: 
                case F2I: 
                case F2L: 
                case F2D: 
                case D2I: 
                case D2L: 
                case D2F: 
                case I2B: 
                case I2C: 
                case I2S: {
                    TypeDefinition expectedArgumentType;
                    TypeDefinition conversionResult;
                    switch (code) {
                        case I2L: {
                            conversionResult = BuiltinTypes.Long;
                            expectedArgumentType = BuiltinTypes.Integer;
                            break;
                        }
                        case I2F: {
                            conversionResult = BuiltinTypes.Float;
                            expectedArgumentType = BuiltinTypes.Integer;
                            break;
                        }
                        case I2D: {
                            conversionResult = BuiltinTypes.Double;
                            expectedArgumentType = BuiltinTypes.Integer;
                            break;
                        }
                        case L2I: {
                            conversionResult = BuiltinTypes.Integer;
                            expectedArgumentType = BuiltinTypes.Long;
                            break;
                        }
                        case L2F: {
                            conversionResult = BuiltinTypes.Float;
                            expectedArgumentType = BuiltinTypes.Long;
                            break;
                        }
                        case L2D: {
                            conversionResult = BuiltinTypes.Double;
                            expectedArgumentType = BuiltinTypes.Long;
                            break;
                        }
                        case F2I: {
                            conversionResult = BuiltinTypes.Integer;
                            expectedArgumentType = BuiltinTypes.Float;
                            break;
                        }
                        case F2L: {
                            conversionResult = BuiltinTypes.Long;
                            expectedArgumentType = BuiltinTypes.Float;
                            break;
                        }
                        case F2D: {
                            conversionResult = BuiltinTypes.Double;
                            expectedArgumentType = BuiltinTypes.Float;
                            break;
                        }
                        case D2I: {
                            conversionResult = BuiltinTypes.Integer;
                            expectedArgumentType = BuiltinTypes.Double;
                            break;
                        }
                        case D2L: {
                            conversionResult = BuiltinTypes.Long;
                            expectedArgumentType = BuiltinTypes.Double;
                            break;
                        }
                        case D2F: {
                            conversionResult = BuiltinTypes.Float;
                            expectedArgumentType = BuiltinTypes.Double;
                            break;
                        }
                        case I2B: {
                            conversionResult = BuiltinTypes.Byte;
                            expectedArgumentType = BuiltinTypes.Integer;
                            break;
                        }
                        case I2C: {
                            conversionResult = BuiltinTypes.Character;
                            expectedArgumentType = BuiltinTypes.Integer;
                            break;
                        }
                        case I2S: {
                            conversionResult = BuiltinTypes.Short;
                            expectedArgumentType = BuiltinTypes.Integer;
                            break;
                        }
                        default: {
                            throw ContractUtils.unsupported();
                        }
                    }
                    arguments.get(0).setExpectedType(expectedArgumentType);
                    TypeDefinition effectiveField = conversionResult;
                    return effectiveField;
                }
                case CheckCast: 
                case Unbox: {
                    TypeReference castType;
                    if (expectedType != null) {
                        castType = (TypeReference)operand;
                        TypeReference inferredType = MetadataHelper.asSubType(castType, expectedType);
                        if (forceInferChildren) {
                            inferredType = this.inferTypeForExpression(arguments.get(0), inferredType != null ? inferredType : (TypeReference)operand);
                        }
                        if (inferredType != null && MetadataHelper.isBytecodeCastAssignable(inferredType, castType) && MetadataHelper.isAssignableFrom(expectedType, inferredType)) {
                            expression.setOperand(inferredType);
                            TypeReference effectiveField = inferredType;
                            return effectiveField;
                        }
                    }
                    castType = (TypeReference)operand;
                    return castType;
                }
                case Box: {
                    TypeReference type = (TypeReference)operand;
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), type);
                    }
                    TypeReference inferredType = type.isPrimitive() ? BuiltinTypes.Object : type;
                    return inferredType;
                }
                case CmpEq: 
                case CmpNe: 
                case CmpLt: 
                case CmpGe: 
                case CmpGt: 
                case CmpLe: {
                    if (forceInferChildren) {
                        TypeReference type = this.inferBinaryExpression(code, arguments, flags);
                        return type;
                    }
                    TypeDefinition type = BuiltinTypes.Boolean;
                    return type;
                }
                case __DCmpG: 
                case __DCmpL: 
                case __FCmpG: 
                case __FCmpL: 
                case __LCmp: {
                    if (forceInferChildren) {
                        TypeReference type = this.inferBinaryExpression(code, arguments, flags);
                        return type;
                    }
                    TypeDefinition type = BuiltinTypes.Integer;
                    return type;
                }
                case IfTrue: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), (TypeReference)BuiltinTypes.Boolean, true);
                    }
                    TypeReference type = null;
                    return type;
                }
                case Goto: 
                case Switch: 
                case AThrow: 
                case LoopOrSwitchBreak: 
                case LoopContinue: 
                case __Return: {
                    TypeReference type = null;
                    return type;
                }
                case __IReturn: 
                case __LReturn: 
                case __FReturn: 
                case __DReturn: 
                case __AReturn: 
                case Return: {
                    Expression lambdaBinding = expression.getUserData(AstKeys.PARENT_LAMBDA_BINDING);
                    if (lambdaBinding != null) {
                        TypeReference newInferredType;
                        TypeReference returnType;
                        Lambda lambda = (Lambda)lambdaBinding.getOperand();
                        MethodReference method = lambda.getMethod();
                        if (method == null) {
                            TypeReference argument = null;
                            return argument;
                        }
                        TypeReference oldInferredType = lambda.getInferredReturnType();
                        TypeReference inferredType = expectedType;
                        TypeReference typeReference = returnType = oldInferredType != null ? oldInferredType : expectedType;
                        if (forceInferChildren) {
                            if (returnType == null) {
                                returnType = lambda.getMethod().getReturnType();
                            }
                            if (returnType.containsGenericParameters()) {
                                HashMap<GenericParameter, TypeReference> mappings = null;
                                TypeReference declaringType = method.getDeclaringType();
                                if (declaringType.isGenericType()) {
                                    MethodReference boundMethod;
                                    for (GenericParameter gp : declaringType.getGenericParameters()) {
                                        GenericParameter inScope = this._context.getCurrentMethod().findTypeVariable(gp.getName());
                                        if (inScope != null && MetadataHelper.isSameType(gp, inScope)) continue;
                                        if (mappings == null) {
                                            mappings = new HashMap<GenericParameter, TypeReference>();
                                        }
                                        if (mappings.containsKey(gp)) continue;
                                        mappings.put(gp, MetadataHelper.eraseRecursive(gp));
                                    }
                                    if (mappings != null && (declaringType = TypeSubstitutionVisitor.instance().visit(declaringType, (Map<TypeReference, TypeReference>)mappings)) != null && (boundMethod = MetadataHelper.asMemberOf(method, declaringType)) != null) {
                                        returnType = boundMethod.getReturnType();
                                    }
                                }
                            }
                            if (!arguments.isEmpty() && returnType != BuiltinTypes.Void) {
                                inferredType = this.inferTypeForExpression(arguments.get(0), returnType);
                            }
                            if (oldInferredType != null && inferredType != BuiltinTypes.Void && (newInferredType = MetadataHelper.asSuper(inferredType, oldInferredType)) != null) {
                                inferredType = newInferredType;
                            }
                        }
                        lambda.setExpectedReturnType(returnType);
                        lambda.setInferredReturnType(inferredType);
                        newInferredType = inferredType;
                        return newInferredType;
                    }
                    TypeReference returnType = this._context.getCurrentMethod().getReturnType();
                    if (forceInferChildren && arguments.size() == 1) {
                        this.inferTypeForExpression(arguments.get(0), returnType, true);
                    }
                    TypeReference method = returnType;
                    return method;
                }
                case Bind: {
                    MethodReference boundMethod;
                    TypeReference asSubType;
                    final Lambda lambda = (Lambda)expression.getOperand();
                    if (lambda == null) {
                        TypeReference returnType = null;
                        return returnType;
                    }
                    MethodReference method = lambda.getMethod();
                    List<Variable> parameters = lambda.getParameters();
                    TypeReference functionType = lambda.getFunctionType();
                    if (functionType != null && expectedType != null && (asSubType = MetadataHelper.asSubType(functionType, expectedType)) != null) {
                        functionType = asSubType;
                    }
                    if ((boundMethod = MetadataHelper.asMemberOf(method, functionType)) == null) {
                        boundMethod = method;
                    }
                    List<ParameterDefinition> methodParameters = boundMethod.getParameters();
                    int argumentCount = Math.min(arguments.size(), methodParameters.size());
                    TypeReference inferredReturnType = null;
                    if (forceInferChildren) {
                        for (int i = 0; i < argumentCount; ++i) {
                            Expression argument = arguments.get(i);
                            this.inferTypeForExpression(argument, methodParameters.get(i).getParameterType());
                        }
                        List<Variable> lambdaParameters = lambda.getParameters();
                        int n = lambdaParameters.size();
                        for (int i = 0; i < n; ++i) {
                            this.invalidateDependentExpressions(expression, lambdaParameters.get(i));
                        }
                        Predicate<Node> nonLambda = new Predicate<Node>(){

                            @Override
                            public boolean test(Node n) {
                                return n == lambda || !(n instanceof Lambda);
                            }
                        };
                        for (Expression e : CollectionUtilities.ofType(lambda.getChildrenAndSelfRecursive(nonLambda, true), Expression.class)) {
                            if (!PatternMatching.match(e, AstCode.Return)) continue;
                            this.runInference(e);
                            if (e.getInferredType() == null) continue;
                            if (inferredReturnType != null) {
                                inferredReturnType = MetadataHelper.asSuper(e.getInferredType(), inferredReturnType);
                                continue;
                            }
                            inferredReturnType = e.getInferredType();
                        }
                    }
                    MethodDefinition r = boundMethod.resolve();
                    if (functionType.containsGenericParameters() && boundMethod.containsGenericParameters() || r != null && r.getDeclaringType().containsGenericParameters() && r.containsGenericParameters()) {
                        TypeReference returnType;
                        HashMap<TypeReference, TypeReference> oldMappings = new HashMap<TypeReference, TypeReference>();
                        HashMap<TypeReference, TypeReference> newMappings = new HashMap<TypeReference, TypeReference>();
                        List<ParameterDefinition> p = boundMethod.getParameters();
                        List<ParameterDefinition> rp = r != null ? r.getParameters() : method.getParameters();
                        TypeReference typeReference = returnType = r != null ? r.getReturnType() : method.getReturnType();
                        if (inferredReturnType != null) {
                            if (returnType.isGenericParameter()) {
                                TypeReference boundReturnType = TypeAnalysis.ensureReferenceType(inferredReturnType);
                                if (!MetadataHelper.isSameType(boundReturnType, returnType)) {
                                    newMappings.put(returnType, boundReturnType);
                                }
                            } else if (returnType.containsGenericParameters()) {
                                HashMap<TypeReference, TypeReference> returnMappings = new HashMap<TypeReference, TypeReference>();
                                new AddMappingsForArgumentVisitor(returnType).visit(inferredReturnType, (Map<TypeReference, TypeReference>)returnMappings);
                                newMappings.putAll(returnMappings);
                            }
                        }
                        int i = 0;
                        int j = Math.max(0, parameters.size() - arguments.size());
                        while (i < arguments.size()) {
                            Expression argument = arguments.get(i);
                            TypeReference rType = rp.get(j).getParameterType();
                            TypeReference pType = p.get(j).getParameterType();
                            TypeReference aType = argument.getInferredType();
                            if (pType != null && rType.containsGenericParameters()) {
                                new AddMappingsForArgumentVisitor(pType).visit(rType, (Map<TypeReference, TypeReference>)oldMappings);
                            }
                            if (aType != null && rType.containsGenericParameters()) {
                                new AddMappingsForArgumentVisitor(aType).visit(rType, (Map<TypeReference, TypeReference>)newMappings);
                            }
                            ++i;
                            ++j;
                        }
                        HashMap<TypeReference, TypeReference> mappings = oldMappings;
                        if (!newMappings.isEmpty()) {
                            for (TypeReference t2 : newMappings.keySet()) {
                                TypeReference oldMapping = (TypeReference)oldMappings.get(t2);
                                TypeReference newMapping = (TypeReference)newMappings.get(t2);
                                if (oldMapping != null && !MetadataHelper.isSubType(newMapping, oldMapping)) continue;
                                mappings.put(t2, newMapping);
                            }
                        }
                        if (!mappings.isEmpty()) {
                            MethodReference newBoundMethod;
                            TypeReference declaringType = (r != null ? r : method).getDeclaringType();
                            TypeReference boundDeclaringType = TypeSubstitutionVisitor.instance().visit(declaringType, (Map<TypeReference, TypeReference>)mappings);
                            if (boundDeclaringType != null && boundDeclaringType.isGenericType()) {
                                for (GenericParameter gp : boundDeclaringType.getGenericParameters()) {
                                    GenericParameter inScope = this._context.getCurrentMethod().findTypeVariable(gp.getName());
                                    if (inScope != null && MetadataHelper.isSameType(gp, inScope) || mappings.containsKey(gp)) continue;
                                    mappings.put(gp, MetadataHelper.eraseRecursive(gp));
                                }
                                boundDeclaringType = TypeSubstitutionVisitor.instance().visit(boundDeclaringType, (Map<TypeReference, TypeReference>)mappings);
                            }
                            if (boundDeclaringType != null) {
                                functionType = boundDeclaringType;
                            }
                            if ((newBoundMethod = MetadataHelper.asMemberOf(boundMethod, boundDeclaringType)) != null) {
                                boundMethod = newBoundMethod;
                                lambda.setMethod(boundMethod);
                                methodParameters = boundMethod.getParameters();
                            }
                        }
                        for (i = 0; i < methodParameters.size(); ++i) {
                            Variable variable = parameters.get(i);
                            TypeReference variableType = methodParameters.get(i).getParameterType();
                            TypeReference oldVariableType = variable.getType();
                            if (oldVariableType != null && MetadataHelper.isSameType(variableType, oldVariableType)) continue;
                            this.invalidateDependentExpressions(expression, variable);
                        }
                    }
                    TypeReference typeReference = functionType;
                    return typeReference;
                }
                case Jsr: {
                    TypeDefinition lambda = BuiltinTypes.Integer;
                    return lambda;
                }
                case Ret: {
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Integer);
                    }
                    TypeReference lambda = null;
                    return lambda;
                }
                case Pop: 
                case Pop2: {
                    TypeReference lambda = null;
                    return lambda;
                }
                case Dup: 
                case Dup2: {
                    Expression argument = arguments.get(0);
                    TypeReference result = this.inferTypeForExpression(argument, expectedType);
                    argument.setExpectedType(result);
                    TypeReference typeReference = result;
                    return typeReference;
                }
                case InstanceOf: {
                    TypeDefinition argument = BuiltinTypes.Boolean;
                    return argument;
                }
                case __IInc: 
                case __IIncW: 
                case Inc: {
                    TypeReference inferredType = this.inferTypeForVariable((Variable)operand, BuiltinTypes.Integer, flags | 1);
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arguments.get(0), inferredType, true);
                    }
                    TypeReference typeReference = inferredType;
                    return typeReference;
                }
                case Leave: 
                case EndFinally: 
                case Nop: {
                    TypeReference typeReference = null;
                    return typeReference;
                }
                case DefaultValue: {
                    TypeReference typeReference = (TypeReference)expression.getOperand();
                    return typeReference;
                }
            }
            System.err.printf("Type inference can't handle opcode '%s'.\n", code.getName());
            TypeReference typeReference = null;
            return typeReference;
        }
        finally {
            this._stack.pop();
        }
    }

    private TypeReference inferInitObject(Expression expression, TypeReference expectedType, boolean forceInferChildren, MethodReference operand, List<Expression> arguments) {
        Map<TypeReference, TypeReference> mappings;
        TypeReference asSubType;
        MethodReference resolvedCtor = operand instanceof IGenericInstance ? operand.resolve() : operand;
        MethodReference constructor = resolvedCtor != null ? resolvedCtor : operand;
        TypeReference type = constructor.getDeclaringType();
        TypeReference inferredType = expectedType != null && !MetadataHelper.isSameType(expectedType, BuiltinTypes.Object) ? ((asSubType = MetadataHelper.asSubType(type, expectedType)) != null ? asSubType : type) : type;
        if (inferredType.isGenericDefinition()) {
            mappings = new HashMap();
            for (GenericParameter gp : inferredType.getGenericParameters()) {
                mappings.put(gp, MetadataHelper.eraseRecursive(gp));
            }
        } else {
            mappings = Collections.emptyMap();
        }
        if (forceInferChildren) {
            MethodReference asMember = MetadataHelper.asMemberOf(constructor, TypeSubstitutionVisitor.instance().visit(inferredType, mappings));
            List<ParameterDefinition> parameters = asMember.getParameters();
            for (int i = 0; i < arguments.size() && i < parameters.size(); ++i) {
                this.inferTypeForExpression(arguments.get(i), parameters.get(i).getParameterType());
            }
            expression.setOperand(asMember);
        }
        if (inferredType == null) {
            return type;
        }
        List<TypeReference> oldTypeArguments = expression.getUserData(AstKeys.TYPE_ARGUMENTS);
        if (inferredType instanceof IGenericInstance) {
            boolean typeArgumentsChanged = false;
            List<TypeReference> typeArguments = ((IGenericInstance)((Object)inferredType)).getTypeArguments();
            for (int i = 0; i < typeArguments.size(); ++i) {
                GenericParameter inScope;
                TypeReference t2 = typeArguments.get(i);
                while (t2.isWildcardType()) {
                    TypeReference typeReference = t2 = t2.hasExtendsBound() ? t2.getExtendsBound() : MetadataHelper.getUpperBound(t2);
                    if (!typeArgumentsChanged) {
                        typeArguments = CollectionUtilities.toList(typeArguments);
                        typeArgumentsChanged = true;
                    }
                    typeArguments.set(i, t2);
                }
                while (t2.isGenericParameter() && ((inScope = this._context.getCurrentMethod().findTypeVariable(t2.getName())) == null || !MetadataHelper.isSameType(t2, inScope))) {
                    TypeReference o;
                    if (oldTypeArguments != null && oldTypeArguments.size() == typeArguments.size() && !MetadataHelper.isSameType(o = oldTypeArguments.get(i), t2)) {
                        t2 = o;
                        if (!typeArgumentsChanged) {
                            typeArguments = CollectionUtilities.toList(typeArguments);
                            typeArgumentsChanged = true;
                        }
                        typeArguments.set(i, t2);
                        continue;
                    }
                    TypeReference typeReference = t2 = t2.hasExtendsBound() ? t2.getExtendsBound() : MetadataHelper.getUpperBound(t2);
                    if (!typeArgumentsChanged) {
                        typeArguments = CollectionUtilities.toList(typeArguments);
                        typeArgumentsChanged = true;
                    }
                    typeArguments.set(i, t2);
                }
            }
            expression.putUserData(AstKeys.TYPE_ARGUMENTS, typeArguments);
            if (typeArgumentsChanged) {
                inferredType = inferredType.makeGenericType(typeArguments);
            }
        }
        return inferredType;
    }

    private TypeReference cleanTypeArguments(TypeReference newType, TypeReference alternateType) {
        List<TypeReference> typeArguments;
        if (!(alternateType instanceof IGenericInstance)) {
            return newType;
        }
        if (!StringUtilities.equals(newType.getInternalName(), alternateType.getInternalName())) {
            return newType;
        }
        List<TypeReference> alternateTypeArguments = ((IGenericInstance)((Object)alternateType)).getTypeArguments();
        boolean typeArgumentsChanged = false;
        if (newType instanceof IGenericInstance) {
            typeArguments = ((IGenericInstance)((Object)newType)).getTypeArguments();
        } else {
            typeArguments = new ArrayList<TypeReference>();
            typeArguments.addAll(newType.getGenericParameters());
        }
        for (int i = 0; i < typeArguments.size(); ++i) {
            GenericParameter inScope;
            TypeReference t2 = typeArguments.get(i);
            while (t2.isGenericParameter() && ((inScope = this._context.getCurrentMethod().findTypeVariable(t2.getName())) == null || !MetadataHelper.isSameType(t2, inScope))) {
                TypeReference o;
                if (alternateTypeArguments != null && alternateTypeArguments.size() == typeArguments.size() && !MetadataHelper.isSameType(o = alternateTypeArguments.get(i), t2)) {
                    t2 = o;
                    if (!typeArgumentsChanged) {
                        typeArguments = CollectionUtilities.toList(typeArguments);
                        typeArgumentsChanged = true;
                    }
                    typeArguments.set(i, t2);
                    continue;
                }
                TypeReference typeReference = t2 = t2.hasExtendsBound() ? t2.getExtendsBound() : MetadataHelper.getUpperBound(t2);
                if (!typeArgumentsChanged) {
                    typeArguments = CollectionUtilities.toList(typeArguments);
                    typeArgumentsChanged = true;
                }
                typeArguments.set(i, t2);
            }
        }
        if (typeArgumentsChanged) {
            return newType.makeGenericType(typeArguments);
        }
        return newType;
    }

    private TypeReference inferBinaryExpression(AstCode code, List<Expression> arguments, int flags) {
        Expression left = arguments.get(0);
        Expression right = arguments.get(1);
        this.runInference(left);
        this.runInference(right);
        TypeReference lInferred = left.getInferredType();
        TypeReference rInferred = right.getInferredType();
        left.setExpectedType(lInferred);
        right.setExpectedType(lInferred);
        left.setInferredType(null);
        right.setInferredType(null);
        int operandFlags = 0;
        switch (code) {
            case Or: 
            case And: 
            case Xor: 
            case CmpEq: 
            case CmpNe: {
                if (left.getExpectedType() == BuiltinTypes.Boolean) {
                    if (right.getExpectedType() == BuiltinTypes.Integer) {
                        if (PatternMatching.matchBooleanConstant(right) != null) {
                            right.setExpectedType(BuiltinTypes.Boolean);
                            break;
                        }
                        left.setExpectedType(BuiltinTypes.Integer);
                        operandFlags |= 1;
                        break;
                    }
                    if (right.getExpectedType() == BuiltinTypes.Boolean) break;
                    left.setExpectedType(BuiltinTypes.Integer);
                    operandFlags |= 1;
                    break;
                }
                if (right.getExpectedType() != BuiltinTypes.Boolean) break;
                if (left.getExpectedType() == BuiltinTypes.Integer) {
                    if (PatternMatching.matchBooleanConstant(left) != null) {
                        left.setExpectedType(BuiltinTypes.Boolean);
                        break;
                    }
                    right.setExpectedType(BuiltinTypes.Integer);
                    operandFlags |= 1;
                    break;
                }
                if (left.getExpectedType() == BuiltinTypes.Boolean) break;
                right.setExpectedType(BuiltinTypes.Integer);
                operandFlags |= 1;
                break;
            }
            default: {
                operandFlags |= 1;
                if (left.getExpectedType() == BuiltinTypes.Boolean || left.getExpectedType() == null && PatternMatching.matchBooleanConstant(left) != null) {
                    left.setExpectedType(BuiltinTypes.Integer);
                }
                if (right.getExpectedType() != BuiltinTypes.Boolean && (right.getExpectedType() != null || PatternMatching.matchBooleanConstant(right) == null)) break;
                right.setExpectedType(BuiltinTypes.Integer);
            }
        }
        if (left.getExpectedType() == BuiltinTypes.Character) {
            if (right.getExpectedType() == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(right) != null) {
                right.setExpectedType(BuiltinTypes.Character);
            }
        } else if (right.getExpectedType() == BuiltinTypes.Character && left.getExpectedType() == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(left) != null) {
            left.setExpectedType(BuiltinTypes.Character);
        }
        TypeReference lType = this.isSameType(lInferred, left.getExpectedType()) ? lInferred : this.doInferTypeForExpression(left, left.getExpectedType(), true, operandFlags);
        TypeReference rType = this.isSameType(rInferred, right.getExpectedType()) ? rInferred : this.doInferTypeForExpression(right, right.getExpectedType(), true, operandFlags);
        TypeReference operandType = this.inferBinaryArguments(left, right, this.typeWithMoreInformation(lType, rType), false, null, null, operandFlags);
        switch (code) {
            case CmpEq: 
            case CmpNe: 
            case CmpLt: 
            case CmpGe: 
            case CmpGt: 
            case CmpLe: {
                return BuiltinTypes.Boolean;
            }
            case Add: 
            case Sub: 
            case Mul: 
            case Or: 
            case And: 
            case Xor: 
            case Div: 
            case Rem: {
                return TypeAnalysis.adjustType(this.doBinaryNumericPromotion(operandType), flags);
            }
        }
        return TypeAnalysis.adjustType(operandType, flags);
    }

    private TypeReference inferDynamicCall(Expression expression, TypeReference expectedType, boolean forceInferChildren) {
        MethodReference bootstrapMethod;
        TypeReference result;
        List<Expression> arguments = expression.getArguments();
        DynamicCallSite callSite = (DynamicCallSite)expression.getOperand();
        TypeReference inferredType = expression.getInferredType();
        if (inferredType == null) {
            inferredType = callSite.getMethodType().getReturnType();
        }
        TypeReference typeReference = result = expectedType == null ? inferredType : MetadataHelper.asSubType(inferredType, expectedType);
        if (result == null) {
            result = inferredType;
        }
        if ((result.isGenericType() || MetadataHelper.isRawType(result)) && "java/lang/invoke/LambdaMetafactory".equals((bootstrapMethod = callSite.getBootstrapMethod()).getDeclaringType().getInternalName()) && StringUtilities.equals("metafactory", bootstrapMethod.getName(), StringComparison.OrdinalIgnoreCase) && callSite.getBootstrapArguments().size() == 3 && callSite.getBootstrapArguments().get(1) instanceof MethodHandle) {
            TypeReference resolvedTargetType;
            MethodHandle targetHandle = (MethodHandle)callSite.getBootstrapArguments().get(1);
            MethodReference targetMethod = targetHandle.getMethod();
            HashMap<GenericParameter, TypeReference> expectedMappings = new HashMap<GenericParameter, TypeReference>();
            HashMap<TypeReference, TypeReference> inferredMappings = new HashMap<TypeReference, TypeReference>();
            MethodDefinition functionMethod = null;
            TypeDefinition resolvedType = result.resolve();
            List<MethodReference> methods = MetadataHelper.findMethods(resolvedType != null ? resolvedType : result, MetadataFilters.matchName(callSite.getMethodName()));
            for (MethodReference m4 : methods) {
                MethodDefinition r = m4.resolve();
                if (r == null || !r.isAbstract() || r.isStatic() || r.isDefault()) continue;
                functionMethod = r;
                break;
            }
            if (functionMethod == null) {
                return null;
            }
            boolean firstArgIsTarget = false;
            MethodReference actualMethod = targetMethod;
            switch (targetHandle.getHandleType()) {
                case GetField: 
                case PutField: 
                case InvokeVirtual: 
                case InvokeSpecial: 
                case InvokeInterface: {
                    TypeReference targetType;
                    if (arguments.size() <= 0) break;
                    Expression arg = arguments.get(0);
                    TypeReference expectedArgType = targetMethod.getDeclaringType();
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arg, expectedArgType, true);
                    }
                    if ((targetType = arg.getInferredType()) == null || !MetadataHelper.isSubType(targetType, expectedArgType)) break;
                    firstArgIsTarget = true;
                    MethodReference asMember = MetadataHelper.asMemberOf(actualMethod, targetType);
                    if (asMember == null) break;
                    actualMethod = asMember;
                }
            }
            if (expectedType != null && expectedType.isGenericType() && !expectedType.isGenericDefinition()) {
                List<GenericParameter> genericParameters = resolvedType != null ? resolvedType.getGenericParameters() : expectedType.getGenericParameters();
                List<TypeReference> typeArguments = ((IGenericInstance)((Object)expectedType)).getTypeArguments();
                if (typeArguments.size() == genericParameters.size()) {
                    for (int i = 0; i < genericParameters.size(); ++i) {
                        GenericParameter genericParameter;
                        TypeReference typeArgument = typeArguments.get(i);
                        if (MetadataHelper.isSameType(typeArgument, genericParameter = genericParameters.get(i), true)) continue;
                        expectedMappings.put(genericParameter, typeArgument);
                    }
                }
            }
            new AddMappingsForArgumentVisitor(actualMethod.isConstructor() ? actualMethod.getDeclaringType() : actualMethod.getReturnType()).visit(((MethodReference)functionMethod).getReturnType(), (Map<TypeReference, TypeReference>)inferredMappings);
            List<ParameterDefinition> tp = actualMethod.getParameters();
            List<ParameterDefinition> fp = ((MethodReference)functionMethod).getParameters();
            if (tp.size() == fp.size()) {
                for (int i = 0; i < fp.size(); ++i) {
                    new AddMappingsForArgumentVisitor(tp.get(i).getParameterType()).visit(fp.get(i).getParameterType(), (Map<TypeReference, TypeReference>)inferredMappings);
                }
            }
            for (TypeReference key : expectedMappings.keySet()) {
                TypeReference expectedMapping = (TypeReference)expectedMappings.get(key);
                TypeReference inferredMapping = (TypeReference)inferredMappings.get(key);
                if (inferredMapping != null && !MetadataHelper.isSubType(expectedMapping, inferredMapping)) continue;
                inferredMappings.put(key, expectedMapping);
            }
            result = TypeSubstitutionVisitor.instance().visit(resolvedType != null ? resolvedType : result, (Map<TypeReference, TypeReference>)inferredMappings);
            if (!firstArgIsTarget || expectedType == null) {
                return result;
            }
            TypeReference declaringType = actualMethod.getDeclaringType();
            if (!declaringType.isGenericDefinition() && !MetadataHelper.isRawType(actualMethod.getDeclaringType())) {
                return result;
            }
            TypeReference typeReference2 = declaringType = declaringType.isGenericDefinition() ? declaringType : declaringType.resolve();
            if (declaringType == null) {
                return result;
            }
            MethodReference resultMethod = MetadataHelper.asMemberOf(functionMethod, result);
            actualMethod = actualMethod.resolve();
            if (resultMethod == null || actualMethod == null) {
                return result;
            }
            inferredMappings.clear();
            new AddMappingsForArgumentVisitor(resultMethod.getReturnType()).visit(actualMethod.getReturnType(), (Map<TypeReference, TypeReference>)inferredMappings);
            List<ParameterDefinition> ap = actualMethod.getParameters();
            List<ParameterDefinition> rp = resultMethod.getParameters();
            if (ap.size() == rp.size()) {
                int n = ap.size();
                for (int i = 0; i < n; ++i) {
                    new AddMappingsForArgumentVisitor(rp.get(i).getParameterType()).visit(ap.get(i).getParameterType(), (Map<TypeReference, TypeReference>)inferredMappings);
                }
            }
            if ((resolvedTargetType = TypeSubstitutionVisitor.instance().visit(declaringType, (Map<TypeReference, TypeReference>)inferredMappings)) != null) {
                this.inferTypeForExpression(arguments.get(0), resolvedTargetType, true);
            }
        }
        return result;
    }

    private TypeReference inferCall(Expression expression, TypeReference expectedType, boolean forceInferChildren) {
        AstCode code = expression.getCode();
        List<Expression> arguments = expression.getArguments();
        MethodReference method = (MethodReference)expression.getOperand();
        List<ParameterDefinition> parameters = method.getParameters();
        boolean hasThis = code != AstCode.InvokeStatic && code != AstCode.InvokeDynamic;
        TypeReference targetType = null;
        MethodReference boundMethod = method;
        if (forceInferChildren) {
            MethodReference actualMethod;
            MethodDefinition r = method.resolve();
            if (hasThis) {
                MethodReference m4;
                TypeReference expectedTargetType;
                Expression thisArg = arguments.get(0);
                TypeReference typeReference = expectedTargetType = thisArg.getInferredType() != null ? thisArg.getInferredType() : thisArg.getExpectedType();
                if (expectedTargetType != null && expectedTargetType.isGenericType() && !expectedTargetType.isGenericDefinition()) {
                    boundMethod = MetadataHelper.asMemberOf(method, expectedTargetType);
                    targetType = this.inferTypeForExpression(arguments.get(0), expectedTargetType);
                } else {
                    targetType = method.isConstructor() ? method.getDeclaringType() : this.inferTypeForExpression(arguments.get(0), method.getDeclaringType());
                }
                if (!(targetType instanceof RawType) && MetadataHelper.isRawType(targetType) && !MetadataHelper.canReferenceTypeVariablesOf(targetType, this._context.getCurrentType())) {
                    targetType = MetadataHelper.erase(targetType);
                }
                MethodReference methodReference = targetType != null ? MetadataHelper.asMemberOf(r != null ? r : method, targetType) : (m4 = method);
                actualMethod = m4 != null ? m4 : (r != null ? r : boundMethod);
            } else {
                actualMethod = r != null ? r : boundMethod;
            }
            boundMethod = actualMethod;
            expression.setOperand(boundMethod);
            List<ParameterDefinition> p = method.getParameters();
            HashMap<TypeReference, TypeReference> mappings = null;
            if (actualMethod.containsGenericParameters() || r != null && r.containsGenericParameters()) {
                TypeReference boundDeclaringType;
                HashMap<TypeReference, TypeReference> oldMappings = new HashMap<TypeReference, TypeReference>();
                HashMap<TypeReference, TypeReference> newMappings = new HashMap<TypeReference, TypeReference>();
                HashMap<TypeReference, TypeReference> inferredMappings = new HashMap<TypeReference, TypeReference>();
                if (targetType != null && targetType.isGenericType()) {
                    oldMappings.putAll(MetadataHelper.getGenericSubTypeMappings(targetType.getUnderlyingType(), targetType));
                }
                List<ParameterDefinition> rp = r != null ? r.getParameters() : actualMethod.getParameters();
                List<ParameterDefinition> cp = boundMethod.getParameters();
                boolean mapOld = method instanceof IGenericInstance;
                for (int i = 0; i < parameters.size(); ++i) {
                    TypeReference rType = rp.get(i).getParameterType();
                    TypeReference pType = p.get(i).getParameterType();
                    TypeReference cType = cp.get(i).getParameterType();
                    TypeReference aType = this.inferTypeForExpression(arguments.get(hasThis ? i + 1 : i), cType);
                    if (mapOld && rType != null && rType.containsGenericParameters()) {
                        new AddMappingsForArgumentVisitor(pType).visit(rType, (Map<TypeReference, TypeReference>)oldMappings);
                    }
                    if (cType != null && rType.containsGenericParameters()) {
                        new AddMappingsForArgumentVisitor(cType).visit(rType, (Map<TypeReference, TypeReference>)newMappings);
                    }
                    if (aType == null || !rType.containsGenericParameters()) continue;
                    new AddMappingsForArgumentVisitor(aType).visit(rType, (Map<TypeReference, TypeReference>)inferredMappings);
                }
                if (expectedType != null) {
                    TypeReference returnType;
                    TypeReference typeReference = returnType = r != null ? r.getReturnType() : actualMethod.getReturnType();
                    if (returnType.containsGenericParameters()) {
                        HashMap<TypeReference, TypeReference> returnMappings = new HashMap<TypeReference, TypeReference>();
                        new AddMappingsForArgumentVisitor(expectedType).visit(returnType, (Map<TypeReference, TypeReference>)returnMappings);
                        newMappings.putAll(returnMappings);
                    }
                }
                if (!(oldMappings.isEmpty() && newMappings.isEmpty() && inferredMappings.isEmpty())) {
                    TypeReference newMapping;
                    TypeReference oldMapping;
                    mappings = oldMappings;
                    for (Iterator<GenericParameter> t2 : newMappings.keySet()) {
                        oldMapping = (TypeReference)mappings.get(t2);
                        newMapping = (TypeReference)newMappings.get(t2);
                        if (oldMapping != null && !MetadataHelper.isSubType(newMapping, oldMapping)) continue;
                        mappings.put((TypeReference)((Object)t2), newMapping);
                    }
                    for (Iterator<GenericParameter> t2 : inferredMappings.keySet()) {
                        oldMapping = (TypeReference)mappings.get(t2);
                        newMapping = (TypeReference)inferredMappings.get(t2);
                        if (oldMapping != null && !MetadataHelper.isSubType(newMapping, oldMapping)) continue;
                        mappings.put((TypeReference)((Object)t2), newMapping);
                    }
                }
                if (mappings != null) {
                    actualMethod = boundMethod = TypeSubstitutionVisitor.instance().visitMethod(r != null ? r : actualMethod, (Map<TypeReference, TypeReference>)mappings);
                    expression.setOperand(boundMethod);
                    p = boundMethod.getParameters();
                }
                if ((boundDeclaringType = boundMethod.getDeclaringType()).isGenericType()) {
                    if (mappings == null) {
                        mappings = new HashMap();
                    }
                    for (GenericParameter gp : boundDeclaringType.getGenericParameters()) {
                        GenericParameter inScope = this._context.getCurrentMethod().findTypeVariable(gp.getName());
                        if (inScope != null && MetadataHelper.isSameType(gp, inScope) || mappings.containsKey(gp)) continue;
                        mappings.put(gp, MetadataHelper.eraseRecursive(gp));
                    }
                    boundMethod = TypeSubstitutionVisitor.instance().visitMethod(actualMethod, (Map<TypeReference, TypeReference>)mappings);
                    expression.setOperand(boundMethod);
                    p = boundMethod.getParameters();
                }
                if (boundMethod.isGenericMethod()) {
                    if (mappings == null) {
                        mappings = new HashMap();
                    }
                    for (GenericParameter gp : boundMethod.getGenericParameters()) {
                        if (mappings.containsKey(gp)) continue;
                        mappings.put(gp, MetadataHelper.eraseRecursive(gp));
                    }
                    boundMethod = TypeSubstitutionVisitor.instance().visitMethod(actualMethod, (Map<TypeReference, TypeReference>)mappings);
                    expression.setOperand(boundMethod);
                    p = boundMethod.getParameters();
                }
                if (r != null && method.isGenericMethod()) {
                    HashMap<TypeReference, TypeReference> tempMappings = new HashMap<TypeReference, TypeReference>();
                    List<ParameterDefinition> bp = method.getParameters();
                    int n = bp.size();
                    for (int i = 0; i < n; ++i) {
                        new AddMappingsForArgumentVisitor(bp.get(i).getParameterType()).visit(rp.get(i).getParameterType(), (Map<TypeReference, TypeReference>)tempMappings);
                    }
                    boolean changed = false;
                    if (mappings == null) {
                        mappings = tempMappings;
                        changed = true;
                    } else {
                        for (TypeReference key : tempMappings.keySet()) {
                            if (mappings.containsKey(key)) continue;
                            mappings.put(key, tempMappings.get(key));
                            changed = true;
                        }
                    }
                    if (changed) {
                        boundMethod = TypeSubstitutionVisitor.instance().visitMethod(actualMethod, (Map<TypeReference, TypeReference>)mappings);
                        expression.setOperand(boundMethod);
                        p = boundMethod.getParameters();
                    }
                }
            } else {
                boundMethod = actualMethod;
            }
            if (hasThis && mappings != null) {
                TypeReference inferredTargetType;
                TypeReference expectedTargetType = boundMethod.isConstructor() ? MetadataHelper.substituteGenericArguments(boundMethod.getDeclaringType(), mappings) : boundMethod.getDeclaringType();
                if (expectedTargetType != null && expectedTargetType.isGenericDefinition() && arguments.get(0).getInferredType() != null) {
                    expectedTargetType = MetadataHelper.asSuper(expectedTargetType, arguments.get(0).getInferredType());
                }
                if ((inferredTargetType = this.inferTypeForExpression(arguments.get(0), expectedTargetType, forceInferChildren)) != null) {
                    targetType = MetadataHelper.substituteGenericArguments(inferredTargetType, mappings);
                    if (MetadataHelper.isRawType(targetType) && !MetadataHelper.canReferenceTypeVariablesOf(targetType, this._context.getCurrentType())) {
                        targetType = MetadataHelper.erase(targetType);
                    }
                    boundMethod = MetadataHelper.asMemberOf(boundMethod, targetType);
                    p = boundMethod.getParameters();
                    expression.setOperand(boundMethod);
                }
            }
            for (int i = 0; i < parameters.size(); ++i) {
                TypeReference pType = p.get(i).getParameterType();
                Expression argument = arguments.get(hasThis ? i + 1 : i);
                this.inferTypeForExpression(argument, pType, forceInferChildren, PatternMatching.match(argument, AstCode.Load) && pType != BuiltinTypes.Boolean ? 1 : 0);
            }
        }
        if (hasThis && boundMethod.isConstructor()) {
            return boundMethod.getDeclaringType();
        }
        return boundMethod.getReturnType();
    }

    private TypeReference inferTypeForVariable(Variable v, TypeReference expectedType) {
        return this.inferTypeForVariable(v, expectedType, false, 0);
    }

    private TypeReference inferTypeForVariable(Variable v, TypeReference expectedType, int flags) {
        return this.inferTypeForVariable(v, expectedType, false, flags);
    }

    private TypeReference inferTypeForVariable(Variable v, TypeReference expectedType, boolean favorExpectedOverActual, int flags) {
        TypeReference lastInferredType = this._inferredVariableTypes.get(v);
        if (lastInferredType != null) {
            return TypeAnalysis.adjustType(lastInferredType, flags);
        }
        if (this.isSingleStoreBoolean(v)) {
            return TypeAnalysis.adjustType(BuiltinTypes.Boolean, flags);
        }
        if (favorExpectedOverActual && expectedType != null) {
            return TypeAnalysis.adjustType(expectedType, flags);
        }
        TypeReference variableType = v.getType();
        if (variableType != null) {
            return TypeAnalysis.adjustType(variableType, flags);
        }
        if (v.isGenerated()) {
            return TypeAnalysis.adjustType(expectedType, flags);
        }
        ParameterDefinition p = v.getOriginalParameter();
        return TypeAnalysis.adjustType(p != null ? p.getParameterType() : v.getOriginalVariable().getVariableType(), flags);
    }

    private static TypeReference adjustType(TypeReference type, int flags) {
        if (Flags.testAny(flags, 1) && type == BuiltinTypes.Boolean) {
            return BuiltinTypes.Integer;
        }
        return type;
    }

    private TypeReference doBinaryNumericPromotion(TypeReference type) {
        if (type == null) {
            return null;
        }
        switch (type.getSimpleType()) {
            case Byte: 
            case Character: 
            case Short: {
                return BuiltinTypes.Integer;
            }
        }
        return type;
    }

    private TypeReference inferBinaryArguments(Expression left, Expression right, TypeReference expectedType, boolean forceInferChildren, TypeReference leftPreferred, TypeReference rightPreferred, int operandFlags) {
        TypeReference actualLeftPreferred = leftPreferred;
        TypeReference actualRightPreferred = rightPreferred;
        if (actualLeftPreferred == null) {
            actualLeftPreferred = this.doInferTypeForExpression(left, expectedType, forceInferChildren, operandFlags);
        }
        if (actualRightPreferred == null) {
            actualRightPreferred = this.doInferTypeForExpression(right, expectedType, forceInferChildren, operandFlags);
        }
        if (actualLeftPreferred == BuiltinTypes.Null) {
            if (actualRightPreferred != null && !actualRightPreferred.isPrimitive()) {
                actualLeftPreferred = actualRightPreferred;
            }
        } else if (actualRightPreferred == BuiltinTypes.Null && actualLeftPreferred != null && !actualLeftPreferred.isPrimitive()) {
            actualRightPreferred = actualLeftPreferred;
        }
        if (actualLeftPreferred == BuiltinTypes.Character) {
            if (actualRightPreferred == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(right) != null) {
                actualRightPreferred = BuiltinTypes.Character;
            }
        } else if (actualRightPreferred == BuiltinTypes.Character && actualLeftPreferred == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(left) != null) {
            actualLeftPreferred = BuiltinTypes.Character;
        }
        if (this.isSameType(actualLeftPreferred, actualRightPreferred)) {
            left.setInferredType(actualLeftPreferred);
            left.setExpectedType(actualLeftPreferred);
            right.setInferredType(actualLeftPreferred);
            right.setExpectedType(actualLeftPreferred);
            return actualLeftPreferred;
        }
        if (this.isSameType(actualRightPreferred, this.doInferTypeForExpression(left, actualRightPreferred, forceInferChildren, operandFlags))) {
            left.setInferredType(actualRightPreferred);
            left.setExpectedType(actualRightPreferred);
            right.setInferredType(actualRightPreferred);
            right.setExpectedType(actualRightPreferred);
            return actualRightPreferred;
        }
        if (this.isSameType(actualLeftPreferred, this.doInferTypeForExpression(right, actualLeftPreferred, forceInferChildren, operandFlags))) {
            left.setInferredType(actualLeftPreferred);
            left.setExpectedType(actualLeftPreferred);
            right.setInferredType(actualLeftPreferred);
            right.setExpectedType(actualLeftPreferred);
            return actualLeftPreferred;
        }
        TypeReference result = this.typeWithMoreInformation(actualLeftPreferred, actualRightPreferred);
        left.setExpectedType(result);
        right.setExpectedType(result);
        left.setInferredType(this.doInferTypeForExpression(left, result, forceInferChildren, operandFlags));
        right.setInferredType(this.doInferTypeForExpression(right, result, forceInferChildren, operandFlags));
        return result;
    }

    private TypeReference typeWithMoreInformation(TypeReference leftPreferred, TypeReference rightPreferred) {
        int right;
        if (leftPreferred == rightPreferred) {
            return leftPreferred;
        }
        int left = TypeAnalysis.getInformationAmount(leftPreferred);
        if (left < (right = TypeAnalysis.getInformationAmount(rightPreferred))) {
            return rightPreferred;
        }
        if (left > right) {
            return leftPreferred;
        }
        if (leftPreferred != null && rightPreferred != null) {
            return MetadataHelper.findCommonSuperType(leftPreferred.isGenericDefinition() ? new RawType(leftPreferred) : leftPreferred, rightPreferred.isGenericDefinition() ? new RawType(rightPreferred) : rightPreferred);
        }
        return leftPreferred;
    }

    private static int getInformationAmount(TypeReference type) {
        if (type == null || type == BuiltinTypes.Null) {
            return 0;
        }
        switch (type.getSimpleType()) {
            case Boolean: {
                return 1;
            }
            case Byte: {
                return 8;
            }
            case Character: 
            case Short: {
                return 16;
            }
            case Integer: 
            case Float: {
                return 32;
            }
            case Long: 
            case Double: {
                return 64;
            }
        }
        return 100;
    }

    static TypeReference getFieldType(FieldReference field) {
        FieldDefinition resolvedField = field.resolve();
        if (resolvedField != null) {
            FieldReference asMember = MetadataHelper.asMemberOf(resolvedField, field.getDeclaringType());
            return asMember.getFieldType();
        }
        return TypeAnalysis.substituteTypeArguments(field.getFieldType(), field);
    }

    static TypeReference substituteTypeArguments(TypeReference type, MemberReference member) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            TypeReference elementType = TypeAnalysis.substituteTypeArguments(arrayType.getElementType(), member);
            if (!MetadataResolver.areEquivalent(elementType, arrayType.getElementType())) {
                return elementType.makeArrayType();
            }
            return type;
        }
        if (type instanceof IGenericInstance) {
            IGenericInstance genericInstance = (IGenericInstance)((Object)type);
            ArrayList<TypeReference> newTypeArguments = new ArrayList<TypeReference>();
            boolean isChanged = false;
            for (TypeReference typeArgument : genericInstance.getTypeArguments()) {
                TypeReference newTypeArgument = TypeAnalysis.substituteTypeArguments(typeArgument, member);
                newTypeArguments.add(newTypeArgument);
                isChanged |= newTypeArgument != typeArgument;
            }
            return isChanged ? type.makeGenericType(newTypeArguments) : type;
        }
        if (type instanceof GenericParameter) {
            TypeReference declaringType;
            GenericParameter genericParameter = (GenericParameter)type;
            IGenericParameterProvider owner = genericParameter.getOwner();
            if (member.getDeclaringType() instanceof ArrayType) {
                return member.getDeclaringType().getElementType();
            }
            if (owner instanceof MethodReference && member instanceof MethodReference) {
                MethodReference method = (MethodReference)member;
                MethodReference ownerMethod = (MethodReference)owner;
                if (method.isGenericMethod() && MetadataResolver.areEquivalent(ownerMethod.getDeclaringType(), method.getDeclaringType()) && StringUtilities.equals(ownerMethod.getName(), method.getName()) && StringUtilities.equals(ownerMethod.getErasedSignature(), method.getErasedSignature())) {
                    if (method instanceof IGenericInstance) {
                        List<TypeReference> typeArguments = ((IGenericInstance)((Object)member)).getTypeArguments();
                        return typeArguments.get(genericParameter.getPosition());
                    }
                    return method.getGenericParameters().get(genericParameter.getPosition());
                }
            } else if (owner instanceof TypeReference && MetadataResolver.areEquivalent((TypeReference)owner, declaringType = member instanceof TypeReference ? (TypeReference)member : member.getDeclaringType())) {
                if (declaringType instanceof IGenericInstance) {
                    List<TypeReference> typeArguments = ((IGenericInstance)((Object)declaringType)).getTypeArguments();
                    return typeArguments.get(genericParameter.getPosition());
                }
                if (!declaringType.isGenericDefinition()) {
                    declaringType = declaringType.getUnderlyingType();
                }
                if (declaringType != null && declaringType.isGenericDefinition()) {
                    return declaringType.getGenericParameters().get(genericParameter.getPosition());
                }
            }
        }
        return type;
    }

    private boolean isSameType(TypeReference t1, TypeReference t2) {
        return MetadataHelper.isSameType(t1, t2, true);
    }

    private boolean anyDone(List<ExpressionToInfer> expressions) {
        for (ExpressionToInfer expression : expressions) {
            if (!expression.done) continue;
            return true;
        }
        return false;
    }

    private boolean allDone(List<ExpressionToInfer> expressions) {
        for (ExpressionToInfer expression : expressions) {
            if (expression.done) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean trueForAll(Iterable<T> sequence, Predicate<T> condition) {
        for (T item : sequence) {
            if (condition.test(item)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBoolean(TypeReference type) {
        return type != null && type.getSimpleType() == JvmType.Boolean;
    }

    private static TypeReference ensureReferenceType(TypeReference mappedType) {
        if (mappedType == null) {
            return null;
        }
        if (mappedType.isPrimitive()) {
            switch (mappedType.getSimpleType()) {
                case Boolean: {
                    return CommonTypeReferences.Boolean;
                }
                case Byte: {
                    return CommonTypeReferences.Byte;
                }
                case Character: {
                    return CommonTypeReferences.Character;
                }
                case Short: {
                    return CommonTypeReferences.Short;
                }
                case Integer: {
                    return CommonTypeReferences.Integer;
                }
                case Long: {
                    return CommonTypeReferences.Long;
                }
                case Float: {
                    return CommonTypeReferences.Float;
                }
                case Double: {
                    return CommonTypeReferences.Double;
                }
            }
        }
        return mappedType;
    }

    private static final class AddMappingsForArgumentVisitor
    extends DefaultTypeVisitor<Map<TypeReference, TypeReference>, Void> {
        private TypeReference argumentType;

        AddMappingsForArgumentVisitor(TypeReference argumentType) {
            this.argumentType = VerifyArgument.notNull(argumentType, "argumentType");
        }

        @Override
        public Void visit(TypeReference t2, Map<TypeReference, TypeReference> map) {
            TypeReference a = this.argumentType;
            t2.accept(this, map);
            this.argumentType = a;
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType t2, Map<TypeReference, TypeReference> map) {
            TypeReference a = this.argumentType;
            if (a.isArray()) {
                this.argumentType = a.getElementType();
                this.visit(t2.getElementType(), map);
            }
            return null;
        }

        @Override
        public Void visitGenericParameter(GenericParameter t2, Map<TypeReference, TypeReference> map) {
            if (MetadataResolver.areEquivalent(this.argumentType, (TypeReference)t2)) {
                return null;
            }
            TypeReference existingMapping = map.get(t2);
            TypeReference mappedType = this.argumentType;
            mappedType = TypeAnalysis.ensureReferenceType(mappedType);
            if (existingMapping == null) {
                if (!(mappedType instanceof RawType) && MetadataHelper.isRawType(mappedType)) {
                    TypeReference bound = MetadataHelper.getUpperBound(t2);
                    TypeReference asSuper = MetadataHelper.asSuper(mappedType, bound);
                    if (asSuper != null) {
                        if (MetadataHelper.isSameType(MetadataHelper.getUpperBound(t2), asSuper)) {
                            return null;
                        }
                        mappedType = asSuper;
                    } else {
                        mappedType = MetadataHelper.erase(mappedType);
                    }
                }
                map.put(t2, mappedType);
            } else if (!MetadataHelper.isSubType(this.argumentType, existingMapping)) {
                TypeReference commonSuperType = MetadataHelper.asSuper(mappedType, existingMapping);
                if (commonSuperType == null) {
                    commonSuperType = MetadataHelper.asSuper(existingMapping, mappedType);
                }
                if (commonSuperType == null) {
                    commonSuperType = MetadataHelper.findCommonSuperType(existingMapping, mappedType);
                }
                map.put(t2, commonSuperType);
            }
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t2, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public <C extends TypeReference> Void visitCompoundType(C t2, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitParameterizedType(TypeReference t2, Map<TypeReference, TypeReference> map) {
            TypeReference r = MetadataHelper.asSuper(t2.getUnderlyingType(), this.argumentType);
            TypeReference s2 = MetadataHelper.asSubType(this.argumentType, r != null ? r : t2.getUnderlyingType());
            if (s2 != null && s2 instanceof IGenericInstance) {
                List<TypeReference> tArgs = ((IGenericInstance)((Object)t2)).getTypeArguments();
                List<TypeReference> sArgs = ((IGenericInstance)((Object)s2)).getTypeArguments();
                if (tArgs.size() == sArgs.size()) {
                    int n = tArgs.size();
                    for (int i = 0; i < n; ++i) {
                        this.argumentType = sArgs.get(i);
                        this.visit(tArgs.get(i), map);
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitPrimitiveType(PrimitiveType t2, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitClassType(TypeReference t2, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitNullType(TypeReference t2, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitBottomType(TypeReference t2, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitRawType(RawType t2, Map<TypeReference, TypeReference> map) {
            return null;
        }
    }

    static final class ExpressionToInfer {
        private final List<Variable> dependencies = new ArrayList<Variable>();
        Expression expression;
        boolean done;
        Variable dependsOnSingleLoad;
        int flags;

        ExpressionToInfer() {
        }

        public String toString() {
            if (this.done) {
                return "[Done] " + this.expression;
            }
            return this.expression.toString();
        }
    }
}

