/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ComposedType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;
import com.strobel.util.ContractUtils;

public abstract class AstType
extends AstNode {
    public static final AstType[] EMPTY_TYPES = new AstType[0];
    public static final AstType NULL = new NullAstType();

    @Override
    public NodeType getNodeType() {
        return NodeType.TYPE_REFERENCE;
    }

    public TypeReference toTypeReference() {
        return this.getUserData(Keys.TYPE_REFERENCE);
    }

    public Role<? extends AstType> getRole() {
        return super.getRole();
    }

    public static AstType forPattern(Pattern pattern) {
        return new PatternPlaceholder(VerifyArgument.notNull(pattern, "pattern"));
    }

    @Override
    public AstType clone() {
        return (AstType)super.clone();
    }

    public AstType makeArrayType() {
        ComposedType composedType = new ComposedType();
        composedType.setBaseType(this);
        TypeReference typeReference = this.getUserData(Keys.TYPE_REFERENCE);
        if (typeReference != null) {
            composedType.putUserData(Keys.TYPE_REFERENCE, typeReference);
        }
        composedType.makeArrayType();
        return composedType;
    }

    public ClassOfExpression classOf() {
        return new ClassOfExpression(-34, this);
    }

    public InvocationExpression invoke(String methodName, Expression ... arguments) {
        return this.makeReference().invoke(methodName, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<Expression> arguments) {
        return this.makeReference().invoke(methodName, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<AstType> typeArguments, Expression ... arguments) {
        return this.makeReference().invoke(methodName, typeArguments, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<AstType> typeArguments, Iterable<Expression> arguments) {
        return this.makeReference().invoke(methodName, typeArguments, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Expression ... arguments) {
        return this.makeReference().invoke(methodReference, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Iterable<Expression> arguments) {
        return this.makeReference().invoke(methodReference, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Iterable<AstType> typeArguments, Expression ... arguments) {
        return this.makeReference().invoke(methodReference, typeArguments, arguments);
    }

    public InvocationExpression invoke(MethodReference methodReference, Iterable<AstType> typeArguments, Iterable<Expression> arguments) {
        return this.makeReference().invoke(methodReference, typeArguments, arguments);
    }

    public MemberReferenceExpression member(String memberName) {
        return this.makeReference().member(memberName);
    }

    public MemberReferenceExpression member(FieldReference member) {
        MemberReferenceExpression r = this.makeReference().member(member.getName());
        r.putUserData(Keys.MEMBER_REFERENCE, member);
        return r;
    }

    public TypeReferenceExpression makeReference() {
        TypeReferenceExpression t2 = new TypeReferenceExpression(-34, this);
        TypeReference r = this.getUserData(Keys.TYPE_REFERENCE);
        if (r != null) {
            t2.putUserData(Keys.TYPE_REFERENCE, r);
        }
        return t2;
    }

    public ObjectCreationExpression makeNew() {
        return new ObjectCreationExpression(-34, this, Expression.EMPTY_EXPESSIONS);
    }

    public ObjectCreationExpression makeNew(Expression ... arguments) {
        return new ObjectCreationExpression(-34, this, arguments);
    }

    public ObjectCreationExpression makeNew(Iterable<Expression> arguments) {
        return new ObjectCreationExpression(-34, this, arguments);
    }

    private static final class PatternPlaceholder
    extends AstType {
        private final Pattern _child;

        PatternPlaceholder(Pattern child) {
            this._child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public TypeReference toTypeReference() {
            throw ContractUtils.unsupported();
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this._child, data);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this._child.matches(other, match);
        }

        @Override
        public boolean matchesCollection(Role<?> role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this._child.matchesCollection(role, position, match, backtrackingInfo);
        }
    }

    private static final class NullAstType
    extends AstType {
        private NullAstType() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }

        @Override
        public TypeReference toTypeReference() {
            return BuiltinTypes.Null;
        }
    }
}

