/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicates;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.ast.Annotation;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.ArraySpecifier;
import com.strobel.decompiler.languages.java.ast.AssertStatement;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.BytecodeConstant;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ComposedType;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.EmptyStatement;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.EnumValueDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.GotoStatement;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.ImportDeclaration;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InlinedBytecodeExpression;
import com.strobel.decompiler.languages.java.ast.InstanceInitializer;
import com.strobel.decompiler.languages.java.ast.InstanceOfExpression;
import com.strobel.decompiler.languages.java.ast.IntersectionType;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.LocalTypeDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ModuleDeclaration;
import com.strobel.decompiler.languages.java.ast.NameResolveMode;
import com.strobel.decompiler.languages.java.ast.NameResolveResult;
import com.strobel.decompiler.languages.java.ast.NewLineNode;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.PackageDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.SwitchExpression;
import com.strobel.decompiler.languages.java.ast.SwitchExpressionArm;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.TextNode;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnionType;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.languages.java.ast.WildcardType;
import com.strobel.decompiler.patterns.Pattern;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class JavaNameResolver {
    public static boolean isStaticContext(AstNode node) {
        return JavaNameResolver.isStaticContext(node, false, true);
    }

    public static boolean isStaticContext(AstNode node, boolean topLevelAreStatic, boolean considerMethods) {
        for (AstNode n = node; n != null && !n.isNull(); n = n.getParent()) {
            if (considerMethods && n instanceof MethodDeclaration) {
                MethodDefinition method = n.getUserData(Keys.METHOD_DEFINITION);
                if (method != null) {
                    return method.isStatic();
                }
                for (JavaModifierToken modifier : ((MethodDeclaration)n).getModifiers()) {
                    if (modifier.getModifier() != Flags.Flag.STATIC) continue;
                    return true;
                }
            }
            if (!(n instanceof TypeDeclaration)) continue;
            TypeDefinition type = n.getUserData(Keys.TYPE_DEFINITION);
            if (type != null) {
                return type.isStatic() || topLevelAreStatic && !type.isInnerClass();
            }
            for (JavaModifierToken modifier : ((TypeDeclaration)n).getModifiers()) {
                if (modifier.getModifier() != Flags.Flag.STATIC) continue;
                return true;
            }
        }
        return false;
    }

    public static NameResolveResult resolve(String name, AstNode node) {
        return new Result(NameResolveMode.EXPRESSION, JavaNameResolver.resolveCore(node, name, NameResolveMode.EXPRESSION));
    }

    public static NameResolveResult resolveAsType(String name, AstNode node) {
        return new Result(NameResolveMode.TYPE, JavaNameResolver.resolveCore(node, name, NameResolveMode.TYPE));
    }

    private static List<Object> resolveCore(AstNode location, String name, NameResolveMode mode) {
        Set<Object> results = FindDeclarationVisitor.resolveName(location, name, mode);
        if (results.isEmpty()) {
            return ReadOnlyList.emptyList();
        }
        return new ReadOnlyList<Object>(Object.class, (Collection<Object>)results);
    }

    private static final class Result
    extends NameResolveResult {
        private final NameResolveMode _mode;
        private final List<Object> _candidates;

        Result(NameResolveMode mode, List<Object> candidates) {
            this._mode = mode;
            this._candidates = candidates;
        }

        @Override
        public final List<Object> getCandidates() {
            return this._candidates;
        }

        @Override
        public final NameResolveMode getMode() {
            return this._mode;
        }
    }

    private static final class FindDeclarationVisitor
    implements IAstVisitor<String, Set<Object>> {
        private final NameResolveMode _mode;
        private boolean _isStaticContext;

        FindDeclarationVisitor(NameResolveMode mode, boolean isStaticContext) {
            this._mode = VerifyArgument.notNull(mode, "mode");
            this._isStaticContext = isStaticContext;
        }

        static Set<Object> resolveName(AstNode node, String name, NameResolveMode mode) {
            VerifyArgument.notNull(node, "node");
            VerifyArgument.notNull(name, "name");
            VerifyArgument.notNull(mode, "mode");
            AstNode n = node;
            LinkedHashSet<Object> results = null;
            while (n instanceof Expression) {
                n = n.getParent();
            }
            if (n == null || n.isNull()) {
                return Collections.emptySet();
            }
            AstNode lastTypeDeclaration = null;
            FindDeclarationVisitor visitor = new FindDeclarationVisitor(mode, JavaNameResolver.isStaticContext(node));
            while (n != null && !n.isNull()) {
                Set<Object> unitResults;
                if (n instanceof CompilationUnit && !(unitResults = n.acceptVisitor(visitor, name)).isEmpty()) {
                    if (results == null) {
                        return unitResults;
                    }
                    results.addAll(unitResults);
                }
                AstNode parent = n.getParent();
                if (n instanceof MethodDeclaration) {
                    MethodDefinition method;
                    Set<Object> methodResults = n.acceptVisitor(visitor, name);
                    if (!methodResults.isEmpty()) {
                        if (results == null) {
                            results = new LinkedHashSet<Object>();
                        }
                        results.addAll(methodResults);
                    }
                    if ((method = n.getUserData(Keys.METHOD_DEFINITION)) != null) {
                        visitor._isStaticContext = method.isStatic();
                    }
                } else if (n instanceof TypeDeclaration) {
                    Set<Object> typeResults = n.acceptVisitor(visitor, name);
                    if (!typeResults.isEmpty()) {
                        if (results == null) {
                            results = new LinkedHashSet();
                        }
                        results.addAll(typeResults);
                        return results;
                    }
                    if (parent instanceof TypeDeclaration) {
                        TypeDefinition type = n.getUserData(Keys.TYPE_DEFINITION);
                        if (type != null) {
                            visitor._isStaticContext = type.isStatic();
                        }
                    } else if (parent instanceof LocalTypeDeclarationStatement) {
                        n = ((LocalTypeDeclarationStatement)parent).getTypeDeclaration();
                        parent = n.getParent();
                    }
                    lastTypeDeclaration = (TypeDeclaration)n;
                } else if (n instanceof Statement) {
                    Statement previousStatement;
                    Statement s2 = (Statement)n;
                    Set<Object> statementResults = s2.acceptVisitor(visitor, name);
                    if (!statementResults.isEmpty()) {
                        if (results == null) {
                            results = new LinkedHashSet();
                        }
                        results.addAll(statementResults);
                        if (mode == NameResolveMode.EXPRESSION || mode == NameResolveMode.TYPE && CollectionUtilities.any(results, Predicates.instanceOf(TypeReference.class))) {
                            return results;
                        }
                    }
                    if ((previousStatement = ((Statement)n).getPreviousStatement()) != null) {
                        n = previousStatement;
                        continue;
                    }
                }
                n = parent;
            }
            if (results != null) {
                return results;
            }
            if (lastTypeDeclaration != null) {
                return visitor.searchUpScope(name, lastTypeDeclaration.getUserData(Keys.TYPE_DEFINITION), new LinkedHashSet<String>(), true);
            }
            return Collections.emptySet();
        }

        private Set<Object> searchUpScope(String name, TypeDefinition type, Set<String> visitedTypes, boolean searchGenericParameters) {
            Set<Object> declaringTypeResults;
            TypeDefinition resolvedType;
            TypeReference declaringType;
            LinkedHashSet baseTypeResults;
            Object resolvedBaseType;
            if (type == null || visitedTypes.contains(type.getInternalName())) {
                return Collections.emptySet();
            }
            LinkedHashSet results = null;
            if (this._mode == NameResolveMode.EXPRESSION) {
                for (FieldDefinition f : type.getDeclaredFields()) {
                    if (!StringUtilities.equals(f.getName(), name) || this._isStaticContext && !f.isStatic()) continue;
                    return Collections.singleton(f);
                }
            }
            if (StringUtilities.equals(type.getSimpleName(), name)) {
                results = new LinkedHashSet<Object>();
                results.add(type);
            }
            if (searchGenericParameters) {
                for (GenericParameter gp : type.getGenericParameters()) {
                    if (!StringUtilities.equals(gp.getName(), name)) continue;
                    if (results == null) {
                        results = new LinkedHashSet();
                    }
                    results.add((Object)gp);
                }
            }
            for (TypeDefinition declaredType : type.getDeclaredTypes()) {
                if (!StringUtilities.equals(declaredType.getSimpleName(), name)) continue;
                if (results == null) {
                    results = new LinkedHashSet();
                }
                results.add((Object)declaredType);
            }
            if (results != null && !results.isEmpty()) {
                return results;
            }
            TypeReference baseType = type.getBaseType();
            if (baseType != null && (resolvedBaseType = baseType.resolve()) != null && (baseTypeResults = this.searchUpScope(name, (TypeDefinition)resolvedBaseType, visitedTypes, false)) != null && !baseTypeResults.isEmpty()) {
                if (results == null) {
                    results = baseTypeResults instanceof LinkedHashSet ? baseTypeResults : new LinkedHashSet(baseTypeResults);
                } else {
                    results.addAll(baseTypeResults);
                }
            }
            for (TypeReference ifType : MetadataHelper.getInterfaces(type)) {
                LinkedHashSet ifTypeResults;
                TypeDefinition resultIfType = ifType.resolve();
                if (resultIfType == null || (ifTypeResults = this.searchUpScope(name, resultIfType, visitedTypes, false)) == null || ifTypeResults.isEmpty()) continue;
                if (results == null) {
                    results = ifTypeResults instanceof LinkedHashSet ? ifTypeResults : new LinkedHashSet(ifTypeResults);
                    continue;
                }
                results.addAll(ifTypeResults);
            }
            MethodReference declaringMethod = type.getDeclaringMethod();
            if (declaringMethod != null && (declaringType = declaringMethod.getDeclaringType()) != null) {
                resolvedType = declaringType.resolve();
                if (resolvedType != null) {
                    declaringTypeResults = this.searchUpScope(name, resolvedType, visitedTypes, true);
                    if (declaringTypeResults != null && !declaringTypeResults.isEmpty()) {
                        if (results == null) {
                            results = declaringTypeResults instanceof LinkedHashSet ? declaringTypeResults : new LinkedHashSet(declaringTypeResults);
                        } else {
                            results.addAll(declaringTypeResults);
                        }
                    }
                } else if (StringUtilities.equals(declaringType.getSimpleName(), name)) {
                    if (results == null) {
                        results = new LinkedHashSet();
                    }
                    results.add((Object)declaringType);
                }
            }
            if ((declaringType = type.getDeclaringType()) != null) {
                resolvedType = declaringType.resolve();
                if (resolvedType != null) {
                    declaringTypeResults = this.searchUpScope(name, resolvedType, visitedTypes, true);
                    if (declaringTypeResults != null && !declaringTypeResults.isEmpty()) {
                        if (results == null) {
                            results = declaringTypeResults instanceof LinkedHashSet ? declaringTypeResults : new LinkedHashSet(declaringTypeResults);
                        } else {
                            results.addAll(declaringTypeResults);
                        }
                    }
                } else if (StringUtilities.equals(declaringType.getSimpleName(), name)) {
                    if (results == null) {
                        results = new LinkedHashSet();
                    }
                    results.add((Object)declaringType);
                }
            }
            if (results != null) {
                return results;
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitComment(Comment node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitPatternPlaceholder(AstNode node, Pattern pattern, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitInvocationExpression(InvocationExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitTypeReference(TypeReferenceExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitJavaTokenNode(JavaTokenNode node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitMemberReferenceExpression(MemberReferenceExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitIdentifier(Identifier node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitNullReferenceExpression(NullReferenceExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitThisReferenceExpression(ThisReferenceExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitSuperReferenceExpression(SuperReferenceExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitClassOfExpression(ClassOfExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitBlockStatement(BlockStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitExpressionStatement(ExpressionStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitBreakStatement(BreakStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitContinueStatement(ContinueStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitDoWhileStatement(DoWhileStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitEmptyStatement(EmptyStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitIfElseStatement(IfElseStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitLabelStatement(LabelStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitLabeledStatement(LabeledStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitReturnStatement(ReturnStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitSwitchStatement(SwitchStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitSwitchSection(SwitchSection node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitSwitchExpression(SwitchExpression node, String data) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitSwitchExpressionArm(SwitchExpressionArm node, String data) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitCaseLabel(CaseLabel node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitThrowStatement(ThrowStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitCatchClause(CatchClause node, String name) {
            Variable exceptionVariable;
            if (this._mode == NameResolveMode.EXPRESSION && StringUtilities.equals(node.getVariableName(), name) && (exceptionVariable = node.getUserData(Keys.VARIABLE)) != null) {
                return Collections.singleton(exceptionVariable);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitAnnotation(Annotation node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitNewLine(NewLineNode node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitVariableDeclaration(VariableDeclarationStatement node, String name) {
            Variable variable;
            VariableInitializer v;
            if (this._mode == NameResolveMode.EXPRESSION && (v = node.getVariable(name)) != null && (variable = v.getUserData(Keys.VARIABLE)) != null) {
                return Collections.singleton(variable);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitVariableInitializer(VariableInitializer node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitText(TextNode node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitImportDeclaration(ImportDeclaration node, String name) {
            TypeReference importedType = node.getUserData(Keys.TYPE_REFERENCE);
            if (importedType != null && (StringUtilities.equals(importedType.getSimpleName(), name) || StringUtilities.equals(importedType.getFullName(), name))) {
                return Collections.singleton(importedType);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitSimpleType(SimpleType node, String name) {
            if (StringUtilities.equals(node.getIdentifier(), name)) {
                return Collections.singleton(node.toTypeReference());
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitIntersectionType(IntersectionType node, String data) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitUnionType(UnionType node, String data) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitMethodDeclaration(MethodDeclaration node, String name) {
            LinkedHashSet<TypeDefinition> results = null;
            if (this._mode == NameResolveMode.EXPRESSION) {
                for (ParameterDeclaration p : node.getParameters()) {
                    ParameterDefinition pd;
                    if (!StringUtilities.equals(p.getName(), name) || (pd = p.getUserData(Keys.PARAMETER_DEFINITION)) == null) continue;
                    if (results == null) {
                        results = new LinkedHashSet<TypeDefinition>();
                    }
                    results.add((TypeDefinition)((Object)pd));
                }
            }
            for (TypeParameterDeclaration tp : node.getTypeParameters()) {
                TypeDefinition gp = tp.getUserData(Keys.TYPE_DEFINITION);
                if (gp == null || !StringUtilities.equals(gp.getName(), name)) continue;
                if (results == null) {
                    results = new LinkedHashSet();
                }
                results.add(gp);
            }
            if (results != null) {
                return results;
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitInitializerBlock(InstanceInitializer node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitConstructorDeclaration(ConstructorDeclaration node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitTypeParameterDeclaration(TypeParameterDeclaration node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitParameterDeclaration(ParameterDeclaration node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitFieldDeclaration(FieldDeclaration node, String name) {
            FieldDefinition f;
            if (this._mode == NameResolveMode.EXPRESSION && StringUtilities.equals(node.getName(), name) && (f = node.getUserData(Keys.FIELD_DEFINITION)) != null && (!this._isStaticContext || f.isStatic())) {
                return Collections.singleton(f);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitTypeDeclaration(TypeDeclaration node, String name) {
            TypeDefinition typeDefinition;
            LinkedHashSet<Object> results = null;
            if (this._mode == NameResolveMode.EXPRESSION) {
                for (EntityDeclaration member : node.getMembers()) {
                    Set<Object> fieldResults;
                    if (!(member instanceof FieldDeclaration) || (fieldResults = member.acceptVisitor(this, name)).isEmpty()) continue;
                    return fieldResults;
                }
            }
            if (StringUtilities.equals(node.getName(), name) && (typeDefinition = node.getUserData(Keys.TYPE_DEFINITION)) != null) {
                results = new LinkedHashSet<Object>();
                results.add(typeDefinition);
            }
            for (EntityDeclaration member : node.getMembers()) {
                TypeDefinition t2;
                TypeDeclaration td;
                if (!(member instanceof TypeDeclaration) || !StringUtilities.equals((td = (TypeDeclaration)member).getName(), name) || (t2 = td.getUserData(Keys.TYPE_DEFINITION)) == null) continue;
                if (results == null) {
                    results = new LinkedHashSet();
                }
                results.add(t2);
            }
            if (this._mode == NameResolveMode.TYPE && results != null && !results.isEmpty()) {
                return results;
            }
            for (TypeParameterDeclaration tp : node.getTypeParameters()) {
                TypeDefinition gp = tp.getUserData(Keys.TYPE_DEFINITION);
                if (gp == null || !StringUtilities.equals(gp.getName(), name)) continue;
                if (results == null) {
                    results = new LinkedHashSet();
                }
                results.add(gp);
            }
            if (results != null && !results.isEmpty()) {
                return results;
            }
            return this.searchUpScope(name, node.getUserData(Keys.TYPE_DEFINITION), new LinkedHashSet<String>(), true);
        }

        @Override
        public Set<Object> visitModuleDeclaration(ModuleDeclaration node, String data) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitLocalTypeDeclarationStatement(LocalTypeDeclarationStatement node, String name) {
            TypeDefinition type;
            TypeDeclaration typeDeclaration = node.getTypeDeclaration();
            if (typeDeclaration.isNull()) {
                return Collections.emptySet();
            }
            if (StringUtilities.equals(typeDeclaration.getName(), name) && (type = typeDeclaration.getUserData(Keys.TYPE_DEFINITION)) != null) {
                return Collections.singleton(type);
            }
            return this.searchUpScope(name, typeDeclaration.getUserData(Keys.TYPE_DEFINITION), new LinkedHashSet<String>(), true);
        }

        @Override
        public Set<Object> visitInlinedBytecode(InlinedBytecodeExpression node, String data) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitBytecodeConstant(BytecodeConstant node, String data) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitCompilationUnit(CompilationUnit node, String name) {
            LinkedHashSet<Object> results = null;
            for (TypeDeclaration typeDeclaration : node.getTypes()) {
                Set<Object> typeResults = typeDeclaration.acceptVisitor(this, name);
                if (typeResults.isEmpty()) continue;
                if (results == null) {
                    results = new LinkedHashSet<Object>();
                }
                results.addAll(typeResults);
            }
            for (ImportDeclaration typeImport : node.getImports()) {
                Set<Object> importResults = typeImport.acceptVisitor(this, name);
                if (importResults.isEmpty()) continue;
                if (results == null) {
                    results = new LinkedHashSet();
                }
                results.addAll(importResults);
            }
            if (results != null) {
                return results;
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitPackageDeclaration(PackageDeclaration node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitArraySpecifier(ArraySpecifier node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitComposedType(ComposedType node, String name) {
            return node.getBaseType().acceptVisitor(this, name);
        }

        @Override
        public Set<Object> visitWhileStatement(WhileStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitPrimitiveExpression(PrimitiveExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitCastExpression(CastExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitBinaryOperatorExpression(BinaryOperatorExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitInstanceOfExpression(InstanceOfExpression node, String name) {
            Variable variable;
            if (this._mode == NameResolveMode.EXPRESSION && StringUtilities.equals(node.getIdentifier().getName(), name) && (variable = node.getUserData(Keys.VARIABLE)) != null) {
                return Collections.singleton(variable);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitIndexerExpression(IndexerExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitIdentifierExpression(IdentifierExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitUnaryOperatorExpression(UnaryOperatorExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitConditionalExpression(ConditionalExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitArrayInitializerExpression(ArrayInitializerExpression arrayInitializerExpression, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitObjectCreationExpression(ObjectCreationExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitArrayCreationExpression(ArrayCreationExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitAssignmentExpression(AssignmentExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitForStatement(ForStatement node, String name) {
            if (this._mode == NameResolveMode.EXPRESSION) {
                LinkedHashSet<Object> results = null;
                for (Statement initializer : node.getInitializers()) {
                    Set<Object> initializerResults = initializer.acceptVisitor(this, name);
                    if (node.getInitializers().isEmpty()) continue;
                    if (results == null) {
                        results = new LinkedHashSet<Object>();
                    }
                    results.addAll(initializerResults);
                }
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitForEachStatement(ForEachStatement node, String name) {
            Variable v;
            if (this._mode == NameResolveMode.EXPRESSION && StringUtilities.equals(node.getVariableName(), name) && (v = node.getUserData(Keys.VARIABLE)) != null) {
                return Collections.singleton(v);
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitTryCatchStatement(TryCatchStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitGotoStatement(GotoStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitParenthesizedExpression(ParenthesizedExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitSynchronizedStatement(SynchronizedStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitWildcardType(WildcardType node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitMethodGroupExpression(MethodGroupExpression node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitEnumValueDeclaration(EnumValueDeclaration node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitAssertStatement(AssertStatement node, String name) {
            return Collections.emptySet();
        }

        @Override
        public Set<Object> visitLambdaExpression(LambdaExpression node, String name) {
            if (this._mode == NameResolveMode.EXPRESSION) {
                LinkedHashSet<ParameterDefinition> results = null;
                for (ParameterDeclaration pd : node.getParameters()) {
                    ParameterDefinition p;
                    if (!StringUtilities.equals(pd.getName(), name) || (p = pd.getUserData(Keys.PARAMETER_DEFINITION)) == null) continue;
                    if (results == null) {
                        results = new LinkedHashSet<ParameterDefinition>();
                    }
                    results.add(p);
                }
                if (results != null) {
                    return results;
                }
            }
            return Collections.emptySet();
        }
    }
}

