/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Repeat;
import com.strobel.decompiler.patterns.SingleOrBinaryAggregateNode;
import java.util.ArrayList;
import java.util.List;

public class EclipseStringSwitchRewriterTransform
extends ContextTrackingVisitor<Void> {
    private static final Pattern HASH_CODE_PATTERN = new NamedNode("hashCodeCall", new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new AnyNode("target").toExpression(), "hashCode", new AstType[0]), new Expression[0]));
    private static final BlockStatement CASE_BODY_PATTERN;

    public EclipseStringSwitchRewriterTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitSwitchStatement(SwitchStatement node, Void data) {
        super.visitSwitchStatement(node, data);
        Expression input = node.getExpression();
        if (input == null || input.isNull()) {
            return null;
        }
        Match m22 = HASH_CODE_PATTERN.match(input);
        if (!m22.success()) {
            return null;
        }
        InvocationExpression hashCodeCall = (InvocationExpression)CollectionUtilities.first(m22.get("hashCodeCall"));
        MemberReference hashCodeMethod = hashCodeCall.getUserData(Keys.MEMBER_REFERENCE);
        if (!(hashCodeMethod instanceof MethodReference) || !CommonTypeReferences.String.isEquivalentTo(hashCodeMethod.getDeclaringType())) {
            return null;
        }
        ArrayList<Match> matches = new ArrayList<Match>();
        AstNodeCollection<SwitchSection> sections = node.getSwitchSections();
        for (SwitchSection section : sections) {
            AstNodeCollection<CaseLabel> caseLabels = section.getCaseLabels();
            if (caseLabels.isEmpty() || caseLabels.hasSingleElement() && ((CaseLabel)caseLabels.firstOrNullObject()).isNull()) {
                return null;
            }
            Match m32 = CASE_BODY_PATTERN.match(section.getStatements().firstOrNullObject());
            if (m32.success()) {
                matches.add(m32);
                continue;
            }
            return null;
        }
        int matchIndex = 0;
        AstNode defaultBreak = null;
        for (SwitchSection section : sections) {
            Match m4 = (Match)matches.get(matchIndex++);
            IfElseStatement test = (IfElseStatement)CollectionUtilities.first(m4.get("test"));
            List stringValues = CollectionUtilities.toList(m4.get("stringValue"));
            AstNodeCollection<CaseLabel> caseLabels = section.getCaseLabels();
            if (defaultBreak == null) {
                defaultBreak = (BreakStatement)CollectionUtilities.firstOrDefault(m4.get("defaultBreak"));
            }
            caseLabels.clear();
            test.remove();
            for (int i = 0; i < stringValues.size(); ++i) {
                PrimitiveExpression stringValue = (PrimitiveExpression)stringValues.get(i);
                stringValue.remove();
                caseLabels.add(new CaseLabel(stringValue));
            }
        }
        if (defaultBreak != null) {
            SwitchSection defaultSection = new SwitchSection();
            defaultBreak.remove();
            defaultSection.getCaseLabels().add(new CaseLabel());
            defaultSection.getStatements().add((Statement)defaultBreak);
            sections.add(defaultSection);
        }
        AstNode newInput = (AstNode)CollectionUtilities.first(m22.get("target"));
        newInput.remove();
        node.getExpression().replaceWith(newInput);
        return null;
    }

    static {
        BlockStatement caseBody = new BlockStatement();
        IfElseStatement test = new IfElseStatement(-34, new UnaryOperatorExpression(UnaryOperatorType.NOT, new SingleOrBinaryAggregateNode(BinaryOperatorType.LOGICAL_OR, new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new NamedNode("input", new IdentifierExpression(-34, "$any$")).toExpression(), "equals", new AstType[0]), new NamedNode("stringValue", new PrimitiveExpression(-34, (Object)"$any$")).toExpression())).toExpression()), (Statement)new BlockStatement(new Choice(new NamedNode("defaultBreak", new BreakStatement(-34, "$any$")), new ReturnStatement(-34)).toStatement()));
        caseBody.add(new NamedNode("test", test).toStatement());
        caseBody.add(new Repeat(new AnyNode("statements")).toStatement());
        CASE_BODY_PATTERN = caseBody;
    }
}

