/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.SafeCloseable;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.InliningHelper;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.BackReference;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.DeclaredVariableBackReference;
import com.strobel.decompiler.patterns.MemberReferenceTypeNode;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.ParameterReferenceNode;
import com.strobel.decompiler.patterns.SubtreeMatch;
import com.strobel.decompiler.patterns.TypedNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EliminateSyntheticAccessorsTransform
extends ContextTrackingVisitor<Void> {
    private final List<AstNode> _nodesToRemove = new ArrayList<AstNode>();
    private final Map<String, MethodDeclaration> _accessMethodDeclarations = new HashMap<String, MethodDeclaration>();
    private final Set<String> _visitedTypes = new HashSet<String>();
    private static final MethodDeclaration SYNTHETIC_GET_ACCESSOR;
    private static final MethodDeclaration SYNTHETIC_SET_ACCESSOR;
    private static final MethodDeclaration SYNTHETIC_SET_ACCESSOR_ALT;
    private static final MethodDeclaration SYNTHETIC_STATIC_GET_ACCESSOR;
    private static final MethodDeclaration SYNTHETIC_STATIC_SET_ACCESSOR;
    private static final MethodDeclaration SYNTHETIC_STATIC_SET_ACCESSOR_ALT;

    public EliminateSyntheticAccessorsTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public void run(AstNode compilationUnit) {
        new PhaseOneVisitor().run(compilationUnit);
        super.run(compilationUnit);
        for (AstNode node : this._nodesToRemove) {
            node.remove();
        }
    }

    private static String makeMethodKey(MethodReference method) {
        return method.getFullName() + ":" + method.getErasedSignature();
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, Void data) {
        super.visitInvocationExpression(node, data);
        Expression target = node.getTarget();
        AstNodeCollection<Expression> arguments = node.getArguments();
        if (target instanceof MemberReferenceExpression) {
            MemberReferenceExpression memberReference = (MemberReferenceExpression)target;
            MemberReference reference = memberReference.getUserData(Keys.MEMBER_REFERENCE);
            if (reference == null) {
                reference = node.getUserData(Keys.MEMBER_REFERENCE);
            }
            if (reference instanceof MethodReference) {
                String key;
                MethodDeclaration declaration;
                AstBuilder astBuilder;
                MethodDefinition md;
                MethodReference method = (MethodReference)reference;
                TypeReference declaringType = method.getDeclaringType();
                if (StringUtilities.equals(declaringType.getPackageName(), this.context.getCurrentType().getPackageName()) && !MetadataResolver.areEquivalent(this.context.getCurrentType(), declaringType) && !MetadataHelper.isEnclosedBy(this.context.getCurrentType(), declaringType) && !this._visitedTypes.contains(declaringType.getInternalName()) && (md = method.resolve()) != null && md.isSynthetic() && !md.isBridgeMethod() && md.isPackagePrivate() && (astBuilder = this.context.getUserData(Keys.AST_BUILDER)) != null) {
                    try (SafeCloseable importSuppression = astBuilder.suppressImports();){
                        TypeDeclaration ownerTypeDeclaration = astBuilder.createType(md.getDeclaringType());
                        ownerTypeDeclaration.acceptVisitor(new PhaseOneVisitor(), data);
                    }
                }
                if ((declaration = this._accessMethodDeclarations.get(key = EliminateSyntheticAccessorsTransform.makeMethodKey(method))) != null) {
                    List<ParameterDefinition> parameters;
                    MethodDefinition definition = declaration.getUserData(Keys.METHOD_DEFINITION);
                    List<ParameterDefinition> list = parameters = definition != null ? definition.getParameters() : null;
                    if (definition != null && parameters.size() == arguments.size()) {
                        AstNode inlinedBody;
                        IdentityHashMap<ParameterDefinition, Expression> parameterMap = new IdentityHashMap<ParameterDefinition, Expression>();
                        int i = 0;
                        for (Expression argument : arguments) {
                            parameterMap.put(parameters.get(i++), argument);
                        }
                        MethodDeclaration clone = (MethodDeclaration)declaration.clone();
                        if (!declaration.getParameters().isEmpty() && !arguments.isEmpty() && EliminateSyntheticAccessorsTransform.isThisOrOuterThisReference(CollectionUtilities.first(arguments))) {
                            new ReplaceSuperReferencesVisitor(clone.getParameters().firstOrNullObject().getName()).run(clone.getBody());
                        }
                        if ((inlinedBody = InliningHelper.inlineMethod(clone, parameterMap)) instanceof Expression) {
                            node.replaceWith(inlinedBody);
                        } else if (inlinedBody instanceof BlockStatement) {
                            BlockStatement block = (BlockStatement)inlinedBody;
                            if (block.getStatements().size() == 2) {
                                Expression expression;
                                Statement setStatement = block.getStatements().firstOrNullObject();
                                if (setStatement instanceof ExpressionStatement && (expression = ((ExpressionStatement)setStatement).getExpression()) instanceof AssignmentExpression) {
                                    expression.remove();
                                    node.replaceWith(expression);
                                }
                            } else if (block.getStatements().size() == 3) {
                                Expression expression;
                                Statement tempAssignment = block.getStatements().firstOrNullObject();
                                Statement setStatement = CollectionUtilities.getOrDefault(block.getStatements(), 1);
                                if (tempAssignment instanceof VariableDeclarationStatement && setStatement instanceof ExpressionStatement && (expression = ((ExpressionStatement)setStatement).getExpression()) instanceof AssignmentExpression) {
                                    VariableDeclarationStatement tempVariable = (VariableDeclarationStatement)tempAssignment;
                                    Expression initializer = tempVariable.getVariables().firstOrNullObject().getInitializer();
                                    AssignmentExpression assignment = (AssignmentExpression)expression;
                                    initializer.remove();
                                    assignment.setRight(initializer);
                                    expression.remove();
                                    node.replaceWith(expression);
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private static boolean isThisOrOuterThisReference(Expression e) {
        FieldDefinition resolvedField;
        MemberReference m4;
        if (e == null || e.isNull()) {
            return false;
        }
        if (e instanceof ThisReferenceExpression && ((ThisReferenceExpression)e).getTarget().isNull()) {
            return true;
        }
        return e instanceof MemberReferenceExpression && (m4 = e.getUserData(Keys.MEMBER_REFERENCE)) instanceof FieldReference && (resolvedField = ((FieldReference)m4).resolve()) != null && resolvedField.isSynthetic() && resolvedField.getDeclaringType().isInnerClass() && resolvedField.getDeclaringType().getDeclaringType() != null && resolvedField.getDeclaringType().getDeclaringType().isEquivalentTo(resolvedField.getFieldType());
    }

    static {
        MethodDeclaration getAccessor = new MethodDeclaration();
        MethodDeclaration setAccessor = new MethodDeclaration();
        getAccessor.setName("$any$");
        getAccessor.getModifiers().add(new JavaModifierToken(Flags.Flag.STATIC));
        getAccessor.setReturnType(new AnyNode("returnType").toType());
        setAccessor.setName("$any$");
        setAccessor.getModifiers().add(new JavaModifierToken(Flags.Flag.STATIC));
        setAccessor.setReturnType(new AnyNode("returnType").toType());
        ParameterDeclaration getParameter = new ParameterDeclaration("$any$", new AnyNode("targetType").toType());
        getParameter.setAnyModifiers(true);
        getAccessor.getParameters().add(getParameter);
        ParameterDeclaration setParameter1 = new ParameterDeclaration("$any$", new AnyNode("targetType").toType());
        ParameterDeclaration setParameter2 = new ParameterDeclaration("$any$", new AnyNode().toType());
        setParameter1.setAnyModifiers(true);
        setParameter2.setAnyModifiers(true);
        setAccessor.getParameters().add(setParameter1);
        setAccessor.getParameters().add(new OptionalNode(setParameter2).toParameterDeclaration());
        getAccessor.setBody(new BlockStatement(new ReturnStatement(-34, new SubtreeMatch(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new ParameterReferenceNode(0).toExpression(), "$any$", new AstType[0]), FieldReference.class)).toExpression())));
        MethodDeclaration altSetAccessor = (MethodDeclaration)setAccessor.clone();
        setAccessor.setBody(new Choice(new BlockStatement(new ExpressionStatement(new AssignmentExpression(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new ParameterReferenceNode(0).toExpression(), "$any$", new AstType[0]), FieldReference.class).toExpression(), AssignmentOperatorType.ANY, new Choice(new ParameterReferenceNode(1, "value"), new CastExpression(new BackReference("returnType").toType(), new ParameterReferenceNode(1, "value").toExpression())).toExpression())), new ReturnStatement(-34, new BackReference("value").toExpression())), new BlockStatement(new ReturnStatement(-34, new AssignmentExpression(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new ParameterReferenceNode(0).toExpression(), "$any$", new AstType[0]), FieldReference.class).toExpression(), AssignmentOperatorType.ANY, new Choice(new ParameterReferenceNode(1, "value"), new CastExpression(new BackReference("returnType").toType(), new ParameterReferenceNode(1, "value").toExpression())).toExpression())))).toBlockStatement());
        VariableDeclarationStatement tempVariable = new VariableDeclarationStatement(new AnyNode().toType(), "$any$", new AnyNode("value").toExpression());
        tempVariable.addModifier(Flags.Flag.FINAL);
        altSetAccessor.setBody(new BlockStatement(new NamedNode("tempVariable", tempVariable).toStatement(), new ExpressionStatement(new AssignmentExpression(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new ParameterReferenceNode(0).toExpression(), "$any$", new AstType[0]), FieldReference.class).toExpression(), AssignmentOperatorType.ANY, new SubtreeMatch(new DeclaredVariableBackReference("tempVariable")).toExpression())), new ReturnStatement(-34, new DeclaredVariableBackReference("tempVariable").toExpression())));
        SYNTHETIC_GET_ACCESSOR = getAccessor;
        SYNTHETIC_SET_ACCESSOR = setAccessor;
        SYNTHETIC_SET_ACCESSOR_ALT = altSetAccessor;
        MethodDeclaration staticGetAccessor = (MethodDeclaration)getAccessor.clone();
        MethodDeclaration staticSetAccessor = (MethodDeclaration)setAccessor.clone();
        MethodDeclaration altStaticSetAccessor = (MethodDeclaration)altSetAccessor.clone();
        staticGetAccessor.getParameters().clear();
        staticGetAccessor.setBody(new BlockStatement(new ReturnStatement(-34, new SubtreeMatch(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new TypedNode(TypeReferenceExpression.class).toExpression(), "$any$", new AstType[0]), FieldReference.class)).toExpression())));
        staticSetAccessor.getParameters().firstOrNullObject().remove();
        staticSetAccessor.setBody(new Choice(new BlockStatement(new ExpressionStatement(new AssignmentExpression(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new TypedNode(TypeReferenceExpression.class).toExpression(), "$any$", new AstType[0]), FieldReference.class).toExpression(), AssignmentOperatorType.ANY, new NamedNode("value", new SubtreeMatch(new ParameterReferenceNode(0))).toExpression())), new ReturnStatement(-34, new BackReference("value").toExpression())), new BlockStatement(new ReturnStatement(-34, new AssignmentExpression(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new TypedNode(TypeReferenceExpression.class).toExpression(), "$any$", new AstType[0]), FieldReference.class).toExpression(), AssignmentOperatorType.ANY, new NamedNode("value", new SubtreeMatch(new ParameterReferenceNode(0))).toExpression())))).toBlockStatement());
        altStaticSetAccessor.getParameters().firstOrNullObject().remove();
        altStaticSetAccessor.setBody(new BlockStatement(new NamedNode("tempVariable", tempVariable).toStatement(), new ExpressionStatement(new AssignmentExpression(new MemberReferenceTypeNode(new MemberReferenceExpression(-34, new TypedNode(TypeReferenceExpression.class).toExpression(), "$any$", new AstType[0]), FieldReference.class).toExpression(), AssignmentOperatorType.ANY, new SubtreeMatch(new DeclaredVariableBackReference("tempVariable")).toExpression())), new ReturnStatement(-34, new DeclaredVariableBackReference("tempVariable").toExpression())));
        SYNTHETIC_STATIC_GET_ACCESSOR = staticGetAccessor;
        SYNTHETIC_STATIC_SET_ACCESSOR = staticSetAccessor;
        SYNTHETIC_STATIC_SET_ACCESSOR_ALT = altStaticSetAccessor;
    }

    private class PhaseOneVisitor
    extends ContextTrackingVisitor<Void> {
        private PhaseOneVisitor() {
            super(EliminateSyntheticAccessorsTransform.this.context);
        }

        @Override
        protected Void visitTypeDeclarationOverride(TypeDeclaration node, Void p) {
            TypeDefinition type = node.getUserData(Keys.TYPE_DEFINITION);
            if (type != null && !EliminateSyntheticAccessorsTransform.this._visitedTypes.add(type.getInternalName())) {
                return null;
            }
            return (Void)super.visitTypeDeclarationOverride(node, p);
        }

        @Override
        protected Void visitMethodDeclarationOverride(MethodDeclaration node, Void p) {
            MethodDefinition method = node.getUserData(Keys.METHOD_DEFINITION);
            if (method != null && method.isSynthetic() && method.isStatic() && (this.tryMatchAccessor(node) || this.tryMatchCallWrapper(node))) {
                EliminateSyntheticAccessorsTransform.this._accessMethodDeclarations.put(EliminateSyntheticAccessorsTransform.makeMethodKey(method), node);
            }
            return (Void)super.visitMethodDeclarationOverride(node, p);
        }

        private boolean tryMatchAccessor(MethodDeclaration node) {
            return SYNTHETIC_GET_ACCESSOR.matches(node) || SYNTHETIC_SET_ACCESSOR.matches(node) || SYNTHETIC_SET_ACCESSOR_ALT.matches(node) || SYNTHETIC_STATIC_GET_ACCESSOR.matches(node) || SYNTHETIC_STATIC_SET_ACCESSOR.matches(node) || SYNTHETIC_STATIC_SET_ACCESSOR_ALT.matches(node);
        }

        private boolean tryMatchCallWrapper(MethodDeclaration node) {
            int j;
            MethodDefinition resolvedTarget;
            ReturnStatement r;
            ExpressionStatement e;
            AstNodeCollection<Statement> statements = node.getBody().getStatements();
            if (!statements.hasSingleElement()) {
                return false;
            }
            Statement s2 = statements.firstOrNullObject();
            InvocationExpression invocation = s2 instanceof ExpressionStatement ? ((e = (ExpressionStatement)s2).getExpression() instanceof InvocationExpression ? (InvocationExpression)e.getExpression() : null) : (s2 instanceof ReturnStatement ? ((r = (ReturnStatement)s2).getExpression() instanceof InvocationExpression ? (InvocationExpression)r.getExpression() : null) : null);
            if (invocation == null) {
                return false;
            }
            MethodReference targetMethod = (MethodReference)invocation.getUserData(Keys.MEMBER_REFERENCE);
            MethodDefinition methodDefinition = resolvedTarget = targetMethod != null ? targetMethod.resolve() : null;
            if (resolvedTarget == null) {
                return false;
            }
            int parametersStart = resolvedTarget.isStatic() ? 0 : 1;
            List<ParameterDeclaration> parameterList = CollectionUtilities.toList(node.getParameters());
            List<Expression> argumentList = CollectionUtilities.toList(invocation.getArguments());
            if (argumentList.size() != parameterList.size() - parametersStart) {
                return false;
            }
            if (!resolvedTarget.isStatic()) {
                if (!(invocation.getTarget() instanceof MemberReferenceExpression)) {
                    return false;
                }
                MemberReferenceExpression m4 = (MemberReferenceExpression)invocation.getTarget();
                Expression target = m4.getTarget();
                if (!target.matches(new IdentifierExpression(-34, parameterList.get(0).getName()))) {
                    return false;
                }
            }
            int i = parametersStart;
            for (j = 0; i < parameterList.size() && j < argumentList.size(); ++i, ++j) {
                Expression pattern = new Choice(new CastExpression(new AnyNode().toType(), new IdentifierExpression(-34, parameterList.get(i).getName())), new IdentifierExpression(-34, parameterList.get(i).getName())).toExpression();
                if (pattern.matches(argumentList.get(j))) continue;
                return false;
            }
            return i == j + parametersStart;
        }
    }

    private class ReplaceSuperReferencesVisitor
    extends ContextTrackingVisitor<Void> {
        private final IdentifierExpression _identifierPattern;

        private ReplaceSuperReferencesVisitor(String identifierName) {
            super(EliminateSyntheticAccessorsTransform.this.context);
            this._identifierPattern = new IdentifierExpression(-34, identifierName);
        }

        @Override
        public Void visitMemberReferenceExpression(MemberReferenceExpression node, Void data) {
            super.visitMemberReferenceExpression(node, data);
            if (this._identifierPattern.matches(node.getTarget())) {
                TypeDefinition currentType;
                MemberReference memberReference = node.getParent().getUserData(Keys.MEMBER_REFERENCE);
                if (memberReference == null) {
                    return null;
                }
                TypeReference declaringType = memberReference.getDeclaringType();
                if (MetadataResolver.areEquivalent(declaringType, currentType = this.context.getCurrentType())) {
                    return null;
                }
                ThisReferenceExpression s2 = new ThisReferenceExpression(node.getTarget().getOffset(), node.getTarget().getStartLocation());
                SimpleType type = new SimpleType(declaringType.getSimpleName());
                s2.putUserData(Keys.TYPE_REFERENCE, declaringType);
                type.putUserData(Keys.TYPE_REFERENCE, declaringType);
                s2.setTarget(new TypeReferenceExpression(node.getTarget().getOffset(), type));
                node.getTarget().replaceWith(s2);
            }
            return null;
        }
    }
}

