/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.ClassTreeNode;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;

public class ClassImplementationsTreeNode
extends ClassTreeNode {
    public ClassImplementationsTreeNode(Translator translator, ClassEntry entry) {
        super(translator, entry);
    }

    public static ClassImplementationsTreeNode findNode(ClassImplementationsTreeNode node, MethodEntry entry) {
        if (node.getClassEntry().equals((ClassEntry)entry.getParent())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassImplementationsTreeNode foundNode = ClassImplementationsTreeNode.findNode((ClassImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.translator.translate(this.getClassEntry()).toString();
    }

    public void load(JarIndex index) {
        ArrayList<ClassImplementationsTreeNode> nodes = Lists.newArrayList();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        Collection<ClassEntry> inheritors = inheritanceIndex.getChildren(this.getClassEntry());
        for (ClassEntry inheritor : inheritors) {
            nodes.add(new ClassImplementationsTreeNode(this.translator, inheritor));
        }
        nodes.forEach(this::add);
    }
}

