/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.ReferenceTargetType;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class EntryReference<E extends Entry<?>, C extends Entry<?>>
implements Translatable {
    private static final List<String> CONSTRUCTOR_NON_NAMES = Arrays.asList("this", "super", "static");
    public final E entry;
    public final C context;
    public final ReferenceTargetType targetType;
    private final boolean declaration;
    private final boolean sourceName;

    public static <E extends Entry<?>, C extends Entry<?>> EntryReference<E, C> declaration(E entry, String sourceName) {
        return new EntryReference<E, Object>(entry, sourceName, null, ReferenceTargetType.none(), true);
    }

    public EntryReference(E entry, String sourceName) {
        this(entry, sourceName, null);
    }

    public EntryReference(E entry, String sourceName, C context) {
        this(entry, sourceName, context, ReferenceTargetType.none());
    }

    public EntryReference(E entry, String sourceName, C context, ReferenceTargetType targetType) {
        this(entry, sourceName, context, targetType, false);
    }

    protected EntryReference(E entry, String sourceName, C context, ReferenceTargetType targetType, boolean declaration) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
        this.entry = entry;
        this.context = context;
        this.targetType = targetType;
        this.declaration = declaration;
        this.sourceName = sourceName != null && !sourceName.isEmpty() && (!(entry instanceof MethodEntry) || !((MethodEntry)entry).isConstructor() || !CONSTRUCTOR_NON_NAMES.contains(sourceName));
    }

    public EntryReference(E entry, C context, EntryReference<E, C> other) {
        this.entry = entry;
        this.context = context;
        this.sourceName = other.sourceName;
        this.targetType = other.targetType;
        this.declaration = other.declaration;
    }

    public ClassEntry getLocationClassEntry() {
        if (this.context != null) {
            return this.context.getContainingClass();
        }
        return this.entry.getContainingClass();
    }

    public boolean isNamed() {
        return this.sourceName;
    }

    public boolean isDeclaration() {
        return this.declaration;
    }

    public Entry<?> getNameableEntry() {
        MethodEntry method;
        E e = this.entry;
        if (e instanceof MethodEntry && (method = (MethodEntry)e).isConstructor()) {
            return this.entry.getContainingClass();
        }
        return this.entry;
    }

    public String getNameableName() {
        return this.getNameableEntry().getName();
    }

    public int hashCode() {
        if (this.context != null) {
            return Objects.hash(this.entry.hashCode(), this.context.hashCode());
        }
        return this.entry.hashCode() ^ Boolean.hashCode(this.declaration);
    }

    public boolean equals(Object other) {
        EntryReference reference;
        return other instanceof EntryReference && this.equals(reference = (EntryReference)other);
    }

    public boolean equals(EntryReference<?, ?> other) {
        return other != null && Objects.equals(this.entry, other.entry) && Objects.equals(this.context, other.context) && this.declaration == other.declaration;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.entry);
        if (this.declaration) {
            buf.append("'s declaration");
            return buf.toString();
        }
        if (this.context != null) {
            buf.append(" called from ");
            buf.append(this.context);
        }
        if (this.targetType != null && this.targetType.getKind() != ReferenceTargetType.Kind.NONE) {
            buf.append(" on target of type ");
            buf.append(this.targetType);
        }
        return buf.toString();
    }

    public TranslateResult<EntryReference<E, C>> extendedTranslate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        return translator.extendedTranslate(this.entry).map(e -> new EntryReference<Entry, Entry>((Entry)e, (Entry)translator.translate(this.context), this));
    }
}

