/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.MethodTreeNode;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;

public class MethodImplementationsTreeNode
extends MethodTreeNode {
    public MethodImplementationsTreeNode(Translator translator, MethodEntry entry) {
        super(translator, entry);
        if (entry == null) {
            throw new IllegalArgumentException("Entry cannot be null!");
        }
    }

    public static MethodImplementationsTreeNode findNode(MethodImplementationsTreeNode node, MethodEntry entry) {
        if (node.getMethodEntry().equals(entry)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            MethodImplementationsTreeNode foundNode = MethodImplementationsTreeNode.findNode((MethodImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    @Override
    public String toString() {
        MethodEntry translatedEntry = this.translator.translate(this.getMethodEntry());
        assert (translatedEntry != null);
        return translatedEntry.getFullName() + "()";
    }

    public void load(JarIndex index) {
        ArrayList<MethodImplementationsTreeNode> nodes = Lists.newArrayList();
        EntryIndex entryIndex = index.getEntryIndex();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        Collection<ClassEntry> descendants = inheritanceIndex.getDescendants((ClassEntry)this.getMethodEntry().getParent());
        for (ClassEntry inheritor : descendants) {
            MethodEntry methodEntry = this.getMethodEntry().withParent(inheritor);
            if (!entryIndex.hasMethod(methodEntry)) continue;
            nodes.add(new MethodImplementationsTreeNode(this.translator, methodEntry));
        }
        nodes.forEach(this::add);
    }
}

