/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.IndexSimpleVerifier;
import cuchaz.enigma.analysis.InterpreterPair;
import cuchaz.enigma.analysis.MethodNodeWithAction;
import cuchaz.enigma.analysis.ReferenceTargetType;
import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.Lambda;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class IndexReferenceVisitor
extends ClassVisitor {
    private final JarIndexer indexer;
    private final EntryIndex entryIndex;
    private final InheritanceIndex inheritanceIndex;
    private ClassEntry classEntry;
    private String className;

    public IndexReferenceVisitor(JarIndexer indexer, EntryIndex entryIndex, InheritanceIndex inheritanceIndex, int api) {
        super(api);
        this.indexer = indexer;
        this.entryIndex = entryIndex;
        this.inheritanceIndex = inheritanceIndex;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classEntry = new ClassEntry(name);
        this.className = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDefEntry entry = new MethodDefEntry(this.classEntry, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access));
        return new MethodNodeWithAction(this.api, access, name, desc, signature, exceptions, methodNode -> {
            try {
                new Analyzer<InterpreterPair.PairValue<BasicValue, SourceValue>>(new MethodInterpreter(entry, this.indexer, this.entryIndex, this.inheritanceIndex)).analyze(this.className, (MethodNode)methodNode);
            }
            catch (AnalyzerException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static class MethodInterpreter
    extends InterpreterPair<BasicValue, SourceValue> {
        private final MethodDefEntry callerEntry;
        private final JarIndexer indexer;

        MethodInterpreter(MethodDefEntry callerEntry, JarIndexer indexer, EntryIndex entryIndex, InheritanceIndex inheritanceIndex) {
            super(new IndexSimpleVerifier(entryIndex, inheritanceIndex), new SourceInterpreter());
            this.callerEntry = callerEntry;
            this.indexer = indexer;
        }

        @Override
        public InterpreterPair.PairValue<BasicValue, SourceValue> newOperation(AbstractInsnNode insn) throws AnalyzerException {
            Object object;
            LdcInsnNode ldc;
            if (insn.getOpcode() == 178) {
                FieldInsnNode field = (FieldInsnNode)insn;
                this.indexer.indexFieldReference(this.callerEntry, FieldEntry.parse(field.owner, field.name, field.desc), ReferenceTargetType.none());
            }
            if (insn.getOpcode() == 18 && (ldc = (LdcInsnNode)insn).getType() == 9 && (object = ldc.cst) instanceof Type) {
                Type type = (Type)object;
                String className = type.getClassName().replace(".", "/");
                this.indexer.indexClassReference(this.callerEntry, ClassEntry.parse(className), ReferenceTargetType.none());
            }
            return super.newOperation(insn);
        }

        @Override
        public InterpreterPair.PairValue<BasicValue, SourceValue> unaryOperation(AbstractInsnNode insn, InterpreterPair.PairValue<BasicValue, SourceValue> value) throws AnalyzerException {
            TypeInsnNode type;
            FieldInsnNode field;
            if (insn.getOpcode() == 179) {
                field = (FieldInsnNode)insn;
                this.indexer.indexFieldReference(this.callerEntry, FieldEntry.parse(field.owner, field.name, field.desc), ReferenceTargetType.none());
            }
            if (insn.getOpcode() == 180) {
                field = (FieldInsnNode)insn;
                this.indexer.indexFieldReference(this.callerEntry, FieldEntry.parse(field.owner, field.name, field.desc), this.getReferenceTargetType(value, insn));
            }
            if (insn.getOpcode() == 193) {
                type = (TypeInsnNode)insn;
                this.indexer.indexClassReference(this.callerEntry, ClassEntry.parse(type.desc), ReferenceTargetType.none());
            }
            if (insn.getOpcode() == 192) {
                type = (TypeInsnNode)insn;
                this.indexer.indexClassReference(this.callerEntry, ClassEntry.parse(type.desc), ReferenceTargetType.none());
            }
            return super.unaryOperation(insn, value);
        }

        @Override
        public InterpreterPair.PairValue<BasicValue, SourceValue> binaryOperation(AbstractInsnNode insn, InterpreterPair.PairValue<BasicValue, SourceValue> value1, InterpreterPair.PairValue<BasicValue, SourceValue> value2) throws AnalyzerException {
            if (insn.getOpcode() == 181) {
                FieldInsnNode field = (FieldInsnNode)insn;
                FieldEntry fieldEntry = FieldEntry.parse(field.owner, field.name, field.desc);
                this.indexer.indexFieldReference(this.callerEntry, fieldEntry, ReferenceTargetType.none());
            }
            return super.binaryOperation(insn, value1, value2);
        }

        @Override
        public InterpreterPair.PairValue<BasicValue, SourceValue> naryOperation(AbstractInsnNode insn, List<? extends InterpreterPair.PairValue<BasicValue, SourceValue>> values) throws AnalyzerException {
            MethodInsnNode methodInsn;
            if (insn.getOpcode() == 185 || insn.getOpcode() == 183 || insn.getOpcode() == 182) {
                methodInsn = (MethodInsnNode)insn;
                this.indexer.indexMethodReference(this.callerEntry, MethodEntry.parse(methodInsn.owner, methodInsn.name, methodInsn.desc), this.getReferenceTargetType(values.get(0), insn));
            }
            if (insn.getOpcode() == 184) {
                methodInsn = (MethodInsnNode)insn;
                this.indexer.indexMethodReference(this.callerEntry, MethodEntry.parse(methodInsn.owner, methodInsn.name, methodInsn.desc), ReferenceTargetType.none());
            }
            if (insn.getOpcode() == 186) {
                InvokeDynamicInsnNode invokeDynamicInsn = (InvokeDynamicInsnNode)insn;
                List<AbstractInsnNode> args = values.stream().map(v -> (AbstractInsnNode)((SourceValue)v.right).insns.stream().findFirst().orElseThrow(AssertionError::new)).toList();
                if ("java/lang/invoke/LambdaMetafactory".equals(invokeDynamicInsn.bsm.getOwner()) && "metafactory".equals(invokeDynamicInsn.bsm.getName())) {
                    Type samMethodType = (Type)invokeDynamicInsn.bsmArgs[0];
                    Handle implMethod = (Handle)invokeDynamicInsn.bsmArgs[1];
                    Type instantiatedMethodType = (Type)invokeDynamicInsn.bsmArgs[2];
                    ReferenceTargetType targetType = implMethod.getTag() != 2 && implMethod.getTag() != 3 && implMethod.getTag() != 6 ? (instantiatedMethodType.getArgumentTypes().length < Type.getArgumentTypes(implMethod.getDesc()).length ? this.getReferenceTargetType(values.get(0), insn) : ReferenceTargetType.none()) : ReferenceTargetType.none();
                    this.indexer.indexLambda(this.callerEntry, new Lambda(invokeDynamicInsn.name, new MethodDescriptor(invokeDynamicInsn.desc), new MethodDescriptor(samMethodType.getDescriptor()), MethodInterpreter.getHandleEntry(implMethod), new MethodDescriptor(instantiatedMethodType.getDescriptor())), targetType);
                }
            }
            return super.naryOperation(insn, values);
        }

        private ReferenceTargetType getReferenceTargetType(InterpreterPair.PairValue<BasicValue, SourceValue> target, AbstractInsnNode insn) throws AnalyzerException {
            if (target.left == BasicValue.UNINITIALIZED_VALUE) {
                return ReferenceTargetType.uninitialized();
            }
            if (((BasicValue)target.left).getType().getSort() == 10) {
                return ReferenceTargetType.classType(new ClassEntry(((BasicValue)target.left).getType().getInternalName()));
            }
            if (((BasicValue)target.left).getType().getSort() == 9) {
                return ReferenceTargetType.classType(new ClassEntry("java/lang/Object"));
            }
            throw new AnalyzerException(insn, "called method on or accessed field of non-object type");
        }

        private static ParentedEntry<?> getHandleEntry(Handle handle) {
            switch (handle.getTag()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return FieldEntry.parse(handle.getOwner(), handle.getName(), handle.getDesc());
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return MethodEntry.parse(handle.getOwner(), handle.getName(), handle.getDesc());
                }
            }
            throw new RuntimeException("Invalid handle tag " + handle.getTag());
        }
    }
}

