/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping;

import com.google.common.collect.Streams;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Set;

public interface EntryResolver {
    public <E extends Entry<?>> Collection<E> resolveEntry(E var1, ResolutionStrategy var2);

    default public <E extends Entry<?>> E resolveFirstEntry(E entry, ResolutionStrategy strategy) {
        return this.resolveEntry(entry, strategy).stream().findFirst().orElse(entry);
    }

    default public <E extends Entry<?>, C extends Entry<?>> Collection<EntryReference<E, C>> resolveReference(EntryReference<E, C> reference, ResolutionStrategy strategy) {
        Collection entry = this.resolveEntry(reference.entry, strategy);
        if (reference.context != null) {
            Collection context = this.resolveEntry((E)reference.context, strategy);
            return Streams.zip(entry.stream(), context.stream(), (e, c) -> new EntryReference<Entry, Entry>((Entry)e, (Entry)c, reference)).toList();
        }
        return entry.stream().map(e -> new EntryReference<Entry, Object>((Entry)e, null, reference)).toList();
    }

    default public <E extends Entry<?>, C extends Entry<?>> EntryReference<E, C> resolveFirstReference(EntryReference<E, C> reference, ResolutionStrategy strategy) {
        Object entry = this.resolveFirstEntry(reference.entry, strategy);
        Object context = this.resolveFirstEntry((E)reference.context, strategy);
        return new EntryReference(entry, context, reference);
    }

    public Set<Entry<?>> resolveEquivalentEntries(Entry<?> var1);

    public Set<MethodEntry> resolveEquivalentMethods(MethodEntry var1);
}

