/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde.enigma;

import com.google.common.base.Charsets;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.translation.mapping.AccessModifier;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingPair;
import cuchaz.enigma.translation.mapping.serde.MappingHelper;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.serde.MappingsReader;
import cuchaz.enigma.translation.mapping.serde.RawEntryMapping;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EnigmaMappingsReader implements MappingsReader
{
    FILE{

        @Override
        public EntryTree<EntryMapping> read(Path path, ProgressListener progress, MappingSaveParameters saveParameters) throws IOException, MappingParseException {
            progress.init(1, I18n.translate("progress.mappings.loading_file"));
            HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
            EnigmaMappingsReader.readFile(path, mappings);
            progress.step(1, I18n.translate("progress.done"));
            return mappings;
        }
    }
    ,
    DIRECTORY{

        @Override
        public EntryTree<EntryMapping> read(Path root, ProgressListener progress, MappingSaveParameters saveParameters) throws IOException, MappingParseException {
            if (!Files.isDirectory(root, new LinkOption[0])) {
                throw new NotDirectoryException(root.toString());
            }
            HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
            List<Path> files = Files.walk(root, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0])).filter(f -> f.toString().endsWith(".mapping")).toList();
            progress.init(files.size(), I18n.translate("progress.mappings.loading_directory"));
            int step = 0;
            for (Path file : files) {
                progress.step(step++, root.relativize(file).toString());
                if (Files.isHidden(file)) continue;
                EnigmaMappingsReader.readFile(file, mappings);
            }
            return mappings;
        }
    }
    ,
    ZIP{

        @Override
        public EntryTree<EntryMapping> read(Path zip, ProgressListener progress, MappingSaveParameters saveParameters) throws MappingParseException, IOException {
            try (FileSystem fs = FileSystems.newFileSystem(zip, (ClassLoader)null);){
                EntryTree<EntryMapping> entryTree = DIRECTORY.read(fs.getPath("/", new String[0]), progress, saveParameters);
                return entryTree;
            }
        }
    };


    public static EntryTree<EntryMapping> readFiles(ProgressListener progress, Path ... paths) throws MappingParseException, IOException {
        HashEntryTree<EntryMapping> mappings = new HashEntryTree<EntryMapping>();
        if (paths.length == 0) {
            throw new IllegalArgumentException("No paths to read mappings from");
        }
        progress.init(paths.length, I18n.translate("progress.mappings.loading_directory"));
        int step = 0;
        for (Path file : paths) {
            progress.step(step++, paths.toString());
            EnigmaMappingsReader.readFile(file, mappings);
        }
        return mappings;
    }

    private static void readFile(Path path, EntryTree<EntryMapping> mappings) throws IOException, MappingParseException {
        List<String> lines = Files.readAllLines(path, Charsets.UTF_8);
        ArrayDeque mappingStack = new ArrayDeque();
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber);
            int indentation = EnigmaMappingsReader.countIndentation(line, path, lineNumber);
            if ((line = EnigmaMappingsReader.formatLine(line)) == null) continue;
            EnigmaMappingsReader.cleanMappingStack(indentation, mappingStack, mappings);
            try {
                MappingPair<?, RawEntryMapping> pair = EnigmaMappingsReader.parseLine((MappingPair)mappingStack.peek(), line);
                if (pair == null) continue;
                mappingStack.push(pair);
                continue;
            }
            catch (Throwable t2) {
                throw new MappingParseException(path, lineNumber + 1, t2);
            }
        }
        EnigmaMappingsReader.cleanMappingStack(0, mappingStack, mappings);
    }

    private static void cleanMappingStack(int indentation, Deque<MappingPair<?, RawEntryMapping>> mappingStack, EntryTree<EntryMapping> mappings) {
        while (indentation < mappingStack.size()) {
            MappingPair<?, RawEntryMapping> pair = mappingStack.pop();
            if (pair.getMapping() == null) continue;
            mappings.insert((Entry<?>)pair.getEntry(), pair.getMapping().bake());
        }
    }

    @Nullable
    private static String formatLine(String line) {
        line = EnigmaMappingsReader.stripComment(line);
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        return line;
    }

    private static String stripComment(String line) {
        if (line.trim().startsWith("COMMENT")) {
            return line;
        }
        int commentPos = line.indexOf(35);
        if (commentPos >= 0) {
            return line.substring(0, commentPos);
        }
        return line;
    }

    private static int countIndentation(String line, Path path, int lineNumber) throws MappingParseException {
        int indent = 0;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') {
                throw new MappingParseException(path, lineNumber + 1, "Spaces must not be used to indent lines!");
            }
            if (line.charAt(i) != '\t') break;
            ++indent;
        }
        return indent;
    }

    private static MappingPair<?, RawEntryMapping> parseLine(@Nullable MappingPair<?, RawEntryMapping> parent, String line) {
        String[] tokens = line.trim().split("\\s");
        String keyToken = tokens[0].toUpperCase(Locale.ROOT);
        Entry<?> parentEntry = parent == null ? null : (Entry<?>)parent.getEntry();
        switch (keyToken) {
            case "CLASS": {
                return EnigmaMappingsReader.parseClass(parentEntry, tokens);
            }
            case "FIELD": {
                return EnigmaMappingsReader.parseField(parentEntry, tokens);
            }
            case "METHOD": {
                return EnigmaMappingsReader.parseMethod(parentEntry, tokens);
            }
            case "ARG": {
                return EnigmaMappingsReader.parseArgument(parentEntry, tokens);
            }
            case "COMMENT": {
                EnigmaMappingsReader.readJavadoc(parent, tokens);
                return null;
            }
        }
        throw new RuntimeException("Unknown token '" + keyToken + "'");
    }

    private static void readJavadoc(MappingPair<?, RawEntryMapping> parent, String[] tokens) {
        String jdLine;
        if (parent == null) {
            throw new IllegalStateException("Javadoc has no parent!");
        }
        String string = jdLine = tokens.length > 1 ? String.join((CharSequence)" ", Arrays.copyOfRange(tokens, 1, tokens.length)) : "";
        if (parent.getMapping() == null) {
            parent.setMapping(new RawEntryMapping(parent.getEntry().getName(), AccessModifier.UNCHANGED));
        }
        parent.getMapping().addJavadocLine(MappingHelper.unescape(jdLine));
    }

    private static MappingPair<ClassEntry, RawEntryMapping> parseClass(@Nullable Entry<?> parent, String[] tokens) {
        String obfuscatedName = ClassEntry.getInnerName(tokens[1]);
        ClassEntry obfuscatedEntry = parent instanceof ClassEntry ? new ClassEntry((ClassEntry)parent, obfuscatedName) : new ClassEntry(obfuscatedName);
        String mapping = null;
        AccessModifier modifier = AccessModifier.UNCHANGED;
        if (tokens.length == 3) {
            AccessModifier parsedModifier = EnigmaMappingsReader.parseModifier(tokens[2]);
            if (parsedModifier != null) {
                modifier = parsedModifier;
                mapping = obfuscatedName;
            } else {
                mapping = tokens[2];
            }
        } else if (tokens.length == 4) {
            mapping = tokens[2];
            modifier = EnigmaMappingsReader.parseModifier(tokens[3]);
        }
        return new MappingPair<ClassEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping, modifier));
    }

    private static MappingPair<FieldEntry, RawEntryMapping> parseField(@Nullable Entry<?> parent, String[] tokens) {
        TypeDescriptor descriptor;
        if (!(parent instanceof ClassEntry)) {
            throw new RuntimeException("Field must be a child of a class!");
        }
        ClassEntry ownerEntry = (ClassEntry)parent;
        String obfuscatedName = tokens[1];
        String mapping = null;
        AccessModifier modifier = AccessModifier.UNCHANGED;
        if (tokens.length == 3) {
            descriptor = new TypeDescriptor(tokens[2]);
        } else if (tokens.length == 4) {
            AccessModifier parsedModifier = EnigmaMappingsReader.parseModifier(tokens[3]);
            if (parsedModifier != null) {
                descriptor = new TypeDescriptor(tokens[2]);
                modifier = parsedModifier;
            } else {
                mapping = tokens[2];
                descriptor = new TypeDescriptor(tokens[3]);
            }
        } else if (tokens.length == 5) {
            mapping = tokens[2];
            modifier = EnigmaMappingsReader.parseModifier(tokens[3]);
            descriptor = new TypeDescriptor(tokens[4]);
        } else {
            throw new RuntimeException("Invalid field declaration");
        }
        FieldEntry obfuscatedEntry = new FieldEntry(ownerEntry, obfuscatedName, descriptor);
        return new MappingPair<FieldEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping, modifier));
    }

    private static MappingPair<MethodEntry, RawEntryMapping> parseMethod(@Nullable Entry<?> parent, String[] tokens) {
        MethodDescriptor descriptor;
        if (!(parent instanceof ClassEntry)) {
            throw new RuntimeException("Method must be a child of a class!");
        }
        ClassEntry ownerEntry = (ClassEntry)parent;
        String obfuscatedName = tokens[1];
        String mapping = null;
        AccessModifier modifier = AccessModifier.UNCHANGED;
        if (tokens.length == 3) {
            descriptor = new MethodDescriptor(tokens[2]);
        } else if (tokens.length == 4) {
            AccessModifier parsedModifier = EnigmaMappingsReader.parseModifier(tokens[3]);
            if (parsedModifier != null) {
                modifier = parsedModifier;
                mapping = obfuscatedName;
                descriptor = new MethodDescriptor(tokens[2]);
            } else {
                mapping = tokens[2];
                descriptor = new MethodDescriptor(tokens[3]);
            }
        } else if (tokens.length == 5) {
            mapping = tokens[2];
            modifier = EnigmaMappingsReader.parseModifier(tokens[4]);
            descriptor = new MethodDescriptor(tokens[3]);
        } else {
            throw new RuntimeException("Invalid method declaration");
        }
        MethodEntry obfuscatedEntry = new MethodEntry(ownerEntry, obfuscatedName, descriptor);
        return new MappingPair<MethodEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping, modifier));
    }

    private static MappingPair<LocalVariableEntry, RawEntryMapping> parseArgument(@Nullable Entry<?> parent, String[] tokens) {
        if (!(parent instanceof MethodEntry)) {
            throw new RuntimeException("Method arg must be a child of a method!");
        }
        MethodEntry ownerEntry = (MethodEntry)parent;
        LocalVariableEntry obfuscatedEntry = new LocalVariableEntry(ownerEntry, Integer.parseInt(tokens[1]), "", true, null);
        String mapping = tokens[2];
        return new MappingPair<LocalVariableEntry, RawEntryMapping>(obfuscatedEntry, new RawEntryMapping(mapping));
    }

    @Nullable
    private static AccessModifier parseModifier(String token) {
        if (token.startsWith("ACC:")) {
            return AccessModifier.valueOf(token.substring(4));
        }
        return null;
    }
}

