/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.IdentifierValidation;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import cuchaz.enigma.utils.validation.ValidationContext;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassEntry
extends ParentedEntry<ClassEntry>
implements Comparable<ClassEntry> {
    private final String fullName;

    public ClassEntry(String className) {
        this(ClassEntry.getOuterClass(className), ClassEntry.getInnerName(className), (String)null);
    }

    public ClassEntry(@Nullable ClassEntry parent, String className) {
        this(parent, className, (String)null);
    }

    public ClassEntry(@Nullable ClassEntry parent, String className, @Nullable String javadocs) {
        super(parent, className, javadocs);
        this.fullName = parent != null ? parent.getFullName() + "$" + this.name : this.name;
        if (parent == null && className.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Class name must be in JVM format. ie, path/to/package/class$inner : " + className);
        }
    }

    public static ClassEntry parse(String name) {
        return new ClassEntry(name);
    }

    @Override
    public Class<ClassEntry> getParentType() {
        return ClassEntry.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        int packagePos = this.name.lastIndexOf(47);
        if (packagePos > 0) {
            return this.name.substring(packagePos + 1);
        }
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getContextualName() {
        if (this.isInnerClass()) {
            return ((ClassEntry)this.parent).getSimpleName() + "$" + this.name;
        }
        return this.getSimpleName();
    }

    @Override
    public TranslateResult<? extends ClassEntry> extendedTranslate(Translator translator, @Nonnull EntryMapping mapping) {
        if (this.name.charAt(0) == '[') {
            TranslateResult<TypeDescriptor> translatedName = translator.extendedTranslate(new TypeDescriptor(this.name));
            return translatedName.map(desc -> new ClassEntry((ClassEntry)this.parent, desc.toString()));
        }
        String translatedName = mapping.targetName() != null ? mapping.targetName() : this.name;
        String docs = mapping.javadoc();
        return TranslateResult.of(mapping.targetName() == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new ClassEntry((ClassEntry)this.parent, translatedName, docs));
    }

    @Override
    public ClassEntry getContainingClass() {
        return this;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ClassEntry && this.equals((ClassEntry)other);
    }

    public boolean equals(ClassEntry other) {
        return other != null && Objects.equals(this.parent, other.parent) && this.name.equals(other.name);
    }

    @Override
    public boolean canConflictWith(Entry<?> entry) {
        return true;
    }

    @Override
    public boolean canShadow(Entry<?> entry) {
        return false;
    }

    @Override
    public void validateName(ValidationContext vc, String name) {
        IdentifierValidation.validateClassName(vc, name, this.isInnerClass());
    }

    @Override
    public ClassEntry withName(String name) {
        return new ClassEntry((ClassEntry)this.parent, name, this.javadocs);
    }

    public ClassEntry withParent(ClassEntry parent) {
        return new ClassEntry(parent, this.name, this.javadocs);
    }

    public String toString() {
        return this.getFullName();
    }

    public String getPackageName() {
        return ClassEntry.getParentPackage(this.fullName);
    }

    public boolean isInnerClass() {
        return this.parent != null;
    }

    @Nullable
    public ClassEntry getOuterClass() {
        return (ClassEntry)this.parent;
    }

    @Nonnull
    public ClassEntry getOutermostClass() {
        if (this.parent == null) {
            return this;
        }
        return ((ClassEntry)this.parent).getOutermostClass();
    }

    public ClassEntry buildClassEntry(List<ClassEntry> classChain) {
        assert (classChain.contains(this));
        StringBuilder buf = new StringBuilder();
        for (ClassEntry chainEntry : classChain) {
            if (buf.length() == 0) {
                buf.append(chainEntry.getFullName());
            } else {
                buf.append("$");
                buf.append(chainEntry.getSimpleName());
            }
            if (chainEntry != this) continue;
            break;
        }
        return new ClassEntry(buf.toString());
    }

    public boolean isJre() {
        String packageName = this.getPackageName();
        return packageName != null && (packageName.startsWith("java/") || packageName.startsWith("javax/"));
    }

    public static String getParentPackage(String name) {
        int pos = name.lastIndexOf(47);
        if (pos > 0) {
            return name.substring(0, pos);
        }
        return null;
    }

    public static String getNameInPackage(String name) {
        int pos = name.lastIndexOf(47);
        if (pos == name.length() - 1) {
            return "(empty)";
        }
        if (pos > 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    @Nullable
    public static ClassEntry getOuterClass(String name) {
        if (name.charAt(0) == '[') {
            return null;
        }
        int index = name.lastIndexOf(36);
        if (index >= 0) {
            return new ClassEntry(name.substring(0, index));
        }
        return null;
    }

    public static String getInnerName(String name) {
        if (name.charAt(0) == '[') {
            return name;
        }
        int innerClassPos = name.lastIndexOf(36);
        if (innerClassPos > 0) {
            return name.substring(innerClassPos + 1);
        }
        return name;
    }

    @Override
    public String getSourceRemapName() {
        ClassEntry outerClass = this.getOuterClass();
        if (outerClass != null) {
            return outerClass.getSourceRemapName() + "." + this.name;
        }
        return this.getSimpleName();
    }

    @Override
    public int compareTo(ClassEntry entry) {
        String fullName = this.getFullName();
        String otherFullName = entry.getFullName();
        if (fullName.length() != otherFullName.length()) {
            return fullName.length() - otherFullName.length();
        }
        return fullName.compareTo(otherFullName);
    }
}

