/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.tree;

import java.nio.CharBuffer;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;

class AlphanumericComparator
implements Comparator<CharSequence> {
    private final Collator collator;

    AlphanumericComparator() {
        this.collator = null;
    }

    AlphanumericComparator(Locale locale) {
        this(Collator.getInstance(Objects.requireNonNull(locale)));
    }

    AlphanumericComparator(Collator collator) {
        this.collator = Objects.requireNonNull(collator);
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        CharBuffer b1 = CharBuffer.wrap(s1);
        CharBuffer b2 = CharBuffer.wrap(s2);
        while (b1.hasRemaining() && b2.hasRemaining()) {
            this.moveWindow(b1);
            this.moveWindow(b2);
            int result = this.compare(b1, b2);
            if (result != 0) {
                return result;
            }
            this.prepareForNextIteration(b1);
            this.prepareForNextIteration(b2);
        }
        return s1.length() - s2.length();
    }

    private void moveWindow(CharBuffer buffer) {
        int start = buffer.position();
        int end = buffer.position();
        boolean isNumerical = this.isDigit(buffer.get(start));
        while (end < buffer.limit() && isNumerical == this.isDigit(buffer.get(end))) {
            if (!isNumerical || start + 1 >= buffer.limit() || !this.isZero(buffer.get(start)) || !this.isDigit(buffer.get(++end))) continue;
            ++start;
        }
        buffer.position(start).limit(end);
    }

    @Override
    private int compare(CharBuffer b1, CharBuffer b2) {
        if (this.isNumerical(b1) && this.isNumerical(b2)) {
            return this.compareNumerically(b1, b2);
        }
        return this.compareAsStrings(b1, b2);
    }

    private boolean isNumerical(CharBuffer buffer) {
        return this.isDigit(buffer.charAt(0));
    }

    private boolean isDigit(char c) {
        if (this.collator == null) {
            char intValue = c;
            return intValue >= '0' && intValue <= '9';
        }
        return Character.isDigit(c);
    }

    private int compareNumerically(CharBuffer b1, CharBuffer b2) {
        int diff = b1.length() - b2.length();
        if (diff != 0) {
            return diff;
        }
        for (int i = 0; i < b1.remaining() && i < b2.remaining(); ++i) {
            int result = Character.compare(b1.charAt(i), b2.charAt(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private void prepareForNextIteration(CharBuffer buffer) {
        buffer.position(buffer.limit()).limit(buffer.capacity());
    }

    private int compareAsStrings(CharBuffer b1, CharBuffer b2) {
        if (this.collator != null) {
            return this.collator.compare(b1.toString(), b2.toString());
        }
        return b1.toString().compareTo(b2.toString());
    }

    private boolean isZero(char c) {
        return c == '0';
    }
}

