/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.java.decompiler.api.plugin.LanguageSpec;
import org.jetbrains.java.decompiler.api.plugin.StatementWriter;
import org.jetbrains.java.decompiler.code.CodeConstants;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.ClassWriter;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.decompiler.CancelationManager;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.main.plugins.PluginContext;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.LambdaProcessor;
import org.jetbrains.java.decompiler.main.rels.NestedClassProcessor;
import org.jetbrains.java.decompiler.main.rels.NestedMemberAccess;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructEnclosingMethodAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructInnerClassesAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLineNumberTableAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ClassesProcessor
implements CodeConstants {
    public static final int AVERAGE_CLASS_SIZE = 16384;
    private final StructContext context;
    private final Map<String, ClassNode> mapRootClasses = new ConcurrentHashMap<String, ClassNode>();
    private final Set<String> whitelist = new HashSet<String>();

    public ClassesProcessor(StructContext context) {
        this.context = context;
    }

    public void addWhitelist(String prefix) {
        this.whitelist.add(prefix);
    }

    public boolean isWhitelisted(String cls) {
        if (this.whitelist.isEmpty()) {
            return true;
        }
        for (String prefix : this.whitelist) {
            if (!cls.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public void loadClasses(IIdentifierRenamer renamer) {
        HashMap<String, Inner> mapInnerClasses = new HashMap<String, Inner>();
        HashMap<String, Set> mapNestedClassReferences = new HashMap<String, Set>();
        HashMap<String, Set> mapEnclosingClassReferences = new HashMap<String, Set>();
        HashMap<String, String> mapNewSimpleNames = new HashMap<String, String>();
        boolean bDecompileInner = DecompilerContext.getOption("decompile-inner");
        boolean verifyAnonymousClasses = DecompilerContext.getOption("verify-anonymous-classes");
        for (StructClass structClass : this.context.getOwnClasses()) {
            StructInnerClassesAttribute inner;
            if (this.mapRootClasses.containsKey(structClass.qualifiedName)) continue;
            if (bDecompileInner && (inner = structClass.getAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES)) != null) {
                for (StructInnerClassesAttribute.Entry entry : inner.getEntries()) {
                    StructClass enclosingClass;
                    StructEnclosingMethodAttribute attr;
                    StructClass in;
                    String innerName = entry.innerName;
                    String simpleName = entry.simpleName;
                    String savedName = (String)mapNewSimpleNames.get(innerName);
                    if (savedName != null) {
                        simpleName = savedName;
                    } else if (simpleName != null && renamer != null && renamer.toBeRenamed(IIdentifierRenamer.Type.ELEMENT_CLASS, simpleName, null, null)) {
                        simpleName = renamer.getNextClassName(innerName, simpleName);
                        mapNewSimpleNames.put(innerName, simpleName);
                    }
                    Inner rec = new Inner();
                    rec.simpleName = simpleName;
                    rec.type = entry.simpleNameIdx == 0 ? ClassNode.Type.ANONYMOUS : (entry.outerNameIdx == 0 ? ClassNode.Type.LOCAL : ClassNode.Type.MEMBER);
                    rec.accessFlags = entry.accessFlags;
                    rec.source = structClass.qualifiedName;
                    if (entry.enclosingName != null) {
                        rec.enclosingName = entry.enclosingName;
                    } else {
                        in = this.context.getClass(entry.innerName);
                        if (in != null && (attr = in.getAttribute(StructGeneralAttribute.ATTRIBUTE_ENCLOSING_METHOD)) != null) {
                            rec.enclosingName = attr.getClassName();
                        }
                    }
                    rec.type = entry.innerName != null ? (entry.simpleName == null ? ClassNode.Type.ANONYMOUS : ((in = this.context.getClass(entry.innerName)) == null ? ClassNode.Type.MEMBER : ((attr = in.getAttribute(StructGeneralAttribute.ATTRIBUTE_ENCLOSING_METHOD)) != null && attr.getMethodName() != null ? ClassNode.Type.LOCAL : ClassNode.Type.MEMBER))) : ClassNode.Type.MEMBER;
                    String enclClassName = entry.outerNameIdx != 0 ? entry.enclosingName : structClass.qualifiedName;
                    if (enclClassName == null || innerName.equals(enclClassName) || rec.type == ClassNode.Type.MEMBER && !innerName.equals(enclClassName + "$" + entry.simpleName) || (enclosingClass = this.context.getClass(enclClassName)) == null || !enclosingClass.isOwn()) continue;
                    Inner existingRec = (Inner)mapInnerClasses.get(innerName);
                    if (existingRec == null) {
                        mapInnerClasses.put(innerName, rec);
                    } else if (!Inner.equal(existingRec, rec)) {
                        int newPriority;
                        int oldPriority;
                        int n = existingRec.source.equals(innerName) ? 1 : (oldPriority = existingRec.source.equals(enclClassName) ? 2 : 3);
                        int n2 = rec.source.equals(innerName) ? 1 : (newPriority = rec.source.equals(enclClassName) ? 2 : 3);
                        if (DecompilerContext.getOption("warn-inconsistent-inner-attributes")) {
                            String message = "Inconsistent inner class entries for " + innerName + "!";
                            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                            DecompilerContext.getLogger().writeMessage("  " + existingRec.source + ": " + existingRec, IFernflowerLogger.Severity.WARN);
                            DecompilerContext.getLogger().writeMessage("  " + rec.source + ": " + rec, IFernflowerLogger.Severity.WARN);
                            if (newPriority < oldPriority) {
                                DecompilerContext.getLogger().writeMessage("Changing mapping to " + innerName + " -> " + rec, IFernflowerLogger.Severity.WARN);
                            }
                        }
                        if (newPriority < oldPriority) {
                            mapInnerClasses.put(innerName, rec);
                        }
                    }
                    mapNestedClassReferences.computeIfAbsent(enclClassName, k -> new HashSet()).add(innerName);
                    mapEnclosingClassReferences.computeIfAbsent(innerName, k -> new HashSet()).add(enclClassName);
                }
            }
            if (!this.isWhitelisted(structClass.qualifiedName)) continue;
            ClassNode node = new ClassNode(ClassNode.Type.ROOT, structClass);
            node.access = structClass.getAccessFlags();
            this.mapRootClasses.put(structClass.qualifiedName, node);
        }
        if (bDecompileInner) {
            for (Map.Entry entry : this.mapRootClasses.entrySet()) {
                if (mapInnerClasses.containsKey(entry.getKey())) continue;
                HashSet<String> setVisited = new HashSet<String>();
                LinkedList<String> stack = new LinkedList<String>();
                stack.add((String)entry.getKey());
                setVisited.add((String)entry.getKey());
                while (!stack.isEmpty()) {
                    String superClass = (String)stack.removeFirst();
                    ClassNode superNode = this.mapRootClasses.get(superClass);
                    Set setNestedClasses = (Set)mapNestedClassReferences.get(superClass);
                    if (setNestedClasses != null) {
                        StructClass scl = superNode.classStruct;
                        StructInnerClassesAttribute inner = scl.getAttribute(StructGeneralAttribute.ATTRIBUTE_INNER_CLASSES);
                        if (inner == null || inner.getEntries().isEmpty()) {
                            DecompilerContext.getLogger().writeMessage(superClass + " does not contain inner classes!", IFernflowerLogger.Severity.WARN);
                            continue;
                        }
                        for (StructInnerClassesAttribute.Entry entry2 : inner.getEntries()) {
                            String nestedClass = entry2.innerName;
                            if (!setNestedClasses.contains(nestedClass)) continue;
                            Inner rec = (Inner)mapInnerClasses.get(nestedClass);
                            if (!scl.qualifiedName.equals(rec.enclosingName) || !setVisited.add(nestedClass)) continue;
                            ClassNode nestedNode = this.mapRootClasses.get(nestedClass);
                            if (nestedNode == null) {
                                DecompilerContext.getLogger().writeMessage("Nested class " + nestedClass + " missing!", IFernflowerLogger.Severity.WARN);
                                continue;
                            }
                            nestedNode.simpleName = rec.simpleName;
                            nestedNode.type = rec.type;
                            if (nestedNode.type == ClassNode.Type.ANONYMOUS) {
                                nestedNode.enclosingMethod = null;
                            }
                            nestedNode.access = rec.accessFlags;
                            if (verifyAnonymousClasses && nestedNode.type == ClassNode.Type.ANONYMOUS && !ClassesProcessor.isAnonymous(nestedNode.classStruct, scl)) {
                                nestedNode.type = ClassNode.Type.LOCAL;
                            }
                            if (nestedNode.type == ClassNode.Type.ANONYMOUS) {
                                StructClass cl = nestedNode.classStruct;
                                nestedNode.access &= 0xFFFFFFF7;
                                int[] interfaces = cl.getInterfaces();
                                nestedNode.anonymousClassType = interfaces.length > 0 ? new VarType(cl.getInterface(0), true) : new VarType(cl.superClass.getString(), true);
                            } else if (nestedNode.type == ClassNode.Type.LOCAL) {
                                int allowedFlags = 1040;
                                if (scl.getVersion().hasLocalEnumsAndInterfaces()) {
                                    allowedFlags |= 0x4200;
                                    if ((nestedNode.access & 0x4000) != 0) {
                                        allowedFlags |= 8;
                                    }
                                }
                                nestedNode.access &= allowedFlags;
                            }
                            superNode.nested.add(nestedNode);
                            nestedNode.parent = superNode;
                            nestedNode.enclosingClasses.addAll((Collection)mapEnclosingClassReferences.get(nestedClass));
                            stack.add(nestedClass);
                        }
                    }
                    Collections.sort(superNode.nested);
                }
            }
        }
    }

    private static boolean isAnonymous(StructClass cl, StructClass enclosingCl) {
        int[] interfaces = cl.getInterfaces();
        if (interfaces.length > 0) {
            boolean hasNonTrivialSuperClass;
            boolean bl = hasNonTrivialSuperClass = cl.superClass != null && !VarType.VARTYPE_OBJECT.equals(new VarType(cl.superClass.getString(), true));
            if (hasNonTrivialSuperClass || interfaces.length > 1) {
                String message = "Inconsistent anonymous class definition: '" + cl.qualifiedName + "'. Multiple interfaces and/or super class defined.";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                return false;
            }
        } else if (cl.superClass == null) {
            String message = "Inconsistent anonymous class definition: '" + cl.qualifiedName + "'. Neither interface nor super class defined.";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
            return false;
        }
        ConstantPool pool = enclosingCl.getPool();
        int refCounter = 0;
        boolean refNotNew = false;
        StructEnclosingMethodAttribute attribute = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_ENCLOSING_METHOD);
        String enclosingMethod = attribute != null ? attribute.getMethodName() : null;
        for (StructMethod mt : enclosingCl.getMethods()) {
            if (enclosingMethod != null && !enclosingMethod.equals(mt.getName())) continue;
            try {
                mt.expandData(enclosingCl);
                InstructionSequence seq = mt.getInstructionSequence();
                if (seq != null) {
                    int len = seq.length();
                    block8: for (int i = 0; i < len; ++i) {
                        Instruction instr = seq.getInstr(i);
                        switch (instr.opcode) {
                            case 192: 
                            case 193: {
                                if (!cl.qualifiedName.equals(pool.getPrimitiveConstant(instr.operand(0)).getString())) continue block8;
                                ++refCounter;
                                refNotNew = true;
                                continue block8;
                            }
                            case 187: 
                            case 189: 
                            case 197: {
                                if (!cl.qualifiedName.equals(pool.getPrimitiveConstant(instr.operand(0)).getString())) continue block8;
                                ++refCounter;
                                continue block8;
                            }
                            case 178: 
                            case 179: {
                                if (!cl.qualifiedName.equals(pool.getLinkConstant((int)instr.operand((int)0)).classname)) continue block8;
                                ++refCounter;
                                refNotNew = true;
                            }
                        }
                    }
                }
                mt.releaseResources();
            }
            catch (IOException ex) {
                String message = "Could not read method while checking anonymous class definition: '" + enclosingCl.qualifiedName + "', '" + InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()) + "'";
                DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                return false;
            }
            if (refCounter <= 1 && !refNotNew) continue;
            String message = "Inconsistent references to the class '" + cl.qualifiedName + "' which is supposed to be anonymous";
            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
            return false;
        }
        return true;
    }

    public void processClass(StructClass cl) throws IOException {
        ClassNode root = this.mapRootClasses.get(cl.qualifiedName);
        if (root.type != ClassNode.Type.ROOT) {
            return;
        }
        boolean packageInfo = cl.isSynthetic() && "package-info".equals(root.simpleName);
        boolean moduleInfo = cl.hasModifier(32768) && cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
        DecompilerContext.getLogger().startProcessingClass(cl.qualifiedName);
        ImportCollector importCollector = new ImportCollector(root);
        DecompilerContext.startClass(importCollector);
        try {
            if (!packageInfo && !moduleInfo) {
                new LambdaProcessor().processClass(root);
                ClassesProcessor.addClassNameToImport(root, importCollector);
                LanguageSpec spec = PluginContext.getCurrentContext().getLanguageSpec(cl);
                ClassesProcessor.initWrappers(root, spec);
                if (spec == null) {
                    new NestedClassProcessor().processClass(root, root);
                    new NestedMemberAccess().propagateMemberAccess(root);
                }
            }
        }
        catch (CancelationManager.CanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DecompilerContext.getLogger().endProcessingClass();
        }
    }

    public void writeClass(StructClass cl, TextBuffer buffer) throws IOException {
        ClassNode root = this.mapRootClasses.get(cl.qualifiedName);
        if (root.type != ClassNode.Type.ROOT) {
            return;
        }
        boolean packageInfo = cl.isSynthetic() && "package-info".equals(root.simpleName);
        boolean moduleInfo = cl.hasModifier(32768) && cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
        DecompilerContext.getLogger().startReadingClass(cl.qualifiedName);
        try {
            if (packageInfo) {
                ClassWriter.packageInfoToJava(cl, buffer);
                DecompilerContext.getImportCollector().writeImports(buffer, false);
            } else if (moduleInfo) {
                TextBuffer moduleBuffer = new TextBuffer(16384);
                ClassWriter.moduleInfoToJava(cl, moduleBuffer);
                DecompilerContext.getImportCollector().writeImports(buffer, true);
                buffer.append(moduleBuffer);
            } else {
                LanguageSpec spec = PluginContext.getCurrentContext().getLanguageSpec(cl);
                TextBuffer classBuffer = new TextBuffer(16384);
                StatementWriter writer = spec != null ? spec.writer : new ClassWriter();
                writer.writeClass(root, classBuffer, 0);
                classBuffer.reformat();
                classBuffer.getTracers().forEach((classAndMethod, tracer) -> {
                    StructMethod method;
                    StructClass clazz = DecompilerContext.getStructContext().getClass((String)classAndMethod.a);
                    if (clazz != null && (method = clazz.getMethod((String)classAndMethod.b)) != null) {
                        StructLineNumberTableAttribute lineNumberTable = method.getAttribute(StructGeneralAttribute.ATTRIBUTE_LINE_NUMBER_TABLE);
                        tracer.setLineNumberTable(lineNumberTable);
                        DecompilerContext.getBytecodeSourceMapper().addTracer((String)classAndMethod.a, (String)classAndMethod.b, (BytecodeMappingTracer)tracer);
                    }
                });
                writer.writeClassHeader(cl, buffer, DecompilerContext.getImportCollector());
                int offsetLines = buffer.countLines();
                buffer.append(classBuffer);
                if (DecompilerContext.getOption("bytecode-source-mapping")) {
                    BytecodeSourceMapper mapper = DecompilerContext.getBytecodeSourceMapper();
                    mapper.addTotalOffset(offsetLines);
                    if (DecompilerContext.getOption("__dump_original_lines__")) {
                        buffer.dumpOriginalLineNumbers(mapper.getOriginalLinesMapping());
                    }
                    if (DecompilerContext.getOption("__unit_test_mode__")) {
                        buffer.appendLineSeparator();
                        mapper.dumpMapping(buffer, true);
                    }
                }
            }
        }
        catch (CancelationManager.CanceledException e) {
            throw e;
        }
        finally {
            ClassesProcessor.destroyWrappers(root);
            DecompilerContext.getLogger().endReadingClass();
        }
    }

    private static void initWrappers(ClassNode node, LanguageSpec spec) {
        if (node.type == ClassNode.Type.LAMBDA) {
            return;
        }
        ArrayList<ClassNode> nestedCopy = new ArrayList<ClassNode>(node.nested);
        for (ClassNode nd : node.nested) {
            if (!ClassesProcessor.shouldInitEarly(nd)) continue;
            ClassesProcessor.initWrappers(nd, spec);
            nestedCopy.remove(nd);
        }
        ClassWrapper wrapper = new ClassWrapper(node.classStruct);
        wrapper.init(spec);
        node.wrapper = wrapper;
        for (ClassNode nd : nestedCopy) {
            ClassesProcessor.initWrappers(nd, spec);
        }
    }

    private static boolean shouldInitEarly(ClassNode node) {
        if (node.classStruct.hasModifier(4096) && node.classStruct.getMethods().size() == 1 && ((StructMethod)node.classStruct.getMethods().get(0)).getName().equals("<clinit>")) {
            return node.classStruct.getFields().stream().allMatch(stField -> stField.getDescriptor().equals("[I") && stField.hasModifier(4120));
        }
        return false;
    }

    private static void addClassNameToImport(ClassNode node, ImportCollector imp) {
        if (node.simpleName != null && node.simpleName.length() > 0) {
            imp.getShortName(node.type == ClassNode.Type.ROOT ? node.classStruct.qualifiedName : node.simpleName, false);
        }
        for (ClassNode nd : node.nested) {
            ClassesProcessor.addClassNameToImport(nd, imp);
        }
    }

    private static void destroyWrappers(ClassNode node) {
        node.wrapper = null;
        node.classStruct.releaseResources();
        node.classStruct.getMethods().forEach(m4 -> m4.clearVariableNamer());
    }

    public Map<String, ClassNode> getMapRootClasses() {
        return this.mapRootClasses;
    }

    public static class ClassNode
    implements Comparable<ClassNode> {
        public Type type;
        public int access;
        public String simpleName;
        public final StructClass classStruct;
        private ClassWrapper wrapper;
        public String enclosingMethod;
        public InvocationExprent superInvocation;
        public final Map<String, VarVersionPair> mapFieldsToVars = new HashMap<String, VarVersionPair>();
        public VarType anonymousClassType;
        public final List<ClassNode> nested = new ArrayList<ClassNode>();
        public final Set<String> enclosingClasses = new HashSet<String>();
        public ClassNode parent;
        public LambdaInformation lambdaInformation;

        public ClassNode(String content_class_name, String content_method_name, String content_method_descriptor, int content_method_invocation_type, String lambda_class_name, String lambda_method_name, String lambda_method_descriptor, StructClass classStruct) {
            boolean is_method_reference;
            this.type = Type.LAMBDA;
            this.classStruct = classStruct;
            this.lambdaInformation = new LambdaInformation();
            this.lambdaInformation.method_name = lambda_method_name;
            this.lambdaInformation.method_descriptor = lambda_method_descriptor;
            this.lambdaInformation.content_class_name = content_class_name;
            this.lambdaInformation.content_method_name = content_method_name;
            this.lambdaInformation.content_method_descriptor = content_method_descriptor;
            this.lambdaInformation.content_method_invocation_type = content_method_invocation_type;
            this.lambdaInformation.content_method_key = InterpreterUtil.makeUniqueKey(this.lambdaInformation.content_method_name, this.lambdaInformation.content_method_descriptor);
            this.anonymousClassType = new VarType(lambda_class_name, true);
            boolean bl = is_method_reference = !classStruct.qualifiedName.equals(content_class_name);
            if (!is_method_reference) {
                StructMethod mt = classStruct.getMethod(content_method_name, content_method_descriptor);
                is_method_reference = !mt.isSynthetic();
            }
            this.lambdaInformation.is_method_reference = is_method_reference;
            this.lambdaInformation.is_content_method_static = this.lambdaInformation.content_method_invocation_type == 6;
        }

        public ClassNode(Type type, StructClass classStruct) {
            this.type = type;
            this.classStruct = classStruct;
            this.simpleName = classStruct.qualifiedName.substring(classStruct.qualifiedName.lastIndexOf(47) + 1);
            StructEnclosingMethodAttribute enclosingMethodAttr = classStruct.getAttribute(StructGeneralAttribute.ATTRIBUTE_ENCLOSING_METHOD);
            if (enclosingMethodAttr != null) {
                String name = enclosingMethodAttr.getMethodName();
                String desc = enclosingMethodAttr.getMethodDescriptor();
                if (name != null && desc != null) {
                    this.enclosingMethod = InterpreterUtil.makeUniqueKey(name, desc);
                }
            }
        }

        public ClassNode getClassNode(String qualifiedName) {
            for (ClassNode node : this.nested) {
                if (!qualifiedName.equals(node.classStruct.qualifiedName)) continue;
                return node;
            }
            return null;
        }

        public ClassWrapper getWrapper() {
            ClassNode node = this;
            while (node.type == Type.LAMBDA) {
                node = node.parent;
            }
            return node.wrapper;
        }

        public Set<ClassNode> getAllNested() {
            LinkedHashSet<ClassNode> nested = new LinkedHashSet<ClassNode>(this.nested);
            for (ClassNode child : this.nested) {
                nested.addAll(child.getAllNested());
            }
            return nested;
        }

        @Override
        public int compareTo(ClassNode o) {
            return this.classStruct.qualifiedName.compareTo(o.classStruct.qualifiedName);
        }

        public String toString() {
            return this.type + " class " + this.classStruct.qualifiedName;
        }

        public static class LambdaInformation {
            public String method_name;
            public String method_descriptor;
            public String content_class_name;
            public String content_method_name;
            public String content_method_descriptor;
            public int content_method_invocation_type;
            public String content_method_key;
            public boolean is_method_reference;
            public boolean is_content_method_static;
        }

        public static enum Type {
            ROOT,
            MEMBER,
            ANONYMOUS,
            LOCAL,
            LAMBDA;

        }
    }

    private static class Inner {
        private String simpleName;
        private ClassNode.Type type;
        private int accessFlags;
        private String source;
        private String enclosingName;

        private Inner() {
        }

        private static boolean equal(Inner o1, Inner o2) {
            return o1.type == o2.type && o1.accessFlags == o2.accessFlags && InterpreterUtil.equalObjects(o1.simpleName, o2.simpleName) && InterpreterUtil.equalObjects(o1.enclosingName, o2.enclosingName);
        }

        public String toString() {
            return this.simpleName + " " + ClassWriter.getModifiers(this.accessFlags) + " " + this.getType() + " of " + this.enclosingName;
        }

        private String getType() {
            return String.valueOf((Object)this.type);
        }
    }
}

