/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.decompiler;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.util.TextUtil;

public class PrintStreamLogger
extends IFernflowerLogger {
    private final PrintStream stream;
    private final ThreadLocal<AtomicInteger> indent;

    public PrintStreamLogger(PrintStream printStream) {
        this.stream = printStream;
        this.indent = ThreadLocal.withInitial(() -> new AtomicInteger(0));
    }

    @Override
    public void writeMessage(String message, IFernflowerLogger.Severity severity) {
        if (this.accepts(severity)) {
            this.stream.println(severity.prefix + TextUtil.getIndentString(this.indent.get().get()) + message);
        }
    }

    @Override
    public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t2) {
        if (this.accepts(severity)) {
            this.writeMessage(message, severity);
            t2.printStackTrace(this.stream);
        }
    }

    @Override
    public void startProcessingClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Preprocessing class " + className, IFernflowerLogger.Severity.INFO);
            this.indent.get().incrementAndGet();
        }
    }

    @Override
    public void endProcessingClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... done", IFernflowerLogger.Severity.INFO);
        }
    }

    @Override
    public void startReadingClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Decompiling class " + className, IFernflowerLogger.Severity.INFO);
            this.indent.get().incrementAndGet();
        }
    }

    @Override
    public void endReadingClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... done", IFernflowerLogger.Severity.INFO);
        }
    }

    @Override
    public void startClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Processing class " + className, IFernflowerLogger.Severity.TRACE);
            this.indent.get().incrementAndGet();
        }
    }

    @Override
    public void endClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
        }
    }

    @Override
    public void startMethod(String methodName) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Processing method " + methodName, IFernflowerLogger.Severity.TRACE);
            this.indent.get().incrementAndGet();
        }
    }

    @Override
    public void endMethod() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... proceeded", IFernflowerLogger.Severity.TRACE);
        }
    }

    @Override
    public void startWriteClass(String className) {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.writeMessage("Writing class " + className, IFernflowerLogger.Severity.TRACE);
            this.indent.get().incrementAndGet();
        }
    }

    @Override
    public void endWriteClass() {
        if (this.accepts(IFernflowerLogger.Severity.INFO)) {
            this.indent.get().decrementAndGet();
            this.writeMessage("... written", IFernflowerLogger.Severity.TRACE);
        }
    }
}

