/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.java.decompiler.util.collections.PackedMap;

public class FastSparseSetFactory<E> {
    private final PackedMap<E> colValuesInternal = new PackedMap();
    private int lastBlock;
    private int lastMask;

    public FastSparseSetFactory(Collection<? extends E> set) {
        int block = -1;
        int mask = -1;
        int index = 0;
        for (E element : set) {
            block = index >> 5;
            mask = (index & 0x1F) == 0 ? 1 : (mask <<= 1);
            this.colValuesInternal.putWithKey(mask, block, element);
            ++index;
        }
        this.lastBlock = block;
        this.lastMask = mask;
    }

    private long addElement(E element) {
        if (this.lastMask < 0) {
            this.lastMask = 1;
            ++this.lastBlock;
        } else {
            this.lastMask <<= 1;
        }
        return this.colValuesInternal.putWithKey(this.lastMask, this.lastBlock, element);
    }

    public FastSparseSet<E> createEmptySet() {
        return new FastSparseSet(this);
    }

    private int getLastBlock() {
        return this.lastBlock;
    }

    private PackedMap<E> getInternalValuesCollection() {
        return this.colValuesInternal;
    }

    public static final class FastSparseSetIterator<E>
    implements Iterator<E> {
        private final PackedMap<E> colValuesInternal;
        private final int[] data;
        private final int[] next;
        private final int size;
        private int pointer = -1;
        private int next_pointer = -1;

        private FastSparseSetIterator(FastSparseSet<E> set) {
            this.colValuesInternal = set.getFactory().getInternalValuesCollection();
            this.data = set.getData();
            this.next = set.getNext();
            this.size = this.colValuesInternal.size();
        }

        private int getNextIndex(int index) {
            int bindex = ++index >>> 5;
            int dindex = index & 0x1F;
            while (bindex < this.data.length) {
                int block = this.data[bindex];
                if (block != 0) {
                    block >>>= dindex;
                    while (dindex < 32) {
                        if ((block & 1) != 0) {
                            return (bindex << 5) + dindex;
                        }
                        block >>>= 1;
                        ++dindex;
                    }
                }
                dindex = 0;
                bindex = this.next == null ? 0 : this.next[bindex];
                if (bindex != 0) continue;
                break;
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            this.next_pointer = this.getNextIndex(this.pointer);
            return this.next_pointer >= 0;
        }

        @Override
        public E next() {
            if (this.next_pointer >= 0) {
                this.pointer = this.next_pointer;
            } else {
                this.pointer = this.getNextIndex(this.pointer);
                if (this.pointer == -1) {
                    this.pointer = this.size;
                }
            }
            this.next_pointer = -1;
            return this.pointer < this.size ? (E)this.colValuesInternal.getKey(this.pointer) : null;
        }

        @Override
        public void remove() {
            long index = this.colValuesInternal.get(this.pointer);
            int n = PackedMap.unpackLow(index);
            this.data[n] = this.data[n] & ~PackedMap.unpackHigh(index);
        }
    }

    public static final class FastSparseSet<E>
    implements Iterable<E> {
        public static final FastSparseSet[] EMPTY_ARRAY = new FastSparseSet[0];
        private final FastSparseSetFactory<E> factory;
        private final PackedMap<E> colValuesInternal;
        private int[] data;
        private int[] next;

        private FastSparseSet(FastSparseSetFactory<E> factory) {
            this.factory = factory;
            this.colValuesInternal = factory.getInternalValuesCollection();
            int length = Math.max(factory.getLastBlock(), 1);
            this.data = new int[length];
            this.next = null;
        }

        private FastSparseSet(FastSparseSetFactory<E> factory, int[] data, int[] next) {
            this.factory = factory;
            this.colValuesInternal = factory.getInternalValuesCollection();
            this.data = data;
            this.next = next;
        }

        public FastSparseSet<E> getCopy() {
            int[] newData = (int[])this.data.clone();
            int[] newNext = this.next == null ? null : (int[])this.next.clone();
            return new FastSparseSet<E>(this.factory, newData, newNext);
        }

        private int[] ensureCapacity(int index) {
            int newlength = this.data.length;
            if (newlength == 0) {
                newlength = 1;
            }
            while (newlength <= index) {
                newlength *= 2;
            }
            this.data = Arrays.copyOf(this.data, newlength);
            if (this.next != null) {
                this.next = Arrays.copyOf(this.next, newlength);
            }
            return this.data;
        }

        public void add(E element) {
            long index = !this.colValuesInternal.containsKey(element) ? this.factory.addElement(element) : this.colValuesInternal.getWithKey(element);
            int block = PackedMap.unpackLow(index);
            if (block >= this.data.length) {
                this.ensureCapacity(block);
            }
            int n = block;
            this.data[n] = this.data[n] | PackedMap.unpackHigh(index);
            this.changeNext(block, this.getNextIdx(block), block);
        }

        private int getNextIdx(int block) {
            return this.next == null ? 0 : this.next[block];
        }

        private int[] allocNext() {
            if (this.next == null) {
                this.next = new int[this.data.length];
            }
            return this.next;
        }

        public void remove(E element) {
            long index = !this.colValuesInternal.containsKey(element) ? this.factory.addElement(element) : this.colValuesInternal.getWithKey(element);
            int block = PackedMap.unpackLow(index);
            if (block < this.data.length) {
                int n = block;
                this.data[n] = this.data[n] & ~PackedMap.unpackHigh(index);
                if (this.data[block] == 0) {
                    this.changeNext(block, block, this.getNextIdx(block));
                }
            }
        }

        public boolean contains(E element) {
            long index = !this.colValuesInternal.containsKey(element) ? this.factory.addElement(element) : this.colValuesInternal.getWithKey(element);
            int block = PackedMap.unpackLow(index);
            return block < this.data.length && (this.data[block] & PackedMap.unpackHigh(index)) != 0;
        }

        private void setNext() {
            int link = 0;
            for (int i = this.data.length - 1; i >= 0; --i) {
                if (link != 0 && this.next == null) {
                    this.allocNext();
                    this.next[i] = link;
                }
                if (this.data[i] == 0) continue;
                link = i;
            }
        }

        private void changeNext(int key, int oldnext, int newnext) {
            for (int i = key - 1; i >= 0 && this.getNextIdx(i) == oldnext; --i) {
                this.allocNext();
                this.next[i] = newnext;
            }
        }

        public void union(FastSparseSet<E> set) {
            int[] extdata = set.getData();
            int[] intdata = this.data;
            int intlength = intdata.length;
            int pointer = 0;
            do {
                if (pointer >= intlength) {
                    intdata = this.ensureCapacity(extdata.length - 1);
                }
                boolean nextrec = intdata[pointer] == 0;
                int n = pointer;
                intdata[n] = intdata[n] | extdata[pointer];
                if (!nextrec) continue;
                this.changeNext(pointer, this.getNextIdx(pointer), pointer);
            } while ((pointer = set.getNextIdx(pointer)) != 0);
        }

        public void intersection(FastSparseSet<E> set) {
            int i;
            int[] extdata = set.getData();
            int[] intdata = this.data;
            int minlength = Math.min(extdata.length, intdata.length);
            for (i = minlength - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] & extdata[i];
            }
            for (i = intdata.length - 1; i >= minlength; --i) {
                intdata[i] = 0;
            }
            this.setNext();
        }

        public void complement(FastSparseSet<E> set) {
            int[] extdata = set.getData();
            int[] intdata = this.data;
            int extlength = extdata.length;
            int pointer = 0;
            while (pointer < extlength) {
                int n = pointer;
                intdata[n] = intdata[n] & ~extdata[pointer];
                if (intdata[pointer] == 0) {
                    this.changeNext(pointer, pointer, this.getNextIdx(pointer));
                }
                if ((pointer = this.getNextIdx(pointer)) != 0) continue;
            }
        }

        public int hashCode() {
            return this.toPlainSet().hashCode();
        }

        public boolean equals(Object o) {
            int i;
            if (o == this) {
                return true;
            }
            if (!(o instanceof FastSparseSet)) {
                return false;
            }
            int[] longdata = ((FastSparseSet)o).getData();
            int[] shortdata = this.data;
            if (this.data.length > longdata.length) {
                shortdata = longdata;
                longdata = this.data;
            }
            for (i = shortdata.length - 1; i >= 0; --i) {
                if (shortdata[i] == longdata[i]) continue;
                return false;
            }
            for (i = longdata.length - 1; i >= shortdata.length; --i) {
                if (longdata[i] == 0) continue;
                return false;
            }
            return true;
        }

        public int getCardinality() {
            boolean found = false;
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int block = intdata[i];
                if (block == 0) continue;
                if (found) {
                    return 2;
                }
                if ((block & block - 1) == 0) {
                    found = true;
                    continue;
                }
                return 2;
            }
            return found ? 1 : 0;
        }

        public boolean isEmpty() {
            return this.data.length == 0 || this.getNextIdx(0) == 0 && this.data[0] == 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new FastSparseSetIterator(this);
        }

        public Set<E> toPlainSet() {
            HashSet<E> set = new HashSet<E>();
            int[] intdata = this.data;
            int size = this.data.length * 32;
            if (size > this.colValuesInternal.size()) {
                size = this.colValuesInternal.size();
            }
            for (int i = size - 1; i >= 0; --i) {
                long index = this.colValuesInternal.get(i);
                if ((intdata[PackedMap.unpackLow(index)] & PackedMap.unpackHigh(index)) == 0) continue;
                set.add(this.colValuesInternal.getKey(i));
            }
            return set;
        }

        public String toString() {
            return this.toPlainSet().toString();
        }

        private int[] getData() {
            return this.data;
        }

        private int[] getNext() {
            return this.next;
        }

        private FastSparseSetFactory<E> getFactory() {
            return this.factory;
        }
    }
}

