/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.util.ContractUtils;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.Modifier;

public class Flags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int VOLATILE = 64;
    public static final int TRANSIENT = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICTFP = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MANDATED = 32768;
    public static final int StandardFlags = 4095;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_MODULE = 32768;
    public static final int ACC_OPEN = 32;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_MANDATED = 32768;
    public static final int ACC_TRANSITIVE = 32;
    public static final int ACC_STATIC_PHASE = 64;
    public static final int DEPRECATED = 131072;
    public static final int HASINIT = 262144;
    public static final int BLOCK = 0x100000;
    public static final int IPROXY = 0x200000;
    public static final int NOOUTERTHIS = 0x400000;
    public static final int EXISTS = 0x800000;
    public static final int COMPOUND = 0x1000000;
    public static final int CLASS_SEEN = 0x2000000;
    public static final int SOURCE_SEEN = 0x4000000;
    public static final int LOCKED = 0x8000000;
    public static final int UNATTRIBUTED = 0x10000000;
    public static final int ANONCONSTR = 0x20000000;
    public static final int ACYCLIC = 0x40000000;
    public static final long BRIDGE = 0x80000000L;
    public static final long PARAMETER = 0x200000000L;
    public static final long VARARGS = 0x400000000L;
    public static final long ACYCLIC_ANN = 0x800000000L;
    public static final long GENERATEDCONSTR = 0x1000000000L;
    public static final long HYPOTHETICAL = 0x2000000000L;
    public static final long PROPRIETARY = 0x4000000000L;
    public static final long UNION = 0x8000000000L;
    public static final long OVERRIDE_BRIDGE = 0x10000000000L;
    public static final long EFFECTIVELY_FINAL = 0x20000000000L;
    public static final long CLASH = 0x40000000000L;
    public static final long DEFAULT = 0x80000000000L;
    public static final long ANONYMOUS = 0x100000000000L;
    public static final long SUPER = 0x200000000000L;
    public static final long LOAD_BODY_FAILED = 0x400000000000L;
    public static final long DEOBFUSCATED = 0x800000000000L;
    public static final long MODULE = 0x8000000000000L;
    public static final long RECORD = 0x2000000000000000L;
    public static final long COMPACT_RECORD_CONSTRUCTOR = 0x8000000000000L;
    public static final long UNINITIALIZED_FIELD = 0x8000000000000L;
    public static final int GENERATED_MEMBER = 0x1000000;
    public static final long SEALED = 0x4000000000000000L;
    public static final long NON_SEALED = Long.MIN_VALUE;
    public static final int ModuleFlags = 36896;
    public static final int RequiresFlags = 36960;
    public static final int ExportsOpensFlags = 36864;
    public static final int AccessFlags = 7;
    public static final int LocalClassFlags = 23568;
    public static final int StaticLocalFlags = 24088;
    public static final int MemberClassFlags = 24087;
    public static final int MemberStaticClassFlags = 24095;
    public static final int ClassFlags = 32273;
    public static final int InterfaceVarFlags = 25;
    public static final int VarFlags = 16607;
    public static final int ConstructorFlags = 7;
    public static final int InterfaceMethodFlags = 1025;
    public static final int MethodFlags = 3391;
    public static final int RecordMethodFlags = 3135;
    public static final long ExtendedInterfaceFlags = -4611686018427387904L;
    public static final long ExtendedStandardFlags = -4611677222334361601L;
    public static final long ExtendedMemberClassFlags = -4611686018427363817L;
    public static final long ExtendedMemberStaticClassFlags = -4611686018427363809L;
    public static final long ExtendedClassFlags = -4611686018427355631L;
    public static final long ModifierFlags = -4611677222334362113L;
    public static final long InterfaceMethodMask = 8796093025291L;
    public static final long AnnotationTypeElementMask = 1025L;
    public static final long LocalVarFlags = 0x200000010L;
    public static final long ReceiverParamFlags = 0x200000000L;
    private static final Map<Long, Set<Modifier>> modifierSets = new ConcurrentHashMap<Long, Set<Modifier>>(64);

    private Flags() {
        throw ContractUtils.unreachable();
    }

    public static String toString(long flags) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (Flag s2 : Flags.asFlagSet(flags)) {
            buf.append(sep);
            buf.append(s2.name());
            sep = ", ";
        }
        return buf.toString();
    }

    public static String toString(long flags, Kind kind) {
        StringBuilder buf = new StringBuilder();
        String sep = "";
        for (Flag s2 : Flags.asFlagSet(flags, kind)) {
            buf.append(sep);
            buf.append(s2.name());
            sep = ", ";
        }
        return buf.toString();
    }

    public static EnumSet<Flag> asFlagSet(long mask) {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if ((mask & 1L) != 0L) {
            flags.add(Flag.PUBLIC);
        }
        if ((mask & 2L) != 0L) {
            flags.add(Flag.PRIVATE);
        }
        if ((mask & 4L) != 0L) {
            flags.add(Flag.PROTECTED);
        }
        if ((mask & 8L) != 0L) {
            flags.add(Flag.STATIC);
        }
        if ((mask & 0x400L) != 0L) {
            flags.add(Flag.ABSTRACT);
        }
        if ((mask & 0x10L) != 0L) {
            flags.add(Flag.FINAL);
        }
        if ((mask & 0x4000000000000000L) != 0L) {
            flags.add(Flag.SEALED);
        }
        if ((mask & Long.MIN_VALUE) != 0L) {
            flags.add(Flag.NON_SEALED);
        }
        if ((mask & 0x20L) != 0L) {
            flags.add(Flag.SYNCHRONIZED);
        }
        if ((mask & 0x40L) != 0L) {
            flags.add(Flag.VOLATILE);
        }
        if ((mask & 0x80L) != 0L) {
            flags.add(Flag.TRANSIENT);
        }
        if ((mask & 0x100L) != 0L) {
            flags.add(Flag.NATIVE);
        }
        if ((mask & 0x200L) != 0L) {
            flags.add(Flag.INTERFACE);
        }
        if ((mask & 0x80000000000L) != 0L) {
            flags.add(Flag.DEFAULT);
        }
        if ((mask & 0x80000000000L) != 0L) {
            flags.add(Flag.DEFAULT);
        }
        if ((mask & 0x800L) != 0L) {
            flags.add(Flag.STRICTFP);
        }
        if ((mask & 0x200000000000L) != 0L) {
            flags.add(Flag.SUPER);
        }
        if ((mask & 0x80000000L) != 0L) {
            flags.add(Flag.BRIDGE);
        }
        if ((mask & 0x1000L) != 0L) {
            flags.add(Flag.SYNTHETIC);
        }
        if ((mask & 0x20000L) != 0L) {
            flags.add(Flag.DEPRECATED);
        }
        if ((mask & 0x40000L) != 0L) {
            flags.add(Flag.HASINIT);
        }
        if ((mask & 0x4000L) != 0L) {
            flags.add(Flag.ENUM);
        }
        if ((mask & 0x8000L) != 0L) {
            flags.add(Flag.MANDATED);
        }
        if ((mask & 0x200000L) != 0L) {
            flags.add(Flag.IPROXY);
        }
        if ((mask & 0x400000L) != 0L) {
            flags.add(Flag.NOOUTERTHIS);
        }
        if ((mask & 0x800000L) != 0L) {
            flags.add(Flag.EXISTS);
        }
        if ((mask & 0x1000000L) != 0L) {
            flags.add(Flag.COMPOUND);
        }
        if ((mask & 0x2000000L) != 0L) {
            flags.add(Flag.CLASS_SEEN);
        }
        if ((mask & 0x4000000L) != 0L) {
            flags.add(Flag.SOURCE_SEEN);
        }
        if ((mask & 0x8000000L) != 0L) {
            flags.add(Flag.LOCKED);
        }
        if ((mask & 0x10000000L) != 0L) {
            flags.add(Flag.UNATTRIBUTED);
        }
        if ((mask & 0x20000000L) != 0L) {
            flags.add(Flag.ANONCONSTR);
        }
        if ((mask & 0x40000000L) != 0L) {
            flags.add(Flag.ACYCLIC);
        }
        if ((mask & 0x200000000L) != 0L) {
            flags.add(Flag.PARAMETER);
        }
        if ((mask & 0x400000000L) != 0L) {
            flags.add(Flag.VARARGS);
        }
        return flags;
    }

    public static EnumSet<Flag> asFlagSet(long mask, Kind kind) {
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        if (kind == Kind.Module) {
            if ((mask & 0x20L) != 0L) {
                flags.add(Flag.OPEN);
            }
            if ((mask & 0x1000L) != 0L) {
                flags.add(Flag.SYNTHETIC);
            }
            if ((mask & 0x8000L) != 0L) {
                flags.add(Flag.MANDATED);
            }
            return flags;
        }
        if (kind == Kind.Requires) {
            if ((mask & 0x20L) != 0L) {
                flags.add(Flag.TRANSITIVE);
            }
            if ((mask & 0x40L) != 0L) {
                flags.add(Flag.STATIC_PHASE);
            }
            if ((mask & 0x1000L) != 0L) {
                flags.add(Flag.SYNTHETIC);
            }
            if ((mask & 0x8000L) != 0L) {
                flags.add(Flag.MANDATED);
            }
            return flags;
        }
        if (kind == Kind.ExportsOpens) {
            if ((mask & 0x1000L) != 0L) {
                flags.add(Flag.SYNTHETIC);
            }
            if ((mask & 0x8000L) != 0L) {
                flags.add(Flag.MANDATED);
            }
            return flags;
        }
        if ((mask & 1L) != 0L) {
            flags.add(Flag.PUBLIC);
        }
        if ((mask & 2L) != 0L) {
            flags.add(Flag.PRIVATE);
        }
        if ((mask & 4L) != 0L) {
            flags.add(Flag.PROTECTED);
        }
        if ((mask & 8L) != 0L) {
            flags.add(Flag.STATIC);
        }
        if ((mask & 0x10L) != 0L) {
            flags.add(Flag.FINAL);
        }
        if ((mask & 0x4000000000000000L) != 0L) {
            flags.add(Flag.SEALED);
        }
        if ((mask & Long.MIN_VALUE) != 0L) {
            flags.add(Flag.NON_SEALED);
        }
        if ((mask & 0x20L) != 0L) {
            flags.add(kind == Kind.Class || kind == Kind.InnerClass ? Flag.SUPER : Flag.SYNCHRONIZED);
        }
        if ((mask & 0x40L) != 0L) {
            flags.add(kind == Kind.Method ? Flag.BRIDGE : Flag.VOLATILE);
        }
        if ((mask & 0x80L) != 0L) {
            flags.add(kind == Kind.Method ? Flag.VARARGS : Flag.TRANSIENT);
        }
        if ((mask & 0x100L) != 0L) {
            flags.add(Flag.NATIVE);
        }
        if ((mask & 0x200L) != 0L) {
            flags.add(Flag.INTERFACE);
        }
        if ((mask & 0x400L) != 0L) {
            flags.add(Flag.ABSTRACT);
        }
        if ((mask & 0x80000000000L) != 0L) {
            flags.add(Flag.DEFAULT);
        }
        if ((mask & 0x800L) != 0L) {
            flags.add(Flag.STRICTFP);
        }
        if ((mask & 0x200000000000L) != 0L) {
            flags.add(Flag.SUPER);
        }
        if ((mask & 0x80000000L) != 0L) {
            flags.add(Flag.BRIDGE);
        }
        if ((mask & 0x1000L) != 0L) {
            flags.add(Flag.SYNTHETIC);
        }
        if ((mask & 0x20000L) != 0L) {
            flags.add(Flag.DEPRECATED);
        }
        if ((mask & 0x40000L) != 0L) {
            flags.add(Flag.HASINIT);
        }
        if ((mask & 0x4000L) != 0L) {
            flags.add(Flag.ENUM);
        }
        if ((mask & 0x200000L) != 0L) {
            flags.add(Flag.IPROXY);
        }
        if ((mask & 0x400000L) != 0L) {
            flags.add(Flag.NOOUTERTHIS);
        }
        if ((mask & 0x800000L) != 0L) {
            flags.add(Flag.EXISTS);
        }
        if ((mask & 0x1000000L) != 0L) {
            flags.add(Flag.COMPOUND);
        }
        if ((mask & 0x2000000L) != 0L) {
            flags.add(Flag.CLASS_SEEN);
        }
        if ((mask & 0x4000000L) != 0L) {
            flags.add(Flag.SOURCE_SEEN);
        }
        if ((mask & 0x8000000L) != 0L) {
            flags.add(Flag.LOCKED);
        }
        if ((mask & 0x10000000L) != 0L) {
            flags.add(Flag.UNATTRIBUTED);
        }
        if ((mask & 0x20000000L) != 0L) {
            flags.add(Flag.ANONCONSTR);
        }
        if ((mask & 0x40000000L) != 0L) {
            flags.add(Flag.ACYCLIC);
        }
        if ((mask & 0x200000000L) != 0L) {
            flags.add(Flag.PARAMETER);
        }
        if ((mask & 0x400000000L) != 0L) {
            flags.add(Flag.VARARGS);
        }
        return flags;
    }

    public static Set<Modifier> asModifierSet(long flags) {
        Set<Modifier> modifiers = modifierSets.get(flags);
        if (modifiers == null) {
            modifiers = EnumSet.noneOf(Modifier.class);
            if (0L != (flags & 1L)) {
                modifiers.add(Modifier.PUBLIC);
            }
            if (0L != (flags & 4L)) {
                modifiers.add(Modifier.PROTECTED);
            }
            if (0L != (flags & 2L)) {
                modifiers.add(Modifier.PRIVATE);
            }
            if (0L != (flags & 0x400L)) {
                modifiers.add(Modifier.ABSTRACT);
            }
            if (0L != (flags & 8L)) {
                modifiers.add(Modifier.STATIC);
            }
            if (0L != (flags & 0x10L)) {
                modifiers.add(Modifier.FINAL);
            }
            if (0L != (flags & 0x80L)) {
                modifiers.add(Modifier.TRANSIENT);
            }
            if (0L != (flags & 0x40L)) {
                modifiers.add(Modifier.VOLATILE);
            }
            if (0L != (flags & 0x20L)) {
                modifiers.add(Modifier.SYNCHRONIZED);
            }
            if (0L != (flags & 0x100L)) {
                modifiers.add(Modifier.NATIVE);
            }
            if (0L != (flags & 0x800L)) {
                modifiers.add(Modifier.STRICTFP);
            }
            modifiers = Collections.unmodifiableSet(modifiers);
            modifierSets.put(flags, modifiers);
        }
        return modifiers;
    }

    public static int toModifiers(long flags) {
        int modifiers = 0;
        if ((flags & 1L) != 0L) {
            modifiers |= 1;
        }
        if ((flags & 4L) != 0L) {
            modifiers |= 4;
        }
        if ((flags & 2L) != 0L) {
            modifiers |= 2;
        }
        if ((flags & 0x400L) != 0L) {
            modifiers |= 0x400;
        }
        if ((flags & 8L) != 0L) {
            modifiers |= 8;
        }
        if ((flags & 0x10L) != 0L) {
            modifiers |= 0x10;
        }
        if ((flags & 0x80L) != 0L) {
            modifiers |= 0x80;
        }
        if ((flags & 0x40L) != 0L) {
            modifiers |= 0x40;
        }
        if ((flags & 0x20L) != 0L) {
            modifiers |= 0x20;
        }
        if ((flags & 0x100L) != 0L) {
            modifiers |= 0x100;
        }
        if ((flags & 0x800L) != 0L) {
            modifiers |= 0x800;
        }
        return modifiers;
    }

    public static boolean testAny(int value, int flags) {
        return (value & flags) != 0;
    }

    public static boolean testAll(int value, int flags) {
        return (value & flags) == flags;
    }

    public static boolean testAny(long value, long flags) {
        return (value & flags) != 0L;
    }

    public static boolean testAll(long value, long flags) {
        return (value & flags) == flags;
    }

    public static boolean isEnum(TypeDefinition symbol) {
        return (symbol.getModifiers() & 0x4000) != 0;
    }

    public static long fromStandardFlags(long accessFlags, Kind kind) {
        long flags = accessFlags;
        if (Flags.testAny(accessFlags, 32L)) {
            flags |= kind == Kind.Class || kind == Kind.InnerClass ? 0x200000000000L : 32L;
        }
        if (Flags.testAny(accessFlags, 64L)) {
            flags |= kind == Kind.Field ? 64L : 0x80000000L;
        }
        if (Flags.testAny(accessFlags, 128L)) {
            flags |= kind == Kind.Field ? 128L : 0x400000000L;
        }
        return flags;
    }

    public static enum Flag {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private"),
        ABSTRACT("abstract"),
        DEFAULT("default"),
        STATIC("static"),
        SEALED("sealed"),
        NON_SEALED("non-sealed"),
        FINAL("final"),
        TRANSIENT("transient"),
        VOLATILE("volatile"),
        SYNCHRONIZED("synchronized"),
        NATIVE("native"),
        STRICTFP("strictfp"),
        INTERFACE("interface"),
        SUPER("super"),
        BRIDGE("bridge"),
        SYNTHETIC("synthetic"),
        DEPRECATED("deprecated"),
        HASINIT("hasinit"),
        ENUM("enum"),
        MANDATED("mandated"),
        IPROXY("iproxy"),
        NOOUTERTHIS("noouterthis"),
        EXISTS("exists"),
        COMPOUND("compound"),
        CLASS_SEEN("class_seen"),
        SOURCE_SEEN("source_seen"),
        LOCKED("locked"),
        UNATTRIBUTED("unattributed"),
        ANONCONSTR("anonconstr"),
        ACYCLIC("acyclic"),
        PARAMETER("parameter"),
        VARARGS("varargs"),
        PACKAGE("package"),
        OPEN("open"),
        TRANSITIVE("transitive"),
        STATIC_PHASE("static");

        public final String name;

        private Flag(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Kind {
        Class,
        InnerClass,
        Field,
        Method,
        Module,
        Requires,
        ExportsOpens;

    }
}

