/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.Predicate;
import com.strobel.core.Predicates;
import com.strobel.core.StringUtilities;
import com.strobel.util.ContractUtils;

public final class MetadataFilters {
    private MetadataFilters() {
        throw ContractUtils.unreachable();
    }

    public static <T extends TypeReference> Predicate<T> isSubType(final TypeReference anchor) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return MetadataHelper.isSubType(t2, anchor);
            }
        };
    }

    public static <T extends TypeReference> Predicate<T> isSuperType(final TypeReference anchor) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return MetadataHelper.isSubType(anchor, t2);
            }
        };
    }

    public static <T extends TypeReference> Predicate<T> isAssignableFrom(final TypeReference sourceType) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return MetadataHelper.isAssignableFrom(t2, sourceType);
            }
        };
    }

    public static <T extends TypeReference> Predicate<T> isAssignableTo(final TypeReference targetType) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return MetadataHelper.isAssignableFrom(targetType, t2);
            }
        };
    }

    public static <T extends MemberReference> Predicate<T> matchName(final String name) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return StringUtilities.equals(((MemberReference)t2).getName(), name);
            }
        };
    }

    public static <T extends MemberReference> Predicate<T> matchDescriptor(final String descriptor) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return StringUtilities.equals(((MemberReference)t2).getErasedSignature(), descriptor);
            }
        };
    }

    public static <T extends MemberReference> Predicate<T> matchSignature(final String signature) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return StringUtilities.equals(((MemberReference)t2).getSignature(), signature);
            }
        };
    }

    public static <T extends MemberReference> Predicate<T> matchNameAndDescriptor(String name, String descriptor) {
        return Predicates.and(MetadataFilters.matchName(name), MetadataFilters.matchDescriptor(descriptor));
    }

    public static <T extends MemberReference> Predicate<T> matchNameAndSignature(String name, String signature) {
        return Predicates.and(MetadataFilters.matchName(name), MetadataFilters.matchSignature(signature));
    }
}

