/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.ArrayType;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CapturedType;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.ConversionType;
import com.strobel.assembler.metadata.DefaultTypeVisitor;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericMethodInstance;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.ICapturedType;
import com.strobel.assembler.metadata.ICompoundType;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.IUnionType;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RawMethod;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMapper;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.TypeRelation;
import com.strobel.assembler.metadata.TypeSubstitutionVisitor;
import com.strobel.assembler.metadata.UnionType;
import com.strobel.assembler.metadata.WildcardType;
import com.strobel.collections.ListBuffer;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.Pair;
import com.strobel.core.Predicate;
import com.strobel.core.Predicates;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class MetadataHelper {
    private static final ThreadLocal<HashSet<Pair<TypeReference, TypeReference>>> CONTAINS_TYPE_CACHE = new ThreadLocal<HashSet<Pair<TypeReference, TypeReference>>>(){

        @Override
        protected final HashSet<Pair<TypeReference, TypeReference>> initialValue() {
            return new HashSet<Pair<TypeReference, TypeReference>>();
        }
    };
    private static final ThreadLocal<HashSet<Pair<TypeReference, TypeReference>>> ADAPT_CACHE = new ThreadLocal<HashSet<Pair<TypeReference, TypeReference>>>(){

        @Override
        protected final HashSet<Pair<TypeReference, TypeReference>> initialValue() {
            return new HashSet<Pair<TypeReference, TypeReference>>();
        }
    };
    private static final TypeMapper<Void> UPPER_BOUND_VISITOR = new TypeMapper<Void>(){

        @Override
        public TypeReference visitType(TypeReference t2, Void ignored) {
            if (t2.isWildcardType() || t2.isGenericParameter() || t2 instanceof ICapturedType) {
                return t2.isUnbounded() || t2.hasSuperBound() ? BuiltinTypes.Object : (TypeReference)this.visit(t2.getExtendsBound());
            }
            return t2;
        }

        @Override
        public TypeReference visitCapturedType(CapturedType t2, Void ignored) {
            return t2.getExtendsBound();
        }

        @Override
        public TypeReference visitArrayType(ArrayType t2, Void ignored) {
            TypeReference newElementType;
            TypeReference oldElementType = t2.getElementType();
            if (oldElementType != (newElementType = (TypeReference)this.visit(t2.getElementType(), ignored))) {
                return newElementType.makeArrayType();
            }
            return t2;
        }

        @Override
        public <U extends TypeReference> TypeReference visitUnionType(U t2, Void ignored) {
            List<TypeReference> alternatives = ((IUnionType)((Object)t2)).getAlternatives();
            TypeReference u = alternatives.get(0);
            int n = alternatives.size();
            for (int i = 1; i < n; ++i) {
                u = MetadataHelper.asSuper(u, alternatives.get(i));
            }
            return u;
        }
    };
    private static final TypeMapper<Void> LOWER_BOUND_VISITOR = new TypeMapper<Void>(){

        @Override
        public TypeReference visitWildcard(WildcardType t2, Void ignored) {
            return t2.hasSuperBound() ? (TypeReference)this.visit(t2.getSuperBound()) : BuiltinTypes.Bottom;
        }

        @Override
        public TypeReference visitCapturedType(CapturedType t2, Void ignored) {
            return t2.getSuperBound();
        }

        @Override
        public TypeReference visitArrayType(ArrayType t2, Void ignored) {
            TypeReference newElementType;
            TypeReference oldElementType = t2.getElementType();
            if (oldElementType != (newElementType = (TypeReference)this.visit(t2.getElementType(), ignored))) {
                return newElementType.makeArrayType();
            }
            return t2;
        }
    };
    private static final TypeRelation IS_SUBTYPE_VISITOR = new TypeRelation(){

        @Override
        public Boolean visitArrayType(ArrayType t2, TypeReference s2) {
            if (s2.isArray()) {
                TypeReference et = MetadataHelper.getElementType(t2);
                TypeReference es = MetadataHelper.getElementType(s2);
                assert (et != null && es != null);
                if (et.isPrimitive()) {
                    return MetadataHelper.isSameType(et, es);
                }
                return MetadataHelper.isSubTypeNoCapture(et, es);
            }
            String sName = s2.getInternalName();
            return StringUtilities.equals(sName, "java/lang/Object") || StringUtilities.equals(sName, "java/lang/Cloneable") || StringUtilities.equals(sName, "java/io/Serializable");
        }

        @Override
        public Boolean visitBottomType(TypeReference t2, TypeReference s2) {
            switch (t2.getSimpleType()) {
                case Object: 
                case Array: 
                case TypeVariable: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Boolean visitClassType(TypeReference t2, TypeReference s2) {
            TypeReference superType = MetadataHelper.asSuper(s2, t2);
            return superType != null && StringUtilities.equals(superType.getInternalName(), s2.getInternalName()) && (!(s2 instanceof IGenericInstance) || MetadataHelper.containsTypeRecursive(s2, superType) || MetadataHelper.isRawType(superType)) && MetadataHelper.isSubTypeNoCapture(superType.getDeclaringType(), s2.getDeclaringType());
        }

        @Override
        public <C extends TypeReference> Boolean visitCompoundType(C t2, TypeReference s2) {
            TypeReference baseType = ((ICompoundType)((Object)t2)).getBaseType();
            if (baseType != null && MetadataHelper.isSubTypeNoCapture(baseType, s2)) {
                return true;
            }
            for (TypeReference ifType : ((ICompoundType)((Object)t2)).getInterfaces()) {
                if (!MetadataHelper.isSubTypeNoCapture(ifType, s2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <U extends TypeReference> Boolean visitUnionType(U t2, TypeReference s2) {
            for (TypeReference alternative : ((IUnionType)((Object)t2)).getAlternatives()) {
                if (!MetadataHelper.isSubTypeNoCapture(alternative, s2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitGenericParameter(GenericParameter t2, TypeReference s2) {
            return MetadataHelper.isSubTypeNoCapture(t2.hasExtendsBound() ? t2.getExtendsBound() : BuiltinTypes.Object, s2);
        }

        @Override
        public Boolean visitParameterizedType(TypeReference t2, TypeReference s2) {
            return this.visitClassType(t2, s2);
        }

        @Override
        public Boolean visitPrimitiveType(PrimitiveType t2, TypeReference s2) {
            JvmType js;
            JvmType jt = t2.getSimpleType();
            if (jt == (js = s2.getSimpleType())) {
                return true;
            }
            if (jt == JvmType.Boolean || js == JvmType.Boolean) {
                return false;
            }
            switch (js) {
                case Byte: {
                    return jt != JvmType.Character && jt.isIntegral() && jt.bitWidth() <= js.bitWidth();
                }
                case Short: {
                    if (jt == JvmType.Character) {
                        return false;
                    }
                }
                case Integer: 
                case Long: {
                    return jt.isIntegral() && jt.bitWidth() <= js.bitWidth();
                }
                case Float: 
                case Double: {
                    return jt.isIntegral() || jt.bitWidth() <= js.bitWidth();
                }
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitRawType(RawType t2, TypeReference s2) {
            return this.visitClassType((TypeReference)t2, s2);
        }

        @Override
        public Boolean visitWildcard(WildcardType t2, TypeReference s2) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitCapturedType(CapturedType t2, TypeReference s2) {
            return MetadataHelper.isSubTypeNoCapture(t2.hasExtendsBound() ? t2.getExtendsBound() : BuiltinTypes.Object, s2);
        }

        @Override
        public Boolean visitType(TypeReference t2, TypeReference s2) {
            return Boolean.FALSE;
        }
    };
    private static final TypeRelation CONTAINS_TYPE_VISITOR = new TypeRelation(){

        private TypeReference U(TypeReference t2) {
            TypeReference current = t2;
            while (current.isWildcardType()) {
                if (current.isUnbounded()) {
                    return BuiltinTypes.Object;
                }
                if (current.hasSuperBound()) {
                    return current.getSuperBound();
                }
                current = current.getExtendsBound();
            }
            return current;
        }

        private TypeReference L(TypeReference t2) {
            TypeReference current = t2;
            while (current.isWildcardType()) {
                if (current.isUnbounded() || current.hasExtendsBound()) {
                    return BuiltinTypes.Bottom;
                }
                current = current.getSuperBound();
            }
            return current;
        }

        @Override
        public Boolean visitType(TypeReference t2, TypeReference s2) {
            return MetadataHelper.isSameType(t2, s2);
        }

        @Override
        public Boolean visitWildcard(WildcardType t2, TypeReference s2) {
            return MetadataHelper.isSameWildcard(t2, s2) || MetadataHelper.isCaptureOf(s2, t2) || (t2.hasExtendsBound() || MetadataHelper.isSubTypeNoCapture(this.L(t2), MetadataHelper.getLowerBound(s2))) && (t2.hasSuperBound() || MetadataHelper.isSubTypeNoCapture(MetadataHelper.getUpperBound(s2), this.U(t2)));
        }

        @Override
        public <U extends TypeReference> Boolean visitUnionType(U t2, TypeReference s2) {
            for (TypeReference alternative : ((IUnionType)((Object)t2)).getAlternatives()) {
                if (!MetadataHelper.isSameType(alternative, s2)) continue;
                return true;
            }
            return false;
        }
    };
    private static final TypeMapper<TypeReference> AS_SUPER_VISITOR = new TypeMapper<TypeReference>(){

        @Override
        public TypeReference visitType(TypeReference t2, TypeReference s2) {
            return null;
        }

        @Override
        public TypeReference visitArrayType(ArrayType t2, TypeReference s2) {
            return MetadataHelper.isSubType(t2, s2) ? s2 : null;
        }

        @Override
        public TypeReference visitClassType(TypeReference t2, TypeReference s2) {
            TypeReference x;
            if (StringUtilities.equals(t2.getInternalName(), s2.getInternalName())) {
                return t2;
            }
            TypeReference st = MetadataHelper.getSuperType(t2);
            if (st != null && (st.getSimpleType() == JvmType.Object || st.getSimpleType() == JvmType.TypeVariable) && (x = MetadataHelper.asSuper(s2, st)) != null) {
                return x;
            }
            TypeDefinition ds = s2.resolve();
            if (ds != null && ds.isInterface()) {
                for (TypeReference i : MetadataHelper.getInterfaces(t2)) {
                    TypeReference x2 = MetadataHelper.asSuper(s2, i);
                    if (x2 == null) continue;
                    return x2;
                }
            }
            return null;
        }

        @Override
        public <U extends TypeReference> TypeReference visitUnionType(U t2, TypeReference s2) {
            for (TypeReference alternative : ((IUnionType)((Object)t2)).getAlternatives()) {
                TypeReference asSuper = MetadataHelper.asSuper(alternative, s2);
                if (asSuper == null) continue;
                return asSuper;
            }
            return null;
        }

        @Override
        public TypeReference visitGenericParameter(GenericParameter t2, TypeReference s2) {
            if (MetadataHelper.isSameType(t2, s2)) {
                return t2;
            }
            return MetadataHelper.asSuper(s2, t2.hasExtendsBound() ? t2.getExtendsBound() : BuiltinTypes.Object);
        }

        @Override
        public TypeReference visitNullType(TypeReference t2, TypeReference s2) {
            return (TypeReference)super.visitNullType(t2, s2);
        }

        @Override
        public TypeReference visitParameterizedType(TypeReference t2, TypeReference s2) {
            return this.visitClassType(t2, s2);
        }

        @Override
        public TypeReference visitPrimitiveType(PrimitiveType t2, TypeReference s2) {
            return (TypeReference)super.visitPrimitiveType(t2, s2);
        }

        @Override
        public TypeReference visitRawType(RawType t2, TypeReference s2) {
            return this.visitClassType((TypeReference)t2, s2);
        }

        @Override
        public TypeReference visitWildcard(WildcardType t2, TypeReference s2) {
            return (TypeReference)super.visitWildcard(t2, s2);
        }
    };
    private static final TypeMapper<Void> SUPER_VISITOR = new TypeMapper<Void>(){

        @Override
        public TypeReference visitType(TypeReference t2, Void ignored) {
            return null;
        }

        @Override
        public TypeReference visitArrayType(ArrayType t2, Void ignored) {
            TypeReference et = MetadataHelper.getElementType(t2);
            assert (et != null);
            if (et.isPrimitive() || MetadataHelper.isSameType(et, BuiltinTypes.Object)) {
                return MetadataHelper.arraySuperType(et);
            }
            TypeReference superType = MetadataHelper.getSuperType(et);
            return superType != null ? superType.makeArrayType() : null;
        }

        @Override
        public <C extends TypeReference> TypeReference visitCompoundType(C t2, Void ignored) {
            TypeReference bt = ((ICompoundType)((Object)t2)).getBaseType();
            if (bt != null) {
                return MetadataHelper.getSuperType(bt);
            }
            return t2;
        }

        @Override
        public <U extends TypeReference> TypeReference visitUnionType(U t2, Void ignored) {
            List<TypeReference> alternatives = ((IUnionType)((Object)t2)).getAlternatives();
            TypeReference u = alternatives.get(0);
            int n = alternatives.size();
            for (int i = 1; i < n; ++i) {
                u = MetadataHelper.asSuper(u, alternatives.get(i));
            }
            return u;
        }

        @Override
        public TypeReference visitClassType(TypeReference t2, Void ignored) {
            TypeReference superType;
            TypeDefinition resolved = t2.resolve();
            if (resolved == null) {
                return BuiltinTypes.Object;
            }
            if (resolved.isInterface()) {
                superType = resolved.getBaseType();
                if (superType == null) {
                    superType = CollectionUtilities.firstOrDefault(resolved.getExplicitInterfaces());
                }
            } else {
                superType = resolved.getBaseType();
            }
            if (superType == null) {
                return null;
            }
            if (resolved.isGenericDefinition()) {
                if (!t2.isGenericType()) {
                    return MetadataHelper.eraseRecursive(superType);
                }
                if (t2.isGenericDefinition()) {
                    return superType;
                }
                return MetadataHelper.substituteGenericArguments(superType, MetadataHelper.classBound(t2));
            }
            return superType;
        }

        @Override
        public TypeReference visitGenericParameter(GenericParameter t2, Void ignored) {
            return t2.hasExtendsBound() ? t2.getExtendsBound() : BuiltinTypes.Object;
        }

        @Override
        public TypeReference visitNullType(TypeReference t2, Void ignored) {
            return BuiltinTypes.Object;
        }

        @Override
        public TypeReference visitParameterizedType(TypeReference t2, Void ignored) {
            return this.visitClassType(t2, ignored);
        }

        @Override
        public TypeReference visitRawType(RawType t2, Void ignored) {
            TypeReference baseType;
            TypeReference genericDefinition = t2.getUnderlyingType();
            if (!genericDefinition.isGenericDefinition()) {
                TypeDefinition resolved = genericDefinition.resolve();
                if (resolved == null || !resolved.isGenericDefinition()) {
                    return BuiltinTypes.Object;
                }
                genericDefinition = resolved;
            }
            return (baseType = MetadataHelper.getBaseType(genericDefinition)) != null && baseType.isGenericType() ? MetadataHelper.eraseRecursive(baseType) : baseType;
        }

        @Override
        public TypeReference visitWildcard(WildcardType t2, Void ignored) {
            if (t2.isUnbounded()) {
                return BuiltinTypes.Object;
            }
            if (t2.hasExtendsBound()) {
                return t2.getExtendsBound();
            }
            return null;
        }
    };
    private static final SameTypeVisitor SAME_TYPE_VISITOR_LOOSE = new LooseSameTypeVisitor();
    private static final SameTypeVisitor SAME_TYPE_VISITOR_STRICT = new StrictSameTypeVisitor();
    private static final DefaultTypeVisitor<Void, List<TypeReference>> INTERFACES_VISITOR = new DefaultTypeVisitor<Void, List<TypeReference>>(){

        @Override
        public List<TypeReference> visitClassType(TypeReference t2, Void ignored) {
            TypeDefinition r = t2.resolve();
            if (r == null) {
                return Collections.emptyList();
            }
            List<TypeReference> interfaces = r.getExplicitInterfaces();
            if (r.isGenericDefinition()) {
                int i;
                if (t2.isGenericDefinition()) {
                    return interfaces;
                }
                if (MetadataHelper.isRawType(t2)) {
                    return MetadataHelper.eraseRecursive(interfaces);
                }
                List formal = MetadataHelper.getTypeArguments(r);
                List actual = MetadataHelper.getTypeArguments(t2);
                ArrayList<TypeReference> result = new ArrayList<TypeReference>();
                HashMap<TypeReference, TypeReference> mappings = new HashMap<TypeReference, TypeReference>();
                int n = formal.size();
                for (i = 0; i < n; ++i) {
                    mappings.put((TypeReference)formal.get(i), (TypeReference)actual.get(i));
                }
                n = interfaces.size();
                for (i = 0; i < n; ++i) {
                    result.add(MetadataHelper.substituteGenericArguments(interfaces.get(i), mappings));
                }
                return result;
            }
            return interfaces;
        }

        @Override
        public List<TypeReference> visitWildcard(WildcardType t2, Void ignored) {
            if (t2.hasExtendsBound()) {
                TypeReference bound = t2.getExtendsBound();
                TypeDefinition resolvedBound = bound.resolve();
                if (resolvedBound != null) {
                    if (resolvedBound.isInterface()) {
                        return Collections.singletonList(bound);
                    }
                    if (resolvedBound.isCompoundType()) {
                        this.visit(bound, null);
                    }
                }
                return (List)this.visit(bound, null);
            }
            return Collections.emptyList();
        }

        @Override
        public List<TypeReference> visitGenericParameter(GenericParameter t2, Void ignored) {
            if (t2.hasExtendsBound()) {
                TypeReference bound = t2.getExtendsBound();
                TypeDefinition resolvedBound = bound.resolve();
                if (resolvedBound != null) {
                    if (resolvedBound.isInterface()) {
                        return Collections.singletonList(bound);
                    }
                    if (resolvedBound.isCompoundType()) {
                        this.visit(bound, null);
                    }
                }
                return (List)this.visit(bound, null);
            }
            return Collections.emptyList();
        }

        @Override
        public <C extends TypeReference> List<TypeReference> visitCompoundType(C t2, Void unused) {
            return ((ICompoundType)((Object)t2)).getInterfaces();
        }
    };
    private static final TypeMapper<TypeReference> AS_SUBTYPE_VISITOR = new TypeMapper<TypeReference>(){

        @Override
        public TypeReference visitClassType(TypeReference t2, TypeReference s2) {
            Map<TypeReference, TypeReference> mappings;
            if (MetadataHelper.isSameType(t2, s2)) {
                return t2;
            }
            TypeReference base = MetadataHelper.asSuper(t2, s2);
            if (base == null) {
                return null;
            }
            try {
                mappings = MetadataHelper.adapt(base, t2);
            }
            catch (AdaptFailure ignored) {
                mappings = MetadataHelper.getGenericSubTypeMappings(t2, base);
            }
            TypeReference result = MetadataHelper.substituteGenericArguments(s2, mappings);
            if (!MetadataHelper.isSubType(result, t2)) {
                return null;
            }
            List tTypeArguments = MetadataHelper.getTypeArguments(t2);
            List sTypeArguments = MetadataHelper.getTypeArguments(s2);
            List resultTypeArguments = MetadataHelper.getTypeArguments(result);
            ArrayList<TypeReference> openGenericParameters = null;
            for (TypeReference a : sTypeArguments) {
                if (!a.isGenericParameter() || CollectionUtilities.indexOfByIdentity(resultTypeArguments, a) < 0 || CollectionUtilities.indexOfByIdentity(tTypeArguments, a) >= 0) continue;
                if (openGenericParameters == null) {
                    openGenericParameters = new ArrayList<TypeReference>();
                }
                openGenericParameters.add(a);
            }
            if (openGenericParameters != null) {
                if (MetadataHelper.isRawType(t2)) {
                    return MetadataHelper.eraseRecursive(result);
                }
                HashMap<TypeReference, TypeReference> unboundMappings = new HashMap<TypeReference, TypeReference>();
                for (TypeReference p : openGenericParameters) {
                    unboundMappings.put(p, WildcardType.unbounded());
                }
                return MetadataHelper.substituteGenericArguments(result, unboundMappings);
            }
            return result;
        }
    };
    private static final DefaultTypeVisitor<Boolean, TypeReference> ERASE_VISITOR = new DefaultTypeVisitor<Boolean, TypeReference>(){

        @Override
        public TypeReference visitArrayType(ArrayType t2, Boolean recurse) {
            TypeReference elementType = MetadataHelper.getElementType(t2);
            TypeReference erasedElementType = MetadataHelper.erase(MetadataHelper.getElementType(t2), recurse);
            return erasedElementType == elementType ? t2 : erasedElementType.makeArrayType();
        }

        @Override
        public TypeReference visitBottomType(TypeReference t2, Boolean recurse) {
            return t2;
        }

        @Override
        public TypeReference visitClassType(TypeReference t2, Boolean recurse) {
            if (t2.isGenericType()) {
                return new RawType(t2);
            }
            TypeDefinition resolved = t2.resolve();
            if (resolved != null && resolved.isGenericDefinition()) {
                return new RawType(resolved);
            }
            return t2;
        }

        @Override
        public <C extends TypeReference> TypeReference visitCompoundType(C t2, Boolean recurse) {
            TypeReference baseType = ((ICompoundType)((Object)t2)).getBaseType();
            return MetadataHelper.erase(baseType != null ? baseType : CollectionUtilities.first(((ICompoundType)((Object)t2)).getInterfaces()), recurse);
        }

        @Override
        public TypeReference visitGenericParameter(GenericParameter t2, Boolean recurse) {
            return MetadataHelper.erase(MetadataHelper.getUpperBound(t2), recurse);
        }

        @Override
        public TypeReference visitNullType(TypeReference t2, Boolean recurse) {
            return t2;
        }

        @Override
        public TypeReference visitPrimitiveType(PrimitiveType t2, Boolean recurse) {
            return t2;
        }

        @Override
        public TypeReference visitRawType(RawType t2, Boolean recurse) {
            return t2;
        }

        @Override
        public TypeReference visitType(TypeReference t2, Boolean recurse) {
            if (t2.isGenericType()) {
                return new RawType(t2);
            }
            return t2;
        }

        @Override
        public TypeReference visitWildcard(WildcardType t2, Boolean recurse) {
            return MetadataHelper.erase(MetadataHelper.getUpperBound(t2), recurse);
        }
    };
    private static final DefaultTypeVisitor<Void, Boolean> IS_DECLARED_TYPE = new DefaultTypeVisitor<Void, Boolean>(){

        @Override
        public Boolean visitWildcard(WildcardType t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitArrayType(ArrayType t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitBottomType(TypeReference t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitCapturedType(CapturedType t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitClassType(TypeReference t2, Void ignored) {
            return true;
        }

        @Override
        public <C extends TypeReference> Boolean visitCompoundType(C t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitGenericParameter(GenericParameter t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitNullType(TypeReference t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitParameterizedType(TypeReference t2, Void ignored) {
            return true;
        }

        @Override
        public Boolean visitPrimitiveType(PrimitiveType t2, Void ignored) {
            return false;
        }

        @Override
        public Boolean visitRawType(RawType t2, Void ignored) {
            return true;
        }

        @Override
        public Boolean visitType(TypeReference t2, Void ignored) {
            return false;
        }
    };

    public static boolean areGenericsSupported(TypeDefinition t2) {
        return t2 != null && t2.getCompilerMajorVersion() >= 49;
    }

    public static int getArrayRank(TypeReference t2) {
        if (t2 == null) {
            return 0;
        }
        int rank = 0;
        TypeReference current = t2;
        while (current.isArray()) {
            ++rank;
            current = current.getElementType();
        }
        return rank;
    }

    @Nullable
    public static TypeDefinition getOutermostEnclosingType(TypeReference innerType) {
        TypeReference t2 = innerType;
        while (t2 != null) {
            TypeDefinition r = t2.resolve();
            if (r == null || !r.isNested()) {
                return r;
            }
            MethodReference m4 = r.getDeclaringMethod();
            t2 = m4 != null ? m4.getDeclaringType() : t2.getDeclaringType();
        }
        return null;
    }

    public static boolean isEnclosedBy(TypeReference innerType, TypeReference outerType) {
        if (innerType == null || outerType == null || BuiltinTypes.Object.isEquivalentTo(outerType)) {
            return false;
        }
        TypeDefinition innerResolved = innerType.resolve();
        TypeDefinition outerResolved = outerType.resolve();
        TypeReference inner = innerResolved != null ? innerResolved : innerType;
        TypeReference outer = outerResolved != null ? outerResolved : outerType;
        for (TypeReference current = inner.getDeclaringType(); current != null; current = current.getDeclaringType()) {
            if (!MetadataHelper.isSameType(current, outer, false)) continue;
            return true;
        }
        TypeReference outerBaseType = outerResolved != null ? outerResolved.getBaseType() : null;
        return outerBaseType != null && MetadataHelper.isEnclosedBy(inner, outerBaseType) || innerResolved != null && MetadataHelper.isEnclosedBy(innerResolved.getBaseType(), outer);
    }

    public static boolean canReferenceTypeVariablesOf(TypeReference declaringType, TypeReference referenceSite) {
        if (declaringType == null || referenceSite == null) {
            return false;
        }
        if (declaringType == referenceSite) {
            return declaringType.isGenericType();
        }
        TypeReference current = referenceSite.getDeclaringType();
        while (current != null) {
            MethodReference declaringMethod;
            if (MetadataHelper.isSameType(current, declaringType)) {
                return true;
            }
            TypeDefinition resolvedType = current.resolve();
            if (resolvedType != null && (declaringMethod = resolvedType.getDeclaringMethod()) != null) {
                current = declaringMethod.getDeclaringType();
                continue;
            }
            current = current.getDeclaringType();
        }
        return false;
    }

    public static TypeReference findCommonSuperType(TypeReference type1, TypeReference type2) {
        VerifyArgument.notNull(type1, "type1");
        VerifyArgument.notNull(type2, "type2");
        if (type1 == type2) {
            return type1;
        }
        if (type1.isPrimitive()) {
            if (type2.isPrimitive()) {
                if (MetadataHelper.isAssignableFrom(type1, type2)) {
                    return type1;
                }
                if (MetadataHelper.isAssignableFrom(type2, type1)) {
                    return type2;
                }
                return MetadataHelper.doNumericPromotion(type1, type2);
            }
            return MetadataHelper.findCommonSuperType(MetadataHelper.getBoxedTypeOrSelf(type1), type2);
        }
        if (type2.isPrimitive()) {
            return MetadataHelper.findCommonSuperType(type1, MetadataHelper.getBoxedTypeOrSelf(type2));
        }
        int rank1 = 0;
        int rank2 = 0;
        TypeReference elementType1 = type1;
        TypeReference elementType2 = type2;
        while (elementType1.isArray()) {
            elementType1 = elementType1.getElementType();
            ++rank1;
        }
        while (elementType2.isArray()) {
            elementType2 = elementType2.getElementType();
            ++rank2;
        }
        if (rank1 != rank2) {
            return BuiltinTypes.Object;
        }
        if (rank1 != 0 && (elementType1.isPrimitive() || elementType2.isPrimitive())) {
            if (elementType1.isPrimitive() && elementType2.isPrimitive()) {
                TypeReference promotedType = MetadataHelper.doNumericPromotion(elementType1, elementType2);
                while (rank1-- > 0) {
                    promotedType = promotedType.makeArrayType();
                }
                return promotedType;
            }
            return BuiltinTypes.Object;
        }
        while (!elementType1.isUnbounded()) {
            elementType1 = elementType1.hasSuperBound() ? elementType1.getSuperBound() : elementType1.getExtendsBound();
        }
        while (!elementType2.isUnbounded()) {
            elementType2 = elementType2.hasSuperBound() ? elementType2.getSuperBound() : elementType2.getExtendsBound();
        }
        TypeReference result = MetadataHelper.findCommonSuperTypeCore(elementType1, elementType2);
        while (rank1-- > 0) {
            result = result.makeArrayType();
        }
        return result;
    }

    private static TypeReference doNumericPromotion(TypeReference leftType, TypeReference rightType) {
        JvmType right;
        JvmType left = leftType.getSimpleType();
        if (left == (right = rightType.getSimpleType())) {
            return leftType;
        }
        if (left == JvmType.Double || right == JvmType.Double) {
            return BuiltinTypes.Double;
        }
        if (left == JvmType.Float || right == JvmType.Float) {
            return BuiltinTypes.Float;
        }
        if (left == JvmType.Long || right == JvmType.Long) {
            return BuiltinTypes.Long;
        }
        if (left.isNumeric() && left != JvmType.Boolean || right.isNumeric() && right != JvmType.Boolean) {
            return BuiltinTypes.Integer;
        }
        return leftType;
    }

    private static TypeReference findCommonSuperTypeCore(TypeReference type1, TypeReference type2) {
        if (MetadataHelper.isAssignableFrom(type1, type2)) {
            TypeDefinition resolved1;
            if (type2.isGenericType() && !type1.isGenericType() && (resolved1 = type1.resolve()) != null) {
                return MetadataHelper.substituteGenericArguments((TypeReference)resolved1, type2);
            }
            return MetadataHelper.substituteGenericArguments(type1, type2);
        }
        if (MetadataHelper.isAssignableFrom(type2, type1)) {
            TypeDefinition resolved2;
            if (type1.isGenericType() && !type2.isGenericType() && (resolved2 = type2.resolve()) != null) {
                return MetadataHelper.substituteGenericArguments((TypeReference)resolved2, type1);
            }
            return MetadataHelper.substituteGenericArguments(type2, type1);
        }
        TypeDefinition c = type1.resolve();
        TypeDefinition d = type2.resolve();
        if (c == null || d == null || c.isInterface() || d.isInterface()) {
            return BuiltinTypes.Object;
        }
        TypeReference current = c;
        while (current != null) {
            for (TypeReference interfaceType : MetadataHelper.getInterfaces(current)) {
                if (!MetadataHelper.isAssignableFrom(interfaceType, d)) continue;
                return interfaceType;
            }
            if ((current = MetadataHelper.getBaseType(current)) == null || !MetadataHelper.isAssignableFrom(current, d)) continue;
            return current;
        }
        return BuiltinTypes.Object;
    }

    public static ConversionType getConversionType(ICompoundType targetType, TypeReference source) {
        VerifyArgument.notNull(targetType, "targetType");
        VerifyArgument.notNull(source, "source");
        ConversionType bestConversion = ConversionType.EXPLICIT;
        TypeReference baseType = targetType.getBaseType();
        if (baseType != null && (bestConversion = Comparer.min(bestConversion, MetadataHelper.conversionType0(baseType, source, false))) == ConversionType.IDENTITY) {
            return bestConversion;
        }
        for (TypeReference ifType : targetType.getInterfaces()) {
            if ((bestConversion = Comparer.min(bestConversion, MetadataHelper.conversionType0(ifType, source, false))) != ConversionType.IDENTITY) continue;
            return bestConversion;
        }
        return bestConversion;
    }

    public static ConversionType getConversionType(TypeReference targetType, ICompoundType source) {
        VerifyArgument.notNull(targetType, "targetType");
        VerifyArgument.notNull(source, "source");
        ConversionType bestConversion = ConversionType.EXPLICIT;
        TypeReference baseType = source.getBaseType();
        if (baseType != null && (bestConversion = Comparer.min(bestConversion, MetadataHelper.conversionType0(targetType, baseType, true))) == ConversionType.IDENTITY) {
            return bestConversion;
        }
        for (TypeReference ifType : source.getInterfaces()) {
            if ((bestConversion = Comparer.min(bestConversion, MetadataHelper.conversionType0(targetType, ifType, true))) != ConversionType.IDENTITY) continue;
            return bestConversion;
        }
        return bestConversion;
    }

    public static ConversionType getConversionType(TypeReference target, TypeReference source) {
        return MetadataHelper.conversionType0(target, source, true);
    }

    private static ConversionType conversionType0(TypeReference target, TypeReference source, boolean processCompoundTypes) {
        ConversionType boundConversion;
        TypeReference bound;
        VerifyArgument.notNull(target, "target");
        VerifyArgument.notNull(source, "source");
        TypeReference underlyingTarget = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(target);
        TypeReference underlyingSource = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(source);
        if (underlyingTarget.getSimpleType().isNumeric() && underlyingSource.getSimpleType().isNumeric()) {
            return MetadataHelper.getNumericConversionType(target, source);
        }
        if (StringUtilities.equals(target.getInternalName(), "java/lang/Object")) {
            return ConversionType.IMPLICIT;
        }
        if (MetadataHelper.isSameType(target, source, true)) {
            return ConversionType.IDENTITY;
        }
        if (MetadataHelper.isAssignableFrom(target, source, false)) {
            return ConversionType.IMPLICIT;
        }
        if (processCompoundTypes) {
            if (underlyingTarget.isCompoundType() && underlyingTarget instanceof ICompoundType) {
                return MetadataHelper.getConversionType((ICompoundType)((Object)underlyingTarget), underlyingSource);
            }
            if (underlyingSource.isCompoundType() && underlyingSource instanceof ICompoundType) {
                return MetadataHelper.getConversionType(underlyingTarget, (ICompoundType)((Object)underlyingSource));
            }
        }
        if (source.isGenericParameter() && (bound = source.getExtendsBound()) != null && !BuiltinTypes.Object.isEquivalentTo(bound) && !MetadataHelper.isSameType(source, bound) && Comparer.compare(boundConversion = MetadataHelper.conversionType0(target, bound, processCompoundTypes), ConversionType.EXPLICIT) < 0) {
            return boundConversion;
        }
        int targetRank = 0;
        int sourceRank = 0;
        TypeReference targetElementType = target;
        TypeReference sourceElementType = source;
        while (targetElementType.isArray()) {
            ++targetRank;
            targetElementType = targetElementType.getElementType();
        }
        while (sourceElementType.isArray()) {
            ++sourceRank;
            sourceElementType = sourceElementType.getElementType();
        }
        if (sourceRank != targetRank) {
            if (MetadataHelper.isSameType(sourceElementType, BuiltinTypes.Object)) {
                return ConversionType.EXPLICIT;
            }
            return ConversionType.NONE;
        }
        return ConversionType.EXPLICIT;
    }

    @NotNull
    public static ConversionType getNumericConversionType(TypeReference target, TypeReference source) {
        JvmType sourceJvmType;
        VerifyArgument.notNull(source, "source");
        VerifyArgument.notNull(target, "target");
        if (MetadataHelper.isSameType(target, source)) {
            return ConversionType.IDENTITY;
        }
        if (!source.isPrimitive()) {
            TypeReference unboxedSourceType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(source);
            if (unboxedSourceType == source || unboxedSourceType == BuiltinTypes.Void) {
                return ConversionType.NONE;
            }
            ConversionType unboxedConversion = MetadataHelper.getNumericConversionType(target, unboxedSourceType);
            switch (unboxedConversion) {
                case IDENTITY: 
                case IMPLICIT: {
                    return ConversionType.IMPLICIT;
                }
                case IMPLICIT_LOSSY: {
                    return ConversionType.IMPLICIT_LOSSY;
                }
                case EXPLICIT: {
                    return ConversionType.NONE;
                }
            }
            return unboxedConversion;
        }
        if (!target.isPrimitive()) {
            TypeReference unboxedTargetType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(target);
            if (unboxedTargetType == target || unboxedTargetType == BuiltinTypes.Void) {
                return ConversionType.NONE;
            }
            switch (MetadataHelper.getNumericConversionType(unboxedTargetType, source)) {
                case IDENTITY: {
                    return ConversionType.IMPLICIT;
                }
                case IMPLICIT: {
                    return ConversionType.EXPLICIT_TO_UNBOXED;
                }
                case IMPLICIT_LOSSY: {
                    return ConversionType.EXPLICIT;
                }
            }
            return ConversionType.NONE;
        }
        JvmType targetJvmType = target.getSimpleType();
        if (targetJvmType == (sourceJvmType = source.getSimpleType())) {
            return ConversionType.IDENTITY;
        }
        if (sourceJvmType == JvmType.Boolean) {
            return ConversionType.NONE;
        }
        switch (targetJvmType) {
            case Float: 
            case Double: {
                if (sourceJvmType.isIntegral()) {
                    return sourceJvmType.bitWidth() >= targetJvmType.bitWidth() ? ConversionType.IMPLICIT_LOSSY : ConversionType.IMPLICIT;
                }
                return sourceJvmType.bitWidth() <= targetJvmType.bitWidth() ? ConversionType.IMPLICIT : ConversionType.EXPLICIT;
            }
            case Byte: 
            case Short: {
                if (sourceJvmType == JvmType.Character) {
                    return ConversionType.EXPLICIT;
                }
            }
            case Integer: 
            case Long: {
                if (sourceJvmType.isIntegral() && sourceJvmType.bitWidth() <= targetJvmType.bitWidth()) {
                    return ConversionType.IMPLICIT;
                }
                return ConversionType.EXPLICIT;
            }
            case Character: {
                return sourceJvmType.isNumeric() ? ConversionType.EXPLICIT : ConversionType.NONE;
            }
        }
        return ConversionType.NONE;
    }

    public static boolean hasImplicitNumericConversion(TypeReference target, TypeReference source) {
        JvmType sourceJvmType;
        VerifyArgument.notNull(source, "source");
        VerifyArgument.notNull(target, "target");
        if (target == source) {
            return true;
        }
        if (!target.isPrimitive() || !source.isPrimitive()) {
            return false;
        }
        JvmType targetJvmType = target.getSimpleType();
        if (targetJvmType == (sourceJvmType = source.getSimpleType())) {
            return true;
        }
        if (sourceJvmType == JvmType.Boolean) {
            return false;
        }
        switch (targetJvmType) {
            case Float: 
            case Double: {
                return sourceJvmType.bitWidth() <= targetJvmType.bitWidth();
            }
            case Byte: 
            case Short: 
            case Integer: 
            case Long: {
                return sourceJvmType.isIntegral() && sourceJvmType.bitWidth() <= targetJvmType.bitWidth();
            }
        }
        return false;
    }

    public static boolean isConvertible(TypeReference source, TypeReference target) {
        return MetadataHelper.isConvertible(source, target, true);
    }

    public static boolean isConvertible(TypeReference source, TypeReference target, boolean allowUnchecked) {
        VerifyArgument.notNull(source, "source");
        VerifyArgument.notNull(target, "target");
        boolean tPrimitive = target.isPrimitive();
        boolean sPrimitive = source.isPrimitive();
        if (source == BuiltinTypes.Null) {
            return !tPrimitive;
        }
        if (target.isWildcardType() && target.isUnbounded()) {
            return !sPrimitive;
        }
        if (tPrimitive == sPrimitive) {
            return allowUnchecked ? MetadataHelper.isSubTypeUnchecked(source, target) : MetadataHelper.isSubType(source, target);
        }
        if (tPrimitive) {
            return MetadataHelper.getNumericConversionType(target, source).isImplicit();
        }
        return allowUnchecked ? MetadataHelper.isSubTypeUnchecked(MetadataHelper.getBoxedTypeOrSelf(source), target) : MetadataHelper.isSubType(MetadataHelper.getBoxedTypeOrSelf(source), target);
    }

    private static boolean isSubTypeUnchecked(TypeReference t2, TypeReference s2) {
        return MetadataHelper.isSubtypeUncheckedInternal(t2, s2);
    }

    private static boolean isSubtypeUncheckedInternal(TypeReference t2, TypeReference s2) {
        if (t2 == s2) {
            return true;
        }
        if (t2 == null || s2 == null) {
            return false;
        }
        if (t2.isArray() && s2.isArray()) {
            if (t2.getElementType().isPrimitive()) {
                return MetadataHelper.isSameType(MetadataHelper.getElementType(t2), MetadataHelper.getElementType(s2));
            }
            return MetadataHelper.isSubTypeUnchecked(MetadataHelper.getElementType(t2), MetadataHelper.getElementType(s2));
        }
        if (MetadataHelper.isSubType(t2, s2)) {
            return true;
        }
        if (t2.isGenericParameter() && t2.hasExtendsBound()) {
            return MetadataHelper.isSubTypeUnchecked(MetadataHelper.getUpperBound(t2), s2);
        }
        if (!MetadataHelper.isRawType(s2)) {
            TypeReference t22 = MetadataHelper.asSuper(s2, t2);
            return t22 != null && MetadataHelper.isRawType(t22);
        }
        return false;
    }

    public static boolean isAssignableFrom(TypeReference target, TypeReference source) {
        return MetadataHelper.isConvertible(source, target);
    }

    public static boolean isAssignableFrom(TypeReference target, TypeReference source, boolean allowUnchecked) {
        return MetadataHelper.isConvertible(source, target, allowUnchecked);
    }

    public static boolean isSubType(TypeReference type, TypeReference baseType) {
        VerifyArgument.notNull(type, "type");
        VerifyArgument.notNull(baseType, "baseType");
        return MetadataHelper.isSubType(type, baseType, true);
    }

    public static boolean isBytecodeCastAssignable(TypeReference target, TypeReference castType) {
        TypeReference erasedCast = MetadataHelper.eraseRecursive(castType);
        TypeReference upper = MetadataHelper.getUpperBound(target);
        if (upper instanceof ICompoundType) {
            ICompoundType c = (ICompoundType)((Object)upper);
            TypeReference baseType = c.getBaseType();
            if (baseType != null && (baseType != BuiltinTypes.Null || castType == BuiltinTypes.Null) && MetadataHelper.isSubType(erasedCast, baseType, true)) {
                return true;
            }
            for (TypeReference ifType : c.getInterfaces()) {
                if (!MetadataHelper.isSubType(erasedCast, ifType, true)) continue;
                return true;
            }
            return false;
        }
        return MetadataHelper.isSubType(erasedCast, upper, true);
    }

    public static boolean isPrimitiveBoxType(TypeReference type) {
        VerifyArgument.notNull(type, "type");
        switch (type.getInternalName()) {
            case "java/lang/Void": 
            case "java/lang/Boolean": 
            case "java/lang/Byte": 
            case "java/lang/Character": 
            case "java/lang/Short": 
            case "java/lang/Integer": 
            case "java/lang/Long": 
            case "java/lang/Float": 
            case "java/lang/Double": {
                return true;
            }
        }
        return false;
    }

    public static TypeReference getBoxedTypeOrSelf(TypeReference type) {
        VerifyArgument.notNull(type, "type");
        if (type.isPrimitive()) {
            switch (type.getSimpleType()) {
                case Boolean: {
                    return CommonTypeReferences.Boolean;
                }
                case Byte: {
                    return CommonTypeReferences.Byte;
                }
                case Character: {
                    return CommonTypeReferences.Character;
                }
                case Short: {
                    return CommonTypeReferences.Short;
                }
                case Integer: {
                    return CommonTypeReferences.Integer;
                }
                case Long: {
                    return CommonTypeReferences.Long;
                }
                case Float: {
                    return CommonTypeReferences.Float;
                }
                case Double: {
                    return CommonTypeReferences.Double;
                }
                case Void: {
                    return CommonTypeReferences.Void;
                }
            }
        }
        return type;
    }

    @NotNull
    public static TypeReference getUnderlyingPrimitiveTypeOrSelf(@NotNull TypeReference type) {
        VerifyArgument.notNull(type, "type");
        if (type.isPrimitive()) {
            return type;
        }
        switch (type.getInternalName()) {
            case "java/lang/Void": {
                return BuiltinTypes.Void;
            }
            case "java/lang/Boolean": {
                return BuiltinTypes.Boolean;
            }
            case "java/lang/Byte": {
                return BuiltinTypes.Byte;
            }
            case "java/lang/Character": {
                return BuiltinTypes.Character;
            }
            case "java/lang/Short": {
                return BuiltinTypes.Short;
            }
            case "java/lang/Integer": {
                return BuiltinTypes.Integer;
            }
            case "java/lang/Long": {
                return BuiltinTypes.Long;
            }
            case "java/lang/Float": {
                return BuiltinTypes.Float;
            }
            case "java/lang/Double": {
                return BuiltinTypes.Double;
            }
        }
        return type;
    }

    public static TypeReference getDeclaredType(TypeReference type) {
        if (type == null) {
            return null;
        }
        TypeDefinition resolvedType = type.resolve();
        if (resolvedType == null) {
            return type;
        }
        if (resolvedType.isAnonymous()) {
            TypeReference baseType;
            List<TypeReference> interfaces = resolvedType.getExplicitInterfaces();
            TypeReference typeReference = baseType = interfaces.isEmpty() ? resolvedType.getBaseType() : interfaces.get(0);
            if (baseType != null) {
                TypeReference asSuperType = MetadataHelper.asSuper(baseType, type);
                if (asSuperType != null) {
                    return asSuperType;
                }
                return baseType.isGenericType() ? new RawType(baseType) : baseType;
            }
        }
        return type;
    }

    public static TypeReference getBaseType(TypeReference type) {
        if (type == null) {
            return null;
        }
        TypeDefinition resolvedType = type.resolve();
        if (resolvedType == null) {
            return null;
        }
        TypeReference baseType = resolvedType.getBaseType();
        if (baseType == null) {
            return null;
        }
        return MetadataHelper.substituteGenericArguments(baseType, type);
    }

    public static List<TypeReference> getInterfaces(TypeReference type) {
        List<TypeReference> result = INTERFACES_VISITOR.visit(type);
        return result != null ? result : Collections.emptyList();
    }

    public static TypeReference asSubType(TypeReference type, TypeReference baseType) {
        VerifyArgument.notNull(type, "type");
        VerifyArgument.notNull(baseType, "baseType");
        TypeReference effectiveType = type;
        if (type instanceof RawType) {
            effectiveType = type.getUnderlyingType();
        } else if (MetadataHelper.isRawType(type)) {
            TypeDefinition resolvedType = type.resolve();
            effectiveType = resolvedType != null ? resolvedType : type;
        }
        return (TypeReference)AS_SUBTYPE_VISITOR.visit(baseType, effectiveType);
    }

    public static TypeReference asSuper(TypeReference type, TypeReference subType) {
        VerifyArgument.notNull(subType, "t");
        VerifyArgument.notNull(type, "s");
        return (TypeReference)AS_SUPER_VISITOR.visit(subType, type);
    }

    public static Map<TypeReference, TypeReference> getGenericSubTypeMappings(TypeReference type, TypeReference baseType) {
        VerifyArgument.notNull(type, "type");
        VerifyArgument.notNull(baseType, "baseType");
        if (type.isArray() && baseType.isArray()) {
            TypeReference elementType = type.getElementType();
            TypeReference baseElementType = baseType.getElementType();
            while (elementType.isArray() && baseElementType.isArray()) {
                elementType = elementType.getElementType();
                baseElementType = baseElementType.getElementType();
            }
            return MetadataHelper.getGenericSubTypeMappings(elementType, baseElementType);
        }
        TypeReference current = type;
        List<TypeReference> baseArguments = baseType.isGenericDefinition() ? baseType.getGenericParameters() : (baseType.isGenericType() ? ((IGenericInstance)((Object)baseType)).getTypeArguments() : Collections.emptyList());
        TypeDefinition resolvedBaseType = baseType.resolve();
        while (current != null) {
            TypeDefinition resolved = current.resolve();
            if (resolvedBaseType != null && resolvedBaseType.isGenericDefinition() && MetadataHelper.isSameType(resolved, resolvedBaseType)) {
                if (current instanceof IGenericInstance && baseType instanceof IGenericInstance) {
                    List<TypeReference> typeArguments = ((IGenericInstance)((Object)current)).getTypeArguments();
                    if (baseArguments.size() == typeArguments.size()) {
                        HashMap<TypeReference, TypeReference> map = new HashMap<TypeReference, TypeReference>();
                        for (int i = 0; i < typeArguments.size(); ++i) {
                            map.put(typeArguments.get(i), baseArguments.get(i));
                        }
                        return map;
                    }
                } else if (baseType instanceof IGenericInstance && resolved.isGenericDefinition()) {
                    List<GenericParameter> genericParameters = resolved.getGenericParameters();
                    List<TypeReference> typeArguments = ((IGenericInstance)((Object)baseType)).getTypeArguments();
                    if (genericParameters.size() == typeArguments.size()) {
                        HashMap<TypeReference, TypeReference> map = new HashMap<TypeReference, TypeReference>();
                        for (int i = 0; i < typeArguments.size(); ++i) {
                            map.put(genericParameters.get(i), typeArguments.get(i));
                        }
                        return map;
                    }
                }
            }
            if (resolvedBaseType != null && resolvedBaseType.isInterface()) {
                for (TypeReference interfaceType : MetadataHelper.getInterfaces(current)) {
                    Map<TypeReference, TypeReference> interfaceMap = MetadataHelper.getGenericSubTypeMappings(interfaceType, baseType);
                    if (interfaceMap.isEmpty()) continue;
                    return interfaceMap;
                }
            }
            current = MetadataHelper.getBaseType(current);
        }
        return Collections.emptyMap();
    }

    public static MethodReference asMemberOf(MethodReference method, TypeReference baseType) {
        MethodReference asMember;
        VerifyArgument.notNull(method, "method");
        VerifyArgument.notNull(baseType, "baseType");
        TypeReference base = baseType;
        if (baseType instanceof RawType) {
            asMember = MetadataHelper.erase(method);
        } else {
            Map<TypeReference, TypeReference> map;
            while (base.isGenericParameter() || base.isWildcardType()) {
                if (base.hasExtendsBound()) {
                    base = MetadataHelper.getUpperBound(base);
                    continue;
                }
                base = BuiltinTypes.Object;
            }
            TypeReference asSuper = MetadataHelper.asSuper(method.getDeclaringType(), base);
            try {
                map = MetadataHelper.adapt(method.getDeclaringType(), asSuper != null ? asSuper : base);
            }
            catch (AdaptFailure ignored) {
                map = MetadataHelper.getGenericSubTypeMappings(method.getDeclaringType(), asSuper != null ? asSuper : base);
            }
            asMember = TypeSubstitutionVisitor.instance().visitMethod(method, map);
            if (asMember != method && asMember instanceof GenericMethodInstance) {
                ((GenericMethodInstance)asMember).setDeclaringType(asSuper != null ? asSuper : base);
            }
        }
        MethodReference result = MetadataHelper.specializeIfNecessary(method, asMember, base);
        return result;
    }

    private static MethodReference specializeIfNecessary(MethodReference originalMethod, MethodReference asMember, TypeReference baseType) {
        if (baseType.isArray() && StringUtilities.equals(asMember.getName(), "clone") && asMember.getParameters().isEmpty()) {
            return MetadataHelper.ensureReturnType(originalMethod, asMember, baseType, baseType);
        }
        if (StringUtilities.equals(asMember.getName(), "getClass") && asMember.getParameters().isEmpty()) {
            TypeDefinition resolvedClassType;
            TypeReference classType;
            TypeDefinition resolvedType = baseType.resolve();
            if (resolvedType == null || (classType = resolvedType.getResolver().lookupType("java/lang/Class")) == null || (resolvedClassType = classType.resolve()) == null) {
                resolvedType = originalMethod.getDeclaringType().resolve();
            }
            if (resolvedType == null || (classType = resolvedType.getResolver().lookupType("java/lang/Class")) == null || (resolvedClassType = classType.resolve()) == null) {
                return asMember;
            }
            if (resolvedClassType.isGenericType()) {
                MethodDefinition resolvedMethod = originalMethod.resolve();
                return new GenericMethodInstance(baseType, resolvedMethod != null ? resolvedMethod : asMember, resolvedClassType.makeGenericType(WildcardType.makeExtends(MetadataHelper.erase(baseType))), Collections.emptyList(), Collections.emptyList());
            }
            return asMember;
        }
        return asMember;
    }

    private static MethodReference ensureReturnType(MethodReference originalMethod, MethodReference method, TypeReference returnType, TypeReference declaringType) {
        if (MetadataHelper.isSameType(method.getReturnType(), returnType, true)) {
            return method;
        }
        MethodDefinition resolvedMethod = originalMethod.resolve();
        List<TypeReference> typeArguments = method instanceof IGenericInstance && method.isGenericMethod() ? ((IGenericInstance)((Object)method)).getTypeArguments() : Collections.emptyList();
        MethodReference definition = resolvedMethod != null ? resolvedMethod : originalMethod;
        return new GenericMethodInstance(declaringType, definition, returnType, MetadataHelper.copyParameters(method.getParameters()), typeArguments);
    }

    @NotNull
    static List<TypeReference> checkTypeArguments(@Nullable IGenericParameterProvider owner, @NotNull List<TypeReference> typeArguments) {
        boolean allowWildcards;
        boolean bl = allowWildcards = !(owner instanceof IMethodSignature);
        if (typeArguments.isEmpty() || allowWildcards) {
            return typeArguments;
        }
        boolean valid = true;
        for (TypeReference t2 : typeArguments) {
            if (!t2.isWildcardType() && !(t2 instanceof ICapturedType)) continue;
            valid = false;
            break;
        }
        if (valid) {
            return typeArguments;
        }
        TypeReference[] adjustedTypeArguments = typeArguments.toArray(TypeReference.EMPTY_REFERENCES);
        for (int i = 0; i < adjustedTypeArguments.length; ++i) {
            TypeReference t3 = adjustedTypeArguments[i];
            if (!t3.isWildcardType() && !(t3 instanceof ICapturedType)) continue;
            adjustedTypeArguments[i] = t3.getExtendsBound();
        }
        return ArrayUtilities.asUnmodifiableList(adjustedTypeArguments);
    }

    public static FieldReference asMemberOf(FieldReference field, TypeReference baseType) {
        VerifyArgument.notNull(field, "field");
        VerifyArgument.notNull(baseType, "baseType");
        Map<TypeReference, TypeReference> map = MetadataHelper.adapt(field.getDeclaringType(), baseType);
        return TypeSubstitutionVisitor.instance().visitField(field, map);
    }

    public static TypeReference asMemberOf(TypeReference innerType, TypeReference baseType) {
        VerifyArgument.notNull(innerType, "innerType");
        VerifyArgument.notNull(baseType, "baseType");
        Map<TypeReference, TypeReference> map = MetadataHelper.adapt(innerType.getDeclaringType(), baseType);
        return TypeSubstitutionVisitor.instance().visit(innerType, map);
    }

    public static TypeReference substituteGenericArguments(TypeReference inputType, TypeReference substitutionsProvider) {
        if (inputType == null || substitutionsProvider == null) {
            return inputType;
        }
        return MetadataHelper.substituteGenericArguments(inputType, MetadataHelper.adapt(inputType, substitutionsProvider));
    }

    public static TypeReference substituteGenericArguments(TypeReference inputType, MethodReference substitutionsProvider) {
        int i;
        List<Object> typeArguments;
        List<Object> genericParameters;
        if (inputType == null) {
            return null;
        }
        if (substitutionsProvider == null || !MetadataHelper.isGenericSubstitutionNeeded(inputType)) {
            return inputType;
        }
        TypeReference declaringType = substitutionsProvider.getDeclaringType();
        assert (declaringType != null);
        if (!substitutionsProvider.isGenericMethod() && !declaringType.isGenericType()) {
            return null;
        }
        List<Object> methodGenericParameters = substitutionsProvider.isGenericMethod() ? substitutionsProvider.getGenericParameters() : Collections.emptyList();
        List<Object> methodTypeArguments = substitutionsProvider.isGenericDefinition() ? methodGenericParameters : ((IGenericInstance)((Object)substitutionsProvider)).getTypeArguments();
        if (declaringType.isGenericType()) {
            genericParameters = declaringType.getGenericParameters();
            typeArguments = declaringType.isGenericDefinition() ? genericParameters : ((IGenericInstance)((Object)declaringType)).getTypeArguments();
        } else {
            genericParameters = Collections.emptyList();
            typeArguments = Collections.emptyList();
        }
        if (methodTypeArguments.isEmpty() && typeArguments.isEmpty()) {
            return inputType;
        }
        HashMap<TypeReference, TypeReference> map = new HashMap<TypeReference, TypeReference>();
        if (methodTypeArguments.size() == methodGenericParameters.size()) {
            for (i = 0; i < methodTypeArguments.size(); ++i) {
                map.put((TypeReference)methodGenericParameters.get(i), (TypeReference)methodTypeArguments.get(i));
            }
        }
        if (typeArguments.size() == genericParameters.size()) {
            for (i = 0; i < typeArguments.size(); ++i) {
                map.put((TypeReference)genericParameters.get(i), (TypeReference)typeArguments.get(i));
            }
        }
        return MetadataHelper.substituteGenericArguments(inputType, map);
    }

    public static TypeReference substituteGenericArguments(TypeReference inputType, Map<TypeReference, TypeReference> substitutionsProvider) {
        if (inputType == null) {
            return null;
        }
        if (substitutionsProvider == null || substitutionsProvider.isEmpty()) {
            return inputType;
        }
        return TypeSubstitutionVisitor.instance().visit(inputType, substitutionsProvider);
    }

    private static boolean isGenericSubstitutionNeeded(TypeReference type) {
        if (type == null) {
            return false;
        }
        TypeDefinition resolvedType = type.resolve();
        return resolvedType != null && resolvedType.containsGenericParameters();
    }

    public static List<MethodReference> findMethods(TypeReference type) {
        return MetadataHelper.findMethods(type, Predicates.alwaysTrue());
    }

    public static List<MethodReference> findMethods(TypeReference type, Predicate<? super MethodReference> filter) {
        return MetadataHelper.findMethods(type, filter, false);
    }

    public static List<MethodReference> findMethods(TypeReference type, Predicate<? super MethodReference> filter, boolean includeBridgeMethods) {
        return MetadataHelper.findMethods(type, filter, includeBridgeMethods, false);
    }

    public static List<MethodReference> findMethods(TypeReference type, Predicate<? super MethodReference> filter, boolean includeBridgeMethods, boolean includeOverriddenMethods) {
        TypeDefinition resolvedType;
        VerifyArgument.notNull(type, "type");
        VerifyArgument.notNull(filter, "filter");
        HashSet<String> descriptors = new HashSet<String>();
        ArrayDeque<TypeReference> agenda = new ArrayDeque<TypeReference>();
        List<MethodReference> results = null;
        agenda.addLast(MetadataHelper.getUpperBound(type));
        descriptors.add(type.getInternalName());
        while (!agenda.isEmpty() && (resolvedType = ((TypeReference)agenda.removeFirst()).resolve()) != null) {
            TypeReference baseType = resolvedType.getBaseType();
            if (baseType != null && descriptors.add(baseType.getInternalName())) {
                agenda.addLast(baseType);
            }
            for (TypeReference interfaceType : resolvedType.getExplicitInterfaces()) {
                if (interfaceType == null || !descriptors.add(interfaceType.getInternalName())) continue;
                agenda.addLast(interfaceType);
            }
            for (MethodDefinition method : resolvedType.getDeclaredMethods()) {
                MethodReference asMember;
                String key;
                if (!includeBridgeMethods && method.isBridgeMethod() || !filter.test(method) || !descriptors.add(key = (includeOverriddenMethods ? method.getFullName() : method.getName()) + ":" + method.getErasedSignature())) continue;
                if (results == null) {
                    results = new ArrayList<MethodReference>();
                }
                results.add((asMember = MetadataHelper.asMemberOf(method, type)) != null ? asMember : method);
            }
        }
        return results != null ? results : Collections.emptyList();
    }

    public static boolean isOverloadCheckingRequired(MethodReference method) {
        MethodDefinition resolved = method.resolve();
        final boolean isVarArgs = resolved != null && resolved.isVarArgs();
        TypeReference declaringType = (resolved != null ? resolved : method).getDeclaringType();
        final int parameterCount = (resolved != null ? resolved.getParameters() : method.getParameters()).size();
        List<MethodReference> methods = MetadataHelper.findMethods(declaringType, Predicates.and(MetadataFilters.matchName(method.getName()), new Predicate<MethodReference>(){

            @Override
            public boolean test(MethodReference m4) {
                MethodDefinition r;
                List<ParameterDefinition> p = m4.getParameters();
                MethodDefinition methodDefinition = r = m4 instanceof MethodDefinition ? (MethodDefinition)m4 : m4.resolve();
                if (r != null && r.isBridgeMethod()) {
                    return false;
                }
                if (isVarArgs) {
                    return r != null && r.isVarArgs() || p.size() >= parameterCount;
                }
                if (p.size() < parameterCount) {
                    return r != null && r.isVarArgs();
                }
                return p.size() == parameterCount;
            }
        }));
        return methods.size() > 1;
    }

    public static boolean isInterface(TypeReference t2) {
        TypeDefinition resolvedType = t2.resolve();
        return resolvedType != null && resolvedType.isInterface();
    }

    public static TypeReference getLowerBound(TypeReference t2) {
        return (TypeReference)LOWER_BOUND_VISITOR.visit(t2);
    }

    public static TypeReference getUpperBound(TypeReference t2) {
        return (TypeReference)UPPER_BOUND_VISITOR.visit(t2);
    }

    public static TypeReference getElementType(TypeReference t2) {
        if (t2.isArray()) {
            return t2.getElementType();
        }
        if (t2.isWildcardType()) {
            return MetadataHelper.getElementType(MetadataHelper.getUpperBound(t2));
        }
        return null;
    }

    public static TypeReference getSuperType(TypeReference t2) {
        if (t2 == null) {
            return null;
        }
        return (TypeReference)SUPER_VISITOR.visit(t2);
    }

    public static boolean isSubTypeNoCapture(TypeReference type, TypeReference baseType) {
        return MetadataHelper.isSubType(type, baseType, false);
    }

    public static boolean isSubType(TypeReference type, TypeReference baseType, boolean capture) {
        if (type == baseType) {
            return true;
        }
        if (type == null || baseType == null) {
            return false;
        }
        if (baseType instanceof ICompoundType) {
            ICompoundType c = (ICompoundType)((Object)baseType);
            TypeReference superType = MetadataHelper.getSuperType(baseType);
            if (!MetadataHelper.isSameType(superType, (TypeReference)((Object)c)) && !MetadataHelper.isSubType(type, superType, capture)) {
                return false;
            }
            for (TypeReference interfaceType : c.getInterfaces()) {
                if (MetadataHelper.isSubType(type, interfaceType, capture)) continue;
                return false;
            }
            return true;
        }
        TypeReference lower = MetadataHelper.getLowerBound(baseType);
        if (lower != baseType) {
            return MetadataHelper.isSubType(capture ? MetadataHelper.capture(type) : type, lower, false);
        }
        return (Boolean)IS_SUBTYPE_VISITOR.visit(capture ? MetadataHelper.capture(type) : type, baseType);
    }

    private static TypeReference capture(TypeReference type) {
        return type;
    }

    public static Map<TypeReference, TypeReference> adapt(TypeReference source, TypeReference target) {
        Adapter adapter = new Adapter();
        adapter.visit(source, target);
        return adapter.mapping;
    }

    private static Map<TypeReference, TypeReference> adaptSelf(TypeReference t2) {
        TypeDefinition r = t2.resolve();
        return r != null ? MetadataHelper.adapt(r, t2) : Collections.emptyMap();
    }

    private static TypeReference rewriteSupers(TypeReference t2) {
        if (!(t2 instanceof IGenericInstance)) {
            return t2;
        }
        Map<TypeReference, TypeReference> map = MetadataHelper.adaptSelf(t2);
        if (map.isEmpty()) {
            return t2;
        }
        HashMap<TypeReference, TypeReference> rewrite = null;
        for (TypeReference k : map.keySet()) {
            TypeReference original = map.get(k);
            TypeReference s2 = MetadataHelper.rewriteSupers(original);
            if (s2.hasSuperBound() && !s2.hasExtendsBound()) {
                s2 = WildcardType.unbounded();
                if (rewrite == null) {
                    rewrite = new HashMap<TypeReference, TypeReference>(map);
                }
            } else if (s2 != original) {
                s2 = WildcardType.makeExtends(MetadataHelper.getUpperBound(s2));
                if (rewrite == null) {
                    rewrite = new HashMap<TypeReference, TypeReference>(map);
                }
            }
            if (rewrite == null) continue;
            map.put(k, s2);
        }
        if (rewrite != null) {
            return MetadataHelper.substituteGenericArguments(t2, rewrite);
        }
        return t2;
    }

    public static boolean containsType(TypeReference t2, TypeReference s2) {
        return (Boolean)CONTAINS_TYPE_VISITOR.visit(t2, s2);
    }

    public static boolean isSameType(TypeReference t2, TypeReference s2) {
        return MetadataHelper.isSameType(t2, s2, false);
    }

    public static boolean isSameType(TypeReference t2, TypeReference s2, boolean strict) {
        if (t2 == s2) {
            return true;
        }
        if (t2 == null || s2 == null) {
            return false;
        }
        return strict ? SAME_TYPE_VISITOR_STRICT.visit(t2, s2) : SAME_TYPE_VISITOR_LOOSE.visit(t2, s2);
    }

    public static boolean areSameTypes(List<? extends TypeReference> t2, List<? extends TypeReference> s2) {
        return MetadataHelper.areSameTypes(t2, s2, false);
    }

    public static boolean areSameTypes(List<? extends TypeReference> t2, List<? extends TypeReference> s2, boolean strict) {
        if (t2.size() != s2.size()) {
            return false;
        }
        int n = t2.size();
        for (int i = 0; i < n; ++i) {
            if (MetadataHelper.isSameType(t2.get(i), s2.get(i), strict)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCaptureOf(TypeReference t2, TypeReference s2) {
        return MetadataHelper.isSameWildcard(t2, s2);
    }

    private static boolean isSameWildcard(TypeReference t2, TypeReference s2) {
        VerifyArgument.notNull(t2, "t");
        VerifyArgument.notNull(s2, "s");
        if (!t2.isWildcardType() || !s2.isWildcardType()) {
            return false;
        }
        if (t2.isUnbounded()) {
            return s2.isUnbounded();
        }
        if (t2.hasSuperBound()) {
            return s2.hasSuperBound() && MetadataHelper.isSameType(t2.getSuperBound(), s2.getSuperBound());
        }
        return s2.hasExtendsBound() && MetadataHelper.isSameType(t2.getExtendsBound(), s2.getExtendsBound());
    }

    private static List<? extends TypeReference> getTypeArguments(TypeReference t2) {
        if (t2 instanceof IGenericInstance) {
            return ((IGenericInstance)((Object)t2)).getTypeArguments();
        }
        if (t2.isGenericType()) {
            return t2.getGenericParameters();
        }
        return Collections.emptyList();
    }

    private static boolean containsType(List<? extends TypeReference> t2, List<? extends TypeReference> s2) {
        if (t2.size() != s2.size()) {
            return false;
        }
        if (t2.isEmpty()) {
            return true;
        }
        int n = t2.size();
        for (int i = 0; i < n; ++i) {
            if (MetadataHelper.containsType(t2.get(i), s2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean containsTypeEquivalent(TypeReference t2, TypeReference s2) {
        return s2 == t2 || MetadataHelper.containsType(t2, s2) && MetadataHelper.containsType(s2, t2);
    }

    private static boolean containsTypeEquivalent(List<? extends TypeReference> t2, List<? extends TypeReference> s2) {
        if (t2.size() != s2.size()) {
            return false;
        }
        int n = t2.size();
        for (int i = 0; i < n; ++i) {
            if (MetadataHelper.containsTypeEquivalent(t2.get(i), s2.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsTypeRecursive(TypeReference t2, TypeReference s2) {
        Pair<TypeReference, TypeReference> pair;
        HashSet<Pair<TypeReference, TypeReference>> cache = CONTAINS_TYPE_CACHE.get();
        if (cache.add(pair = new Pair<TypeReference, TypeReference>(t2, s2))) {
            try {
                boolean bl = MetadataHelper.containsType(MetadataHelper.getTypeArguments(t2), MetadataHelper.getTypeArguments(s2));
                return bl;
            }
            finally {
                cache.remove(pair);
            }
        }
        return MetadataHelper.containsType(MetadataHelper.getTypeArguments(t2), MetadataHelper.getTypeArguments(MetadataHelper.rewriteSupers(s2)));
    }

    private static TypeReference arraySuperType(TypeReference t2) {
        TypeDefinition resolved = t2.resolve();
        if (resolved != null) {
            IMetadataResolver resolver = resolved.getResolver();
            TypeReference cloneable = resolver.lookupType("java/lang/Cloneable");
            TypeReference serializable = resolver.lookupType("java/io/Serializable");
            if (cloneable != null) {
                if (serializable != null) {
                    return new CompoundTypeReference(null, ArrayUtilities.asUnmodifiableList(cloneable, serializable), resolved.getResolver());
                }
                return cloneable;
            }
            if (serializable != null) {
                return serializable;
            }
        }
        return BuiltinTypes.Object;
    }

    public static boolean isRawType(TypeReference t2) {
        if (t2 == null) {
            return false;
        }
        if (t2 instanceof RawType) {
            return true;
        }
        if (t2.isGenericType()) {
            return false;
        }
        TypeDefinition r = t2.resolve();
        return r != null && r.isGenericType();
    }

    public static int getUnboundGenericParameterCount(TypeReference t2) {
        if (t2 == null || t2 instanceof RawType || !t2.isGenericType()) {
            return 0;
        }
        List<GenericParameter> genericParameters = t2.getGenericParameters();
        if (t2.isGenericDefinition()) {
            return genericParameters.size();
        }
        IGenericParameterProvider genericDefinition = ((IGenericInstance)((Object)t2)).getGenericDefinition();
        if (!genericDefinition.isGenericDefinition()) {
            return 0;
        }
        List<TypeReference> typeArguments = ((IGenericInstance)((Object)t2)).getTypeArguments();
        assert (genericParameters.size() == typeArguments.size());
        int count = 0;
        for (int i = 0; i < genericParameters.size(); ++i) {
            TypeReference typeArgument;
            GenericParameter genericParameter = genericParameters.get(i);
            if (!MetadataHelper.isSameType(genericParameter, typeArgument = typeArguments.get(i), true)) continue;
            ++count;
        }
        return count;
    }

    public static List<TypeReference> eraseRecursive(List<TypeReference> types) {
        List<TypeReference> result = null;
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            TypeReference type = types.get(i);
            TypeReference erased = MetadataHelper.eraseRecursive(type);
            if (result != null) {
                ((ArrayList)result).set(i, erased);
                continue;
            }
            if (type == erased) continue;
            result = new ArrayList<TypeReference>(types);
            ((ArrayList)result).set(i, erased);
        }
        return result != null ? result : types;
    }

    public static TypeReference eraseRecursive(TypeReference type) {
        return MetadataHelper.erase(type, true);
    }

    private static boolean eraseNotNeeded(TypeReference type) {
        return type == null || type instanceof RawType || type.isPrimitive() || StringUtilities.equals(type.getInternalName(), CommonTypeReferences.String.getInternalName());
    }

    public static TypeReference erase(TypeReference type) {
        return MetadataHelper.erase(type, false);
    }

    public static TypeReference erase(TypeReference type, boolean recurse) {
        if (MetadataHelper.eraseNotNeeded(type)) {
            return type;
        }
        return type.accept(ERASE_VISITOR, recurse);
    }

    public static MethodReference erase(MethodReference method) {
        if (method != null) {
            MethodReference baseMethod = method;
            MethodDefinition resolvedMethod = baseMethod.resolve();
            if (resolvedMethod != null) {
                baseMethod = resolvedMethod;
            } else if (baseMethod instanceof IGenericInstance) {
                baseMethod = (MethodReference)((IGenericInstance)((Object)baseMethod)).getGenericDefinition();
            }
            if (baseMethod != null) {
                return new RawMethod(baseMethod);
            }
        }
        return method;
    }

    private static TypeReference classBound(TypeReference t2) {
        return t2;
    }

    public static boolean isOverride(MethodDefinition method, MethodReference ancestorMethod) {
        TypeReference baseReturnType;
        TypeReference ancestorDeclaringType;
        int ancestorModifiers;
        MethodDefinition resolvedAncestor = ancestorMethod.resolve();
        if (resolvedAncestor == null || resolvedAncestor.isFinal() || resolvedAncestor.isPrivate() || resolvedAncestor.isStatic()) {
            return false;
        }
        int modifiers = method.getModifiers() & 7;
        if (modifiers != (ancestorModifiers = resolvedAncestor.getModifiers() & 7)) {
            return false;
        }
        if (!StringUtilities.equals(method.getName(), ancestorMethod.getName())) {
            return false;
        }
        if (method.getDeclaringType().isInterface()) {
            return false;
        }
        MethodDefinition resolved = method.resolve();
        TypeReference declaringType = MetadataHelper.erase(resolved != null ? resolved.getDeclaringType() : method.getDeclaringType());
        if (MetadataHelper.isSameType(declaringType, ancestorDeclaringType = MetadataHelper.erase(resolvedAncestor.getDeclaringType()))) {
            return false;
        }
        if (StringUtilities.equals(method.getErasedSignature(), ancestorMethod.getErasedSignature())) {
            return true;
        }
        if (!MetadataHelper.isSubType(declaringType, ancestorDeclaringType)) {
            return false;
        }
        List<ParameterDefinition> parameters = method.getParameters();
        List<ParameterDefinition> ancestorParameters = ancestorMethod.getParameters();
        if (parameters.size() != ancestorParameters.size()) {
            return false;
        }
        TypeReference ancestorReturnType = MetadataHelper.erase(ancestorMethod.getReturnType());
        if (!MetadataHelper.isAssignableFrom(ancestorReturnType, baseReturnType = MetadataHelper.erase(method.getReturnType()))) {
            return false;
        }
        int n = ancestorParameters.size();
        for (int i = 0; i < n; ++i) {
            TypeReference ancestorParameterType;
            TypeReference parameterType = MetadataHelper.erase(parameters.get(i).getParameterType());
            if (MetadataHelper.isSameType(parameterType, ancestorParameterType = MetadataHelper.erase(ancestorParameters.get(i).getParameterType()), false)) continue;
            return false;
        }
        return true;
    }

    static List<ParameterDefinition> copyParameters(List<ParameterDefinition> parameters) {
        ArrayList<ParameterDefinition> newParameters = new ArrayList<ParameterDefinition>();
        for (ParameterDefinition p : parameters) {
            if (p.hasName()) {
                newParameters.add(new ParameterDefinition(p.getSlot(), p.getName(), p.getParameterType()));
                continue;
            }
            newParameters.add(new ParameterDefinition(p.getSlot(), p.getParameterType()));
        }
        return newParameters;
    }

    static final class StrictSameTypeVisitor
    extends SameTypeVisitor {
        StrictSameTypeVisitor() {
        }

        @Override
        boolean areSameGenericParameters(GenericParameter gp1, GenericParameter gp2) {
            if (gp1 == gp2) {
                return true;
            }
            if (gp1 == null || gp2 == null) {
                return false;
            }
            if (!StringUtilities.equals(gp1.getName(), gp2.getName())) {
                return false;
            }
            IGenericParameterProvider owner1 = gp1.getOwner();
            IGenericParameterProvider owner2 = gp2.getOwner();
            if (owner1 == null || owner2 == null ? owner1 != owner2 : CollectionUtilities.indexOfByIdentity(owner1.getGenericParameters(), gp1) != CollectionUtilities.indexOfByIdentity(owner2.getGenericParameters(), gp2)) {
                return false;
            }
            if (owner1 == owner2) {
                return true;
            }
            if (owner1 instanceof TypeReference) {
                return owner2 instanceof TypeReference && StringUtilities.equals(gp1.getName(), gp2.getName()) && StringUtilities.equals(((TypeReference)owner1).getInternalName(), ((TypeReference)owner2).getInternalName());
            }
            return owner1 instanceof MethodReference && owner2 instanceof MethodReference && StringUtilities.equals(gp1.getName(), gp2.getName()) && StringUtilities.equals(((MethodReference)owner1).getFullName(), ((MethodReference)owner2).getFullName()) && StringUtilities.equals(((MethodReference)owner1).getErasedSignature(), ((MethodReference)owner2).getErasedSignature());
        }

        @Override
        protected boolean containsTypes(List<? extends TypeReference> t1, List<? extends TypeReference> t2) {
            return MetadataHelper.areSameTypes(t1, t2, true);
        }

        @Override
        public Boolean visitWildcard(WildcardType t2, TypeReference s2) {
            if (s2.isWildcardType()) {
                if (t2.isUnbounded()) {
                    return s2.isUnbounded();
                }
                if (t2.hasExtendsBound()) {
                    return s2.hasExtendsBound() && MetadataHelper.isSameType(t2.getExtendsBound(), s2.getExtendsBound());
                }
                return s2.hasSuperBound() && MetadataHelper.isSameType(t2.getSuperBound(), s2.getSuperBound());
            }
            return false;
        }
    }

    static final class LooseSameTypeVisitor
    extends SameTypeVisitor {
        LooseSameTypeVisitor() {
        }

        @Override
        boolean areSameGenericParameters(GenericParameter gp1, GenericParameter gp2) {
            if (gp1 == gp2) {
                return true;
            }
            if (gp1 == null || gp2 == null) {
                return false;
            }
            if (!StringUtilities.equals(gp1.getName(), gp2.getName())) {
                return false;
            }
            IGenericParameterProvider owner1 = gp1.getOwner();
            IGenericParameterProvider owner2 = gp2.getOwner();
            if (owner1.getGenericParameters().indexOf(gp1) != owner1.getGenericParameters().indexOf(gp2)) {
                return false;
            }
            if (owner1 == owner2) {
                return true;
            }
            if (owner1 instanceof TypeReference) {
                return owner2 instanceof TypeReference && StringUtilities.equals(((TypeReference)owner1).getInternalName(), ((TypeReference)owner2).getInternalName());
            }
            return owner1 instanceof MethodReference && owner2 instanceof MethodReference && StringUtilities.equals(((MethodReference)owner1).getFullName(), ((MethodReference)owner2).getFullName()) && StringUtilities.equals(((MethodReference)owner1).getErasedSignature(), ((MethodReference)owner2).getErasedSignature());
        }

        @Override
        protected boolean containsTypes(List<? extends TypeReference> t1, List<? extends TypeReference> t2) {
            return MetadataHelper.containsTypeEquivalent(t1, t2);
        }
    }

    static abstract class SameTypeVisitor
    extends TypeRelation {
        SameTypeVisitor() {
        }

        abstract boolean areSameGenericParameters(GenericParameter var1, GenericParameter var2);

        protected abstract boolean containsTypes(List<? extends TypeReference> var1, List<? extends TypeReference> var2);

        @Override
        public Boolean visit(TypeReference t2, TypeReference s2) {
            if (t2 == null) {
                return s2 == null;
            }
            if (s2 == null) {
                return false;
            }
            return t2.accept(this, s2);
        }

        @Override
        public Boolean visitType(TypeReference t2, TypeReference s2) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitArrayType(ArrayType t2, TypeReference s2) {
            return s2.isArray() && MetadataHelper.containsTypeEquivalent(MetadataHelper.getElementType(t2), MetadataHelper.getElementType(s2));
        }

        @Override
        public Boolean visitBottomType(TypeReference t2, TypeReference s2) {
            return t2 == s2;
        }

        @Override
        public Boolean visitClassType(TypeReference t2, TypeReference s2) {
            TypeDefinition sResolved;
            TypeDefinition tResolved;
            if (t2 == s2) {
                return true;
            }
            if (!(t2 instanceof RawType) && MetadataHelper.isRawType(t2) && (tResolved = t2.resolve()) != null) {
                return this.visitClassType((TypeReference)tResolved, s2);
            }
            if (!(s2 instanceof RawType) && MetadataHelper.isRawType(s2) && (sResolved = s2.resolve()) != null) {
                return this.visitClassType(t2, sResolved);
            }
            if (t2.isGenericDefinition()) {
                return s2.isGenericDefinition() && StringUtilities.equals(t2.getInternalName(), s2.getInternalName()) && this.visit(t2.getDeclaringType(), s2.getDeclaringType()) != false;
            }
            return s2.getSimpleType() == JvmType.Object && StringUtilities.equals(t2.getInternalName(), s2.getInternalName()) && this.containsTypes(MetadataHelper.getTypeArguments(t2), MetadataHelper.getTypeArguments(s2));
        }

        @Override
        public <C extends TypeReference> Boolean visitCompoundType(C t2, TypeReference s2) {
            if (!s2.isCompoundType()) {
                return false;
            }
            if (!this.visit(MetadataHelper.getSuperType(t2), MetadataHelper.getSuperType(s2)).booleanValue()) {
                return false;
            }
            HashSet<TypeReference> set = new HashSet<TypeReference>(MetadataHelper.getInterfaces(t2));
            for (TypeReference i : MetadataHelper.getInterfaces(s2)) {
                if (set.remove(i)) continue;
                return false;
            }
            return set.isEmpty();
        }

        @Override
        public <U extends TypeReference> Boolean visitUnionType(U t2, TypeReference s2) {
            if (!(s2 instanceof UnionType)) {
                return false;
            }
            HashSet<TypeReference> set = new HashSet<TypeReference>(((IUnionType)((Object)t2)).getAlternatives());
            for (TypeReference i : ((UnionType)s2).getAlternatives()) {
                if (set.remove(i)) continue;
                return false;
            }
            return set.isEmpty();
        }

        @Override
        public Boolean visitGenericParameter(GenericParameter t2, TypeReference s2) {
            if (s2 instanceof GenericParameter) {
                return this.areSameGenericParameters(t2, (GenericParameter)s2);
            }
            return s2.hasSuperBound() && !s2.hasExtendsBound() && this.visit((TypeReference)t2, MetadataHelper.getUpperBound(s2)) != false;
        }

        @Override
        public Boolean visitNullType(TypeReference t2, TypeReference s2) {
            return t2 == s2;
        }

        @Override
        public Boolean visitParameterizedType(TypeReference t2, TypeReference s2) {
            return this.visitClassType(t2, s2);
        }

        @Override
        public Boolean visitPrimitiveType(PrimitiveType t2, TypeReference s2) {
            return t2.getSimpleType() == s2.getSimpleType();
        }

        @Override
        public Boolean visitRawType(RawType t2, TypeReference s2) {
            return s2.getSimpleType() == JvmType.Object && !s2.isGenericType() && StringUtilities.equals(t2.getInternalName(), s2.getInternalName());
        }

        @Override
        public Boolean visitWildcard(WildcardType t2, TypeReference s2) {
            if (s2.isWildcardType()) {
                if (t2.isUnbounded()) {
                    return s2.isUnbounded();
                }
                if (t2.hasExtendsBound()) {
                    return s2.hasExtendsBound() && this.visit(MetadataHelper.getUpperBound(t2), MetadataHelper.getUpperBound(s2)) != false;
                }
                if (t2.hasSuperBound()) {
                    return s2.hasSuperBound() && this.visit(MetadataHelper.getLowerBound(t2), MetadataHelper.getLowerBound(s2)) != false;
                }
            }
            return Boolean.FALSE;
        }
    }

    public static class AdaptFailure
    extends RuntimeException {
        static final long serialVersionUID = -7490231548272701566L;
    }

    private static final class Adapter
    extends DefaultTypeVisitor<TypeReference, Void> {
        final ListBuffer<TypeReference> from = ListBuffer.lb();
        final ListBuffer<TypeReference> to = ListBuffer.lb();
        final Map<TypeReference, TypeReference> mapping = new HashMap<TypeReference, TypeReference>();

        private Adapter() {
        }

        private void adaptRecursive(List<? extends TypeReference> source, List<? extends TypeReference> target) {
            if (source.size() == target.size()) {
                int n = source.size();
                for (int i = 0; i < n; ++i) {
                    this.adaptRecursive(source.get(i), target.get(i));
                }
            }
        }

        @Override
        public Void visitClassType(TypeReference source, TypeReference target) {
            this.adaptRecursive(MetadataHelper.getTypeArguments(source), MetadataHelper.getTypeArguments(target));
            return null;
        }

        @Override
        public Void visitParameterizedType(TypeReference source, TypeReference target) {
            this.adaptRecursive(MetadataHelper.getTypeArguments(source), MetadataHelper.getTypeArguments(target));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adaptRecursive(TypeReference source, TypeReference target) {
            Pair<TypeReference, TypeReference> pair;
            HashSet cache = (HashSet)ADAPT_CACHE.get();
            if (cache.add(pair = Pair.create(source, target))) {
                try {
                    this.visit(source, target);
                }
                finally {
                    cache.remove(pair);
                }
            }
        }

        @Override
        public Void visitArrayType(ArrayType source, TypeReference target) {
            if (target.isArray()) {
                this.adaptRecursive(MetadataHelper.getElementType(source), MetadataHelper.getElementType(target));
            }
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType source, TypeReference target) {
            if (source.hasExtendsBound()) {
                this.adaptRecursive(MetadataHelper.getUpperBound(source), MetadataHelper.getUpperBound(target));
            } else if (source.hasSuperBound()) {
                this.adaptRecursive(MetadataHelper.getLowerBound(source), MetadataHelper.getLowerBound(target));
            }
            return null;
        }

        @Override
        public Void visitGenericParameter(GenericParameter source, TypeReference target) {
            TypeReference value = this.mapping.get(source);
            if (value != null) {
                if (value.hasSuperBound() && target.hasSuperBound()) {
                    value = MetadataHelper.isSubType(MetadataHelper.getLowerBound(value), MetadataHelper.getLowerBound(target)) ? target : value;
                } else if (value.hasExtendsBound() && target.hasExtendsBound()) {
                    value = MetadataHelper.isSubType(MetadataHelper.getUpperBound(value), MetadataHelper.getUpperBound(target)) ? value : target;
                } else if (!(value.isWildcardType() && value.isUnbounded() || MetadataHelper.isSameType(value, target))) {
                    throw new AdaptFailure();
                }
            } else {
                value = target;
                this.from.append(source);
                this.to.append(target);
            }
            this.mapping.put(source, value);
            return null;
        }
    }
}

