/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections.concurrent;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.collections.concurrent.ConcurrentIntObjectMap;
import com.strobel.collections.concurrent.IntObjectEntry;
import com.strobel.concurrent.StripedReentrantLock;
import com.strobel.core.VerifyArgument;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;

public class ConcurrentIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    protected static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final StripedReentrantLock STRIPED_REENTRANT_LOCK = StripedReentrantLock.instance();
    private final byte _lockIndex = (byte)STRIPED_REENTRANT_LOCK.allocateLockIndex();
    protected volatile IntHashEntry<V>[] table;
    protected volatile int count;
    protected int modCount;
    private final float _loadFactor;

    public ConcurrentIntObjectHashMap() {
        this(16, 0.75f);
    }

    public ConcurrentIntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentIntObjectHashMap(int initialCapacity, float loadFactor) {
        int capacity = ConcurrentIntObjectHashMap.computeInitialCapacity(initialCapacity, loadFactor);
        this.setTable(new IntHashEntry[capacity]);
        this._loadFactor = loadFactor;
    }

    private void lock() {
        STRIPED_REENTRANT_LOCK.lock(this._lockIndex);
    }

    private void unlock() {
        STRIPED_REENTRANT_LOCK.unlock(this._lockIndex);
    }

    private int threshold() {
        return (int)((float)this.table.length * this._loadFactor);
    }

    private void setTable(IntHashEntry<?>[] newTable) {
        this.table = newTable;
    }

    private static int computeInitialCapacity(int initialCapacity, float loadFactor) {
        int capacity;
        VerifyArgument.isNonNegative(initialCapacity, "initialCapacity");
        VerifyArgument.isPositive(loadFactor, "loadFactor");
        int desiredCapacity = Math.min(initialCapacity, 0x40000000);
        for (capacity = 1; capacity < desiredCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    private IntHashEntry<V> getFirst(int hash) {
        IntHashEntry<V>[] t2 = this.table;
        return t2[hash & t2.length - 1];
    }

    private V readValueUnderLock(IntHashEntry<V> entry) {
        this.lock();
        try {
            Object v = entry.value;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    private void rehash() {
        IntHashEntry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            return;
        }
        int newCapacity = oldCapacity << 1;
        IntHashEntry[] newTable = new IntHashEntry[newCapacity];
        int sizeMask = newCapacity - 1;
        for (IntHashEntry<V> oldEntry : oldTable) {
            if (oldEntry == null) continue;
            IntHashEntry next = oldEntry.next;
            int index = oldEntry.key & sizeMask;
            if (next == null) {
                newTable[index] = oldEntry;
                continue;
            }
            IntHashEntry<V> lastRun = oldEntry;
            int lastIndex = index;
            IntHashEntry last = next;
            while (last != null) {
                int k = last.key & sizeMask;
                if (k != lastIndex) {
                    lastIndex = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIndex] = lastRun;
            IntHashEntry<V> p = oldEntry;
            while (p != lastRun) {
                int currentIndex = p.key & sizeMask;
                IntHashEntry current = newTable[currentIndex];
                newTable[currentIndex] = new IntHashEntry(p.key, current, p.value);
                p = p.next;
            }
        }
        this.setTable(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V put(int key, @NotNull V value, boolean onlyIfAbsent) {
        this.lock();
        try {
            V oldValue;
            IntHashEntry<V> first;
            int c = this.count;
            if (c++ > this.threshold()) {
                this.rehash();
            }
            IntHashEntry<V>[] t2 = this.table;
            int index = key & this.table.length - 1;
            IntHashEntry<V> entry = first = t2[index];
            while (entry != null && entry.key != key) {
                entry = entry.next;
            }
            if (entry != null) {
                oldValue = entry.value;
                if (!onlyIfAbsent) {
                    entry.value = value;
                }
            } else {
                oldValue = null;
                ++this.modCount;
                t2[index] = new IntHashEntry(key, first, value);
                this.count = c;
            }
            V v = oldValue;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V removeCore(int key, @Nullable V value) {
        this.lock();
        try {
            int newCount = this.count - 1;
            IntHashEntry<V>[] t2 = this.table;
            int index = key & this.table.length - 1;
            IntHashEntry<V> entry = t2[index];
            while (entry != null && entry.key != key) {
                entry = entry.next;
            }
            if (entry != null) {
                Object oldValue = entry.value;
                if (value == null || value.equals(oldValue)) {
                    IntHashEntry<V> newFirst;
                    ++this.modCount;
                    IntHashEntry<V> p = newFirst = t2[index];
                    while (p != entry) {
                        newFirst = new IntHashEntry(p.key, newFirst, p.value);
                        p = p.next;
                    }
                    t2[index] = newFirst;
                    this.count = newCount;
                    Object v = oldValue;
                    return v;
                }
            }
            V v = null;
            return v;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    @NotNull
    public V addOrGet(int key, @NotNull V value) {
        V previous = this.putIfAbsent(key, value);
        return previous != null ? previous : value;
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        return this.removeCore(key, value) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        VerifyArgument.notNull(oldValue, "oldValue");
        VerifyArgument.notNull(newValue, "newValue");
        this.lock();
        try {
            IntHashEntry<V> entry = this.getFirst(key);
            while (entry != null && entry.key != key) {
                entry = entry.next;
            }
            if (entry != null && oldValue.equals(entry.value)) {
                entry.value = newValue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public V put(int key, @NotNull V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        return this.put(key, value, true);
    }

    @Override
    public V get(int key) {
        if (this.count != 0) {
            IntHashEntry<V> entry = this.getFirst(key);
            while (entry != null) {
                if (entry.key == key) {
                    Object value = entry.value;
                    return value != null ? value : this.readValueUnderLock(entry);
                }
                entry = entry.next;
            }
        }
        return null;
    }

    @Override
    public V remove(int key) {
        return this.removeCore(key, null);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(int key) {
        if (this.count != 0) {
            IntHashEntry<V> entry = this.getFirst(key);
            while (entry != null) {
                if (entry.key == key) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.count != 0) {
            this.lock();
            try {
                IntHashEntry<V>[] t2 = this.table;
                for (int i = 0; i < t2.length; ++i) {
                    t2[i] = null;
                }
                ++this.modCount;
                this.count = 0;
            }
            finally {
                this.unlock();
            }
        }
    }

    @Override
    @NotNull
    public int[] keys() {
        IntHashEntry<V>[] t2 = this.table;
        int c = Math.min(this.count, t2.length);
        int[] keys = new int[c];
        int k = 0;
        int i = 0;
        while (i < t2.length) {
            if (k >= keys.length) {
                keys = Arrays.copyOf(keys, keys.length * 2);
            }
            keys[k] = t2[i].key;
            ++i;
            ++k;
        }
        if (k < keys.length) {
            return Arrays.copyOfRange(keys, 0, k);
        }
        return keys;
    }

    @Override
    @NotNull
    public Iterable<IntObjectEntry<V>> entries() {
        return new Iterable<IntObjectEntry<V>>(){

            @Override
            public Iterator<IntObjectEntry<V>> iterator() {
                return new Iterator<IntObjectEntry<V>>(){
                    private final HashIterator hashIterator;
                    {
                        this.hashIterator = new HashIterator();
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.hashIterator.hasNext();
                    }

                    @Override
                    public final IntObjectEntry<V> next() {
                        IntHashEntry e = this.hashIterator.nextEntry();
                        return new SimpleEntry(e.key, e.value);
                    }

                    @Override
                    public final void remove() {
                        this.hashIterator.remove();
                    }
                };
            }
        };
    }

    @NotNull
    public Iterable<V> elements() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }
        };
    }

    private static final class IntHashEntry<V> {
        final int key;
        final IntHashEntry<V> next;
        @NotNull
        volatile V value;

        private IntHashEntry(int key, IntHashEntry<V> next, @NotNull V value) {
            this.key = key;
            this.next = next;
            this.value = value;
        }
    }

    private static final class SimpleEntry<V>
    implements IntObjectEntry<V> {
        private final int _key;
        private final V _value;

        private SimpleEntry(int key, V value) {
            this._key = key;
            this._value = value;
        }

        @Override
        public final int key() {
            return this._key;
        }

        @Override
        @NotNull
        public final V value() {
            return this._value;
        }
    }

    private final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        private ValueIterator() {
        }

        @Override
        public V nextElement() {
            return this.nextEntry().value;
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class HashIterator {
        private int _nextTableIndex;
        private IntHashEntry<V> _nextEntry;
        private IntHashEntry<V> _lastReturned;

        private HashIterator() {
            this._nextTableIndex = ConcurrentIntObjectHashMap.this.table.length - 1;
            this.advance();
        }

        private void advance() {
            if (this._nextEntry != null && (this._nextEntry = this._nextEntry.next) != null) {
                return;
            }
            while (this._nextTableIndex >= 0) {
                if ((this._nextEntry = ConcurrentIntObjectHashMap.this.table[this._nextTableIndex--]) == null) continue;
                return;
            }
        }

        public final boolean hasMoreElements() {
            return this._nextEntry != null;
        }

        public final boolean hasNext() {
            return this._nextEntry != null;
        }

        protected final IntHashEntry<V> nextEntry() {
            if (this._nextEntry == null) {
                throw new IllegalStateException();
            }
            this._lastReturned = this._nextEntry;
            this.advance();
            return this._lastReturned;
        }

        public final void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentIntObjectHashMap.this.remove(this._lastReturned.key);
            this._lastReturned = null;
        }
    }
}

