/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.core.Predicate;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Predicates {
    public static final Predicate<Object> IS_NULL = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return o == null;
        }
    };
    public static final Predicate<Object> NON_NULL = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return o != null;
        }
    };
    public static final Predicate<Object> FALSE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }
    };
    public static final Predicate<Object> TRUE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return true;
        }
    };

    private Predicates() {
        throw new AssertionError((Object)"No instances!");
    }

    public static <T> Predicate<T> isNull() {
        return IS_NULL;
    }

    public static <T> Predicate<T> nonNull() {
        return NON_NULL;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> instanceOf(final Class<?> clazz) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return clazz.isInstance(o);
            }
        };
    }

    public static <T> Predicate<T> isSame(final T target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return t2 == target;
            }
        };
    }

    public static <T> Predicate<T> isEqual(final T target) {
        if (null == target) {
            return Predicates.isNull();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return target.equals(t2);
            }
        };
    }

    public static <T> Predicate<T> contains(final Collection<? extends T> target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return target.contains(t2);
            }
        };
    }

    public static <T> Predicate<T> containsKey(final Map<? extends T, ?> target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return target.containsKey(t2);
            }
        };
    }

    public static <T> Predicate<T> negate(final Predicate<? super T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return !predicate.test(t2);
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<T> first, final Predicate<? super T> second) {
        if (first != null && first == second) {
            return first;
        }
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return first.test(t2) && second.test(t2);
            }
        };
    }

    public static <T> Predicate<T> and(Iterable<Predicate<? super T>> components) {
        final List<Predicate<T>> predicates = Predicates.safeCopyOf(components);
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    static <T> Predicate<T> and(Predicate<? super T> first, Iterable<Predicate<? super T>> components) {
        final List<Predicate<? super T>> predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> ... components) {
        final Predicate[] predicates = Predicates.safeCopyOf(components);
        if (0 == predicates.length) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @SafeVarargs
    static <T> Predicate<T> and(Predicate<? super T> first, Predicate<? super T> ... components) {
        final Predicate[] predicates = Predicates.safeCopyOf(first, components);
        if (0 == predicates.length) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t2)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<T> first, final Predicate<? super T> second) {
        if (first != null && first == second) {
            return first;
        }
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return first.test(t2) || second.test(t2);
            }
        };
    }

    public static <T> Predicate<T> or(Iterable<Predicate<? super T>> components) {
        final List<Predicate<T>> predicates = Predicates.safeCopyOf(components);
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static <T> Predicate<T> or(Predicate<? super T> first, Iterable<Predicate<? super T>> components) {
        final List<Predicate<? super T>> predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... components) {
        final Predicate[] predicates = Predicates.safeCopyOf(components);
        if (0 == predicates.length) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    static <T> Predicate<T> or(Predicate<T> first, Predicate<? super T> ... components) {
        final Predicate[] predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t2)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> xor(final Predicate<T> first, final Predicate<? super T> second) {
        if (null != first && first == second) {
            return Predicates.alwaysFalse();
        }
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return first.test(t2) ^ second.test(t2);
            }
        };
    }

    @SafeVarargs
    private static <T> T[] safeCopyOf(T ... array) {
        T[] copy;
        for (T each : copy = Arrays.copyOf(array, array.length)) {
            Objects.requireNonNull(each);
        }
        return copy;
    }

    @SafeVarargs
    private static <T> T[] safeCopyOf(T first, T ... array) {
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        copy[0] = Objects.requireNonNull(first);
        System.arraycopy(array, 0, copy, 1, array.length);
        for (Object each : copy) {
            Objects.requireNonNull(each);
        }
        return copy;
    }

    private static <T> List<T> safeCopyOf(T first, Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(Objects.requireNonNull(first));
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element));
        }
        return list;
    }

    private static <T> List<T> safeCopyOf(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element));
        }
        return list;
    }
}

