/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.IntegerBox;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Loop;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.JavaOutputVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NameVariables {
    private static final char MAX_LOOP_VARIABLE_NAME = 'm';
    private static final String[] METHOD_PREFIXES = new String[]{"get", "is", "are", "to", "as", "create", "make", "new", "read", "parse", "extract", "find"};
    private static final String[] METHOD_SUFFIXES = new String[]{"At", "For", "From", "Of"};
    private static final Map<String, String> BUILT_IN_TYPE_NAMES;
    private static final Map<String, String> METHOD_NAME_MAPPINGS;
    private final Map<String, Integer> _typeNames = new HashMap<String, Integer>();

    public NameVariables(DecompilerContext context) {
    }

    public final void addExistingName(String name) {
        if (StringUtilities.isNullOrEmpty(name)) {
            return;
        }
        IntegerBox number = new IntegerBox();
        String nameWithoutDigits = this.splitName(name, number);
        Integer existingNumber = this._typeNames.get(nameWithoutDigits);
        if (existingNumber != null) {
            this._typeNames.put(nameWithoutDigits, Math.max(number.value, existingNumber));
        } else {
            this._typeNames.put(nameWithoutDigits, number.value);
        }
    }

    final String splitName(String name, IntegerBox number) {
        int position;
        for (position = name.length(); position > 0 && name.charAt(position - 1) >= '0' && name.charAt(position - 1) <= '9'; --position) {
        }
        if (position < name.length()) {
            number.value = Integer.parseInt(name.substring(position));
            return name.substring(0, position);
        }
        number.value = 1;
        return name;
    }

    public static NameVariables assignNamesToVariables(DecompilerContext context, Iterable<Variable> parameters, Iterable<Variable> variables, Block methodBody) {
        NameVariables nv = new NameVariables(context);
        for (String name : context.getReservedVariableNames()) {
            nv.addExistingName(name);
        }
        for (Variable p : parameters) {
            nv.addExistingName(p.getName());
        }
        if (context.getCurrentMethod().isTypeInitializer()) {
            for (FieldDefinition f : context.getCurrentType().getDeclaredFields()) {
                if (!f.isStatic() || !f.isFinal() || f.hasConstantValue()) continue;
                nv.addExistingName(f.getName());
            }
        }
        for (Variable v : variables) {
            if (v.isGenerated()) {
                nv.addExistingName(v.getName());
                continue;
            }
            VariableDefinition originalVariable = v.getOriginalVariable();
            if (originalVariable != null) {
                String varName = originalVariable.getName();
                if (StringUtilities.isNullOrEmpty(varName) || varName.startsWith("V_") || !NameVariables.isValidName(varName)) {
                    v.setName(null);
                    continue;
                }
                v.setName(nv.getAlternativeName(varName));
                continue;
            }
            v.setName(null);
        }
        for (Variable p : parameters) {
            ParameterDefinition op = p.getOriginalParameter();
            if (op == null || op.hasName()) continue;
            p.setName(nv.generateNameForVariable(p, methodBody));
        }
        for (Variable varDef : variables) {
            boolean generateName = StringUtilities.isNullOrEmpty(varDef.getName()) || varDef.isGenerated() || !varDef.isParameter() && !varDef.getOriginalVariable().isFromMetadata();
            if (!generateName) continue;
            varDef.setName(nv.generateNameForVariable(varDef, methodBody));
        }
        return nv;
    }

    static boolean isValidName(String name) {
        if (StringUtilities.isNullOrEmpty(name)) {
            return false;
        }
        if (!Character.isJavaIdentifierPart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getAlternativeName(String oldVariableName) {
        IntegerBox number = new IntegerBox();
        String nameWithoutDigits = this.splitName(oldVariableName, number);
        if (!this._typeNames.containsKey(nameWithoutDigits) && !JavaOutputVisitor.isKeyword(oldVariableName)) {
            this._typeNames.put(nameWithoutDigits, Math.max(number.value, 1));
            return oldVariableName;
        }
        if (oldVariableName.length() == 1 && oldVariableName.charAt(0) >= 'i' && oldVariableName.charAt(0) <= 'm') {
            for (char c = 'i'; c <= 'm'; c = (char)(c + '\u0001')) {
                String cs = String.valueOf(c);
                if (this._typeNames.containsKey(cs)) continue;
                this._typeNames.put(cs, 1);
                return cs;
            }
        }
        if (!this._typeNames.containsKey(nameWithoutDigits)) {
            this._typeNames.put(nameWithoutDigits, number.value - 1);
        }
        int count = this._typeNames.get(nameWithoutDigits) + 1;
        this._typeNames.put(nameWithoutDigits, count);
        if (count != 1 || JavaOutputVisitor.isKeyword(nameWithoutDigits)) {
            return nameWithoutDigits + count;
        }
        return nameWithoutDigits;
    }

    private String generateNameForVariable(Variable variable, Block methodBody) {
        String proposedName = null;
        if (variable.getType().getSimpleType() == JvmType.Integer) {
            boolean isLoopCounter = false;
            block3: for (Loop loop : methodBody.getSelfAndChildrenRecursive(Loop.class)) {
                Expression e = loop.getCondition();
                while (e != null && e.getCode() == AstCode.LogicalNot) {
                    e = e.getArguments().get(0);
                }
                if (e == null) continue;
                switch (e.getCode()) {
                    case CmpEq: 
                    case CmpNe: 
                    case CmpLe: 
                    case CmpGt: 
                    case CmpGe: 
                    case CmpLt: {
                        StrongBox loadVariable = new StrongBox();
                        if (PatternMatching.matchGetOperand(e.getArguments().get(0), AstCode.Load, loadVariable) && loadVariable.get() == variable) {
                            isLoopCounter = true;
                            break block3;
                        }
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            if (isLoopCounter) {
                for (char c = 'i'; c < 'm'; c = (char)(c + '\u0001')) {
                    String name = String.valueOf(c);
                    if (this._typeNames.containsKey(name)) continue;
                    proposedName = name;
                    break;
                }
            }
        }
        if (StringUtilities.isNullOrEmpty(proposedName)) {
            String proposedNameForStore = null;
            for (Expression e : methodBody.getSelfAndChildrenRecursive(Expression.class)) {
                String name;
                if (e.getCode() != AstCode.Store || e.getOperand() != variable || (name = NameVariables.getNameFromExpression(e.getArguments().get(0))) == null) continue;
                if (proposedNameForStore != null) {
                    proposedNameForStore = null;
                    break;
                }
                proposedNameForStore = name;
            }
            if (proposedNameForStore != null) {
                proposedName = proposedNameForStore;
            }
        }
        if (StringUtilities.isNullOrEmpty(proposedName)) {
            String proposedNameForLoad = null;
            block7: for (Expression e : methodBody.getSelfAndChildrenRecursive(Expression.class)) {
                List<Expression> arguments = e.getArguments();
                for (int i = 0; i < arguments.size(); ++i) {
                    String name;
                    Expression a = arguments.get(i);
                    if (a.getCode() != AstCode.Load || a.getOperand() != variable || (name = NameVariables.getNameForArgument(e, i)) == null) continue;
                    if (proposedNameForLoad != null) {
                        proposedNameForLoad = null;
                        continue block7;
                    }
                    proposedNameForLoad = name;
                }
            }
            if (proposedNameForLoad != null) {
                proposedName = proposedNameForLoad;
            }
        }
        if (StringUtilities.isNullOrEmpty(proposedName)) {
            proposedName = this.getNameForType0(variable.getType());
        }
        return this.getAlternativeName(proposedName);
    }

    private static String cleanUpVariableName(String s2) {
        int lowerEnd;
        if (s2 == null) {
            return null;
        }
        String name = s2;
        if (name.length() > 2 && name.startsWith("m_")) {
            name = name.substring(2);
        } else if (name.length() > 1 && name.startsWith("_")) {
            name = name.substring(1);
        }
        int length = name.length();
        if (length == 0) {
            return "obj";
        }
        for (lowerEnd = 1; lowerEnd < length && Character.isUpperCase(name.charAt(lowerEnd)); ++lowerEnd) {
            if (lowerEnd >= length - 1) continue;
            char nextChar = name.charAt(lowerEnd + 1);
            if (Character.isLowerCase(nextChar)) break;
            if (Character.isAlphabetic(nextChar)) continue;
            ++lowerEnd;
            break;
        }
        if (JavaOutputVisitor.isKeyword(name = name.substring(0, lowerEnd).toLowerCase() + name.substring(lowerEnd))) {
            return name + "1";
        }
        return name;
    }

    private static String getNameFromExpression(Expression e) {
        switch (e.getCode()) {
            case ArrayLength: {
                return NameVariables.cleanUpVariableName("length");
            }
            case GetField: 
            case GetStatic: {
                return NameVariables.cleanUpVariableName(((FieldReference)e.getOperand()).getName());
            }
            case InvokeVirtual: 
            case InvokeSpecial: 
            case InvokeStatic: 
            case InvokeInterface: {
                String methodName;
                MethodReference method = (MethodReference)e.getOperand();
                if (method == null) break;
                String name = methodName = method.getName();
                String mappedMethodName = METHOD_NAME_MAPPINGS.get(methodName);
                if (mappedMethodName != null) {
                    return NameVariables.cleanUpVariableName(mappedMethodName);
                }
                for (String prefix : METHOD_PREFIXES) {
                    if (methodName.length() <= prefix.length() || !methodName.startsWith(prefix) || !Character.isUpperCase(methodName.charAt(prefix.length()))) continue;
                    name = methodName.substring(prefix.length());
                    break;
                }
                for (String suffix : METHOD_SUFFIXES) {
                    if (name.length() <= suffix.length() || !name.endsWith(suffix) || !Character.isLowerCase(name.charAt(name.length() - suffix.length() - 1))) continue;
                    name = name.substring(0, name.length() - suffix.length());
                    break;
                }
                return NameVariables.cleanUpVariableName(name);
            }
        }
        return null;
    }

    private static String getNameForArgument(Expression parent, int i) {
        switch (parent.getCode()) {
            case PutField: 
            case PutStatic: {
                if (i != parent.getArguments().size() - 1) break;
                return NameVariables.cleanUpVariableName(((FieldReference)parent.getOperand()).getName());
            }
            case InvokeVirtual: 
            case InvokeSpecial: 
            case InvokeStatic: 
            case InvokeInterface: 
            case InitObject: {
                ParameterDefinition p;
                MethodReference method = (MethodReference)parent.getOperand();
                if (method == null) break;
                String methodName = method.getName();
                List<ParameterDefinition> parameters = method.getParameters();
                if (parameters.size() == 1 && i == parent.getArguments().size() - 1 && methodName.length() > 3 && StringUtilities.startsWith(methodName, "set") && Character.isUpperCase(methodName.charAt(3))) {
                    return NameVariables.cleanUpVariableName(methodName.substring(3));
                }
                MethodDefinition definition = method.resolve();
                if (definition == null || (p = CollectionUtilities.getOrDefault(definition.getParameters(), parent.getCode() != AstCode.InitObject && !definition.isStatic() ? i - 1 : i)) == null || !p.hasName() || StringUtilities.isNullOrEmpty(p.getName())) break;
                return NameVariables.cleanUpVariableName(p.getName());
            }
        }
        return null;
    }

    public String getNameForType(TypeReference type) {
        String baseName = this.getNameForType0(type);
        return this.getAlternativeName(baseName);
    }

    private String getNameForType0(TypeReference type) {
        String name;
        TypeReference nameSource = type;
        if (nameSource.isArray()) {
            name = "array";
        } else if (CommonTypeReferences.Throwable.isEquivalentTo(nameSource)) {
            name = "t";
        } else if (StringUtilities.endsWith(nameSource.getName(), "Exception")) {
            name = "ex";
        } else if (StringUtilities.endsWith(nameSource.getName(), "List")) {
            name = "list";
        } else if (StringUtilities.endsWith(nameSource.getName(), "Set")) {
            name = "set";
        } else if (StringUtilities.endsWith(nameSource.getName(), "Collection")) {
            name = "collection";
        } else {
            TypeDefinition resolvedType;
            name = BUILT_IN_TYPE_NAMES.get(nameSource.getInternalName());
            if (name != null) {
                return name;
            }
            if (!(nameSource = MetadataHelper.getDeclaredType(nameSource)).isDefinition() && (resolvedType = nameSource.resolve()) != null) {
                nameSource = resolvedType;
            }
            if ((name = nameSource.getSimpleName()).length() > 2 && (name.charAt(0) == 'I' || name.charAt(0) == 'J') && Character.isUpperCase(name.charAt(1)) && Character.isLowerCase(name.charAt(2))) {
                name = name.substring(1);
            }
            name = NameVariables.cleanUpVariableName(name);
        }
        return name;
    }

    static {
        LinkedHashMap<String, String> builtInTypeNames = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> methodNameMappings = new LinkedHashMap<String, String>();
        builtInTypeNames.put(BuiltinTypes.Boolean.getInternalName(), "b");
        builtInTypeNames.put(CommonTypeReferences.Boolean.getInternalName(), "b");
        builtInTypeNames.put(BuiltinTypes.Byte.getInternalName(), "b");
        builtInTypeNames.put(CommonTypeReferences.Byte.getInternalName(), "b");
        builtInTypeNames.put(BuiltinTypes.Short.getInternalName(), "n");
        builtInTypeNames.put(CommonTypeReferences.Short.getInternalName(), "n");
        builtInTypeNames.put(BuiltinTypes.Integer.getInternalName(), "n");
        builtInTypeNames.put(CommonTypeReferences.Integer.getInternalName(), "n");
        builtInTypeNames.put(BuiltinTypes.Long.getInternalName(), "n");
        builtInTypeNames.put(CommonTypeReferences.Long.getInternalName(), "n");
        builtInTypeNames.put(BuiltinTypes.Float.getInternalName(), "n");
        builtInTypeNames.put(CommonTypeReferences.Float.getInternalName(), "n");
        builtInTypeNames.put(BuiltinTypes.Double.getInternalName(), "n");
        builtInTypeNames.put(CommonTypeReferences.Double.getInternalName(), "n");
        builtInTypeNames.put(BuiltinTypes.Character.getInternalName(), "c");
        builtInTypeNames.put(CommonTypeReferences.Number.getInternalName(), "n");
        builtInTypeNames.put("java/io/Serializable", "s");
        builtInTypeNames.put(CommonTypeReferences.Character.getInternalName(), "c");
        builtInTypeNames.put(CommonTypeReferences.Object.getInternalName(), "o");
        builtInTypeNames.put(CommonTypeReferences.String.getInternalName(), "s");
        builtInTypeNames.put(CommonTypeReferences.StringBuilder.getInternalName(), "sb");
        builtInTypeNames.put(CommonTypeReferences.StringBuffer.getInternalName(), "sb");
        builtInTypeNames.put(CommonTypeReferences.Class.getInternalName(), "clazz");
        BUILT_IN_TYPE_NAMES = Collections.unmodifiableMap(builtInTypeNames);
        methodNameMappings.put("get", "value");
        METHOD_NAME_MAPPINGS = methodNameMappings;
    }
}

