/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.CompilationUnit;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.ImportDeclaration;
import com.strobel.decompiler.languages.java.ast.JavaNameResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.NameResolveMode;
import com.strobel.decompiler.languages.java.ast.NameResolveResult;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class AddReferenceQualifiersTransform
extends ContextTrackingVisitor<Void> {
    private final Set<AstNode> _addQualifierCandidates = new LinkedHashSet<AstNode>();
    private final Set<AstNode> _removeQualifierCandidates = new LinkedHashSet<AstNode>();
    private final boolean _simplifyMemberReferences;

    public AddReferenceQualifiersTransform(DecompilerContext context) {
        super(context);
        this._simplifyMemberReferences = context.getSettings().getSimplifyMemberReferences();
    }

    @Override
    public void run(AstNode compilationUnit) {
        super.run(compilationUnit);
        this.addQualifiersWhereNecessary();
        this.removeQualifiersWherePossible();
    }

    private void addQualifiersWhereNecessary() {
        for (AstNode candidate : this._addQualifierCandidates) {
            String s2;
            if (!(candidate instanceof SimpleType)) continue;
            SimpleType type = (SimpleType)candidate;
            TypeReference referencedType = type.getUserData(Keys.ANONYMOUS_BASE_TYPE_REFERENCE);
            if (referencedType == null) {
                referencedType = type.getUserData(Keys.TYPE_REFERENCE);
            }
            if (StringUtilities.isNullOrEmpty(s2 = this.qualifyReference(candidate, referencedType))) continue;
            type.setIdentifier(s2);
        }
    }

    private void removeQualifiersWherePossible() {
        for (AstNode candidate : this._removeQualifierCandidates) {
            FieldReference field;
            if (!(candidate instanceof MemberReferenceExpression) || (field = (FieldReference)candidate.getUserData(Keys.MEMBER_REFERENCE)) == null) continue;
            IdentifierExpression identifier = new IdentifierExpression(((Expression)candidate).getOffset(), field.getName());
            identifier.copyUserDataFrom(candidate);
            candidate.replaceWith(identifier);
        }
    }

    private static NameResolveMode modeForType(AstNode type) {
        if (type != null && type.getParent() instanceof TypeReferenceExpression && ((TypeReferenceExpression)type.getParent()).getType() == type) {
            return NameResolveMode.EXPRESSION;
        }
        return NameResolveMode.TYPE;
    }

    private String qualifyReference(AstNode node, TypeReference type) {
        String outerReference;
        if (type == null || type.isGenericParameter() || type.isWildcardType()) {
            return null;
        }
        TypeDefinition resolvedType = type.resolve();
        TypeDefinition t2 = resolvedType != null ? resolvedType : (type.isGenericType() ? type.getUnderlyingType() : type);
        Object resolvedObject = this.resolveName(node, ((TypeReference)t2).getSimpleName(), AddReferenceQualifiersTransform.modeForType(node));
        if (!this.context.getSettings().getForceFullyQualifiedReferences() && resolvedObject instanceof TypeReference && MetadataHelper.isSameType(t2, (TypeReference)resolvedObject)) {
            return ((TypeReference)t2).getSimpleName();
        }
        if (((TypeReference)t2).isNested() && (outerReference = this.qualifyReference(node, t2.getDeclaringType())) != null) {
            return outerReference + "." + ((TypeReference)t2).getSimpleName();
        }
        if (resolvedObject != null) {
            return ((TypeReference)t2).getFullName();
        }
        return null;
    }

    @Override
    public Void visitSimpleType(SimpleType node, Void data) {
        int i;
        AstNode parent = node.getParent();
        if (parent instanceof ObjectCreationExpression && !((ObjectCreationExpression)parent).getTarget().isNull()) {
            return (Void)super.visitSimpleType(node, data);
        }
        String name = node.getIdentifier();
        TypeReference type = node.getUserData(Keys.TYPE_REFERENCE);
        if (type.isPrimitive() || type.isGenericParameter()) {
            return (Void)super.visitSimpleType(node, data);
        }
        while (type.isNested() && (i = name.lastIndexOf(46)) > 0 && i < name.length() - 1) {
            type = type.getDeclaringType();
            name = name.substring(0, i);
        }
        Object resolvedObject = this.resolveName(node, name, AddReferenceQualifiersTransform.modeForType(node));
        if (this.context.getSettings().getForceFullyQualifiedReferences() || resolvedObject == null || !(resolvedObject instanceof TypeReference) || !MetadataHelper.isSameType(type, (TypeReference)resolvedObject)) {
            this._addQualifierCandidates.add(node);
        }
        return (Void)super.visitSimpleType(node, data);
    }

    @Override
    public Void visitCompilationUnit(CompilationUnit node, Void data) {
        super.visitCompilationUnit(node, data);
        LinkedHashSet<String> topLevelTypeNames = new LinkedHashSet<String>();
        ArrayList<ImportDeclaration> importsToRemove = new ArrayList<ImportDeclaration>();
        for (AstNode astNode : node.getChildrenByRole(CompilationUnit.TYPE_ROLE)) {
            if (!(astNode instanceof TypeDeclaration)) continue;
            topLevelTypeNames.add(((TypeDeclaration)astNode).getName());
        }
        for (ImportDeclaration importDeclaration : node.getChildrenByRole(CompilationUnit.IMPORT_ROLE)) {
            TypeReference importedType = importDeclaration.getUserData(Keys.TYPE_REFERENCE);
            if (importedType == null || !topLevelTypeNames.contains(importedType.getSimpleName())) continue;
            importsToRemove.add(importDeclaration);
        }
        for (ImportDeclaration importDeclaration : importsToRemove) {
            importDeclaration.remove();
        }
        return null;
    }

    @Override
    public Void visitMemberReferenceExpression(MemberReferenceExpression node, Void data) {
        Object resolvedObject;
        MemberReference member;
        if (this._simplifyMemberReferences && (member = node.getUserData(Keys.MEMBER_REFERENCE)) instanceof FieldReference && this.context.getCurrentType() != null && MetadataHelper.isEnclosedBy(this.context.getCurrentType(), member.getDeclaringType()) && (resolvedObject = this.resolveName(node, member.getName(), NameResolveMode.EXPRESSION)) instanceof FieldReference && MetadataHelper.isSameType(((FieldReference)resolvedObject).getDeclaringType(), member.getDeclaringType())) {
            this._removeQualifierCandidates.add(node);
        }
        return (Void)super.visitMemberReferenceExpression(node, data);
    }

    protected Object resolveName(AstNode location, String name, NameResolveMode mode) {
        if (location == null || location.isNull() || name == null) {
            return null;
        }
        NameResolveResult result = mode == NameResolveMode.TYPE ? JavaNameResolver.resolveAsType(name, location) : JavaNameResolver.resolve(name, location);
        if (result.hasMatch() && !result.isAmbiguous()) {
            return CollectionUtilities.first(result.getCandidates());
        }
        return null;
    }
}

