/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.LanguageFeature;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.DefaultMap;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.analysis.ControlFlowEdge;
import com.strobel.decompiler.languages.java.analysis.ControlFlowEdgeType;
import com.strobel.decompiler.languages.java.analysis.ControlFlowGraphBuilder;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNode;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNodeType;
import com.strobel.decompiler.languages.java.analysis.Correlator;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentAnalysis;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentStatus;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.NameVariables;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.languages.java.ast.transforms.DeclareVariablesTransform;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.AssignmentChain;
import com.strobel.decompiler.patterns.BackReference;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.IdentifierBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.Repeat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;

public final class ConvertLoopsTransform
extends ContextTrackingVisitor<AstNode> {
    private static final Statement[] EMPTY_STATEMENTS = new Statement[0];
    private static final ExpressionStatement ARRAY_INIT_PATTERN = new ExpressionStatement(new AssignmentExpression(new NamedNode("array", new IdentifierExpression(-34, "$any$")).toExpression(), new AnyNode("initializer").toExpression()));
    private static final ForStatement FOR_ARRAY_PATTERN_1;
    private static final ForStatement FOR_ARRAY_PATTERN_2;
    private static final ForStatement FOR_ARRAY_PATTERN_3;
    private static final ExpressionStatement GET_ITERATOR_PATTERN;
    private static final WhileStatement FOR_EACH_PATTERN;
    private static final WhileStatement EMPTY_FOR_EACH_PATTERN;
    private static final WhileStatement DO_WHILE_PATTERN;
    private static final WhileStatement CONTINUE_OUTER_PATTERN;

    public ConvertLoopsTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    protected AstNode visitChildren(AstNode node, Void data) {
        AstNode child = node.getFirstChild();
        while (child != null) {
            AstNode next = child.getNextSibling();
            AstNode childResult = child.acceptVisitor(this, data);
            if (childResult != null && childResult != child) {
                next = childResult;
            }
            child = next;
        }
        return node;
    }

    @Override
    public AstNode visitExpressionStatement(ExpressionStatement node, Void data) {
        ForEachStatement result;
        AstNode n = (AstNode)super.visitExpressionStatement(node, data);
        if (this.context.isSupported(LanguageFeature.FOR_EACH_LOOPS) && !this.context.getSettings().getDisableForEachTransforms() && n instanceof ExpressionStatement && (result = this.transformForEach((ExpressionStatement)n)) != null) {
            return ((AstNode)result).acceptVisitor(this, data);
        }
        return n;
    }

    @Override
    public AstNode visitWhileStatement(WhileStatement node, Void data) {
        ForStatement forLoop = this.transformFor(node);
        if (forLoop != null) {
            ForEachStatement forEachInArray;
            if (!this.context.getSettings().getDisableForEachTransforms() && (forEachInArray = this.transformForEachInArray(forLoop)) != null) {
                return ((AstNode)forEachInArray).acceptVisitor(this, data);
            }
            return forLoop.acceptVisitor(this, data);
        }
        DoWhileStatement doWhile = this.transformDoWhile(node);
        if (doWhile != null) {
            return doWhile.acceptVisitor(this, data);
        }
        return this.visitChildren((AstNode)this.transformContinueOuter(node), data);
    }

    public final ForStatement transformFor(WhileStatement node) {
        Statement iterator;
        Statement s2;
        Expression condition = node.getCondition();
        if (condition == null || condition.isNull() || condition instanceof PrimitiveExpression) {
            return null;
        }
        if (!(node.getEmbeddedStatement() instanceof BlockStatement)) {
            return null;
        }
        BlockStatement body = (BlockStatement)node.getEmbeddedStatement();
        ControlFlowGraphBuilder graphBuilder = new ControlFlowGraphBuilder();
        List<ControlFlowNode> nodes = graphBuilder.buildControlFlowGraph(node, new JavaResolver(this.context));
        if (nodes.size() < 2) {
            return null;
        }
        ControlFlowNode conditionNode = CollectionUtilities.firstOrDefault(nodes, new Predicate<ControlFlowNode>(){

            @Override
            public boolean test(ControlFlowNode n) {
                return n.getType() == ControlFlowNodeType.LoopCondition;
            }
        });
        if (conditionNode == null) {
            return null;
        }
        ArrayList<ControlFlowNode> bodyNodes = new ArrayList<ControlFlowNode>();
        for (ControlFlowEdge edge : conditionNode.getIncoming()) {
            ControlFlowNode from = edge.getFrom();
            Statement statement = from.getPreviousStatement();
            if (statement == null || !body.isAncestorOf(statement, node)) continue;
            bodyNodes.add(from);
        }
        if (bodyNodes.size() != 1) {
            return null;
        }
        LinkedHashSet<Statement> incoming = new LinkedHashSet<Statement>();
        ArrayDeque<ControlFlowEdge> agenda = new ArrayDeque<ControlFlowEdge>(conditionNode.getIncoming());
        HashSet<ControlFlowEdge> visited = new HashSet<ControlFlowEdge>(conditionNode.getIncoming());
        while (!agenda.isEmpty()) {
            ControlFlowEdge edge = agenda.removeFirst();
            ControlFlowNode from = edge.getFrom();
            if (from == null) continue;
            if (edge.getType() == ControlFlowEdgeType.Jump) {
                Statement jump = from.getNextStatement();
                if (jump.getPreviousStatement() != null) {
                    incoming.add(jump.getPreviousStatement());
                    continue;
                }
                incoming.add(jump);
                continue;
            }
            Statement previousStatement = from.getPreviousStatement();
            if (previousStatement == null || from.getType() != ControlFlowNodeType.EndNode) continue;
            if (previousStatement instanceof TryCatchStatement) {
                incoming.add(previousStatement);
                continue;
            }
            if (previousStatement instanceof BlockStatement || ConvertLoopsTransform.hasNestedBlocks(previousStatement)) {
                for (ControlFlowEdge e : from.getIncoming()) {
                    if (!visited.add(e)) continue;
                    agenda.addLast(e);
                }
                continue;
            }
            incoming.add(previousStatement);
        }
        if (incoming.isEmpty()) {
            return null;
        }
        Statement[] iteratorSites = incoming.toArray(EMPTY_STATEMENTS);
        ArrayList<Statement> iterators = new ArrayList<Statement>();
        HashSet<Statement> iteratorCopies = new HashSet<Statement>();
        DefaultMap iteratorCopyMap = new DefaultMap(CollectionUtilities.listFactory());
        block3: while ((s2 = iteratorSites[0]) != null && !s2.isNull() && s2.isEmbeddable() && ConvertLoopsTransform.isSimpleIterator(s2)) {
            int i;
            for (i = 1; i < iteratorSites.length; ++i) {
                Statement o = iteratorSites[i];
                if (o == null || !s2.matches(o)) break block3;
            }
            iterators.add(s2);
            for (i = 0; i < iteratorSites.length; ++i) {
                iteratorCopies.add(iteratorSites[i]);
                ((List)iteratorCopyMap.get(s2)).add(iteratorSites[i]);
                iteratorSites[i] = iteratorSites[i].getPreviousStatement();
            }
        }
        Collections.reverse(iterators);
        while (!iterators.isEmpty() && !Correlator.areCorrelated(condition, iterator = (Statement)CollectionUtilities.first(iterators))) {
            for (Statement copy : (List)iteratorCopyMap.get(iterator)) {
                iteratorCopies.remove(copy);
            }
            iterators.remove(0);
        }
        if (iterators.isEmpty()) {
            return null;
        }
        ForStatement forLoop = new ForStatement(node.getOffset());
        Stack<Statement> initializers = new Stack<Statement>();
        Object s3 = node.getPreviousStatement();
        while (s3 instanceof ExpressionStatement) {
            Expression left;
            boolean canExtract;
            final Statement fs = s3;
            Expression e = ((ExpressionStatement)s3).getExpression();
            boolean bl = canExtract = e instanceof AssignmentExpression && (left = e.getChildByRole(AssignmentExpression.LEFT_ROLE)) instanceof IdentifierExpression && (Correlator.areCorrelated(condition, (Statement)s3) || CollectionUtilities.any(iterators, new Predicate<Statement>(){

                @Override
                public boolean test(Statement i) {
                    return i instanceof ExpressionStatement && Correlator.areCorrelated(((ExpressionStatement)i).getExpression(), fs) || Correlator.areCorrelated(left, i);
                }
            }));
            if (!canExtract) break;
            initializers.add((Statement)s3);
            s3 = ((Statement)s3).getPreviousStatement();
        }
        if (initializers.isEmpty()) {
            return null;
        }
        condition.remove();
        body.remove();
        forLoop.setCondition(condition);
        if (body instanceof BlockStatement) {
            for (Statement copy : iteratorCopies) {
                copy.remove();
            }
            forLoop.setEmbeddedStatement(body);
        }
        forLoop.getIterators().addAll(iterators);
        while (!initializers.isEmpty()) {
            Statement initializer = (Statement)initializers.pop();
            initializer.remove();
            forLoop.getInitializers().add(initializer);
        }
        node.replaceWith(forLoop);
        Statement firstInlinableInitializer = this.canInlineInitializerDeclarations(forLoop);
        if (firstInlinableInitializer != null) {
            BlockStatement parent = (BlockStatement)forLoop.getParent();
            VariableDeclarationStatement newDeclaration = new VariableDeclarationStatement();
            ArrayList<Statement> forInitializers = new ArrayList<Statement>(forLoop.getInitializers());
            int firstInlinableInitializerIndex = forInitializers.indexOf(firstInlinableInitializer);
            forLoop.getInitializers().clear();
            forLoop.getInitializers().add(newDeclaration);
            for (int i = 0; i < forInitializers.size(); ++i) {
                Statement initializer = (Statement)forInitializers.get(i);
                if (i < firstInlinableInitializerIndex) {
                    parent.insertChildBefore(forLoop, initializer, BlockStatement.STATEMENT_ROLE);
                    continue;
                }
                AssignmentExpression assignment = (AssignmentExpression)((ExpressionStatement)initializer).getExpression();
                IdentifierExpression variable = (IdentifierExpression)assignment.getLeft();
                String variableName = variable.getIdentifier();
                VariableDeclarationStatement declaration = ConvertLoopsTransform.findVariableDeclaration(forLoop, variableName);
                Expression initValue = assignment.getRight();
                initValue.remove();
                newDeclaration.getVariables().add(new VariableInitializer(variableName, initValue));
                AstType newDeclarationType = newDeclaration.getType();
                if (newDeclarationType != null && !newDeclarationType.isNull()) continue;
                newDeclaration.setType(declaration.getType().clone());
            }
        }
        return forLoop;
    }

    private static boolean hasNestedBlocks(AstNode node) {
        return AstNode.isLoop(node) || node instanceof TryCatchStatement || node instanceof CatchClause || node instanceof LabeledStatement || node instanceof SynchronizedStatement || node instanceof IfElseStatement || node instanceof SwitchSection;
    }

    private static boolean isSimpleIterator(Statement statement) {
        if (!(statement instanceof ExpressionStatement)) {
            return false;
        }
        Expression e = ((ExpressionStatement)statement).getExpression();
        if (e instanceof AssignmentExpression) {
            return true;
        }
        if (e instanceof UnaryOperatorExpression) {
            switch (((UnaryOperatorExpression)e).getOperator()) {
                case INCREMENT: 
                case DECREMENT: 
                case POST_INCREMENT: 
                case POST_DECREMENT: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement canInlineInitializerDeclarations(ForStatement forLoop) {
        TypeReference variableType = null;
        BlockStatement tempOuter = new BlockStatement();
        BlockStatement temp = new BlockStatement();
        Statement[] initializers = forLoop.getInitializers().toArray((T1[])EMPTY_STATEMENTS);
        HashSet<String> variableNames = new HashSet<String>();
        Statement firstInlinableInitializer = null;
        forLoop.getParent().insertChildBefore(forLoop, tempOuter, BlockStatement.STATEMENT_ROLE);
        forLoop.remove();
        for (Statement initializer : initializers) {
            initializer.remove();
            temp.getStatements().add(initializer);
        }
        temp.getStatements().add(forLoop);
        tempOuter.getStatements().add(temp);
        try {
            for (Statement initializer : initializers) {
                AssignmentExpression assignment = (AssignmentExpression)((ExpressionStatement)initializer).getExpression();
                IdentifierExpression variable = (IdentifierExpression)assignment.getLeft();
                String variableName = variable.getIdentifier();
                VariableDeclarationStatement declaration = ConvertLoopsTransform.findVariableDeclaration(forLoop, variableName);
                if (declaration == null) {
                    firstInlinableInitializer = null;
                    continue;
                }
                Variable underlyingVariable = declaration.getUserData(Keys.VARIABLE);
                if (underlyingVariable == null || underlyingVariable.isParameter()) {
                    firstInlinableInitializer = null;
                    continue;
                }
                if (!variableNames.add(underlyingVariable.getName())) {
                    firstInlinableInitializer = null;
                    continue;
                }
                if (variableType == null) {
                    variableType = underlyingVariable.getType();
                } else if (!variableType.equals(underlyingVariable.getType())) {
                    variableType = underlyingVariable.getType();
                    firstInlinableInitializer = null;
                }
                if (!(declaration.getParent() instanceof BlockStatement)) {
                    firstInlinableInitializer = null;
                    continue;
                }
                Statement declarationPoint = ConvertLoopsTransform.canMoveVariableDeclarationIntoStatement(this.context, declaration, forLoop);
                if (declarationPoint != tempOuter) {
                    variableType = null;
                    firstInlinableInitializer = null;
                    continue;
                }
                if (firstInlinableInitializer != null) continue;
                firstInlinableInitializer = initializer;
            }
            Statement[] statementArray = firstInlinableInitializer;
            return statementArray;
        }
        finally {
            forLoop.remove();
            tempOuter.replaceWith(forLoop);
            for (Statement initializer : initializers) {
                initializer.remove();
                forLoop.getInitializers().add(initializer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ForEachStatement transformForEachInArray(ForStatement loop) {
        Match m22;
        Match m4 = FOR_ARRAY_PATTERN_1.match(loop);
        if (!(m4.success() || (m4 = FOR_ARRAY_PATTERN_2.match(loop)).success() || (m4 = FOR_ARRAY_PATTERN_3.match(loop)).success())) {
            return null;
        }
        IdentifierExpression array = (IdentifierExpression)CollectionUtilities.first(m4.get("array"));
        IdentifierExpression item = (IdentifierExpression)CollectionUtilities.last(m4.get("item"));
        IdentifierExpression index = (IdentifierExpression)CollectionUtilities.first(m4.get("index"));
        VariableDeclarationStatement itemDeclaration = ConvertLoopsTransform.findVariableDeclaration(loop, item.getIdentifier());
        if (itemDeclaration == null || !(itemDeclaration.getParent() instanceof BlockStatement)) {
            return null;
        }
        Statement declarationPoint = ConvertLoopsTransform.canMoveVariableDeclarationIntoStatement(this.context, itemDeclaration, loop);
        if (declarationPoint != loop) {
            return null;
        }
        BlockStatement loopBody = (BlockStatement)loop.getEmbeddedStatement();
        Statement secondStatement = CollectionUtilities.getOrDefault(loopBody.getStatements(), 1);
        if (secondStatement != null && !secondStatement.isNull()) {
            DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(this.context, loopBody);
            analysis.setAnalyzedRange(secondStatement, loopBody);
            analysis.analyze(array.getIdentifier(), DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED);
            if (analysis.getStatusAfter(loopBody) != DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED) {
                return null;
            }
            analysis.analyze(index.getIdentifier(), DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED);
            if (analysis.getStatusAfter(loopBody) != DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED) {
                return null;
            }
            if (!analysis.getUnassignedVariableUses().isEmpty()) {
                return null;
            }
        }
        ForEachStatement forEach = new ForEachStatement(loop.getOffset());
        forEach.setVariableType(itemDeclaration.getType().clone());
        forEach.setVariableName(item.getIdentifier());
        forEach.putUserData(Keys.VARIABLE, itemDeclaration.getVariables().firstOrNullObject().getUserData(Keys.VARIABLE));
        BlockStatement body = new BlockStatement();
        BlockStatement parent = (BlockStatement)loop.getParent();
        forEach.setEmbeddedStatement(body);
        parent.getStatements().insertBefore(loop, forEach);
        loop.remove();
        body.add(loop);
        loop.remove();
        body.add(loop);
        array.remove();
        forEach.setInExpression(array);
        AstNodeCollection<Statement> bodyStatements = body.getStatements();
        bodyStatements.clear();
        AstNode itemParent = item.getParent();
        if (itemParent.getParent() instanceof AssignmentExpression && ((AssignmentExpression)itemParent.getParent()).getRight() == itemParent) {
            Statement itemStatement = CollectionUtilities.firstOrDefault(itemParent.getParent().getAncestors(Statement.class));
            item.remove();
            itemParent.replaceWith(item);
            if (itemStatement != null) {
                itemStatement.remove();
                bodyStatements.add(itemStatement);
            }
        }
        for (Statement statement : m4.get("statement")) {
            statement.remove();
            bodyStatements.add(statement);
        }
        Statement previous = forEach.getPreviousStatement();
        while (previous instanceof LabelStatement) {
            previous = previous.getPreviousStatement();
        }
        if (previous != null && (m22 = ARRAY_INIT_PATTERN.match(previous)).success()) {
            Expression initializer = (Expression)m22.get("initializer").iterator().next();
            IdentifierExpression array2 = (IdentifierExpression)m22.get("array").iterator().next();
            if (StringUtilities.equals(array2.getIdentifier(), array.getIdentifier())) {
                BlockStatement tempOuter = new BlockStatement();
                BlockStatement temp = new BlockStatement();
                boolean restorePrevious = true;
                parent.insertChildBefore(forEach, tempOuter, BlockStatement.STATEMENT_ROLE);
                previous.remove();
                forEach.remove();
                temp.add(previous);
                temp.add(forEach);
                tempOuter.add(temp);
                try {
                    Statement arrayDeclarationPoint;
                    VariableDeclarationStatement arrayDeclaration = ConvertLoopsTransform.findVariableDeclaration(forEach, array.getIdentifier());
                    if (arrayDeclaration != null && arrayDeclaration.getParent() instanceof BlockStatement && (arrayDeclarationPoint = ConvertLoopsTransform.canMoveVariableDeclarationIntoStatement(this.context, arrayDeclaration, forEach)) == tempOuter) {
                        initializer.remove();
                        array.replaceWith(initializer);
                        restorePrevious = false;
                    }
                }
                finally {
                    previous.remove();
                    forEach.remove();
                    if (restorePrevious) {
                        parent.insertChildBefore(tempOuter, previous, BlockStatement.STATEMENT_ROLE);
                    }
                    parent.insertChildBefore(tempOuter, forEach, BlockStatement.STATEMENT_ROLE);
                    tempOuter.remove();
                }
            }
        }
        if (body.getStatements().isEmpty()) {
            forEach.addVariableModifier(Flags.Flag.FINAL);
        } else {
            DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(this.context, body);
            Statement firstStatement = CollectionUtilities.firstOrDefault(body.getStatements());
            Statement lastStatement = CollectionUtilities.lastOrDefault(body.getStatements());
            analysis.setAnalyzedRange(firstStatement, lastStatement);
            analysis.analyze(item.getIdentifier(), DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED);
            if (!analysis.isPotentiallyAssigned()) {
                forEach.addVariableModifier(Flags.Flag.FINAL);
            }
        }
        return forEach;
    }

    public final ForEachStatement transformForEach(ExpressionStatement node) {
        AstNode itemParent;
        String itemName;
        AstType itemType;
        VariableDeclarationStatement itemDeclaration;
        Match m1 = GET_ITERATOR_PATTERN.match(node);
        if (!m1.success()) {
            return null;
        }
        AstNode next = node.getNextSibling();
        while (next instanceof LabelStatement) {
            next = next.getNextSibling();
        }
        Match m22 = FOR_EACH_PATTERN.match(next);
        if (!m22.success() && !(m22 = EMPTY_FOR_EACH_PATTERN.match(next)).success()) {
            return null;
        }
        IdentifierExpression iterator = (IdentifierExpression)m22.get("iterator").iterator().next();
        IdentifierExpression item = (IdentifierExpression)CollectionUtilities.lastOrDefault(m22.get("item"));
        WhileStatement loop = (WhileStatement)next;
        if (!iterator.matches((INode)m1.get("left").iterator().next())) {
            return null;
        }
        String itName = iterator.getIdentifier();
        VariableDeclarationStatement iteratorDeclaration = ConvertLoopsTransform.findVariableDeclaration(loop, itName);
        if (iteratorDeclaration == null || !(iteratorDeclaration.getParent() instanceof BlockStatement)) {
            return null;
        }
        if (item == null) {
            itemDeclaration = null;
        } else {
            itemDeclaration = ConvertLoopsTransform.findVariableDeclaration(loop, item.getIdentifier());
            if (itemDeclaration == null || !(itemDeclaration.getParent() instanceof BlockStatement)) {
                return null;
            }
            Statement declarationPoint = ConvertLoopsTransform.canMoveVariableDeclarationIntoStatement(this.context, itemDeclaration, loop);
            if (declarationPoint != loop) {
                return null;
            }
        }
        BlockStatement loopBody = (BlockStatement)loop.getEmbeddedStatement();
        Statement secondStatement = CollectionUtilities.getOrDefault(loopBody.getStatements(), 1);
        if (secondStatement != null && !secondStatement.isNull()) {
            DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(this.context, loopBody);
            analysis.setAnalyzedRange(secondStatement, loopBody);
            analysis.analyze(itName, DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED);
            if (!analysis.getUnassignedVariableUses().isEmpty()) {
                return null;
            }
        }
        if (item != null) {
            itemType = itemDeclaration.getType();
            itemName = item.getIdentifier();
        } else {
            TypeReference itemTypeReference;
            NameVariables nv;
            MethodDeclaration md = node.getParent(MethodDeclaration.class);
            NameVariables nameVariables = nv = md != null ? md.getUserData(Keys.NAME_VARIABLES) : null;
            if (nv == null) {
                return null;
            }
            itemType = CollectionUtilities.firstOrDefault(iteratorDeclaration.getType().getChildrenByRole(Roles.TYPE_ARGUMENT));
            String string = itemName = itemType != null && (itemTypeReference = itemType.toTypeReference()) != null ? nv.getNameForType(itemTypeReference) : null;
        }
        if (itemType == null || itemName == null) {
            return null;
        }
        ForEachStatement forEach = new ForEachStatement(node.getOffset());
        forEach.setVariableType(itemType.clone());
        forEach.setVariableName(itemName);
        if (itemDeclaration != null) {
            forEach.putUserData(Keys.VARIABLE, itemDeclaration.getVariables().firstOrNullObject().getUserData(Keys.VARIABLE));
        }
        BlockStatement body = new BlockStatement();
        forEach.setEmbeddedStatement(body);
        ((BlockStatement)node.getParent()).getStatements().insertBefore(loop, forEach);
        node.remove();
        body.add(node);
        loop.remove();
        body.add(loop);
        Statement declarationPoint = ConvertLoopsTransform.canMoveVariableDeclarationIntoStatement(this.context, iteratorDeclaration, forEach);
        if (declarationPoint != forEach) {
            node.remove();
            ((BlockStatement)forEach.getParent()).getStatements().insertBefore(forEach, node);
            forEach.replaceWith(loop);
            return null;
        }
        Expression collection = (Expression)m1.get("collection").iterator().next();
        collection.remove();
        if (collection instanceof SuperReferenceExpression) {
            ThisReferenceExpression self = new ThisReferenceExpression(collection.getOffset());
            self.putUserData(Keys.TYPE_REFERENCE, collection.getUserData(Keys.TYPE_REFERENCE));
            self.putUserData(Keys.VARIABLE, collection.getUserData(Keys.VARIABLE));
            forEach.setInExpression(self);
        } else {
            forEach.setInExpression(collection);
        }
        AstNodeCollection<Statement> bodyStatements = body.getStatements();
        bodyStatements.clear();
        AstNode astNode = itemParent = item != null ? item.getParent() : null;
        if (itemParent != null && itemParent.getParent() instanceof AssignmentExpression && ((AssignmentExpression)itemParent.getParent()).getRight() == itemParent) {
            Statement itemStatement = CollectionUtilities.firstOrDefault(itemParent.getParent().getAncestors(Statement.class));
            item.remove();
            itemParent.replaceWith(item);
            if (itemStatement != null) {
                itemStatement.remove();
                bodyStatements.add(itemStatement);
            }
        }
        for (Statement statement : m22.get("statement")) {
            statement.remove();
            bodyStatements.add(statement);
        }
        Statement firstStatement = CollectionUtilities.firstOrDefault(body.getStatements());
        Statement lastStatement = CollectionUtilities.lastOrDefault(body.getStatements());
        if (firstStatement != null && lastStatement != null) {
            DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(this.context, body);
            analysis.setAnalyzedRange(firstStatement, lastStatement);
            if (item == null) {
                forEach.addVariableModifier(Flags.Flag.FINAL);
            } else {
                analysis.analyze(item.getIdentifier(), DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED);
                if (!analysis.isPotentiallyAssigned()) {
                    forEach.addVariableModifier(Flags.Flag.FINAL);
                }
            }
        }
        return forEach;
    }

    public final DoWhileStatement transformDoWhile(WhileStatement loop) {
        boolean hasContinueCondition;
        Match m4 = DO_WHILE_PATTERN.match(loop);
        if (!m4.success() || !this.canConvertWhileToDoWhile(loop, (ContinueStatement)CollectionUtilities.firstOrDefault(m4.get("continueStatement")))) {
            return null;
        }
        DoWhileStatement doWhile = new DoWhileStatement(loop.getOffset());
        Expression condition = (Expression)CollectionUtilities.firstOrDefault(m4.get("continueCondition"));
        boolean bl = hasContinueCondition = condition != null;
        if (hasContinueCondition) {
            condition.remove();
            ((Statement)CollectionUtilities.first(m4.get("breakStatement"))).remove();
        } else {
            condition = (Expression)CollectionUtilities.first(m4.get("breakCondition"));
            condition.remove();
            if (condition instanceof UnaryOperatorExpression && ((UnaryOperatorExpression)condition).getOperator() == UnaryOperatorType.NOT) {
                condition = ((UnaryOperatorExpression)condition).getExpression();
                condition.remove();
            } else {
                condition = new UnaryOperatorExpression(UnaryOperatorType.NOT, condition);
            }
        }
        doWhile.setCondition(condition);
        BlockStatement block = (BlockStatement)loop.getEmbeddedStatement();
        Statement lastStatement = CollectionUtilities.lastOrDefault(block.getStatements());
        if (lastStatement != null) {
            lastStatement.remove();
        }
        block.remove();
        doWhile.setEmbeddedStatement(block);
        loop.replaceWith(doWhile);
        for (Statement statement : block.getStatements()) {
            VariableDeclarationStatement declaration;
            VariableInitializer v;
            if (!(statement instanceof VariableDeclarationStatement) || (v = CollectionUtilities.firstOrDefault((declaration = (VariableDeclarationStatement)statement).getVariables())) == null) continue;
            for (AstNode node : condition.getDescendantsAndSelf()) {
                if (!(node instanceof IdentifierExpression) || !StringUtilities.equals(v.getName(), ((IdentifierExpression)node).getIdentifier())) continue;
                Expression initializer = v.getInitializer();
                initializer.remove();
                AssignmentExpression assignment = new AssignmentExpression(new IdentifierExpression(statement.getOffset(), v.getName()), initializer);
                assignment.putUserData(Keys.MEMBER_REFERENCE, initializer.getUserData(Keys.MEMBER_REFERENCE));
                assignment.putUserData(Keys.VARIABLE, initializer.getUserData(Keys.VARIABLE));
                v.putUserData(Keys.MEMBER_REFERENCE, null);
                v.putUserData(Keys.VARIABLE, null);
                assignment.putUserData(Keys.MEMBER_REFERENCE, declaration.getUserData(Keys.MEMBER_REFERENCE));
                assignment.putUserData(Keys.VARIABLE, declaration.getUserData(Keys.VARIABLE));
                declaration.replaceWith(new ExpressionStatement(assignment));
                declaration.putUserData(Keys.MEMBER_REFERENCE, null);
                declaration.putUserData(Keys.VARIABLE, null);
                doWhile.getParent().insertChildBefore(doWhile, declaration, BlockStatement.STATEMENT_ROLE);
            }
        }
        return doWhile;
    }

    private boolean canConvertWhileToDoWhile(WhileStatement loop, ContinueStatement continueStatement) {
        ArrayList<ContinueStatement> continueStatements = new ArrayList<ContinueStatement>();
        for (AstNode node : loop.getDescendantsAndSelf()) {
            if (!(node instanceof ContinueStatement)) continue;
            continueStatements.add((ContinueStatement)node);
        }
        if (continueStatements.isEmpty()) {
            return true;
        }
        for (ContinueStatement cs : continueStatements) {
            String label = cs.getLabel();
            if (StringUtilities.isNullOrEmpty(label) && cs != continueStatement) {
                return false;
            }
            Statement previousStatement = loop.getPreviousStatement();
            if (previousStatement instanceof LabelStatement) {
                return !StringUtilities.equals(((LabelStatement)previousStatement).getLabel(), label);
            }
            if (!(loop.getParent() instanceof LabeledStatement)) continue;
            return !StringUtilities.equals(((LabeledStatement)loop.getParent()).getLabel(), label);
        }
        return true;
    }

    public final WhileStatement transformContinueOuter(WhileStatement loop) {
        Match m4 = CONTINUE_OUTER_PATTERN.match(loop);
        if (!m4.success()) {
            return loop;
        }
        LabelStatement label = (LabelStatement)m4.get("label").iterator().next();
        label.remove();
        loop.getParent().insertChildBefore(loop, label, BlockStatement.STATEMENT_ROLE);
        return loop;
    }

    static VariableDeclarationStatement findVariableDeclaration(AstNode node, String identifier) {
        for (AstNode current = node; current != null; current = current.getParent()) {
            while (current.getPreviousSibling() != null) {
                if (!((current = current.getPreviousSibling()) instanceof VariableDeclarationStatement)) continue;
                VariableDeclarationStatement variableDeclaration = (VariableDeclarationStatement)current;
                Variable variable = variableDeclaration.getUserData(Keys.VARIABLE);
                if (variable != null && StringUtilities.equals(variable.getName(), identifier)) {
                    return variableDeclaration;
                }
                if (variableDeclaration.getVariables().size() != 1 || !StringUtilities.equals(variableDeclaration.getVariables().firstOrNullObject().getName(), identifier)) continue;
                return variableDeclaration;
            }
        }
        return null;
    }

    static Statement canMoveVariableDeclarationIntoStatement(DecompilerContext context, VariableDeclarationStatement declaration, Statement targetStatement) {
        BlockStatement block;
        if (declaration == null) {
            return null;
        }
        BlockStatement parent = (BlockStatement)declaration.getParent();
        assert (CollectionUtilities.contains(targetStatement.getAncestors(), parent));
        ArrayList<BlockStatement> blocks = new ArrayList<BlockStatement>();
        for (AstNode block2 : targetStatement.getAncestors()) {
            if (block2 == parent) break;
            if (!(block2 instanceof BlockStatement)) continue;
            blocks.add((BlockStatement)block2);
        }
        blocks.add(parent);
        Collections.reverse(blocks);
        StrongBox<Statement> declarationPoint = new StrongBox<Statement>();
        DefiniteAssignmentAnalysis analysis = new DefiniteAssignmentAnalysis(context, (Statement)blocks.get(0));
        Statement result = null;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext() && DeclareVariablesTransform.findDeclarationPoint(analysis, declaration, block = (BlockStatement)iterator.next(), declarationPoint, null)) {
            result = declarationPoint.get();
        }
        return result;
    }

    static {
        ForStatement forArrayPattern1 = new ForStatement(-34);
        VariableDeclarationStatement declaration1 = new VariableDeclarationStatement();
        SimpleType variableType1 = new SimpleType("int");
        variableType1.putUserData(Keys.TYPE_REFERENCE, BuiltinTypes.Integer);
        declaration1.setType(variableType1);
        declaration1.getVariables().add(new VariableInitializer("$any$", new NamedNode("array", new IdentifierExpression(-34, "$any$")).toExpression().member("length")));
        declaration1.getVariables().add(new VariableInitializer("$any$", new PrimitiveExpression(-34, 0)));
        forArrayPattern1.getInitializers().add(new NamedNode("declaration", declaration1).toStatement());
        forArrayPattern1.setCondition(new BinaryOperatorExpression(new NamedNode("index", new IdentifierExpression(-34, "$any$")).toExpression(), BinaryOperatorType.LESS_THAN, new NamedNode("length", new IdentifierExpression(-34, "$any$")).toExpression()));
        forArrayPattern1.getIterators().add(new ExpressionStatement(new UnaryOperatorExpression(UnaryOperatorType.INCREMENT, new BackReference("index").toExpression())));
        BlockStatement embeddedStatement1 = new BlockStatement();
        embeddedStatement1.add(new ExpressionStatement(new AssignmentChain(new NamedNode("item", new IdentifierExpression(-34, "$any$")).toExpression(), new IndexerExpression(-34, new BackReference("array").toExpression(), new BackReference("index").toExpression())).toExpression()));
        embeddedStatement1.add(new Repeat(new AnyNode("statement")).toStatement());
        forArrayPattern1.setEmbeddedStatement(embeddedStatement1);
        FOR_ARRAY_PATTERN_1 = forArrayPattern1;
        ForStatement forArrayPattern2 = new ForStatement(-34);
        VariableDeclarationStatement declaration2 = new VariableDeclarationStatement();
        SimpleType variableType2 = new SimpleType("int");
        variableType2.putUserData(Keys.TYPE_REFERENCE, BuiltinTypes.Integer);
        declaration2.setType(variableType2);
        declaration2.getVariables().add(new VariableInitializer("$any$", new PrimitiveExpression(-34, 0)));
        forArrayPattern2.getInitializers().add(new NamedNode("declaration", declaration2).toStatement());
        forArrayPattern2.setCondition(new BinaryOperatorExpression(new NamedNode("index", new IdentifierExpression(-34, "$any$")).toExpression(), BinaryOperatorType.LESS_THAN, new NamedNode("length", new IdentifierExpression(-34, "$any$")).toExpression()));
        forArrayPattern2.getIterators().add(new ExpressionStatement(new UnaryOperatorExpression(UnaryOperatorType.INCREMENT, new BackReference("index").toExpression())));
        BlockStatement embeddedStatement2 = new BlockStatement();
        embeddedStatement2.add(new ExpressionStatement(new AssignmentChain(new NamedNode("item", new IdentifierExpression(-34, "$any$")).toExpression(), new IndexerExpression(-34, new NamedNode("array", new IdentifierExpression(-34, "$any$")).toExpression(), new BackReference("index").toExpression())).toExpression()));
        embeddedStatement2.add(new Repeat(new AnyNode("statement")).toStatement());
        forArrayPattern2.setEmbeddedStatement(embeddedStatement2);
        FOR_ARRAY_PATTERN_2 = forArrayPattern2;
        ForStatement altForArrayPattern = new ForStatement(-34);
        altForArrayPattern.getInitializers().add(new ExpressionStatement(new AssignmentExpression(new NamedNode("length", new IdentifierExpression(-34, "$any$")).toExpression(), AssignmentOperatorType.ASSIGN, new NamedNode("array", new IdentifierExpression(-34, "$any$")).toExpression().member("length"))));
        altForArrayPattern.getInitializers().add(new ExpressionStatement(new AssignmentExpression(new NamedNode("index", new IdentifierExpression(-34, "$any$")).toExpression(), AssignmentOperatorType.ASSIGN, new PrimitiveExpression(-34, 0))));
        altForArrayPattern.setCondition(new BinaryOperatorExpression(new BackReference("index").toExpression(), BinaryOperatorType.LESS_THAN, new BackReference("length").toExpression()));
        altForArrayPattern.getIterators().add(new ExpressionStatement(new UnaryOperatorExpression(UnaryOperatorType.INCREMENT, new BackReference("index").toExpression())));
        BlockStatement altEmbeddedStatement = new BlockStatement();
        altEmbeddedStatement.add(new ExpressionStatement(new AssignmentChain(new NamedNode("item", new IdentifierExpression(-34, "$any$")).toExpression(), new IndexerExpression(-34, new BackReference("array").toExpression(), new BackReference("index").toExpression())).toExpression()));
        altEmbeddedStatement.add(new Repeat(new AnyNode("statement")).toStatement());
        altForArrayPattern.setEmbeddedStatement(altEmbeddedStatement);
        FOR_ARRAY_PATTERN_3 = altForArrayPattern;
        GET_ITERATOR_PATTERN = new ExpressionStatement(new AssignmentExpression(new NamedNode("left", new AnyNode()).toExpression(), new AnyNode("collection").toExpression().invoke("iterator", new Expression[0])));
        WhileStatement forEachPattern = new WhileStatement(-34);
        forEachPattern.setCondition(new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new NamedNode("iterator", new IdentifierExpression(-34, "$any$")).toExpression(), "hasNext", new AstType[0]), new Expression[0]));
        BlockStatement embeddedStatement = new BlockStatement();
        embeddedStatement.add(new NamedNode("next", new ExpressionStatement(new AssignmentChain(new NamedNode("item", new IdentifierExpression(-34, "$any$")), new Choice(new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new BackReference("iterator").toExpression(), "next", new AstType[0]), new Expression[0]), new CastExpression(new AnyNode("castType").toType(), new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new BackReference("iterator").toExpression(), "next", new AstType[0]), new Expression[0])))).toExpression())).toStatement());
        embeddedStatement.add(new Repeat(new AnyNode("statement")).toStatement());
        forEachPattern.setEmbeddedStatement(embeddedStatement);
        FOR_EACH_PATTERN = forEachPattern;
        WhileStatement emptyPattern = new WhileStatement(forEachPattern.getCondition().clone());
        emptyPattern.setEmbeddedStatement(new BlockStatement(new ExpressionStatement(new IdentifierBackReference("iterator").toExpression().invoke("next", new Expression[0]))));
        EMPTY_FOR_EACH_PATTERN = emptyPattern;
        WhileStatement doWhile = new WhileStatement(-34);
        doWhile.setCondition(new PrimitiveExpression(-34, true));
        doWhile.setEmbeddedStatement(new Choice(new BlockStatement(new Repeat(new AnyNode("statement")).toStatement(), new IfElseStatement(-34, new AnyNode("breakCondition").toExpression(), (Statement)new BlockStatement(new BreakStatement(-34)))), new BlockStatement(new Repeat(new AnyNode("statement")).toStatement(), new IfElseStatement(-34, new AnyNode("continueCondition").toExpression(), (Statement)new BlockStatement(new NamedNode("continueStatement", new ContinueStatement(-34)).toStatement())), new NamedNode("breakStatement", new BreakStatement(-34)).toStatement())).toBlockStatement());
        DO_WHILE_PATTERN = doWhile;
        WhileStatement continueOuter = new WhileStatement(-34);
        continueOuter.setCondition(new AnyNode().toExpression());
        continueOuter.setEmbeddedStatement(new BlockStatement(new NamedNode("label", new LabelStatement(-34, "$any$")).toStatement(), new Repeat(new AnyNode("statement")).toStatement()));
        CONTINUE_OUTER_PATTERN = continueOuter;
    }
}

