/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.ExceptionUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.semantics.ResolveResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RewriteBoxingCastsTransform
extends ContextTrackingVisitor<Void> {
    private static final Map<String, MethodReference> BOX_METHODS;
    private final JavaResolver _resolver;

    protected RewriteBoxingCastsTransform(DecompilerContext context) {
        super(context);
        this._resolver = new JavaResolver(context);
    }

    @Override
    public void run(AstNode compilationUnit) {
        if (this.context.getCurrentType().getCompilerTarget().boxWithConstructors()) {
            return;
        }
        super.run(compilationUnit);
    }

    @Override
    public Void visitCastExpression(CastExpression node, Void data) {
        MethodReference boxMethod;
        Expression operand;
        ResolveResult rr;
        TypeReference unboxedType;
        super.visitCastExpression(node, data);
        AstType castType = node.getType();
        TypeReference typeReference = castType.toTypeReference();
        if (typeReference != null && !typeReference.isPrimitive() && (unboxedType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(typeReference)).isPrimitive() && (rr = this._resolver.apply(operand = node.getExpression())) != null && rr.getType() != null && MetadataHelper.getConversionType(unboxedType, rr.getType()).isImplicit() && (boxMethod = BOX_METHODS.get(typeReference.getInternalName())) != null) {
            castType.remove();
            operand.remove();
            InvocationExpression replacement = castType.invoke("valueOf", operand);
            replacement.putUserData(Keys.MEMBER_REFERENCE, boxMethod);
            replacement.getTarget().putUserData(Keys.MEMBER_REFERENCE, boxMethod);
            node.replaceWith(replacement);
        }
        return null;
    }

    static {
        Map<String, MethodReference> boxMethods;
        try {
            String[] methods = new String[]{"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;", "java/lang/Character.valueOf:(C)Ljava/lang/Character;", "java/lang/Byte.valueOf:(B)Ljava/lang/Byte;", "java/lang/Short.valueOf:(S)Ljava/lang/Short;", "java/lang/Integer.valueOf:(I)Ljava/lang/Integer;", "java/lang/Long.valueOf:(J)Ljava/lang/Long;", "java/lang/Float.valueOf:(F)Ljava/lang/Float;", "java/lang/Double.valueOf:(D)Ljava/lang/Double;"};
            MetadataParser parser = new MetadataParser();
            boxMethods = new HashMap();
            for (String s2 : methods) {
                TypeReference t2 = parser.parseTypeDescriptor(s2.substring(0, s2.indexOf(46)));
                MethodReference m4 = parser.parseMethod(t2, "valueOf", s2.substring(s2.indexOf(58) + 1));
                boxMethods.put(t2.getInternalName(), m4);
            }
        }
        catch (Throwable ignored) {
            ExceptionUtilities.rethrowCritical(ignored);
            boxMethods = Collections.emptyMap();
        }
        BOX_METHODS = boxMethods;
    }
}

