/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classprovider;

import cuchaz.enigma.classprovider.ClassProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class CombiningClassProvider
implements ClassProvider {
    private final ClassProvider[] classProviders;

    public CombiningClassProvider(ClassProvider ... classProviders) {
        this.classProviders = classProviders;
    }

    @Override
    public Collection<String> getClassNames() {
        return Arrays.stream(this.classProviders).map(ClassProvider::getClassNames).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public ClassNode get(String name) {
        for (ClassProvider cp : this.classProviders) {
            ClassNode node = cp.get(name);
            if (node == null) continue;
            return node;
        }
        return null;
    }
}

