/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.vineflower;

import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.utils.AsmUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.objectweb.asm.tree.ClassNode;

class VineflowerContextSource
implements IContextSource {
    private final IContextSource classpathSource = new ClasspathSource();
    private final ClassProvider classProvider;
    private final String className;
    private IContextSource.Entries entries;

    VineflowerContextSource(ClassProvider classProvider, String className) {
        this.classProvider = classProvider;
        this.className = className;
    }

    public IContextSource getClasspath() {
        return this.classpathSource;
    }

    @Override
    public String getName() {
        return "Enigma-provided context for class " + this.className;
    }

    @Override
    public IContextSource.Entries getEntries() {
        this.computeEntriesIfNecessary();
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEntriesIfNecessary() {
        if (this.entries != null) {
            return;
        }
        VineflowerContextSource vineflowerContextSource = this;
        synchronized (vineflowerContextSource) {
            if (this.entries != null) {
                return;
            }
            ArrayList<String> classNames = new ArrayList<String>();
            classNames.add(this.className);
            int dollarIndex = this.className.indexOf(36);
            String outermostClass = dollarIndex == -1 ? this.className : this.className.substring(0, this.className.indexOf(36));
            String outermostClassSuffixed = outermostClass + "$";
            for (String currentClass : this.classProvider.getClassNames()) {
                if (!currentClass.startsWith(outermostClassSuffixed) || currentClass.equals(this.className)) continue;
                classNames.add(currentClass);
            }
            List<IContextSource.Entry> classes = classNames.stream().map(IContextSource.Entry::atBase).toList();
            this.entries = new IContextSource.Entries(classes, Collections.emptyList(), Collections.emptyList());
        }
    }

    @Override
    public InputStream getInputStream(String resource) {
        ClassNode node = this.classProvider.get(resource.substring(0, resource.lastIndexOf(".class")));
        if (node == null) {
            return null;
        }
        return new ByteArrayInputStream(AsmUtil.nodeToBytes(node));
    }

    @Override
    public IContextSource.IOutputSink createOutputSink(final IResultSaver saver) {
        return new IContextSource.IOutputSink(){

            @Override
            public void begin() {
            }

            @Override
            public void acceptClass(String qualifiedName, String fileName, String content, int[] mapping) {
                if (qualifiedName.equals(VineflowerContextSource.this.className)) {
                    saver.saveClassFile(null, qualifiedName, fileName, content, mapping);
                }
            }

            @Override
            public void acceptDirectory(String directory) {
            }

            @Override
            public void acceptOther(String path) {
            }

            @Override
            public void close() {
            }
        };
    }

    public class ClasspathSource
    implements IContextSource {
        @Override
        public String getName() {
            return "Enigma-provided classpath context for " + VineflowerContextSource.this.className;
        }

        @Override
        public IContextSource.Entries getEntries() {
            return IContextSource.Entries.EMPTY;
        }

        @Override
        public boolean isLazy() {
            return true;
        }

        @Override
        public InputStream getInputStream(String resource) {
            return VineflowerContextSource.this.getInputStream(resource);
        }
    }
}

