/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.MappingDelta;
import cuchaz.enigma.translation.mapping.MappingOperations;
import cuchaz.enigma.translation.mapping.serde.MappingIoConverter;
import cuchaz.enigma.translation.mapping.serde.MappingParseException;
import cuchaz.enigma.translation.mapping.serde.MappingSaveParameters;
import cuchaz.enigma.translation.mapping.serde.MappingsReader;
import cuchaz.enigma.translation.mapping.serde.MappingsWriter;
import cuchaz.enigma.translation.mapping.serde.enigma.EnigmaMappingsReader;
import cuchaz.enigma.translation.mapping.serde.enigma.EnigmaMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.proguard.ProguardMappingsReader;
import cuchaz.enigma.translation.mapping.serde.recaf.RecafMappingsReader;
import cuchaz.enigma.translation.mapping.serde.recaf.RecafMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.srg.SrgMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.tiny.TinyMappingsReader;
import cuchaz.enigma.translation.mapping.serde.tiny.TinyMappingsWriter;
import cuchaz.enigma.translation.mapping.serde.tinyv2.TinyV2Reader;
import cuchaz.enigma.translation.mapping.serde.tinyv2.TinyV2Writer;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.utils.I18n;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.MappingWriter;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.mappingio.tree.VisitOrder;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.ApiStatus;

public enum MappingFormat {
    ENIGMA_FILE(EnigmaMappingsWriter.FILE, EnigmaMappingsReader.FILE, FileType.MAPPING, net.fabricmc.mappingio.format.MappingFormat.ENIGMA_FILE),
    ENIGMA_DIRECTORY(EnigmaMappingsWriter.DIRECTORY, EnigmaMappingsReader.DIRECTORY, FileType.DIRECTORY, net.fabricmc.mappingio.format.MappingFormat.ENIGMA_DIR),
    ENIGMA_ZIP(EnigmaMappingsWriter.ZIP, EnigmaMappingsReader.ZIP, FileType.ZIP, null),
    TINY_V2(new TinyV2Writer("intermediary", "named"), new TinyV2Reader(), FileType.TINY, net.fabricmc.mappingio.format.MappingFormat.TINY_2_FILE),
    TINY_FILE(TinyMappingsWriter.INSTANCE, TinyMappingsReader.INSTANCE, FileType.TINY, net.fabricmc.mappingio.format.MappingFormat.TINY_FILE),
    SRG_FILE(SrgMappingsWriter.INSTANCE, null, FileType.SRG, net.fabricmc.mappingio.format.MappingFormat.SRG_FILE),
    XSRG_FILE(null, null, FileType.XSRG, net.fabricmc.mappingio.format.MappingFormat.XSRG_FILE),
    JAM_FILE(null, null, FileType.JAM, net.fabricmc.mappingio.format.MappingFormat.JAM_FILE),
    CSRG_FILE(null, null, FileType.CSRG, net.fabricmc.mappingio.format.MappingFormat.CSRG_FILE),
    TSRG_FILE(null, null, FileType.TSRG, net.fabricmc.mappingio.format.MappingFormat.TSRG_FILE),
    TSRG_2_FILE(null, null, FileType.TSRG, net.fabricmc.mappingio.format.MappingFormat.TSRG_2_FILE),
    PROGUARD(null, ProguardMappingsReader.INSTANCE, FileType.TXT, net.fabricmc.mappingio.format.MappingFormat.PROGUARD_FILE),
    RECAF(RecafMappingsWriter.INSTANCE, RecafMappingsReader.INSTANCE, FileType.TXT, net.fabricmc.mappingio.format.MappingFormat.RECAF_SIMPLE_FILE),
    JOBF_FILE(null, null, FileType.JOBF, net.fabricmc.mappingio.format.MappingFormat.JOBF_FILE),
    INTELLIJ_MIGRATION_MAP_FILE(null, null, FileType.XML, net.fabricmc.mappingio.format.MappingFormat.INTELLIJ_MIGRATION_MAP_FILE);

    private final MappingsWriter writer;
    private final MappingsReader reader;
    private final FileType fileType;
    private final net.fabricmc.mappingio.format.MappingFormat mappingIoCounterpart;
    private final boolean hasMappingIoWriter;
    private boolean usedMappingIoWriterLast;

    private MappingFormat(MappingsWriter writer, MappingsReader reader, FileType fileType, net.fabricmc.mappingio.format.MappingFormat mappingIoCounterpart) {
        this.writer = writer;
        this.reader = reader;
        this.fileType = fileType;
        this.mappingIoCounterpart = mappingIoCounterpart;
        this.hasMappingIoWriter = mappingIoCounterpart == null ? false : mappingIoCounterpart.hasWriter;
    }

    public void write(EntryTree<EntryMapping> mappings, Path path, ProgressListener progressListener, MappingSaveParameters saveParameters) {
        this.write(mappings, MappingDelta.added(mappings), path, progressListener, saveParameters);
    }

    public void write(EntryTree<EntryMapping> mappings, MappingDelta<EntryMapping> delta, Path path, ProgressListener progressListener, MappingSaveParameters saveParameters) {
        if (!this.hasMappingIoWriter || !this.useMappingIo() && this.writer != null) {
            this.writer.write(mappings, this.usedMappingIoWriterLast ? MappingDelta.added(mappings) : delta, path, progressListener, saveParameters);
            this.usedMappingIoWriterLast = false;
            return;
        }
        try {
            if (this == ENIGMA_DIRECTORY) {
                EnigmaMappingsWriter.DIRECTORY.write(mappings, this.usedMappingIoWriterLast ? MappingDelta.added(mappings) : delta, path, progressListener, saveParameters, true);
                this.usedMappingIoWriterLast = false;
            } else {
                if (this == PROGUARD) {
                    mappings = MappingOperations.invert(mappings);
                }
                VisitableMappingTree tree = MappingIoConverter.toMappingIo(mappings, progressListener);
                progressListener.init(1, I18n.translate("progress.mappings.writing"));
                progressListener.step(1, null);
                tree.accept(MappingWriter.create(path, this.mappingIoCounterpart), VisitOrder.createByName());
                progressListener.step(1, I18n.translate("progress.done"));
                this.usedMappingIoWriterLast = true;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public EntryTree<EntryMapping> read(Path path, ProgressListener progressListener, MappingSaveParameters saveParameters) throws IOException, MappingParseException {
        return this.read(path, progressListener, saveParameters, null);
    }

    public EntryTree<EntryMapping> read(Path path, ProgressListener progressListener, MappingSaveParameters saveParameters, JarIndex index) throws IOException, MappingParseException {
        if (this.mappingIoCounterpart == null || !this.useMappingIo() && this.reader != null) {
            return this.reader.read(path, progressListener, saveParameters);
        }
        String loadingMessage = this.mappingIoCounterpart.hasSingleFile() ? I18n.translate("progress.mappings.loading_file") : I18n.translate("progress.mappings.loading_directory");
        progressListener.init(1, loadingMessage);
        MemoryMappingTree mappingTree = new MemoryMappingTree();
        MappingReader.read(path, this.mappingIoCounterpart, (MappingVisitor)mappingTree);
        EntryTree<EntryMapping> mappings = MappingIoConverter.fromMappingIo(mappingTree, progressListener, index);
        return this == PROGUARD ? MappingOperations.invert(mappings) : mappings;
    }

    @Nullable
    @Deprecated
    public MappingsWriter getWriter() {
        return this.writer;
    }

    @Nullable
    @Deprecated
    public MappingsReader getReader() {
        return this.reader;
    }

    @ApiStatus.Internal
    public FileType getFileType() {
        return this.fileType;
    }

    @Nullable
    @ApiStatus.Internal
    public net.fabricmc.mappingio.format.MappingFormat getMappingIoCounterpart() {
        return this.mappingIoCounterpart;
    }

    @ApiStatus.Internal
    public boolean hasMappingIoWriter() {
        return this.hasMappingIoWriter;
    }

    public boolean isReadable() {
        return this.reader != null || this.mappingIoCounterpart != null;
    }

    public boolean isWritable() {
        return this.writer != null || this.hasMappingIoWriter;
    }

    private boolean useMappingIo() {
        return System.getProperty("enigma.use_mappingio", "true").equals("true");
    }

    public static List<MappingFormat> getReadableFormats() {
        return Arrays.stream(MappingFormat.values()).filter(MappingFormat::isReadable).toList();
    }

    public static List<MappingFormat> getWritableFormats() {
        return Arrays.stream(MappingFormat.values()).filter(MappingFormat::isWritable).toList();
    }

    @ApiStatus.Internal
    public record FileType(List<String> extensions) {
        public static final FileType DIRECTORY = new FileType(new String[0]);
        public static final FileType ZIP = new FileType(".zip");
        public static final FileType MAPPING = new FileType(".mapping", ".mappings");
        public static final FileType TINY = new FileType(".tiny");
        public static final FileType SRG = new FileType(".srg");
        public static final FileType XSRG = new FileType(".xsrg");
        public static final FileType JAM = new FileType(".jam");
        public static final FileType CSRG = new FileType(".csrg");
        public static final FileType TSRG = new FileType(".tsrg");
        public static final FileType TXT = new FileType(".txt");
        public static final FileType JOBF = new FileType(".jobf");
        public static final FileType XML = new FileType(".xml");

        public FileType(String ... extensions) {
            this(List.of(extensions));
        }

        public boolean isDirectory() {
            return this.extensions.isEmpty();
        }
    }
}

