/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;

public final class RootStatement
extends Statement {
    private final DummyExitStatement dummyExit;
    public final StructMethod mt;
    public Set<String> commentLines = null;
    public boolean addErrorComment = false;
    private final ContentFlags flags = new ContentFlags();

    public RootStatement(Statement head, DummyExitStatement dummyExit, StructMethod mt) {
        super(Statement.StatementType.ROOT);
        this.first = head;
        this.dummyExit = dummyExit;
        this.mt = mt;
        if (this.first == null) {
            throw new IllegalStateException("Root statement has no content!");
        }
        this.stats.addWithKey(this.first, this.first.id);
        this.first.setParent(this);
    }

    @Override
    public TextBuffer toJava(int indent) {
        return ExprProcessor.listToJava(this.varDefinitions, indent).append(this.first.toJava(indent));
    }

    public DummyExitStatement getDummyExit() {
        return this.dummyExit;
    }

    public void addComment(String comment) {
        this.addComment(comment, false);
    }

    public void addComment(String comment, boolean error) {
        if (this.commentLines == null) {
            this.commentLines = new LinkedHashSet<String>();
        }
        this.commentLines.add(comment);
        this.addErrorComment |= error;
    }

    public void addComments(RootStatement root) {
        if (root.commentLines != null) {
            for (String s2 : root.commentLines) {
                this.addComment(s2);
            }
        }
        this.addErrorComment |= root.addErrorComment;
    }

    public void addComments(ControlFlowGraph graph) {
        if (graph.commentLines != null) {
            for (String s2 : graph.commentLines) {
                this.addComment(s2);
            }
        }
        this.addErrorComment |= graph.addErrorComment;
    }

    public void buildContentFlags() {
        this.buildContentFlagsStat(this);
    }

    private void buildContentFlagsStat(Statement stat) {
        for (Statement st : stat.stats) {
            this.buildContentFlagsStat(st);
        }
        if (stat instanceof CatchStatement || stat instanceof CatchAllStatement) {
            this.flags.hasTryCatch = true;
        } else if (stat instanceof DoStatement) {
            this.flags.hasLoops = true;
        } else if (stat instanceof SwitchStatement) {
            this.flags.hasSwitch = true;
        }
    }

    public boolean hasTryCatch() {
        return this.flags.hasTryCatch;
    }

    public boolean hasLoops() {
        return this.flags.hasLoops;
    }

    public boolean hasSwitch() {
        return this.flags.hasSwitch;
    }

    @Override
    public StartEndPair getStartEndRange() {
        return StartEndPair.join(this.first.getStartEndRange(), this.dummyExit != null ? this.dummyExit.getStartEndRange() : null);
    }

    private static class ContentFlags {
        private boolean hasTryCatch;
        private boolean hasLoops;
        private boolean hasSwitch;

        private ContentFlags() {
        }
    }
}

