/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.TextTokenVisitor;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.Pair;
import org.jetbrains.java.decompiler.util.token.ClassTextToken;
import org.jetbrains.java.decompiler.util.token.FieldTextToken;
import org.jetbrains.java.decompiler.util.token.MethodTextToken;
import org.jetbrains.java.decompiler.util.token.TextToken;
import org.jetbrains.java.decompiler.util.token.VariableTextToken;

public class TextBuffer {
    private static final boolean ALLOW_TO_STRING = Boolean.getBoolean("decompiler.allow.text.buffer.to.string");
    private final String myLineSeparator = DecompilerContext.getNewLineSeparator();
    private final String myIndent = (String)DecompilerContext.getProperty("indent-string");
    private final int myPreferredLineLength = DecompilerContext.getIntOption("preferred-line-length");
    private final NewlineGroup myRootGroup;
    private NewlineGroup myCurrentGroup = this.myRootGroup = new NewlineGroup(null, 0, 0, 0);
    private boolean myHasReformatted = false;
    private final StringBuilder myStringBuilder;
    private Map<Integer, Integer> myLineToOffsetMapping = null;
    private final Map<BytecodeMappingKey, Integer> myBytecodeOffsetMapping = new LinkedHashMap<BytecodeMappingKey, Integer>();
    private final DebugTrace myDebugTrace = DecompilerContext.getOption("__unit_test_mode__") ? new DebugTrace(this) : null;
    private Map<Integer, Set<Integer>> myLineMapping = null;

    public TextBuffer() {
        this.myStringBuilder = new StringBuilder();
    }

    public TextBuffer(int size) {
        this.myStringBuilder = new StringBuilder(size);
    }

    public TextBuffer(String text) {
        this.myStringBuilder = new StringBuilder(text);
    }

    public TextBuffer append(String str) {
        this.myStringBuilder.append(str);
        return this;
    }

    public TextBuffer append(char ch) {
        this.myStringBuilder.append(ch);
        return this;
    }

    public TextBuffer append(int i) {
        this.myStringBuilder.append(i);
        return this;
    }

    public TextBuffer appendLineSeparator() {
        this.myStringBuilder.append(this.myLineSeparator);
        return this;
    }

    public TextBuffer appendIndent(int length) {
        while (length-- > 0) {
            this.append(this.myIndent);
        }
        return this;
    }

    public TextBuffer appendCastTypeName(VarType type) {
        return this.appendCastTypeName(ExprProcessor.getCastTypeName(type), type);
    }

    public TextBuffer appendCastTypeName(String castName, VarType type) {
        if (type.type == CodeType.OBJECT) {
            if (type.arrayDim > 0) {
                String name = castName.substring(0, castName.length() - type.arrayDim * 2);
                this.appendAllClasses(name, type.value);
                this.addGenericTypeTokens(this.length() - name.length(), name, type);
                this.append(castName.substring(castName.length() - type.arrayDim * 2));
            } else {
                this.appendAllClasses(castName, type.value);
                this.addGenericTypeTokens(this.length() - castName.length(), castName, type);
            }
            return this;
        }
        return this.append(castName);
    }

    public TextBuffer appendTypeName(VarType type) {
        return this.appendTypeName(ExprProcessor.getTypeName(type), type);
    }

    public TextBuffer appendTypeName(String name, VarType type) {
        if (type.type == CodeType.OBJECT) {
            this.appendAllClasses(name, type.value);
            this.addGenericTypeTokens(this.length() - name.length(), name, type);
            return this;
        }
        return this.append(name);
    }

    public TextBuffer addTypeNameToken(VarType type, int index) {
        if (type.type == CodeType.OBJECT) {
            String name = ExprProcessor.getTypeName(type);
            this.addAllClassTokens(index, name, type.value);
            this.addGenericTypeTokens(index, name, type);
        }
        return this;
    }

    public TextBuffer appendAllClasses(String text, String qualifiedName) {
        this.addAllClassTokens(this.length(), text, qualifiedName);
        return this.append(text);
    }

    public TextBuffer addAllClassTokens(int index, String text, String qualifiedName) {
        if (text.contains("<")) {
            text = text.substring(0, text.indexOf("<"));
        }
        int pos = 0;
        while (text.contains(".") && qualifiedName.substring(pos).contains("$")) {
            int length = text.indexOf(".");
            this.addClassToken(index, length, qualifiedName.substring(0, qualifiedName.indexOf("$", pos)));
            pos = qualifiedName.indexOf("$", pos) + 1;
            text = text.substring(length + 1);
            index += length + 1;
        }
        if (!text.isBlank()) {
            this.addClassToken(index, text.length(), qualifiedName);
        }
        return this;
    }

    public TextBuffer addGenericTypeTokens(int index, String text, VarType type) {
        if (!type.isGeneric()) {
            return this;
        }
        GenericType genType = (GenericType)type;
        index += text.indexOf("<") + 1;
        int offset = 0;
        for (int i = 0; i < genType.getArguments().size(); ++i) {
            VarType t2 = genType.getArguments().get(i);
            if (t2 == null) {
                ++offset;
            } else if (t2.isGeneric()) {
                GenericType gt = (GenericType)t2;
                switch (gt.getWildcard()) {
                    case 1: {
                        offset += 10;
                        break;
                    }
                    case 2: {
                        offset += 8;
                    }
                }
                String name = GenericMain.getGenericCastTypeName(gt);
                if (gt.type == CodeType.OBJECT) {
                    this.addAllClassTokens(index + offset, name, gt.value);
                }
                this.addGenericTypeTokens(index + offset, name, gt);
                offset += name.length();
            } else {
                if (t2.type == CodeType.OBJECT) {
                    this.addTypeNameToken(t2, index + offset);
                }
                offset += ExprProcessor.getCastTypeName(t2).length();
            }
            offset += 2;
        }
        return this;
    }

    public TextBuffer addClassToken(int index, int length, String name) {
        this.addToken(new ClassTextToken(index, length, false, name));
        return this;
    }

    public TextBuffer appendClass(String value, boolean declaration, String qualifiedName) {
        this.addToken(new ClassTextToken(this.length(), value.length(), declaration, qualifiedName));
        return this.append(value);
    }

    public TextBuffer appendField(String value, boolean declaration, String className, String name, String descriptor) {
        return this.appendField(value, declaration, className, name, FieldDescriptor.parseDescriptor(descriptor));
    }

    public TextBuffer appendField(String value, boolean declaration, String className, String name, FieldDescriptor descriptor) {
        this.addToken(new FieldTextToken(this.length(), value.length(), declaration, className, name, descriptor));
        return this.append(value);
    }

    public TextBuffer appendMethod(String value, boolean declaration, String className, String name, String descriptor) {
        return this.appendMethod(value, declaration, className, name, MethodDescriptor.parseDescriptor(descriptor));
    }

    public TextBuffer appendMethod(String value, boolean declaration, String className, String name, MethodDescriptor descriptor) {
        this.addToken(new MethodTextToken(this.length(), value.length(), declaration, className, name, descriptor));
        return this.append(value);
    }

    public TextBuffer appendVariable(String value, boolean declaration, boolean parameter, String className, String methodName, String methodDescriptor, int index, String name) {
        return this.appendVariable(value, declaration, parameter, className, methodName, MethodDescriptor.parseDescriptor(methodDescriptor), index, name);
    }

    public TextBuffer appendVariable(String value, boolean declaration, boolean parameter, String className, String methodName, MethodDescriptor methodDescriptor, int index, String name) {
        this.addToken(new VariableTextToken(this.length(), value.length(), declaration, parameter, className, methodName, methodDescriptor, index, name));
        return this.append(value);
    }

    private void addToken(TextToken token) {
        this.myCurrentGroup.myTokens.add(token);
    }

    public TextBuffer pushNewlineGroup(int baseIndent, int extraIndent) {
        NewlineGroup group = new NewlineGroup(this.myCurrentGroup, this.myStringBuilder.length(), baseIndent, extraIndent);
        this.myCurrentGroup.myChildren.add(group);
        this.myCurrentGroup = group;
        return this;
    }

    public TextBuffer appendPossibleNewline() {
        return this.appendPossibleNewline("");
    }

    public TextBuffer appendPossibleNewline(String alternative) {
        return this.appendPossibleNewline(alternative, false);
    }

    public TextBuffer appendPossibleNewline(String alternative, boolean dedent) {
        this.myCurrentGroup.myReplacements.add(new NewlineGroup.Replacement(this.myStringBuilder.length(), alternative.length(), dedent));
        return this.append(alternative);
    }

    public TextBuffer popNewlineGroup() {
        if (this.myCurrentGroup == this.myRootGroup) {
            throw new IllegalStateException("Cannot pop root group: " + this.convertToStringAndAllowDataDiscard());
        }
        assert (this.myStringBuilder.length() >= this.myCurrentGroup.myStart);
        this.myCurrentGroup.myLength = this.myStringBuilder.length() - this.myCurrentGroup.myStart;
        this.myCurrentGroup = this.myCurrentGroup.myParent;
        return this;
    }

    public TextBuffer prepend(String s2) {
        this.myStringBuilder.insert(0, s2);
        this.shiftMapping(s2.length());
        return this;
    }

    public TextBuffer enclose(String left, String right) {
        this.prepend(left);
        this.append(right);
        return this;
    }

    public TextBuffer encloseWithParens() {
        return this.enclose("(", ")");
    }

    public boolean containsOnlyWhitespaces() {
        for (int i = 0; i < this.myStringBuilder.length(); ++i) {
            if (this.myStringBuilder.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public void addBytecodeMapping(int bytecodeOffset) {
        if (this.myDebugTrace != null) {
            this.myDebugTrace.myPreventDeletion = true;
        }
        this.myBytecodeOffsetMapping.putIfAbsent(new BytecodeMappingKey(bytecodeOffset, null, null), this.myStringBuilder.length());
    }

    public void addStartBytecodeMapping(int bytecodeOffset) {
        if (this.myDebugTrace != null) {
            this.myDebugTrace.myPreventDeletion = true;
        }
        this.myBytecodeOffsetMapping.putIfAbsent(new BytecodeMappingKey(bytecodeOffset, null, null), 0);
    }

    public void addBytecodeMapping(BitSet bytecodeOffsets) {
        if (bytecodeOffsets == null) {
            return;
        }
        int i = bytecodeOffsets.nextSetBit(0);
        while (i >= 0) {
            this.addBytecodeMapping(i);
            i = bytecodeOffsets.nextSetBit(i + 1);
        }
    }

    public void addStartBytecodeMapping(BitSet bytecodeOffsets) {
        if (bytecodeOffsets == null) {
            return;
        }
        int i = bytecodeOffsets.nextSetBit(0);
        while (i >= 0) {
            this.addStartBytecodeMapping(i);
            i = bytecodeOffsets.nextSetBit(i + 1);
        }
    }

    public void clearUnassignedBytecodeMappingData() {
        this.myBytecodeOffsetMapping.keySet().removeIf(key -> key.myClass == null);
    }

    public Map<Pair<String, String>, BytecodeMappingTracer> getTracers() {
        ArrayList<Integer> newlineOffsets = new ArrayList<Integer>();
        int i = this.myStringBuilder.indexOf(this.myLineSeparator);
        while (i != -1) {
            newlineOffsets.add(i);
            i = this.myStringBuilder.indexOf(this.myLineSeparator, i + 1);
        }
        LinkedHashMap<Pair<String, String>, BytecodeMappingTracer> tracers = new LinkedHashMap<Pair<String, String>, BytecodeMappingTracer>();
        this.myBytecodeOffsetMapping.forEach((key, textOffset) -> {
            if (key.myClass == null) {
                throw new IllegalStateException("getTracers called when not all bytecode offsets have a valid class and method");
            }
            BytecodeMappingTracer tracer = tracers.computeIfAbsent(Pair.of(key.myClass, key.myMethod), k -> new BytecodeMappingTracer());
            int lineNo = Collections.binarySearch(newlineOffsets, textOffset);
            if (lineNo < 0) {
                lineNo = -lineNo - 1;
            }
            tracer.setCurrentSourceLine(lineNo);
            tracer.addMapping(key.myBytecodeOffset);
        });
        return tracers;
    }

    private void reformatGroup(NewlineGroup group, List<Integer> offsetMapping, int extraIndent) {
        int groupEndWithoutNewlines;
        int offset = offsetMapping.get(group.myStart);
        int actualStart = group.myStart + offset;
        int lastNewline = this.myStringBuilder.lastIndexOf(this.myLineSeparator, actualStart);
        int nextNewline = this.myStringBuilder.indexOf(this.myLineSeparator, actualStart);
        int firstPartEnd = nextNewline == -1 ? actualStart + group.myLength : Math.min(nextNewline, actualStart + group.myLength);
        int n = groupEndWithoutNewlines = lastNewline == -1 ? firstPartEnd : firstPartEnd - lastNewline;
        while (nextNewline != -1 && nextNewline <= actualStart + group.myLength) {
            int lineLength;
            int lineStart = nextNewline;
            int lineEnd = nextNewline = this.myStringBuilder.indexOf(this.myLineSeparator, nextNewline + 1);
            if (lineEnd == -1 || lineEnd > actualStart + group.myLength) {
                lineEnd = actualStart + group.myLength;
            }
            if ((lineLength = extraIndent + lineEnd - lineStart - this.myLineSeparator.length()) <= groupEndWithoutNewlines) continue;
            groupEndWithoutNewlines = lineLength;
        }
        boolean addNewLines = groupEndWithoutNewlines > this.myPreferredLineLength;
        int originalExtraIndent = extraIndent;
        if (addNewLines && !group.myReplacements.isEmpty()) {
            extraIndent += group.myExtraIndent;
        }
        int childrenIndex = 0;
        int replacementIndex = 0;
        for (int pos = group.myStart; pos <= group.myStart + group.myLength; ++pos) {
            if (pos != group.myStart) {
                offsetMapping.add(offset);
            }
            assert (offsetMapping.size() == pos + 1);
            if (pos + offset + this.myLineSeparator.length() < this.myStringBuilder.length() && this.myStringBuilder.substring(pos + offset, pos + offset + this.myLineSeparator.length()).equals(this.myLineSeparator) && (pos + offset + this.myLineSeparator.length() * 2 >= this.myStringBuilder.length() || !this.myStringBuilder.substring(pos + offset + this.myLineSeparator.length(), pos + offset + this.myLineSeparator.length() * 2).equals(this.myLineSeparator))) {
                for (int i = 0; i < extraIndent; ++i) {
                    this.myStringBuilder.insert(pos + offset + this.myLineSeparator.length(), this.myIndent);
                }
                offset += this.myIndent.length() * extraIndent;
            }
            boolean anotherPass = true;
            while (anotherPass) {
                anotherPass = false;
                if (addNewLines && replacementIndex < group.myReplacements.size() && pos == group.myReplacements.get((int)replacementIndex).myStart) {
                    NewlineGroup.Replacement replacement = group.myReplacements.get(replacementIndex);
                    this.myStringBuilder.replace(pos + offset, pos + offset + replacement.myLength, this.myLineSeparator);
                    if (replacement.myDedent) {
                        extraIndent = originalExtraIndent;
                    }
                    for (int i = 0; i < group.myBaseIndent + extraIndent; ++i) {
                        this.myStringBuilder.insert(pos + offset + this.myLineSeparator.length(), this.myIndent);
                    }
                    offset += this.myIndent.length() * (group.myBaseIndent + extraIndent) + this.myLineSeparator.length() - replacement.myLength;
                    ++replacementIndex;
                    anotherPass = true;
                }
                offsetMapping.set(offsetMapping.size() - 1, offset);
                int currentPos = pos;
                if (childrenIndex >= group.myChildren.size() || group.myChildren.get((int)childrenIndex).myStart != currentPos) continue;
                NewlineGroup child = group.myChildren.get(childrenIndex);
                this.reformatGroup(child, offsetMapping, extraIndent);
                offset = offsetMapping.get(offsetMapping.size() - 1);
                pos += child.myLength;
                ++childrenIndex;
                anotherPass = true;
            }
        }
        offsetMapping.set(offsetMapping.size() - 1, offset);
        for (TextToken token : group.myTokens) {
            if (token.getStart() >= offsetMapping.size()) continue;
            token.shift(offsetMapping.get(token.getStart()));
        }
    }

    public void reformat() {
        if (this.myCurrentGroup != this.myRootGroup) {
            throw new IllegalStateException("Cannot reformat while in a group");
        }
        if (this.myHasReformatted) {
            throw new IllegalStateException("Cannot reformat twice");
        }
        this.myHasReformatted = true;
        this.myRootGroup.myLength = this.myStringBuilder.length();
        ArrayList<Integer> offsetMapping = new ArrayList<Integer>(this.myStringBuilder.length());
        offsetMapping.add(0);
        this.reformatGroup(this.myRootGroup, offsetMapping, 0);
        this.myBytecodeOffsetMapping.replaceAll((key, value) -> value + (Integer)offsetMapping.get((int)value));
    }

    public boolean contentEquals(String string) {
        return this.myStringBuilder.toString().equals(string);
    }

    public String convertToStringAndAllowDataDiscard() {
        if (this.myDebugTrace != null) {
            this.myDebugTrace.myPreventDeletion = false;
        }
        String original = this.myStringBuilder.toString();
        if (this.myLineToOffsetMapping == null || this.myLineToOffsetMapping.isEmpty()) {
            if (this.myLineMapping != null) {
                return this.addOriginalLineNumbers();
            }
            return original;
        }
        StringBuilder res = new StringBuilder();
        String[] srcLines = original.split(this.myLineSeparator);
        int currentLineStartOffset = 0;
        int currentLine = 0;
        int previousMarkLine = 0;
        int dumpedLines = 0;
        ArrayList<Integer> linesWithMarks = new ArrayList<Integer>(this.myLineToOffsetMapping.keySet());
        Collections.sort(linesWithMarks);
        block0: for (Integer markLine : linesWithMarks) {
            Integer markOffset = this.myLineToOffsetMapping.get(markLine);
            while (currentLine < srcLines.length) {
                String line = srcLines[currentLine];
                int lineEnd = currentLineStartOffset + line.length() + this.myLineSeparator.length();
                if (markOffset <= lineEnd) {
                    int requiredLine = markLine - 1;
                    int linesToAdd = requiredLine - dumpedLines;
                    dumpedLines = requiredLine;
                    this.appendLines(res, srcLines, previousMarkLine, currentLine, linesToAdd);
                    previousMarkLine = currentLine;
                    continue block0;
                }
                currentLineStartOffset = lineEnd;
                ++currentLine;
            }
        }
        if (previousMarkLine < srcLines.length) {
            this.appendLines(res, srcLines, previousMarkLine, srcLines.length, srcLines.length - previousMarkLine);
        }
        return res.toString();
    }

    public String toString() {
        if (!ALLOW_TO_STRING) {
            if (DecompilerContext.getOption("__unit_test_mode__")) {
                throw new AssertionError((Object)"Usage of TextBuffer.toString");
            }
            DecompilerContext.getLogger().writeMessage("Usage of TextBuffer.toString", IFernflowerLogger.Severity.WARN);
        }
        return this.convertToStringAndAllowDataDiscard();
    }

    private String addOriginalLineNumbers() {
        int lineEnd;
        StringBuilder sb = new StringBuilder();
        int lineStart = 0;
        int count = 0;
        int length = this.myLineSeparator.length();
        while ((lineEnd = this.myStringBuilder.indexOf(this.myLineSeparator, lineStart)) > 0) {
            sb.append(this.myStringBuilder.substring(lineStart, lineEnd));
            Set<Integer> integers = this.myLineMapping.get(++count);
            if (integers != null) {
                sb.append("//");
                for (Integer integer : integers) {
                    sb.append(' ').append(integer);
                }
            }
            sb.append(this.myLineSeparator);
            lineStart = lineEnd + length;
        }
        if (lineStart < this.myStringBuilder.length()) {
            sb.append(this.myStringBuilder.substring(lineStart));
        }
        return sb.toString();
    }

    private void appendLines(StringBuilder res, String[] srcLines, int from, int to, int requiredLineNumber) {
        if (to - from > requiredLineNumber) {
            List<String> strings = TextBuffer.compactLines(Arrays.asList(srcLines).subList(from, to), requiredLineNumber);
            int separatorsRequired = requiredLineNumber - 1;
            for (String s2 : strings) {
                res.append(s2);
                if (separatorsRequired-- <= 0) continue;
                res.append(this.myLineSeparator);
            }
            res.append(this.myLineSeparator);
        } else if (to - from <= requiredLineNumber) {
            int i;
            for (i = from; i < to; ++i) {
                res.append(srcLines[i]).append(this.myLineSeparator);
            }
            for (i = 0; i < requiredLineNumber - to + from; ++i) {
                res.append(this.myLineSeparator);
            }
        }
    }

    public int length() {
        return this.myStringBuilder.length();
    }

    public void setStart(int position) {
        this.myStringBuilder.delete(0, position);
        this.shiftMapping(-position);
    }

    public void setLength(int position) {
        this.myStringBuilder.setLength(position);
        if (this.myLineToOffsetMapping != null) {
            HashMap<Integer, Integer> newMap = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : this.myLineToOffsetMapping.entrySet()) {
                if (entry.getValue() > position) continue;
                newMap.put(entry.getKey(), entry.getValue());
            }
            this.myLineToOffsetMapping = newMap;
        }
        this.myRootGroup.truncate(position);
        assert (this.currentGroupExists());
    }

    private boolean currentGroupExists() {
        NewlineGroup group = this.myCurrentGroup;
        while (group != this.myRootGroup) {
            if (!group.myParent.myChildren.contains(group)) {
                return false;
            }
            group = group.myParent;
        }
        return true;
    }

    public TextBuffer append(TextBuffer buffer, String className, String methodKey) {
        if (buffer.myCurrentGroup != buffer.myRootGroup) {
            throw new IllegalArgumentException("Can't append buffer with non-root group");
        }
        if (buffer.myDebugTrace != null) {
            buffer.myDebugTrace.myPreventDeletion = false;
        }
        if (buffer.myLineToOffsetMapping != null && !buffer.myLineToOffsetMapping.isEmpty()) {
            this.checkMapCreated();
            for (Map.Entry<Integer, Integer> entry : buffer.myLineToOffsetMapping.entrySet()) {
                this.myLineToOffsetMapping.put(entry.getKey(), entry.getValue() + this.myStringBuilder.length());
            }
        }
        buffer.myBytecodeOffsetMapping.forEach((key, value) -> {
            if (key.myClass == null) {
                key = new BytecodeMappingKey(key.myBytecodeOffset, className, methodKey);
            }
            this.myBytecodeOffsetMapping.putIfAbsent((BytecodeMappingKey)key, value + this.myStringBuilder.length());
        });
        NewlineGroup otherRoot = buffer.myRootGroup.copy();
        otherRoot.shift(this.myStringBuilder.length());
        this.myCurrentGroup.myReplacements.addAll(otherRoot.myReplacements);
        this.myCurrentGroup.myTokens.addAll(otherRoot.myTokens);
        this.myCurrentGroup.myChildren.addAll(otherRoot.myChildren);
        this.myStringBuilder.append((CharSequence)buffer.myStringBuilder);
        return this;
    }

    public TextBuffer append(TextBuffer buffer) {
        return this.append(buffer, null, null);
    }

    public TextBuffer appendText(TextBuffer buffer) {
        NewlineGroup otherRoot = buffer.myRootGroup.copy();
        otherRoot.shift(this.myStringBuilder.length());
        this.myCurrentGroup.myTokens.addAll(otherRoot.myTokens);
        this.myStringBuilder.append((CharSequence)buffer.myStringBuilder);
        return this;
    }

    private void shiftMapping(int shiftOffset) {
        if (this.myLineToOffsetMapping != null) {
            HashMap<Integer, Integer> newMap = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : this.myLineToOffsetMapping.entrySet()) {
                int newValue = entry.getValue();
                if (newValue >= 0) {
                    newValue += shiftOffset;
                }
                if (newValue < 0) continue;
                newMap.put(entry.getKey(), newValue);
            }
            this.myLineToOffsetMapping = newMap;
        }
        this.myBytecodeOffsetMapping.replaceAll((key, value) -> value + shiftOffset);
        this.myRootGroup.shift(shiftOffset);
    }

    private void checkMapCreated() {
        if (this.myLineToOffsetMapping == null) {
            this.myLineToOffsetMapping = new HashMap<Integer, Integer>();
        }
    }

    public int countLines() {
        return this.countLines(0);
    }

    public int countLines(int from) {
        return this.count(this.myLineSeparator, from);
    }

    public int count(String substring, int from) {
        int count = 0;
        int length = substring.length();
        int p = from;
        while ((p = this.myStringBuilder.indexOf(substring, p)) > 0) {
            ++count;
            p += length;
        }
        return count;
    }

    @Deprecated
    public int countChars(char c) {
        this.convertToStringAndAllowDataDiscard();
        int count = 0;
        CharSequence chars = this.myStringBuilder.subSequence(0, this.myStringBuilder.length());
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    private static List<String> compactLines(List<String> srcLines, int requiredLineNumber) {
        String s2;
        int i;
        if (srcLines.size() < 2 || srcLines.size() <= requiredLineNumber) {
            return srcLines;
        }
        LinkedList<String> res = new LinkedList<String>(srcLines);
        for (i = res.size() - 1; i > 0; --i) {
            s2 = (String)res.get(i);
            if (s2.trim().equals("{") || s2.trim().equals("}")) {
                res.set(i - 1, ((String)res.get(i - 1)).concat(s2));
                res.remove(i);
            }
            if (res.size() > requiredLineNumber) continue;
            return res;
        }
        for (i = res.size() - 1; i > 0; --i) {
            s2 = (String)res.get(i);
            if (s2.trim().isEmpty()) {
                res.set(i - 1, ((String)res.get(i - 1)).concat(s2));
                res.remove(i);
            }
            if (res.size() > requiredLineNumber) continue;
            return res;
        }
        return res;
    }

    public void dumpOriginalLineNumbers(int[] lineMapping) {
        if (lineMapping.length > 0) {
            this.myLineMapping = new HashMap<Integer, Set<Integer>>();
            for (int i = 0; i < lineMapping.length; i += 2) {
                int key = lineMapping[i + 1];
                Set existing = this.myLineMapping.computeIfAbsent(key, k -> new TreeSet());
                existing.add(lineMapping[i]);
            }
        }
    }

    public String getPos(int index) {
        int lineStart;
        String before = this.myStringBuilder.substring(0, index);
        int line = before.split(this.myLineSeparator).length;
        return line + ":" + (index + 1 - (lineStart += (lineStart = before.lastIndexOf(this.myLineSeparator)) != -1 ? this.myLineSeparator.length() : 1));
    }

    public List<TextToken> getTokens() {
        return this.myRootGroup.flattenTokens();
    }

    public void visitTokens(TextTokenVisitor visitor) {
        if (visitor == null) {
            return;
        }
        visitor.start(this.myStringBuilder.toString());
        for (TextToken token : this.getTokens()) {
            token.visit(visitor);
        }
        visitor.end();
    }

    public static void checkLeaks() {
        DebugTrace.checkLeaks();
    }

    static class DebugTrace
    extends WeakReference<TextBuffer> {
        private static final Set<DebugTrace> ALL_REMAINING_TRACES = ConcurrentHashMap.newKeySet();
        private static final AtomicBoolean STARTED = new AtomicBoolean();
        private static final ReferenceQueue<TextBuffer> REFERENCE_QUEUE = new ReferenceQueue();
        final Throwable myCreationTrace = new Throwable();
        boolean myPreventDeletion = false;

        private static void ensureStarted() {
            if (!STARTED.getAndSet(true)) {
                Thread cleaner = new Thread(() -> {
                    while (true) {
                        DebugTrace trace;
                        try {
                            trace = (DebugTrace)REFERENCE_QUEUE.remove();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        trace.onDeletion();
                        ALL_REMAINING_TRACES.remove(trace);
                    }
                });
                cleaner.setName("TextBuffer debug cleaner");
                cleaner.setDaemon(true);
                cleaner.start();
            }
        }

        DebugTrace(TextBuffer buffer) {
            super(buffer, REFERENCE_QUEUE);
            DebugTrace.ensureStarted();
            ALL_REMAINING_TRACES.add(this);
        }

        private void onDeletion() {
            if (this.myPreventDeletion && !DotExporter.DUMP_DOTS && !DotExporter.DUMP_ERROR_DOTS) {
                throw new AssertionError("TextBuffer was garbage collected without being added to another TextBuffer, data loss occurred. See cause for the creation trace", this.myCreationTrace);
            }
        }

        static void checkLeaks() {
            for (DebugTrace trace : ALL_REMAINING_TRACES) {
                trace.onDeletion();
            }
            ALL_REMAINING_TRACES.clear();
        }
    }

    private static final class NewlineGroup {
        final NewlineGroup myParent;
        int myStart;
        int myLength;
        final int myBaseIndent;
        final int myExtraIndent;
        final List<NewlineGroup> myChildren = new ArrayList<NewlineGroup>();
        final List<Replacement> myReplacements = new ArrayList<Replacement>();
        final List<TextToken> myTokens = new ArrayList<TextToken>();

        NewlineGroup(NewlineGroup parent, int start, int baseIndent, int extraIndent) {
            this.myParent = parent;
            this.myStart = start;
            this.myBaseIndent = baseIndent;
            this.myExtraIndent = extraIndent;
        }

        void shift(int amount) {
            this.myStart += amount;
            for (Replacement replacement : this.myReplacements) {
                replacement.myStart += amount;
            }
            for (TextToken token : this.myTokens) {
                token.shift(amount);
            }
            for (NewlineGroup child : this.myChildren) {
                child.shift(amount);
            }
        }

        void truncate(int stringLength) {
            if (this.myStart + this.myLength > stringLength) {
                this.myLength = stringLength - this.myStart;
            }
            Iterator<NewlineGroup> itr = this.myChildren.iterator();
            while (itr.hasNext()) {
                NewlineGroup child = itr.next();
                if (child.myStart <= stringLength) {
                    child.truncate(stringLength);
                    continue;
                }
                itr.remove();
            }
            this.myReplacements.removeIf(r -> r.myStart > stringLength);
            this.myTokens.removeIf(t2 -> t2.getStart() > stringLength);
        }

        void dump(String indent) {
            System.out.println(indent + "group " + this.myStart + "-" + (this.myStart + this.myLength) + ": " + this.myReplacements.size() + " replacements");
            for (NewlineGroup child : this.myChildren) {
                child.dump(indent + "  ");
            }
        }

        NewlineGroup copy() {
            NewlineGroup copy = new NewlineGroup(this.myParent, this.myStart, this.myBaseIndent, this.myExtraIndent);
            copy.myLength = this.myLength;
            for (NewlineGroup child : this.myChildren) {
                copy.myChildren.add(child.copy());
            }
            for (TextToken token : this.myTokens) {
                copy.myTokens.add(token.copy());
            }
            copy.myReplacements.addAll(this.myReplacements);
            return copy;
        }

        private List<TextToken> flattenTokens() {
            ArrayList<TextToken> result = new ArrayList<TextToken>(this.myTokens);
            for (NewlineGroup child : this.myChildren) {
                result.addAll(child.flattenTokens());
            }
            result.sort(Comparator.comparingInt(TextToken::getStart));
            return result;
        }

        private static class Replacement {
            int myStart;
            final int myLength;
            final boolean myDedent;

            Replacement(int start, int length, boolean dedent) {
                this.myStart = start;
                this.myLength = length;
                this.myDedent = dedent;
            }
        }
    }

    private static final class BytecodeMappingKey {
        private final int myBytecodeOffset;
        private final String myClass;
        private final String myMethod;

        public BytecodeMappingKey(int bytecodeOffset, String className, String methodKey) {
            this.myBytecodeOffset = bytecodeOffset;
            this.myClass = className;
            this.myMethod = methodKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BytecodeMappingKey that = (BytecodeMappingKey)o;
            return this.myBytecodeOffset == that.myBytecodeOffset && Objects.equals(this.myClass, that.myClass) && Objects.equals(this.myMethod, that.myMethod);
        }

        public int hashCode() {
            return Objects.hash(this.myBytecodeOffset, this.myClass, this.myMethod);
        }

        public String toString() {
            return this.myClass + ":" + this.myMethod + ":" + this.myBytecodeOffset;
        }
    }
}

