/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classprovider;

import cuchaz.enigma.EnigmaServices;
import cuchaz.enigma.api.service.DecompilerInputTransformerService;
import cuchaz.enigma.classprovider.ClassProvider;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class DecompilerInputTransformingClassProvider
implements ClassProvider {
    private final ClassProvider delegate;
    private final EnigmaServices services;

    public DecompilerInputTransformingClassProvider(ClassProvider delegate, EnigmaServices services) {
        this.delegate = delegate;
        this.services = services;
    }

    @Override
    public Collection<String> getClassNames() {
        return this.delegate.getClassNames();
    }

    @Override
    @Nullable
    public ClassNode get(String name) {
        ClassNode classNode = this.delegate.get(name);
        if (classNode == null) {
            return null;
        }
        for (DecompilerInputTransformerService transformer : this.services.get(DecompilerInputTransformerService.TYPE)) {
            classNode = transformer.transform(classNode);
        }
        return classNode;
    }
}

