/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.vineflower;

import cuchaz.enigma.source.Source;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.source.vineflower.VineflowerContextSource;
import cuchaz.enigma.source.vineflower.VineflowerJavadocProvider;
import cuchaz.enigma.source.vineflower.VineflowerTextTokenCollector;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Manifest;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.main.extern.TextTokenVisitor;

class VineflowerSource
implements Source {
    private final IContextSource contextSource;
    private final IContextSource librarySource;
    private final SourceSettings settings;
    private EntryRemapper remapper;
    private SourceIndex index;

    VineflowerSource(VineflowerContextSource contextSource, EntryRemapper remapper, SourceSettings settings) {
        this.contextSource = contextSource;
        this.librarySource = contextSource.getClasspath();
        this.remapper = remapper;
        this.settings = settings;
    }

    @Override
    public String asString() {
        this.ensureDecompiled();
        return this.index.getSource();
    }

    @Override
    public Source withJavadocs(EntryRemapper remapper) {
        this.remapper = remapper;
        this.index = null;
        return this;
    }

    @Override
    public SourceIndex index() {
        this.ensureDecompiled();
        return this.index;
    }

    private void ensureDecompiled() {
        if (this.index != null) {
            return;
        }
        HashMap<String, Object> preferences = new HashMap<String, Object>(IFernflowerPreferences.DEFAULTS);
        preferences.put("indent-string", "\t");
        preferences.put("log-level", IFernflowerLogger.Severity.WARN.name());
        preferences.put("thread-count", String.valueOf(Math.max(1, Runtime.getRuntime().availableProcessors() - 2)));
        preferences.put("fabric:javadoc", new VineflowerJavadocProvider(this.remapper));
        if (this.settings.removeImports) {
            preferences.put("remove-imports", "1");
        }
        this.index = new SourceIndex();
        ResultSaver saver = new ResultSaver(this.index);
        PrintStreamLogger logger = new PrintStreamLogger(System.out);
        BaseDecompiler decompiler = new BaseDecompiler(saver, preferences, logger);
        AtomicReference tokenCollector = new AtomicReference();
        TextTokenVisitor.addVisitor(next -> {
            tokenCollector.set(new VineflowerTextTokenCollector(next));
            return (TextTokenVisitor)tokenCollector.get();
        });
        decompiler.addSource(this.contextSource);
        if (this.librarySource != null) {
            decompiler.addLibrary(this.librarySource);
        }
        decompiler.decompileContext();
        ((VineflowerTextTokenCollector)tokenCollector.get()).accept(this.index);
    }

    private class ResultSaver
    implements IResultSaver {
        private final SourceIndex index;

        private ResultSaver(SourceIndex index) {
            this.index = index;
        }

        @Override
        public void saveFolder(String path) {
        }

        @Override
        public void copyFile(String source, String path, String entryName) {
        }

        @Override
        public void saveClassFile(String path, String qualifiedName, String entryName, String content, int[] mapping) {
            this.index.setSource(content);
        }

        @Override
        public void createArchive(String path, String archiveName, Manifest manifest) {
        }

        @Override
        public void saveDirEntry(String path, String archiveName, String entryName) {
        }

        @Override
        public void copyEntry(String source, String path, String archiveName, String entry) {
        }

        @Override
        public void closeArchive(String path, String archiveName) {
        }

        @Override
        public void saveClassEntry(String path, String archiveName, String qualifiedName, String entryName, String content) {
        }
    }
}

