/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils;

import cuchaz.enigma.api.Ordering;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface OrderingImpl
extends Ordering {
    public static List<String> sort(String serviceName, Map<String, List<Ordering>> idToOrderings) {
        ArrayList first = new ArrayList();
        ArrayList middle = new ArrayList();
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        HashMap graph = new HashMap();
        idToOrderings.forEach((id, orderings) -> {
            inDegree.put((String)id, 0);
            graph.put(id, new LinkedHashSet());
            boolean isFirst = false;
            boolean isLast = false;
            for (Ordering ordering : orderings) {
                if (ordering instanceof First) {
                    isFirst = true;
                    continue;
                }
                if (!(ordering instanceof Last)) continue;
                isLast = true;
            }
            if (isFirst) {
                if (isLast) {
                    throw new IllegalArgumentException("Service " + id + " has both 'first' and 'last' ordering");
                }
                first.add(id);
            } else if (!isLast) {
                middle.add(id);
            }
        });
        idToOrderings.forEach((id, orderings) -> {
            boolean isFirst = false;
            boolean isLast = false;
            for (Ordering ordering : orderings) {
                if (ordering instanceof Before) {
                    Before before = (Before)ordering;
                    if (!idToOrderings.containsKey(before.id()) || !((Set)graph.get(id)).add(before.id())) continue;
                    inDegree.merge(before.id(), 1, Integer::sum);
                    continue;
                }
                if (ordering instanceof After) {
                    After after = (After)ordering;
                    if (!idToOrderings.containsKey(after.id()) || !((Set)graph.get(after.id())).add(id)) continue;
                    inDegree.merge((String)id, 1, Integer::sum);
                    continue;
                }
                if (ordering instanceof First) {
                    isFirst = true;
                    continue;
                }
                if (!(ordering instanceof Last)) continue;
                isLast = true;
            }
            if (!isFirst) {
                for (String aFirst : first) {
                    if (!((Set)graph.get(aFirst)).add(id)) continue;
                    inDegree.merge((String)id, 1, Integer::sum);
                }
                if (isLast) {
                    for (String aMiddle : middle) {
                        if (!((Set)graph.get(aMiddle)).add(id)) continue;
                        inDegree.merge((String)id, 1, Integer::sum);
                    }
                }
            }
        });
        ArrayDeque<String> queue = new ArrayDeque<String>();
        for (String id2 : idToOrderings.keySet()) {
            if ((Integer)inDegree.get(id2) != 0) continue;
            queue.add(id2);
        }
        ArrayList<String> result = new ArrayList<String>(idToOrderings.size());
        while (!queue.isEmpty()) {
            String id2;
            id2 = (String)queue.remove();
            result.add(id2);
            for (String successor : (Set)graph.get(id2)) {
                if (inDegree.merge(successor, -1, Integer::sum) != 0) continue;
                queue.add(successor);
            }
        }
        if (result.size() != idToOrderings.size()) {
            throw new IllegalStateException("Services in " + serviceName + " contain circular dependencies");
        }
        return result;
    }

    public record Before(String id) implements OrderingImpl
    {
    }

    public record After(String id) implements OrderingImpl
    {
    }

    public static enum First implements OrderingImpl
    {
        INSTANCE;

    }

    public static enum Last implements OrderingImpl
    {
        INSTANCE;

    }
}

