/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.api.service;

import cuchaz.enigma.api.service.EnigmaService;
import cuchaz.enigma.api.service.EnigmaServiceType;
import cuchaz.enigma.api.view.index.JarIndexView;
import cuchaz.enigma.classprovider.ClassProvider;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.objectweb.asm.ClassVisitor;

public interface JarIndexerService
extends EnigmaService {
    public static final EnigmaServiceType<JarIndexerService> TYPE = EnigmaServiceType.create("jar_indexer");

    public void acceptJar(Set<String> var1, ClassProvider var2, JarIndexView var3);

    public static JarIndexerService fromVisitor(ClassVisitor visitor) {
        return (scope, classProvider, jarIndex) -> {
            for (String className : scope) {
                classProvider.get(className).accept(visitor);
            }
        };
    }

    public static <V extends ClassVisitor> JarIndexerService fromVisitorsInParallel(Supplier<V> visitorCreator, Consumer<Collection<V>> combiner) {
        return (scope, classProvider, jarIndex) -> {
            CopyOnWriteArrayList allVisitors = new CopyOnWriteArrayList();
            ThreadLocal<ClassVisitor> visitors = ThreadLocal.withInitial(() -> JarIndexerService.lambda$fromVisitorsInParallel$1((Supplier)visitorCreator, allVisitors));
            scope.parallelStream().forEach(className -> classProvider.get((String)className).accept((ClassVisitor)visitors.get()));
            combiner.accept(allVisitors);
        };
    }

    private static /* synthetic */ ClassVisitor lambda$fromVisitorsInParallel$1(Supplier visitorCreator, CopyOnWriteArrayList allVisitors) {
        ClassVisitor visitor = (ClassVisitor)visitorCreator.get();
        allVisitors.add(visitor);
        return visitor;
    }
}

