/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation;

import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ObfuscatingTranslator
implements Translator {
    private final JarIndex jarIndex;
    private final EntryTree<EntryMapping> inverseMappings = new HashEntryTree<EntryMapping>();
    private final EntryResolver resolver = new ObfuscatingResolver();

    public ObfuscatingTranslator(JarIndex jarIndex) {
        this.jarIndex = jarIndex;
    }

    @Override
    @Nullable
    public <T extends Translatable> TranslateResult<T> extendedTranslate(@Nullable T translatable) {
        if (translatable == null) {
            return null;
        }
        if (translatable instanceof FieldEntry || translatable instanceof MethodEntry) {
            ParentedEntry key = this.obfOwnerAndDesc((ParentedEntry)translatable);
            EntryMapping mapping = (EntryMapping)this.inverseMappings.get(key);
            return mapping == null ? TranslateResult.obfuscated(key) : TranslateResult.deobfuscated(key.withName(mapping.targetName()));
        }
        return translatable.extendedTranslate(this, this.resolver, this.inverseMappings);
    }

    public void refreshAll(Translator deobfuscator) {
        this.inverseMappings.clear();
        for (ClassEntry clazz : this.jarIndex.getEntryIndex().getClasses()) {
            this.inverseMappings.insert(deobfuscator.extendedTranslate(clazz).getValue(), new EntryMapping(clazz.getName()));
        }
        for (FieldEntry field : this.jarIndex.getEntryIndex().getFields()) {
            this.inverseMappings.insert(this.obfOwnerAndDesc(deobfuscator.extendedTranslate(field).getValue()), new EntryMapping(field.getName()));
        }
        for (MethodEntry method : this.jarIndex.getEntryIndex().getMethods()) {
            this.inverseMappings.insert(this.obfOwnerAndDesc(deobfuscator.extendedTranslate(method).getValue()), new EntryMapping(method.getName()));
        }
    }

    public void refreshName(Entry<?> entry, String oldDeobfName, String newDeobfName) {
        this.inverseMappings.remove(entry.withName(oldDeobfName));
        this.inverseMappings.insert(entry.withName(newDeobfName), new EntryMapping(entry.getName()));
    }

    private <T extends ParentedEntry<ClassEntry>> T obfOwnerAndDesc(T translatable) {
        if (translatable.getParent() != null) {
            translatable = translatable.withParent(this.extendedTranslate(translatable.getParent()).getValue());
        }
        if (translatable instanceof FieldEntry) {
            FieldEntry field = (FieldEntry)translatable;
            translatable = field.withDesc(this.extendedTranslate(field.getDesc()).getValue());
        } else if (translatable instanceof MethodEntry) {
            MethodEntry method = (MethodEntry)translatable;
            translatable = method.withDesc(this.extendedTranslate(method.getDesc()).getValue());
        }
        return translatable;
    }

    private class ObfuscatingResolver
    implements EntryResolver {
        private ObfuscatingResolver() {
        }

        @Override
        public <E extends Entry<?>> Collection<E> resolveEntry(E entry, ResolutionStrategy strategy) {
            ClassEntry containingClass;
            if (entry instanceof ClassEntry || (containingClass = entry.findAncestor(ClassEntry.class)) == null) {
                return List.of(entry);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(entry);
            for (ClassEntry parentClass : ObfuscatingTranslator.this.jarIndex.getInheritanceIndex().getAncestors(containingClass)) {
                result.add(entry.replaceAncestor((ClassEntry)containingClass, (ClassEntry)parentClass));
            }
            return result;
        }

        @Override
        public Set<Entry<?>> resolveEquivalentEntries(Entry<?> entry) {
            return Set.of(entry);
        }

        @Override
        public Set<MethodEntry> resolveEquivalentMethods(MethodEntry methodEntry) {
            return Set.of(methodEntry);
        }
    }
}

