/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.serde;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.mapping.tree.EntryTreeNode;
import cuchaz.enigma.translation.mapping.tree.HashEntryTree;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.StreamSupport;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MappingIoConverter {
    public static VisitableMappingTree toMappingIo(EntryTree<EntryMapping> mappings, ProgressListener progress) {
        return MappingIoConverter.toMappingIo(mappings, progress, "intermediary", "named");
    }

    public static VisitableMappingTree toMappingIo(EntryTree<EntryMapping> mappings, ProgressListener progress, String fromNs, String toNs) {
        try {
            List<EntryTreeNode> classes = StreamSupport.stream(mappings.spliterator(), false).filter(node -> node.getEntry() instanceof ClassEntry).toList();
            progress.init(classes.size(), I18n.translate("progress.mappings.converting.to_mappingio"));
            int stepsDone = 0;
            MemoryMappingTree mappingTree = new MemoryMappingTree();
            mappingTree.visitNamespaces(fromNs, List.of(toNs));
            for (EntryTreeNode classNode : classes) {
                progress.step(++stepsDone, classNode.getEntry().getFullName());
                MappingIoConverter.writeClass(classNode, mappings, mappingTree);
            }
            mappingTree.visitEnd();
            return mappingTree;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void writeClass(EntryTreeNode<EntryMapping> classNode, EntryMap<EntryMapping> oldMappingTree, VisitableMappingTree newMappingTree) throws IOException {
        ClassEntry classEntry = (ClassEntry)classNode.getEntry();
        EntryMapping mapping = oldMappingTree.get(classEntry);
        LinkedList<String> parts = new LinkedList<String>();
        newMappingTree.visitClass(classEntry.getFullName());
        if (mapping != null) {
            newMappingTree.visitComment(MappedElementKind.CLASS, mapping.javadoc());
        }
        do {
            if ((mapping = oldMappingTree.get(classEntry)) != null && mapping.targetName() != null) {
                parts.addFirst(mapping.targetName());
                continue;
            }
            parts.addFirst(classEntry.getName());
        } while ((classEntry = classEntry.getOuterClass()) != null);
        String mappedName = String.join((CharSequence)"$", parts);
        newMappingTree.visitDstName(MappedElementKind.CLASS, 0, mappedName);
        for (EntryTreeNode<EntryMapping> child : classNode.getChildNodes()) {
            Entry<?> entry = child.getEntry();
            if (entry instanceof FieldEntry) {
                MappingIoConverter.writeField(child, newMappingTree);
                continue;
            }
            if (!(entry instanceof MethodEntry)) continue;
            MappingIoConverter.writeMethod(child, newMappingTree);
        }
    }

    private static void writeField(EntryTreeNode<EntryMapping> fieldNode, VisitableMappingTree mappingTree) throws IOException {
        if (fieldNode.getValue() == null || fieldNode.getValue().equals(EntryMapping.DEFAULT)) {
            return;
        }
        FieldEntry fieldEntry = (FieldEntry)fieldNode.getEntry();
        mappingTree.visitField(fieldEntry.getName(), fieldEntry.getDesc().toString());
        EntryMapping fieldMapping = fieldNode.getValue();
        if (fieldMapping == null) {
            fieldMapping = EntryMapping.DEFAULT;
        }
        mappingTree.visitDstName(MappedElementKind.FIELD, 0, fieldMapping.targetName());
        mappingTree.visitComment(MappedElementKind.FIELD, fieldMapping.javadoc());
    }

    private static void writeMethod(EntryTreeNode<EntryMapping> methodNode, VisitableMappingTree mappingTree) throws IOException {
        MethodEntry methodEntry = (MethodEntry)methodNode.getEntry();
        mappingTree.visitMethod(methodEntry.getName(), methodEntry.getDesc().toString());
        EntryMapping methodMapping = methodNode.getValue();
        if (methodMapping == null) {
            methodMapping = EntryMapping.DEFAULT;
        }
        mappingTree.visitDstName(MappedElementKind.METHOD, 0, methodMapping.targetName());
        mappingTree.visitComment(MappedElementKind.METHOD, methodMapping.javadoc());
        for (EntryTreeNode<EntryMapping> child : methodNode.getChildNodes()) {
            Entry<?> entry = child.getEntry();
            if (!(entry instanceof LocalVariableEntry)) continue;
            LocalVariableEntry local = (LocalVariableEntry)entry;
            if (local.isArgument()) {
                MappingIoConverter.writeMethodArg(child, mappingTree);
                continue;
            }
            MappingIoConverter.writeMethodVar(child, mappingTree);
        }
    }

    private static void writeMethodArg(EntryTreeNode<EntryMapping> argNode, VisitableMappingTree mappingTree) throws IOException {
        if (argNode.getValue() == null || argNode.getValue().equals(EntryMapping.DEFAULT)) {
            return;
        }
        LocalVariableEntry argEntry = (LocalVariableEntry)argNode.getEntry();
        mappingTree.visitMethodArg(-1, argEntry.getIndex(), argEntry.getName());
        EntryMapping argMapping = argNode.getValue();
        if (argMapping == null) {
            argMapping = EntryMapping.DEFAULT;
        }
        mappingTree.visitDstName(MappedElementKind.METHOD_ARG, 0, argMapping.targetName());
        mappingTree.visitComment(MappedElementKind.METHOD_ARG, argMapping.javadoc());
    }

    private static void writeMethodVar(EntryTreeNode<EntryMapping> varNode, VisitableMappingTree mappingTree) throws IOException {
        if (varNode.getValue() == null || varNode.getValue().equals(EntryMapping.DEFAULT)) {
            return;
        }
        LocalVariableEntry varEntry = (LocalVariableEntry)varNode.getEntry();
        mappingTree.visitMethodVar(-1, varEntry.getIndex(), -1, -1, varEntry.getName());
        EntryMapping varMapping = varNode.getValue();
        if (varMapping == null) {
            varMapping = EntryMapping.DEFAULT;
        }
        mappingTree.visitDstName(MappedElementKind.METHOD_VAR, 0, varMapping.targetName());
        mappingTree.visitComment(MappedElementKind.METHOD_VAR, varMapping.javadoc());
    }

    public static EntryTree<EntryMapping> fromMappingIo(VisitableMappingTree mappingTree, ProgressListener progress, @Nullable JarIndex index) {
        HashEntryTree<EntryMapping> dstMappingTree = new HashEntryTree<EntryMapping>();
        progress.init(mappingTree.getClasses().size(), I18n.translate("progress.mappings.converting.from_mappingio"));
        int steps = 0;
        for (MappingTree.ClassMapping classMapping : mappingTree.getClasses()) {
            progress.step(steps++, classMapping.getDstName(0) != null ? classMapping.getDstName(0) : classMapping.getSrcName());
            MappingIoConverter.readClass(classMapping, dstMappingTree, index);
        }
        return dstMappingTree;
    }

    private static void readClass(MappingTree.ClassMapping classMapping, EntryTree<EntryMapping> mappingTree, JarIndex index) {
        ClassEntry currentClass = new ClassEntry(classMapping.getSrcName());
        String dstName = classMapping.getDstName(0);
        if (dstName != null) {
            dstName = dstName.substring(dstName.lastIndexOf(36) + 1);
        }
        mappingTree.insert(currentClass, new EntryMapping(dstName, classMapping.getComment()));
        for (MappingTree.FieldMapping fieldMapping : classMapping.getFields()) {
            MappingIoConverter.readField(fieldMapping, currentClass, mappingTree, index);
        }
        for (MappingTree.MethodMapping methodMapping : classMapping.getMethods()) {
            MappingIoConverter.readMethod(methodMapping, currentClass, mappingTree);
        }
    }

    private static void readField(MappingTree.FieldMapping fieldMapping, ClassEntry parent, EntryTree<EntryMapping> mappingTree, JarIndex index) {
        FieldEntry[] fieldEntries;
        String srcDesc = fieldMapping.getSrcDesc();
        if (srcDesc != null) {
            fieldEntries = new FieldEntry[]{new FieldEntry(parent, fieldMapping.getSrcName(), new TypeDescriptor(fieldMapping.getSrcDesc()))};
        } else {
            if (index == null) {
                return;
            }
            fieldEntries = (FieldEntry[])index.getChildrenByClass().get(parent).stream().filter(entry -> entry instanceof FieldEntry).filter(entry -> entry.getName().equals(fieldMapping.getSrcName())).toArray(FieldEntry[]::new);
            if (fieldEntries.length == 0) {
                fieldEntries = (FieldEntry[])index.getEntryIndex().getFields().stream().filter(entry -> ((ClassEntry)entry.getParent()).getFullName().equals(parent.getFullName())).filter(entry -> {
                    if (entry.getName().equals(fieldMapping.getSrcName())) {
                        return true;
                    }
                    System.out.println("Entry name: " + entry.getName() + ", mapping name: " + fieldMapping.getSrcName());
                    return false;
                }).toArray(FieldEntry[]::new);
            }
            if (fieldEntries.length == 0) {
                return;
            }
        }
        for (FieldEntry fieldEntry : fieldEntries) {
            mappingTree.insert(fieldEntry, new EntryMapping(fieldMapping.getDstName(0), fieldMapping.getComment()));
        }
    }

    private static void readMethod(MappingTree.MethodMapping methodMapping, ClassEntry parent, EntryTree<EntryMapping> mappingTree) {
        MethodEntry currentMethod = new MethodEntry(parent, methodMapping.getSrcName(), new MethodDescriptor(methodMapping.getSrcDesc()));
        mappingTree.insert(currentMethod, new EntryMapping(methodMapping.getDstName(0), methodMapping.getComment()));
        for (MappingTree.MethodArgMapping methodArgMapping : methodMapping.getArgs()) {
            MappingIoConverter.readMethodArg(methodArgMapping, currentMethod, mappingTree);
        }
        for (MappingTree.MethodVarMapping methodVarMapping : methodMapping.getVars()) {
            MappingIoConverter.readMethodVar(methodVarMapping, currentMethod, mappingTree);
        }
    }

    private static void readMethodArg(MappingTree.MethodArgMapping argMapping, MethodEntry parent, EntryTree<EntryMapping> mappingTree) {
        String srcName = argMapping.getSrcName() != null ? argMapping.getSrcName() : "";
        mappingTree.insert(new LocalVariableEntry(parent, argMapping.getLvIndex(), srcName, true, null), new EntryMapping(argMapping.getDstName(0), argMapping.getComment()));
    }

    private static void readMethodVar(MappingTree.MethodVarMapping varMapping, MethodEntry parent, EntryTree<EntryMapping> mappingTree) {
        String srcName = varMapping.getSrcName() != null ? varMapping.getSrcName() : "";
        mappingTree.insert(new LocalVariableEntry(parent, varMapping.getLvIndex(), srcName, false, null), new EntryMapping(varMapping.getDstName(0), varMapping.getComment()));
    }
}

