/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class AssertExprent
extends Exprent {
    private final List<? extends Exprent> parameters;

    public AssertExprent(List<? extends Exprent> parameters) {
        super(Exprent.Type.ASSERT);
        this.parameters = parameters;
    }

    @Override
    protected List<Exprent> getAllExprents(List<Exprent> list) {
        ArrayList<? extends Exprent> copy = new ArrayList<Exprent>(this.parameters);
        copy.removeIf(Objects::isNull);
        list.addAll(copy);
        return list;
    }

    @Override
    public Exprent copy() {
        return null;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buffer = new TextBuffer();
        buffer.append("assert ");
        buffer.addBytecodeMapping(this.bytecode);
        if (this.parameters.get(0) == null) {
            buffer.append("false");
        } else {
            buffer.append(this.parameters.get(0).toJava(indent));
        }
        if (this.parameters.size() > 1) {
            buffer.append(" : ");
            buffer.append(this.parameters.get(1).toJava(indent));
        }
        return buffer;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        AssertExprent.measureBytecode(values, this.parameters);
        this.measureBytecode(values);
    }
}

