/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.StartEndPair;
import org.jetbrains.java.decompiler.util.TextBuffer;

public final class BasicBlockStatement
extends Statement {
    private final BasicBlock block;
    private boolean removableMonitorexit;

    public BasicBlockStatement(BasicBlock block) {
        super(Statement.StatementType.BASIC_BLOCK, block.id);
        Instruction instr;
        this.block = block;
        CounterContainer coun = DecompilerContext.getCounterContainer();
        if (this.id >= coun.getCounter(0)) {
            coun.setCounter(0, this.id + 1);
        }
        if ((instr = block.getLastInstruction()) != null) {
            if (instr.group == 2 && instr.opcode != 167) {
                this.lastBasicType = Statement.LastBasicType.IF;
            } else if (instr.group == 3) {
                this.lastBasicType = Statement.LastBasicType.SWITCH;
            }
        }
        this.buildMonitorFlags();
    }

    @Override
    public void markMonitorexitDead() {
        InstructionSequence seq = this.getBlock().getSeq();
        if (seq != null && !seq.isEmpty()) {
            for (int i = 0; i < seq.length(); ++i) {
                if (seq.getInstr((int)i).opcode != 195) continue;
                this.setRemovableMonitorexit(true);
                break;
            }
        }
    }

    @Override
    public BasicBlockStatement getBasichead() {
        return this;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer tb = ExprProcessor.listToJava(this.varDefinitions, indent);
        boolean islabeled = this.isLabeled();
        if (islabeled) {
            tb.appendIndent(indent).append("label").append(this.id).append(':').append("// $VF: Invalid label!").appendLineSeparator();
        }
        tb.append(ExprProcessor.listToJava(this.exprents, indent));
        return tb;
    }

    @Override
    public Statement getSimpleCopy() {
        BasicBlock newblock = new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0));
        SimpleInstructionSequence seq = new SimpleInstructionSequence();
        for (int i = 0; i < this.block.getSeq().length(); ++i) {
            seq.addInstruction(this.block.getSeq().getInstr(i).clone(), -1);
        }
        newblock.setSeq(seq);
        return new BasicBlockStatement(newblock);
    }

    @Override
    public List<VarExprent> getImplicitlyDefinedVars() {
        if (this.getExprents() != null && this.getExprents().size() > 0) {
            ArrayList<VarExprent> vars = new ArrayList<VarExprent>();
            List<Exprent> exps = this.getExprents();
            for (Exprent exp : exps) {
                List<Exprent> inner = exp.getAllExprents(true);
                inner.add(exp);
                for (Exprent exprent : inner) {
                    if (!(exprent instanceof FunctionExprent) || ((FunctionExprent)exprent).getFuncType() != FunctionExprent.FunctionType.INSTANCEOF || ((FunctionExprent)exprent).getLstOperands().size() <= 2) continue;
                    vars.add((VarExprent)((FunctionExprent)exprent).getLstOperands().get(2));
                }
            }
            return vars;
        }
        return null;
    }

    public boolean isRemovableMonitorexit() {
        return this.removableMonitorexit;
    }

    public void setRemovableMonitorexit(boolean removableMonitorexit) {
        this.removableMonitorexit = removableMonitorexit;
    }

    public static BasicBlockStatement create() {
        BasicBlockStatement stat = new BasicBlockStatement(new BasicBlock(DecompilerContext.getCounterContainer().getCounterAndIncrement(0)));
        stat.setExprents(new ArrayList<Exprent>());
        return stat;
    }

    @Override
    public boolean hasBasicSuccEdge() {
        return true;
    }

    public BasicBlock getBlock() {
        return this.block;
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        for (int i = 0; i < this.exprents.size(); ++i) {
            if (this.exprents.get(i) != oldexpr) continue;
            this.exprents.set(i, newexpr);
        }
    }

    @Override
    public StartEndPair getStartEndRange() {
        if (this.block.size() > 0) {
            return new StartEndPair(this.block.getStartInstruction(), this.block.getEndInstruction());
        }
        return new StartEndPair(0, 0);
    }
}

